/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.awt.Image;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.VirtualAttributeAccessor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jaxb.DefaultElementConverter;
import org.eclipse.persistence.internal.jaxb.DomHandlerConverter;
import org.eclipse.persistence.internal.jaxb.JAXBElementConverter;
import org.eclipse.persistence.internal.jaxb.JAXBElementRootConverter;
import org.eclipse.persistence.internal.jaxb.JAXBSetMethodAttributeAccessor;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.jaxb.MultiArgInstantiationPolicy;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.XMLJavaTypeConverter;
import org.eclipse.persistence.internal.jaxb.many.JAXBArrayAttributeAccessor;
import org.eclipse.persistence.internal.jaxb.many.ManyValue;
import org.eclipse.persistence.internal.jaxb.many.MapValue;
import org.eclipse.persistence.internal.jaxb.many.MapValueAttributeAccessor;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.oxm.XMLContainerMapping;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBEnumTypeConverter;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.CompilerHelper;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.PackageInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAbstractNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper;
import org.eclipse.persistence.jaxb.xmlmodel.XmlIsSetNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlRootElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransformation;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.FixedMimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.MimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAnyAttributeMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLInverseReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLTransformationMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.converters.XMLListConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.IsSetNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.schema.XMLSchemaClassPathReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sessions.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingsGenerator {
    private static final String ATT = "@";
    private static final String TXT = "/text()";
    private static String OBJECT_CLASS_NAME = "java.lang.Object";
    public static final QName RESERVED_QNAME = new QName("urn:ECLIPSELINK_RESERVEDURI", "RESERVEDNAME");
    String outputDir = ".";
    private HashMap<String, QName> userDefinedSchemaTypes;
    private org.eclipse.persistence.jaxb.javamodel.Helper helper;
    private JavaClass jotArrayList;
    private JavaClass jotHashSet;
    private JavaClass jotHashMap;
    private HashMap<String, PackageInfo> packageToPackageInfoMappings;
    private HashMap<String, TypeInfo> typeInfo;
    private HashMap<QName, Class> qNamesToGeneratedClasses;
    private HashMap<String, Class> classToGeneratedClasses;
    private HashMap<QName, Class> qNamesToDeclaredClasses;
    private HashMap<QName, ElementDeclaration> globalElements;
    private List<ElementDeclaration> localElements;
    private Map<TypeMappingInfo, Class> typeMappingInfoToGeneratedClasses;
    private Map<MapEntryGeneratedKey, Class> generatedMapEntryClasses;
    private Project project;
    private NamespaceResolver globalNamespaceResolver;
    private boolean isDefaultNamespaceAllowed;
    private Map<TypeMappingInfo, Class> typeMappingInfoToAdapterClasses;

    public MappingsGenerator(org.eclipse.persistence.jaxb.javamodel.Helper helper) {
        this.helper = helper;
        this.jotArrayList = helper.getJavaClass(ArrayList.class);
        this.jotHashSet = helper.getJavaClass(HashSet.class);
        this.jotHashMap = helper.getJavaClass(HashMap.class);
        this.qNamesToGeneratedClasses = new HashMap();
        this.qNamesToDeclaredClasses = new HashMap();
        this.classToGeneratedClasses = new HashMap();
        this.globalNamespaceResolver = new NamespaceResolver();
        this.isDefaultNamespaceAllowed = true;
    }

    public Project generateProject(ArrayList<JavaClass> typeInfoClasses, HashMap<String, TypeInfo> typeInfo, HashMap<String, QName> userDefinedSchemaTypes, HashMap<String, PackageInfo> packageToPackageInfoMappings, HashMap<QName, ElementDeclaration> globalElements, List<ElementDeclaration> localElements, Map<TypeMappingInfo, Class> typeMappingInfoToGeneratedClass, Map<TypeMappingInfo, Class> typeMappingInfoToAdapterClasses, boolean isDefaultNamespaceAllowed) throws Exception {
        this.typeInfo = typeInfo;
        this.userDefinedSchemaTypes = userDefinedSchemaTypes;
        this.packageToPackageInfoMappings = packageToPackageInfoMappings;
        this.isDefaultNamespaceAllowed = isDefaultNamespaceAllowed;
        this.globalElements = globalElements;
        this.localElements = localElements;
        this.typeMappingInfoToGeneratedClasses = typeMappingInfoToGeneratedClass;
        this.typeMappingInfoToAdapterClasses = typeMappingInfoToAdapterClasses;
        this.project = new Project();
        for (JavaClass next : typeInfoClasses) {
            if (next.isEnum()) continue;
            this.generateDescriptor(next, this.project);
        }
        for (JavaClass next : typeInfoClasses) {
            if (next.isEnum()) continue;
            this.setupInheritance(next);
        }
        this.generateMappings();
        Set<Map.Entry<String, TypeInfo>> entrySet = this.typeInfo.entrySet();
        for (Map.Entry<String, TypeInfo> entry : entrySet) {
            TypeInfo tInfo = entry.getValue();
            if (tInfo.getXmlCustomizer() == null) continue;
            String customizerClassName = tInfo.getXmlCustomizer();
            try {
                Class customizerClass = PrivilegedAccessHelper.getClassForName((String)customizerClassName, (boolean)true, (ClassLoader)this.helper.getClassLoader());
                DescriptorCustomizer descriptorCustomizer = (DescriptorCustomizer)PrivilegedAccessHelper.newInstanceFromClass((Class)customizerClass);
                descriptorCustomizer.customize((ClassDescriptor)tInfo.getDescriptor());
            }
            catch (IllegalAccessException iae) {
                throw JAXBException.couldNotCreateCustomizerInstance((Exception)iae, (String)customizerClassName);
            }
            catch (InstantiationException ie) {
                throw JAXBException.couldNotCreateCustomizerInstance((Exception)ie, (String)customizerClassName);
            }
            catch (ClassCastException cce) {
                throw JAXBException.invalidCustomizerClass((Exception)cce, (String)customizerClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw JAXBException.couldNotCreateCustomizerInstance((Exception)cnfe, (String)customizerClassName);
            }
        }
        this.processGlobalElements(this.project);
        return this.project;
    }

    public void generateDescriptor(JavaClass javaClass, Project project) {
        JavaClass manyValueJavaClass;
        String namespace;
        String elementName;
        String jClassName = javaClass.getQualifiedName();
        TypeInfo info = this.typeInfo.get(jClassName);
        if (info.isTransient()) {
            return;
        }
        NamespaceInfo namespaceInfo = this.packageToPackageInfoMappings.get(javaClass.getPackageName()).getNamespaceInfo();
        String packageNamespace = namespaceInfo.getNamespace();
        if (javaClass.getSuperclass() != null && javaClass.getSuperclass().getName().equals("javax.xml.bind.JAXBElement")) {
            this.generateDescriptorForJAXBElementSubclass(javaClass, project, namespaceInfo.getNamespaceResolverForDescriptor());
            return;
        }
        XMLDescriptor descriptor = new XMLDescriptor();
        XmlRootElement rootElem = info.getXmlRootElement();
        if (rootElem == null) {
            try {
                elementName = info.getXmlNameTransformer().transformRootElementName(javaClass.getName());
            }
            catch (Exception ex) {
                throw JAXBException.exceptionDuringNameTransformation((String)javaClass.getName(), (String)info.getXmlNameTransformer().getClass().getName(), (Exception)ex);
            }
            namespace = packageNamespace;
            descriptor.setResultAlwaysXMLRoot(true);
        } else {
            elementName = rootElem.getName();
            if (elementName.equals("##default")) {
                try {
                    elementName = info.getXmlNameTransformer().transformRootElementName(javaClass.getName());
                }
                catch (Exception ex) {
                    throw JAXBException.exceptionDuringNameTransformation((String)javaClass.getName(), (String)info.getXmlNameTransformer().getClass().getName(), (Exception)ex);
                }
            }
            namespace = rootElem.getNamespace();
            descriptor.setResultAlwaysXMLRoot(false);
        }
        descriptor.setJavaClassName(jClassName);
        if (info.getFactoryMethodName() != null) {
            descriptor.getInstantiationPolicy().useFactoryInstantiationPolicy(info.getObjectFactoryClassName(), info.getFactoryMethodName());
        }
        if (namespace.equals("##default")) {
            namespace = namespaceInfo.getNamespace();
        }
        if (!(manyValueJavaClass = this.helper.getJavaClass(ManyValue.class)).isAssignableFrom(javaClass)) {
            if (namespace.length() != 0 && this.isDefaultNamespaceAllowed && this.globalNamespaceResolver.getDefaultNamespaceURI() == null && namespace.length() != 0) {
                this.globalNamespaceResolver.setDefaultNamespaceURI(namespace);
                namespaceInfo.getNamespaceResolverForDescriptor().setDefaultNamespaceURI(namespace);
            }
            if (rootElem == null) {
                descriptor.setDefaultRootElement("");
            } else if (namespace.length() == 0) {
                descriptor.setDefaultRootElement(elementName);
            } else {
                descriptor.setDefaultRootElement(this.getQualifiedString(this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolverForDescriptor(), null), elementName));
            }
        }
        descriptor.setNamespaceResolver(namespaceInfo.getNamespaceResolverForDescriptor());
        this.setSchemaContext(descriptor, info);
        if (info.isSetClassExtractorName()) {
            descriptor.getInheritancePolicy().setClassExtractorName(info.getClassExtractorName());
        }
        if (info.getUserProperties() != null) {
            descriptor.setProperties(info.getUserProperties());
        }
        if (info.isLocationAware()) {
            Property locProp = null;
            for (Property p : info.getPropertyList()) {
                if (!p.getType().getName().equals("org.xml.sax.Locator")) continue;
                locProp = p;
            }
            if (locProp != null && locProp.isTransient()) {
                MethodAttributeAccessor aa;
                if (locProp.isMethodProperty()) {
                    aa = new MethodAttributeAccessor();
                    aa.setAttributeName(locProp.getPropertyName());
                    aa.setSetMethodName(locProp.getSetMethodName());
                    aa.setGetMethodName(locProp.getGetMethodName());
                    descriptor.setLocationAccessor((AttributeAccessor)aa);
                } else {
                    aa = new InstanceVariableAttributeAccessor();
                    aa.setAttributeName(locProp.getPropertyName());
                    descriptor.setLocationAccessor((AttributeAccessor)aa);
                }
            }
        }
        project.addDescriptor((ClassDescriptor)descriptor);
        info.setDescriptor(descriptor);
    }

    public void generateDescriptorForJAXBElementSubclass(JavaClass javaClass, Project project, NamespaceResolver nsr) {
        String jClassName = javaClass.getQualifiedName();
        TypeInfo info = this.typeInfo.get(jClassName);
        XMLDescriptor xmlDescriptor = new XMLDescriptor();
        xmlDescriptor.setJavaClassName(jClassName);
        String[] factoryMethodParamTypes = info.getFactoryMethodParamTypes();
        MultiArgInstantiationPolicy policy = new MultiArgInstantiationPolicy();
        policy.useFactoryInstantiationPolicy(info.getObjectFactoryClassName(), info.getFactoryMethodName());
        policy.setParameterTypeNames(factoryMethodParamTypes);
        policy.setDefaultValues(new String[1]);
        xmlDescriptor.setInstantiationPolicy((InstantiationPolicy)policy);
        JavaClass paramClass = this.helper.getJavaClass(factoryMethodParamTypes[0]);
        if (this.helper.isBuiltInJavaType(paramClass)) {
            if (this.isBinaryData(paramClass)) {
                XMLBinaryDataMapping mapping = new XMLBinaryDataMapping();
                mapping.setAttributeName("value");
                mapping.setXPath(".");
                ((XMLField)mapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
                mapping.setSetMethodName("setValue");
                mapping.setGetMethodName("getValue");
                Class attributeClassification = Helper.getClassFromClasseName((String)factoryMethodParamTypes[0], (ClassLoader)this.getClass().getClassLoader());
                mapping.setAttributeClassification(attributeClassification);
                mapping.setShouldInlineBinaryData(false);
                if (mapping.getMimeType() == null) {
                    if (this.areEquals(paramClass, Source.class)) {
                        mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/xml"));
                    } else {
                        mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/octet-stream"));
                    }
                }
                xmlDescriptor.addMapping((DatabaseMapping)mapping);
            } else {
                XMLDirectMapping mapping = new XMLDirectMapping();
                mapping.setAttributeName("value");
                mapping.setGetMethodName("getValue");
                mapping.setSetMethodName("setValue");
                mapping.setXPath("text()");
                Class attributeClassification = Helper.getClassFromClasseName((String)factoryMethodParamTypes[0], (ClassLoader)this.getClass().getClassLoader());
                mapping.setAttributeClassification(attributeClassification);
                xmlDescriptor.addMapping((DatabaseMapping)mapping);
            }
        } else if (paramClass.isEnum()) {
            EnumTypeInfo enumInfo = (EnumTypeInfo)this.typeInfo.get(paramClass.getQualifiedName());
            XMLDirectMapping mapping = new XMLDirectMapping();
            mapping.setConverter((Converter)this.buildJAXBEnumTypeConverter((DatabaseMapping)mapping, enumInfo));
            mapping.setAttributeName("value");
            mapping.setGetMethodName("getValue");
            mapping.setSetMethodName("setValue");
            mapping.setXPath("text()");
            Class attributeClassification = Helper.getClassFromClasseName((String)factoryMethodParamTypes[0], (ClassLoader)this.getClass().getClassLoader());
            mapping.setAttributeClassification(attributeClassification);
            xmlDescriptor.addMapping((DatabaseMapping)mapping);
        } else {
            XMLCompositeObjectMapping mapping = new XMLCompositeObjectMapping();
            mapping.setAttributeName("value");
            mapping.setGetMethodName("getValue");
            mapping.setSetMethodName("setValue");
            mapping.setXPath(".");
            mapping.setReferenceClassName(factoryMethodParamTypes[0]);
            xmlDescriptor.addMapping((DatabaseMapping)mapping);
        }
        xmlDescriptor.setNamespaceResolver(nsr);
        this.setSchemaContext(xmlDescriptor, info);
        project.addDescriptor((ClassDescriptor)xmlDescriptor);
        info.setDescriptor(xmlDescriptor);
    }

    private void setSchemaContext(XMLDescriptor desc, TypeInfo info) {
        XMLSchemaClassPathReference schemaRef = new XMLSchemaClassPathReference();
        if (info.getClassNamespace() == null || info.getClassNamespace().equals("")) {
            schemaRef.setSchemaContext("/" + info.getSchemaTypeName());
            schemaRef.setSchemaContextAsQName(new QName(info.getSchemaTypeName()));
        } else {
            String prefix = desc.getNonNullNamespaceResolver().resolveNamespaceURI(info.getClassNamespace());
            if (prefix != null && !prefix.equals("")) {
                schemaRef.setSchemaContext("/" + prefix + ":" + info.getSchemaTypeName());
                schemaRef.setSchemaContextAsQName(new QName(info.getClassNamespace(), info.getSchemaTypeName(), prefix));
            } else {
                String generatedPrefix = this.getPrefixForNamespace(info.getClassNamespace(), desc.getNonNullNamespaceResolver(), null, false);
                schemaRef.setSchemaContext("/" + this.getQualifiedString(generatedPrefix, info.getSchemaTypeName()));
                if (generatedPrefix == null || generatedPrefix.equals("")) {
                    schemaRef.setSchemaContextAsQName(new QName(info.getClassNamespace(), info.getSchemaTypeName()));
                } else {
                    schemaRef.setSchemaContextAsQName(new QName(info.getClassNamespace(), info.getSchemaTypeName(), generatedPrefix));
                }
            }
        }
        if (info.isEnumerationType() || info.getPropertyNames().size() == 1 && this.helper.isAnnotationPresent(info.getProperties().get(info.getPropertyNames().get(0)).getElement(), XmlValue.class)) {
            schemaRef.setType(2);
        }
        desc.setSchemaReference((XMLSchemaReference)schemaRef);
    }

    public DatabaseMapping generateMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        if (property.isSetXmlJavaTypeAdapter()) {
            XMLCompositeCollectionMapping mapping;
            boolean isArray;
            if (property.isReference()) {
                return this.generateMappingForReferenceProperty(property, descriptor, namespaceInfo);
            }
            XmlJavaTypeAdapter xja = property.getXmlJavaTypeAdapter();
            JavaClass adapterClass = this.helper.getJavaClass(xja.getValue());
            JavaClass valueType = null;
            String sValType = xja.getValueType();
            valueType = sValType.equals("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter.DEFAULT") ? property.getActualType() : this.helper.getJavaClass(xja.getValueType());
            boolean bl = isArray = property.getType().isArray() && !property.getType().getRawName().equals("byte[]");
            if (this.typeInfo.containsKey(valueType.getQualifiedName())) {
                if (this.isCollectionType(property)) {
                    mapping = this.generateCompositeCollectionMapping(property, descriptor, namespaceInfo, valueType.getQualifiedName());
                    mapping.setConverter((Converter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                } else {
                    mapping = this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, valueType.getQualifiedName());
                    ((XMLCompositeObjectMapping)mapping).setConverter((Converter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                }
            } else if (property.isAny()) {
                if (this.isCollectionType(property)) {
                    mapping = this.generateAnyCollectionMapping(property, descriptor, namespaceInfo, property.isMixedContent());
                    ((XMLAnyCollectionMapping)mapping).setConverter((XMLConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                } else {
                    mapping = this.generateAnyObjectMapping(property, descriptor, namespaceInfo);
                    ((XMLAnyObjectMapping)mapping).setConverter((XMLConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                }
            } else if (this.isCollectionType(property) || isArray) {
                if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
                    mapping = this.generateBinaryDataCollectionMapping(property, descriptor, namespaceInfo);
                    ((XMLBinaryDataCollectionMapping)mapping).setValueConverter((Converter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                } else {
                    mapping = this.generateDirectCollectionMapping(property, descriptor, namespaceInfo);
                    if (adapterClass.getQualifiedName().equals(CollapsedStringAdapter.class.getName())) {
                        ((XMLCompositeDirectCollectionMapping)mapping).setCollapsingStringValues(true);
                    } else if (adapterClass.getQualifiedName().equals(NormalizedStringAdapter.class.getName())) {
                        ((XMLCompositeDirectCollectionMapping)mapping).setNormalizingStringValues(true);
                    } else {
                        ((XMLCompositeDirectCollectionMapping)mapping).setValueConverter((Converter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                    }
                }
            } else if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
                mapping = this.generateBinaryMapping(property, descriptor, namespaceInfo);
                ((XMLBinaryDataMapping)mapping).setConverter((Converter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
            } else {
                if (!property.isAttribute() && this.areEquals(valueType, Object.class)) {
                    XMLCompositeObjectMapping mapping2 = this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, null);
                    mapping2.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                    mapping2.setConverter((Converter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                    return mapping2;
                }
                mapping = this.generateDirectMapping(property, descriptor, namespaceInfo);
                if (adapterClass.getQualifiedName().equals(CollapsedStringAdapter.class.getName())) {
                    ((XMLDirectMapping)mapping).setCollapsingStringValues(true);
                } else if (adapterClass.getQualifiedName().equals(NormalizedStringAdapter.class.getName())) {
                    ((XMLDirectMapping)mapping).setNormalizingStringValues(true);
                } else {
                    ((XMLDirectMapping)mapping).setConverter((Converter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                }
            }
            return mapping;
        }
        if (property.isSetXmlJoinNodes()) {
            if (this.isCollectionType(property)) {
                return this.generateXMLCollectionReferenceMapping(property, descriptor, namespaceInfo, property.getActualType());
            }
            return this.generateXMLObjectReferenceMapping(property, descriptor, namespaceInfo, property.getType());
        }
        if (property.isXmlTransformation()) {
            return this.generateTransformationMapping(property, descriptor, namespaceInfo);
        }
        if (property.isChoice()) {
            if (this.isCollectionType(property)) {
                return this.generateChoiceCollectionMapping(property, descriptor, namespaceInfo);
            }
            return this.generateChoiceMapping(property, descriptor, namespaceInfo);
        }
        if (property.isInverseReference()) {
            return this.generateInverseReferenceMapping(property, descriptor, namespaceInfo);
        }
        if (property.isAny()) {
            if (this.isCollectionType(property) || property.getType().isArray()) {
                return this.generateAnyCollectionMapping(property, descriptor, namespaceInfo, property.isMixedContent());
            }
            return this.generateAnyObjectMapping(property, descriptor, namespaceInfo);
        }
        if (property.isReference()) {
            return this.generateMappingForReferenceProperty(property, descriptor, namespaceInfo);
        }
        if (property.isMap()) {
            if (property.isAnyAttribute()) {
                return this.generateAnyAttributeMapping(property, descriptor, namespaceInfo);
            }
            return this.generateMapMapping(property, descriptor, namespaceInfo);
        }
        if (this.isCollectionType(property)) {
            return this.generateCollectionMapping(property, descriptor, namespaceInfo);
        }
        JavaClass referenceClass = property.getType();
        String referenceClassName = referenceClass.getRawName();
        if (referenceClass.isArray() && !referenceClassName.equals("byte[]")) {
            JavaClass componentType = referenceClass.getComponentType();
            TypeInfo reference = this.typeInfo.get(componentType.getName());
            if (reference != null && reference.isEnumerationType()) {
                return this.generateEnumCollectionMapping(property, descriptor, namespaceInfo, (EnumTypeInfo)reference);
            }
            if (this.areEquals(componentType, Object.class)) {
                XMLCompositeCollectionMapping mapping = this.generateCompositeCollectionMapping(property, descriptor, namespaceInfo, null);
                mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                return mapping;
            }
            if (reference != null || componentType.isArray()) {
                return this.generateCompositeCollectionMapping(property, descriptor, namespaceInfo, componentType.getQualifiedName());
            }
            return this.generateDirectCollectionMapping(property, descriptor, namespaceInfo);
        }
        if (property.isXmlIdRef()) {
            return this.generateXMLObjectReferenceMapping(property, descriptor, namespaceInfo, referenceClass);
        }
        TypeInfo reference = this.typeInfo.get(referenceClass.getQualifiedName());
        if (reference != null) {
            if (reference.isEnumerationType()) {
                return this.generateDirectEnumerationMapping(property, descriptor, namespaceInfo, (EnumTypeInfo)reference);
            }
            if (property.isXmlLocation()) {
                XMLCompositeObjectMapping locationMapping = this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, referenceClass.getQualifiedName());
                reference.getDescriptor().setInstantiationPolicy((InstantiationPolicy)new NullInstantiationPolicy());
                descriptor.setLocationAccessor(locationMapping.getAttributeAccessor());
                return locationMapping;
            }
            return this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, referenceClass.getQualifiedName());
        }
        if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
            return this.generateBinaryMapping(property, descriptor, namespaceInfo);
        }
        if (referenceClass.getQualifiedName().equals(OBJECT_CLASS_NAME) && !property.isAttribute()) {
            XMLCompositeObjectMapping coMapping = this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, null);
            coMapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
            return coMapping;
        }
        if (property.isXmlLocation()) {
            return null;
        }
        return this.generateDirectMapping(property, descriptor, namespaceInfo);
    }

    private XMLInverseReferenceMapping generateInverseReferenceMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespace) {
        XMLInverseReferenceMapping invMapping = new XMLInverseReferenceMapping();
        if (this.isCollectionType(property.getType())) {
            invMapping.setReferenceClassName(property.getGenericType().getQualifiedName());
        } else {
            invMapping.setReferenceClassName(property.getType().getQualifiedName());
        }
        invMapping.setAttributeName(property.getPropertyName());
        String setMethodName = property.getInverseReferencePropertySetMethodName();
        String getMethodName = property.getInverseReferencePropertyGetMethodName();
        if (setMethodName != null && !setMethodName.equals("")) {
            invMapping.setSetMethodName(setMethodName);
        }
        if (getMethodName != null && !getMethodName.equals("")) {
            invMapping.setGetMethodName(getMethodName);
        }
        invMapping.setMappedBy(property.getInverseReferencePropertyName());
        if (this.isCollectionType(property.getType())) {
            JavaClass collectionType = property.getType();
            if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
                collectionType = this.jotArrayList;
            } else if (this.areEquals(collectionType, Set.class)) {
                collectionType = this.jotHashSet;
            }
            invMapping.useCollectionClass(this.helper.getClassForJavaClass(collectionType));
        }
        return invMapping;
    }

    public XMLTransformationMapping generateTransformationMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespace) {
        XMLTransformationMapping mapping = new XMLTransformationMapping();
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.isSetXmlTransformation()) {
            XmlTransformation xmlTransformation = property.getXmlTransformation();
            mapping.setIsOptional(xmlTransformation.isOptional());
            if (xmlTransformation.isSetXmlReadTransformer()) {
                mapping.setAttributeName(property.getPropertyName());
                XmlTransformation.XmlReadTransformer readTransformer = xmlTransformation.getXmlReadTransformer();
                if (readTransformer.isSetTransformerClass()) {
                    mapping.setAttributeTransformerClassName(xmlTransformation.getXmlReadTransformer().getTransformerClass());
                } else {
                    mapping.setAttributeTransformation(xmlTransformation.getXmlReadTransformer().getMethod());
                }
            }
            if (xmlTransformation.isSetXmlWriteTransformers()) {
                for (XmlTransformation.XmlWriteTransformer writeTransformer : xmlTransformation.getXmlWriteTransformer()) {
                    if (writeTransformer.isSetTransformerClass()) {
                        mapping.addFieldTransformerClassName(writeTransformer.getXmlPath(), writeTransformer.getTransformerClass());
                        continue;
                    }
                    mapping.addFieldTransformation(writeTransformer.getXmlPath(), writeTransformer.getMethod());
                }
            }
        }
        return mapping;
    }

    public XMLChoiceObjectMapping generateChoiceMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespace) {
        XMLChoiceObjectMapping mapping = new XMLChoiceObjectMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isSetReadOnly()) {
            mapping.setIsReadOnly(property.isReadOnly());
        }
        if (property.isSetWriteOnly()) {
            mapping.setIsWriteOnly(property.isWriteOnly());
        }
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        boolean isIdRef = property.isXmlIdRef();
        for (Property next : property.getChoiceProperties()) {
            XmlJavaTypeAdapter adapter;
            JavaClass type = next.getType();
            JavaClass originalType = next.getType();
            XMLJavaTypeConverter converter = null;
            TypeInfo info = this.typeInfo.get(type.getName());
            if (info != null && (adapter = info.getXmlJavaTypeAdapter()) != null) {
                JavaClass theClass;
                String adapterValue = adapter.getValue();
                JavaClass adapterClass = this.helper.getJavaClass(adapterValue);
                type = theClass = CompilerHelper.getTypeFromAdapterClass(adapterClass, this.helper);
                converter = new XMLJavaTypeConverter(adapterClass.getQualifiedName());
            }
            if (next.getXmlJoinNodes() != null) {
                ArrayList<XMLField> srcFlds = new ArrayList<XMLField>();
                ArrayList<XMLField> tgtFlds = new ArrayList<XMLField>();
                for (XmlJoinNodes.XmlJoinNode xmlJoinNode : next.getXmlJoinNodes().getXmlJoinNode()) {
                    srcFlds.add(new XMLField(xmlJoinNode.getXmlPath()));
                    tgtFlds.add(new XMLField(xmlJoinNode.getReferencedXmlPath()));
                }
                mapping.addChoiceElement(srcFlds, type.getQualifiedName(), tgtFlds);
                continue;
            }
            if (isIdRef) {
                String tgtXPath = null;
                TypeInfo referenceType = this.typeInfo.get(type.getQualifiedName());
                if (referenceType != null && referenceType.isIDSet()) {
                    Property prop;
                    tgtXPath = this.getXPathForField(prop, namespace, !(prop = referenceType.getIDProperty()).isAttribute()).getXPath();
                }
                XMLField srcXPath = next.getXmlPath() != null ? new XMLField(next.getXmlPath()) : this.getXPathForField(next, namespace, true);
                mapping.addChoiceElement(srcXPath.getXPath(), type.getQualifiedName(), tgtXPath);
                continue;
            }
            XMLField xpath = next.getXmlPath() != null ? new XMLField(next.getXmlPath()) : this.getXPathForField(next, namespace, !this.typeInfo.containsKey(type.getQualifiedName()) || next.isMtomAttachment());
            mapping.addChoiceElement(xpath, type.getQualifiedName());
            if (originalType.getQualifiedName().equals(type.getQualifiedName())) continue;
            if (mapping.getClassNameToFieldMappings().get(originalType.getQualifiedName()) == null) {
                mapping.getClassNameToFieldMappings().put(originalType.getQualifiedName(), xpath);
            }
            mapping.addConverter(xpath, (Converter)converter);
        }
        return mapping;
    }

    public XMLChoiceCollectionMapping generateChoiceCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespace) {
        JavaClass collectionType;
        XMLChoiceCollectionMapping mapping = new XMLChoiceCollectionMapping();
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping);
        mapping.setAttributeName(property.getPropertyName());
        if (property.isSetReadOnly()) {
            mapping.setIsReadOnly(property.isReadOnly());
        }
        if (property.isSetWriteOnly()) {
            mapping.setIsWriteOnly(property.isWriteOnly());
        }
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if ((collectionType = property.getType()).isArray() || this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        if (property.isSetXmlElementWrapper()) {
            mapping.setWrapperNullPolicy(this.getWrapperNullPolicyFromProperty(property));
        }
        boolean isIdRef = property.isXmlIdRef();
        for (Property next : property.getChoiceProperties()) {
            XmlJavaTypeAdapter adapter;
            JavaClass type = next.getType();
            JavaClass originalType = next.getType();
            XMLJavaTypeConverter converter = null;
            TypeInfo info = this.typeInfo.get(type.getName());
            if (info != null && (adapter = info.getXmlJavaTypeAdapter()) != null) {
                JavaClass theClass;
                String adapterValue = adapter.getValue();
                JavaClass adapterClass = this.helper.getJavaClass(adapterValue);
                type = theClass = CompilerHelper.getTypeFromAdapterClass(adapterClass, this.helper);
                converter = new XMLJavaTypeConverter(adapterClass.getQualifiedName());
            }
            if (next.getXmlJoinNodes() != null) {
                ArrayList<XMLField> srcFlds = new ArrayList<XMLField>();
                ArrayList<XMLField> tgtFlds = new ArrayList<XMLField>();
                for (XmlJoinNodes.XmlJoinNode xmlJoinNode : next.getXmlJoinNodes().getXmlJoinNode()) {
                    srcFlds.add(new XMLField(xmlJoinNode.getXmlPath()));
                    tgtFlds.add(new XMLField(xmlJoinNode.getReferencedXmlPath()));
                }
                mapping.addChoiceElement(srcFlds, type.getQualifiedName(), tgtFlds);
                continue;
            }
            if (isIdRef) {
                String tgtXPath = null;
                TypeInfo referenceType = this.typeInfo.get(type.getQualifiedName());
                if (referenceType != null && referenceType.isIDSet()) {
                    Property prop;
                    tgtXPath = this.getXPathForField(prop, namespace, !(prop = referenceType.getIDProperty()).isAttribute()).getXPath();
                }
                XMLField srcXPath = next.getXmlPath() != null ? new XMLField(next.getXmlPath()) : this.getXPathForField(next, namespace, true);
                mapping.addChoiceElement(srcXPath.getXPath(), type.getQualifiedName(), tgtXPath);
                continue;
            }
            XMLField xpath = next.getXmlPath() != null ? new XMLField(next.getXmlPath()) : this.getXPathForField(next, namespace, !this.typeInfo.containsKey(type.getQualifiedName()));
            mapping.addChoiceElement(xpath.getName(), type.getQualifiedName());
            if (originalType.getQualifiedName().equals(type.getQualifiedName())) continue;
            if (mapping.getClassNameToFieldMappings().get(originalType.getQualifiedName()) == null) {
                mapping.getClassNameToFieldMappings().put(originalType.getQualifiedName(), xpath);
            }
            mapping.addConverter(xpath, (Converter)converter);
        }
        return mapping;
    }

    public DatabaseMapping generateMappingForReferenceProperty(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLChoiceCollectionMapping mapping;
        boolean isCollection;
        boolean bl = isCollection = this.isCollectionType(property) || property.getType().isArray();
        if (property.isAny()) {
            return this.generateAnyCollectionMapping(property, descriptor, namespaceInfo, true);
        }
        if (isCollection) {
            mapping = new XMLChoiceCollectionMapping();
            this.initializeXMLContainerMapping((XMLContainerMapping)mapping);
            JavaClass collectionType = property.getType();
            if (collectionType.isArray() || this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
                collectionType = this.jotArrayList;
            } else if (this.areEquals(collectionType, Set.class)) {
                collectionType = this.jotHashSet;
            }
            mapping.useCollectionClassName(collectionType.getRawName());
            JAXBElementRootConverter jaxbERConverter = new JAXBElementRootConverter(Object.class);
            if (property.isSetXmlJavaTypeAdapter()) {
                JavaClass adapterClass = this.helper.getJavaClass(property.getXmlJavaTypeAdapter().getValue());
                jaxbERConverter.setNestedConverter((XMLConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
            }
            mapping.setConverter((Converter)jaxbERConverter);
            if (property.isSetWriteOnly()) {
                mapping.setIsWriteOnly(property.isWriteOnly());
            }
            if (property.isSetXmlElementWrapper()) {
                mapping.setWrapperNullPolicy(this.getWrapperNullPolicyFromProperty(property));
            }
        } else {
            mapping = new XMLChoiceObjectMapping();
            JAXBElementRootConverter jaxbERConverter = new JAXBElementRootConverter(Object.class);
            if (property.isSetXmlJavaTypeAdapter()) {
                JavaClass adapterClass = this.helper.getJavaClass(property.getXmlJavaTypeAdapter().getValue());
                jaxbERConverter.setNestedConverter((XMLConverter)new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
            }
            ((XMLChoiceObjectMapping)mapping).setConverter((Converter)jaxbERConverter);
            if (property.isSetWriteOnly()) {
                ((XMLChoiceObjectMapping)mapping).setIsWriteOnly(property.isWriteOnly());
            }
        }
        if (property.isSetReadOnly()) {
            mapping.setIsReadOnly(property.isReadOnly());
        }
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                ((XMLMapping)mapping).setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        List<ElementDeclaration> referencedElements = property.getReferencedElements();
        JavaClass propertyType = property.getType();
        if (propertyType.isArray()) {
            JAXBArrayAttributeAccessor accessor = new JAXBArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy(), this.helper.getClassLoader());
            accessor.setComponentClassName(property.getType().getComponentType().getQualifiedName());
            JavaClass componentType = propertyType.getComponentType();
            if (componentType.isArray()) {
                Class adaptedClass = this.classToGeneratedClasses.get(componentType.getQualifiedName());
                accessor.setAdaptedClassName(adaptedClass.getName());
            }
            mapping.setAttributeAccessor((AttributeAccessor)accessor);
        }
        String wrapperXPath = "";
        if (property.isSetXmlElementWrapper()) {
            XmlElementWrapper wrapper = property.getXmlElementWrapper();
            String namespace = wrapper.getNamespace();
            if (namespace.equals("##default")) {
                namespace = namespaceInfo.isElementFormQualified() ? namespaceInfo.getNamespace() : "";
            }
            if (namespace.equals("")) {
                wrapperXPath = String.valueOf(wrapperXPath) + wrapper.getName() + "/";
            } else {
                String prefix = this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolver(), null);
                wrapperXPath = String.valueOf(wrapperXPath) + this.getQualifiedString(prefix, String.valueOf(wrapper.getName()) + "/");
            }
        }
        if (property.isMixedContent() && isCollection) {
            if (wrapperXPath.length() == 0) {
                mapping.setMixedContent(true);
            } else {
                mapping.setMixedContent(wrapperXPath.substring(0, wrapperXPath.length() - 1));
            }
        }
        for (ElementDeclaration element : referencedElements) {
            Converter originalConverter;
            DatabaseMapping nestedMapping;
            QName elementName = element.getElementName();
            JavaClass pType = element.getJavaType();
            boolean isBinaryType = this.areEquals(pType, "javax.activation.DataHandler") || this.areEquals(pType, byte[].class) || this.areEquals(pType, Image.class) || this.areEquals(pType, Source.class) || this.areEquals(pType, "javax.mail.internet.MimeMultipart");
            boolean isText = !isBinaryType && !this.typeInfo.containsKey(element.getJavaTypeName()) && !element.getJavaTypeName().equals(OBJECT_CLASS_NAME);
            String xPath = wrapperXPath;
            XMLField xmlField = this.getXPathForElement(xPath, elementName, namespaceInfo, isText);
            if (this.helper.getXMLToJavaTypeMap().get(element.getJavaType().getRawName()) == XMLConstants.BASE_64_BINARY_QNAME) {
                xmlField.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            }
            if (this.areEquals(pType, Object.class)) {
                xmlField.setIsTypedTextField(true);
                xmlField.setSchemaType(XMLConstants.ANY_TYPE_QNAME);
            }
            if (isCollection) {
                XMLChoiceCollectionMapping xmlChoiceCollectionMapping = mapping;
                xmlChoiceCollectionMapping.addChoiceElement(xmlField, element.getJavaTypeName());
                nestedMapping = (DatabaseMapping)xmlChoiceCollectionMapping.getChoiceElementMappings().get(xmlField);
                if (nestedMapping.isAbstractCompositeCollectionMapping()) {
                    ((XMLCompositeCollectionMapping)nestedMapping).setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                }
                if (nestedMapping.isAbstractCompositeDirectCollectionMapping()) {
                    ((XMLCompositeDirectCollectionMapping)nestedMapping).getNullPolicy().setNullRepresentedByEmptyNode(false);
                }
                if (element.isList() && nestedMapping.isAbstractCompositeDirectCollectionMapping()) {
                    XMLListConverter listConverter = new XMLListConverter();
                    listConverter.setObjectClassName(element.getJavaType().getQualifiedName());
                    ((XMLCompositeDirectCollectionMapping)nestedMapping).setValueConverter((Converter)listConverter);
                }
            } else {
                XMLChoiceObjectMapping xmlChoiceObjectMapping = (XMLChoiceObjectMapping)mapping;
                xmlChoiceObjectMapping.addChoiceElement(xmlField, element.getJavaTypeName());
                nestedMapping = (DatabaseMapping)xmlChoiceObjectMapping.getChoiceElementMappings().get(xmlField);
                if (nestedMapping.isAbstractCompositeObjectMapping()) {
                    ((XMLCompositeObjectMapping)nestedMapping).setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                }
            }
            if (element.isXmlRootElement()) continue;
            Class<JAXBElement.GlobalScope> scopeClass = element.getScopeClass();
            if (scopeClass == XmlElementDecl.GLOBAL.class) {
                scopeClass = JAXBElement.GlobalScope.class;
            }
            Class declaredType = this.helper.getClassForJavaClass(element.getJavaType());
            JAXBElementConverter converter = new JAXBElementConverter(xmlField, declaredType, scopeClass);
            if (isCollection) {
                XMLChoiceCollectionMapping xmlChoiceCollectionMapping = mapping;
                originalConverter = xmlChoiceCollectionMapping.getConverter(xmlField);
                converter.setNestedConverter(originalConverter);
                xmlChoiceCollectionMapping.addConverter(xmlField, (Converter)converter);
                continue;
            }
            XMLChoiceObjectMapping xmlChoiceObjectMapping = (XMLChoiceObjectMapping)mapping;
            originalConverter = xmlChoiceObjectMapping.getConverter(xmlField);
            converter.setNestedConverter(originalConverter);
            xmlChoiceObjectMapping.addConverter(xmlField, (Converter)converter);
        }
        return mapping;
    }

    public XMLAnyCollectionMapping generateAnyCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, boolean isMixed) {
        XMLAnyCollectionMapping mapping = new XMLAnyCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping);
        if (property.isSetReadOnly()) {
            mapping.setIsReadOnly(property.isReadOnly());
        }
        if (property.isSetWriteOnly()) {
            mapping.setIsWriteOnly(property.isWriteOnly());
        }
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.getXmlPath() != null) {
            mapping.setField((DatabaseField)new XMLField(property.getXmlPath()));
        } else if (property.isSetXmlElementWrapper()) {
            mapping.setField((DatabaseField)this.getXPathForField(property, namespaceInfo, false, true));
        }
        if (property.isSetXmlElementWrapper()) {
            mapping.setWrapperNullPolicy(this.getWrapperNullPolicyFromProperty(property));
        }
        Class declaredType = this.helper.getClassForJavaClass(property.getActualType());
        JAXBElementRootConverter jaxbElementRootConverter = new JAXBElementRootConverter(declaredType);
        mapping.setConverter((XMLConverter)jaxbElementRootConverter);
        if (property.getDomHandlerClassName() != null) {
            jaxbElementRootConverter.setNestedConverter(new DomHandlerConverter(property.getDomHandlerClassName()));
        }
        if (property.isLax() || property.isReference()) {
            mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        } else {
            mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT);
        }
        mapping.setMixedContent(isMixed);
        if (isMixed) {
            mapping.setPreserveWhitespaceForMixedContent(true);
        }
        mapping.setUseXMLRoot(true);
        JavaClass collectionType = property.getType();
        if (collectionType.isArray()) {
            JAXBArrayAttributeAccessor accessor = new JAXBArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy(), this.helper.getClassLoader());
            JavaClass componentType = collectionType.getComponentType();
            if (componentType.isArray()) {
                JavaClass baseComponentType = this.getBaseComponentType(componentType);
                if (baseComponentType.isPrimitive()) {
                    Class primitiveClass = XMLConversionManager.getDefaultManager().convertClassNameToClass(baseComponentType.getRawName());
                    accessor.setComponentClass(primitiveClass);
                } else {
                    accessor.setComponentClassName(baseComponentType.getQualifiedName());
                }
            } else {
                accessor.setComponentClassName(componentType.getQualifiedName());
            }
            mapping.setAttributeAccessor((AttributeAccessor)accessor);
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClass(this.helper.getClassForJavaClass(collectionType));
        return mapping;
    }

    public XMLCompositeObjectMapping generateCompositeObjectMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, String referenceClassName) {
        XMLCompositeObjectMapping mapping = new XMLCompositeObjectMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isSetReadOnly()) {
            mapping.setIsReadOnly(property.isReadOnly());
        }
        if (property.isSetWriteOnly()) {
            mapping.setIsWriteOnly(property.isWriteOnly());
        }
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                if (!property.isXmlLocation()) {
                    mapping.setIsWriteOnly(true);
                }
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setXPath(this.getXPathForField(property, namespaceInfo, false).getXPath());
        if (property.isSetNullPolicy()) {
            mapping.setNullPolicy(this.getNullPolicyFromProperty(property, namespaceInfo.getNamespaceResolverForDescriptor()));
        } else if (property.isNillable()) {
            mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
            mapping.getNullPolicy().setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
        }
        if (referenceClassName == null) {
            ((XMLField)mapping.getField()).setIsTypedTextField(true);
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.ANY_TYPE_QNAME);
            String defaultValue = property.getDefaultValue();
            if (defaultValue != null) {
                mapping.setConverter((Converter)new DefaultElementConverter(defaultValue));
            }
        } else {
            mapping.setReferenceClassName(referenceClassName);
        }
        if (property.getInverseReferencePropertyName() != null) {
            mapping.setContainerAttributeName(property.getInverseReferencePropertyName());
            JavaClass backPointerPropertyType = null;
            JavaClass referenceClass = property.getActualType();
            if (property.getInverseReferencePropertyGetMethodName() != null && property.getInverseReferencePropertySetMethodName() != null && !property.getInverseReferencePropertyGetMethodName().equals("") && !property.getInverseReferencePropertySetMethodName().equals("")) {
                mapping.setContainerGetMethodName(property.getInverseReferencePropertySetMethodName());
                mapping.setContainerSetMethodName(property.getInverseReferencePropertySetMethodName());
                JavaMethod getMethod = referenceClass.getDeclaredMethod(mapping.getContainerGetMethodName(), new JavaClass[0]);
                if (getMethod != null) {
                    backPointerPropertyType = getMethod.getReturnType();
                }
            } else {
                JavaField backpointerField = referenceClass.getDeclaredField(property.getInverseReferencePropertyName());
                if (backpointerField != null) {
                    backPointerPropertyType = backpointerField.getResolvedType();
                }
            }
            if (this.isCollectionType(backPointerPropertyType)) {
                mapping.getInverseReferenceMapping().setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
            }
        }
        if (property.isRequired()) {
            ((XMLField)mapping.getField()).setRequired(true);
        }
        return mapping;
    }

    public XMLDirectMapping generateDirectMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLDirectMapping mapping = new XMLDirectMapping();
        mapping.setAttributeName(property.getPropertyName());
        String fixedValue = property.getFixedValue();
        if (fixedValue != null) {
            mapping.setIsWriteOnly(true);
        }
        if (property.isSetReadOnly()) {
            mapping.setIsReadOnly(property.isReadOnly());
        }
        if (property.isSetWriteOnly()) {
            mapping.setIsWriteOnly(property.isWriteOnly());
        }
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        XMLField xmlField = this.getXPathForField(property, namespaceInfo, true);
        mapping.setField((DatabaseField)xmlField);
        if (property.getDefaultValue() != null) {
            mapping.setNullValue((Object)property.getDefaultValue());
        }
        if (property.isSetNullPolicy()) {
            mapping.setNullPolicy(this.getNullPolicyFromProperty(property, namespaceInfo.getNamespaceResolverForDescriptor()));
        } else {
            if (property.isNillable()) {
                mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
                mapping.getNullPolicy().setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
            }
            mapping.getNullPolicy().setNullRepresentedByEmptyNode(false);
            if (!mapping.getXPath().equals("text()")) {
                ((NullPolicy)mapping.getNullPolicy()).setSetPerformedForAbsentNode(false);
            }
        }
        if (property.isRequired()) {
            ((XMLField)mapping.getField()).setRequired(true);
        }
        if (property.getType() != null) {
            String theClass = null;
            theClass = property.isSetXmlJavaTypeAdapter() ? property.getOriginalType().getQualifiedName() : property.getType().getQualifiedName();
            try {
                JavaClass actualJavaClass = this.helper.getJavaClass(theClass);
                Class actualClass = this.helper.getClassForJavaClass(actualJavaClass);
                mapping.setAttributeClassification(actualClass);
            }
            catch (Exception exception) {
                mapping.setAttributeClassificationName(theClass);
            }
        }
        if (XMLConstants.QNAME_QNAME.equals(property.getSchemaType())) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.QNAME_QNAME);
        }
        if (property.isSetCdata()) {
            mapping.setIsCDATA(property.isCdata());
        }
        return mapping;
    }

    public XMLBinaryDataMapping generateBinaryMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLField f;
        XMLBinaryDataMapping mapping = new XMLBinaryDataMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isSetReadOnly()) {
            mapping.setIsReadOnly(property.isReadOnly());
        }
        if (property.isSetWriteOnly()) {
            mapping.setIsWriteOnly(property.isWriteOnly());
        }
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setField((DatabaseField)this.getXPathForField(property, namespaceInfo, false));
        if (property.isSwaAttachmentRef()) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.SWA_REF_QNAME);
            mapping.setSwaRef(true);
        } else if (property.isMtomAttachment() && !(f = (XMLField)mapping.getField()).getSchemaType().equals(XMLConstants.HEX_BINARY_QNAME)) {
            f.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
        }
        if (property.isInlineBinaryData()) {
            mapping.setShouldInlineBinaryData(true);
        }
        if (property.getMimeType() != null) {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy(property.getMimeType(), (DatabaseMapping)mapping));
        } else if (this.areEquals(property.getType(), Source.class)) {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/xml", (DatabaseMapping)mapping));
        } else if (this.areEquals(property.getType(), Image.class)) {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("image/png", (DatabaseMapping)mapping));
        } else {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/octet-stream", (DatabaseMapping)mapping));
        }
        mapping.setAttributeClassificationName(property.getActualType().getQualifiedName());
        return mapping;
    }

    public XMLBinaryDataCollectionMapping generateBinaryDataCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLBinaryDataCollectionMapping mapping = new XMLBinaryDataCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping);
        if (property.isSetReadOnly()) {
            mapping.setIsReadOnly(property.isReadOnly());
        }
        if (property.isSetWriteOnly()) {
            mapping.setIsWriteOnly(property.isWriteOnly());
        }
        if (property.isSetXmlElementWrapper()) {
            mapping.setWrapperNullPolicy(this.getWrapperNullPolicyFromProperty(property));
        }
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setField((DatabaseField)this.getXPathForField(property, namespaceInfo, false));
        if (property.isSwaAttachmentRef()) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.SWA_REF_QNAME);
            mapping.setSwaRef(true);
        } else if (property.isMtomAttachment()) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
        }
        if (property.isInlineBinaryData()) {
            mapping.setShouldInlineBinaryData(true);
        }
        if (property.getMimeType() != null) {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy(property.getMimeType()));
        } else if (this.areEquals(property.getType(), Source.class)) {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/xml"));
        } else {
            mapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy("application/octet-stream"));
        }
        JavaClass collectionType = property.getType();
        JavaClass itemType = property.getActualType();
        if (collectionType != null && this.isCollectionType(collectionType)) {
            try {
                Class declaredClass = PrivilegedAccessHelper.getClassForName((String)itemType.getQualifiedName(), (boolean)false, (ClassLoader)this.helper.getClassLoader());
                mapping.setAttributeElementClass(declaredClass);
            }
            catch (Exception exception) {}
        }
        if (collectionType.isArray() || this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        return mapping;
    }

    public XMLDirectMapping generateDirectEnumerationMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, EnumTypeInfo enumInfo) {
        XMLDirectMapping mapping = new XMLDirectMapping();
        mapping.setConverter((Converter)this.buildJAXBEnumTypeConverter((DatabaseMapping)mapping, enumInfo));
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setField((DatabaseField)this.getXPathForField(property, namespaceInfo, true));
        if (!mapping.getXPath().equals("text()")) {
            ((NullPolicy)mapping.getNullPolicy()).setSetPerformedForAbsentNode(false);
        }
        return mapping;
    }

    private JAXBEnumTypeConverter buildJAXBEnumTypeConverter(DatabaseMapping mapping, EnumTypeInfo enumInfo) {
        JAXBEnumTypeConverter converter = new JAXBEnumTypeConverter(mapping, enumInfo.getClassName(), false);
        List<String> fieldNames = enumInfo.getFieldNames();
        List<String> xmlEnumValues = enumInfo.getXmlEnumValues();
        int i = 0;
        while (i < fieldNames.size()) {
            converter.addConversionValue(xmlEnumValues.get(i), fieldNames.get(i));
            ++i;
        }
        return converter;
    }

    public DatabaseMapping generateCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        JavaClass javaClass = property.getActualType();
        if (property.isMixedContent()) {
            return this.generateAnyCollectionMapping(property, descriptor, namespaceInfo, true);
        }
        if (property.isXmlIdRef() || property.isSetXmlJoinNodes()) {
            return this.generateXMLCollectionReferenceMapping(property, descriptor, namespaceInfo, javaClass);
        }
        if (javaClass != null && this.typeInfo.get(javaClass.getQualifiedName()) != null) {
            TypeInfo referenceInfo = this.typeInfo.get(javaClass.getQualifiedName());
            if (referenceInfo.isEnumerationType()) {
                return this.generateEnumCollectionMapping(property, descriptor, namespaceInfo, (EnumTypeInfo)referenceInfo);
            }
            return this.generateCompositeCollectionMapping(property, descriptor, namespaceInfo, javaClass.getQualifiedName());
        }
        if (!property.isAttribute() && javaClass != null && javaClass.getQualifiedName().equals(OBJECT_CLASS_NAME)) {
            XMLCompositeCollectionMapping ccMapping = this.generateCompositeCollectionMapping(property, descriptor, namespaceInfo, null);
            ccMapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
            return ccMapping;
        }
        if (this.isBinaryData(javaClass)) {
            return this.generateBinaryDataCollectionMapping(property, descriptor, namespaceInfo);
        }
        return this.generateDirectCollectionMapping(property, descriptor, namespaceInfo);
    }

    public XMLCompositeDirectCollectionMapping generateEnumCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, EnumTypeInfo info) {
        XMLCompositeDirectCollectionMapping mapping = this.generateDirectCollectionMapping(property, descriptor, namespaceInfo);
        mapping.setValueConverter((Converter)this.buildJAXBEnumTypeConverter((DatabaseMapping)mapping, info));
        return mapping;
    }

    public XMLAnyAttributeMapping generateAnyAttributeMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLAnyAttributeMapping mapping = new XMLAnyAttributeMapping();
        mapping.setAttributeName(property.getPropertyName());
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping);
        if (property.isSetReadOnly()) {
            mapping.setIsReadOnly(property.isReadOnly());
        }
        if (property.isSetWriteOnly()) {
            mapping.setIsWriteOnly(property.isWriteOnly());
        }
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.getXmlPath() != null) {
            mapping.setField((DatabaseField)new XMLField(property.getXmlPath()));
        }
        mapping.setSchemaInstanceIncluded(false);
        mapping.setNamespaceDeclarationIncluded(false);
        JavaClass mapType = property.getType();
        if (this.areEquals(mapType, Map.class)) {
            mapType = this.jotHashMap;
        }
        mapping.useMapClassName(mapType.getRawName());
        return mapping;
    }

    public XMLAnyObjectMapping generateAnyObjectMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLAnyObjectMapping mapping = new XMLAnyObjectMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isSetReadOnly()) {
            mapping.setIsReadOnly(property.isReadOnly());
        }
        if (property.isSetWriteOnly()) {
            mapping.setIsWriteOnly(property.isWriteOnly());
        }
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.getXmlPath() != null) {
            mapping.setField((DatabaseField)new XMLField(property.getXmlPath()));
        }
        Class declaredType = this.helper.getClassForJavaClass(property.getActualType());
        JAXBElementRootConverter jaxbElementRootConverter = new JAXBElementRootConverter(declaredType);
        mapping.setConverter((XMLConverter)jaxbElementRootConverter);
        if (property.getDomHandlerClassName() != null) {
            jaxbElementRootConverter.setNestedConverter(new DomHandlerConverter(property.getDomHandlerClassName()));
        }
        if (property.isLax()) {
            mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        } else {
            mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT);
        }
        if (property.isMixedContent()) {
            mapping.setMixedContent(true);
        } else {
            mapping.setUseXMLRoot(true);
        }
        return mapping;
    }

    protected boolean areEquals(JavaClass src, Class tgt) {
        if (src == null || tgt == null) {
            return false;
        }
        return src.getRawName().equals(tgt.getCanonicalName());
    }

    protected boolean areEquals(JavaClass src, String tgtCanonicalName) {
        if (src == null || tgtCanonicalName == null) {
            return false;
        }
        return src.getRawName().equals(tgtCanonicalName);
    }

    public XMLCompositeCollectionMapping generateMapMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLCompositeCollectionMapping mapping = new XMLCompositeCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping);
        XMLField field = this.getXPathForField(property, namespaceInfo, false);
        JavaClass descriptorClass = this.helper.getJavaClass(descriptor.getJavaClassName());
        JavaClass mapValueClass = this.helper.getJavaClass(MapValue.class);
        if (mapValueClass.isAssignableFrom(descriptorClass)) {
            mapping.setXPath("entry");
        } else {
            mapping.setXPath(String.valueOf(field.getXPath()) + "/entry");
        }
        Class generatedClass = this.generateMapEntryClassAndDescriptor(property, descriptor.getNonNullNamespaceResolver());
        mapping.setReferenceClass(generatedClass);
        String mapClassName = property.getType().getRawName();
        mapping.useCollectionClass(ArrayList.class);
        mapping.setAttributeAccessor((AttributeAccessor)new MapValueAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy(), generatedClass, mapClassName));
        return mapping;
    }

    private Class generateMapEntryClassAndDescriptor(Property property, NamespaceResolver nr) {
        JavaClass keyType = property.getKeyType();
        JavaClass valueType = property.getValueType();
        if (keyType == null) {
            keyType = this.helper.getJavaClass("java.lang.Object");
        }
        if (valueType == null) {
            valueType = this.helper.getJavaClass("java.lang.Object");
        }
        String mapEntryClassName = this.getJaxbClassLoader().nextAvailableGeneratedClassName();
        MapEntryGeneratedKey mapKey = new MapEntryGeneratedKey(keyType.getQualifiedName(), valueType.getQualifiedName());
        Class generatedClass = this.getGeneratedMapEntryClasses().get(mapKey);
        if (generatedClass == null) {
            generatedClass = this.generateMapEntryClass(mapEntryClassName, keyType.getQualifiedName(), valueType.getQualifiedName());
            this.getGeneratedMapEntryClasses().put(mapKey, generatedClass);
            XMLDescriptor desc = new XMLDescriptor();
            desc.setJavaClass(generatedClass);
            desc.addMapping(this.generateMappingForType(keyType, "key"));
            desc.addMapping(this.generateMappingForType(valueType, "value"));
            desc.setNamespaceResolver(nr);
            this.project.addDescriptor((ClassDescriptor)desc);
        }
        return generatedClass;
    }

    private Class generateMapEntryClass(String className, String keyType, String valueType) {
        ClassWriter cw = new ClassWriter(2);
        String qualifiedInternalClassName = className.replace('.', '/');
        String qualifiedInternalKeyClassName = keyType.replace('.', '/');
        String qualifiedInternalValueClassName = valueType.replace('.', '/');
        String sig = "Ljava/lang/Object;Lorg/eclipse/persistence/internal/jaxb/many/MapEntry<L" + qualifiedInternalKeyClassName + ";L" + qualifiedInternalValueClassName + ";>;";
        cw.visit(49, 33, qualifiedInternalClassName, sig, "java/lang/Object", new String[]{"org/eclipse/persistence/internal/jaxb/many/MapEntry"});
        cw.visitField(2, "key", "L" + qualifiedInternalKeyClassName + ";", null, null);
        cw.visitField(2, "value", "L" + qualifiedInternalValueClassName + ";", null, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getKey", "()L" + qualifiedInternalKeyClassName + ";", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, qualifiedInternalClassName, "key", "L" + qualifiedInternalKeyClassName + ";");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "setKey", "(L" + qualifiedInternalKeyClassName + ";)V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, qualifiedInternalClassName, "key", "L" + qualifiedInternalKeyClassName + ";");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getValue", "()L" + qualifiedInternalValueClassName + ";", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, qualifiedInternalClassName, "value", "L" + qualifiedInternalValueClassName + ";");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "setValue", "(L" + qualifiedInternalValueClassName + ";)V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, qualifiedInternalClassName, "value", "L" + qualifiedInternalValueClassName + ";");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        if (!qualifiedInternalValueClassName.equals("java/lang/Object")) {
            mv = cw.visitMethod(4161, "getValue", "()Ljava/lang/Object;", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, qualifiedInternalClassName, "getValue", "()L" + qualifiedInternalValueClassName + ";");
            mv.visitInsn(176);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            mv = cw.visitMethod(4161, "setValue", "(Ljava/lang/Object;)V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, qualifiedInternalValueClassName);
            mv.visitMethodInsn(182, qualifiedInternalClassName, "setValue", "(L" + qualifiedInternalValueClassName + ";)V");
            mv.visitInsn(177);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
        }
        if (!qualifiedInternalKeyClassName.equals("java/lang/Object")) {
            mv = cw.visitMethod(4161, "getKey", "()Ljava/lang/Object;", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, qualifiedInternalClassName, "getKey", "()L" + qualifiedInternalKeyClassName + ";");
            mv.visitInsn(176);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            mv = cw.visitMethod(4161, "setKey", "(Ljava/lang/Object;)V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, qualifiedInternalKeyClassName);
            mv.visitMethodInsn(182, qualifiedInternalClassName, "setKey", "(L" + qualifiedInternalKeyClassName + ";)V");
            mv.visitInsn(177);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
        }
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        Class generatedClass = this.getJaxbClassLoader().generateClass(className, classBytes);
        return generatedClass;
    }

    private DatabaseMapping generateMappingForType(JavaClass theType, String attributeName) {
        XMLCompositeObjectMapping mapping;
        boolean typeIsObject = theType.getRawName().equals(OBJECT_CLASS_NAME);
        TypeInfo info = this.typeInfo.get(theType.getQualifiedName());
        if (info != null && !info.isEnumerationType() || typeIsObject) {
            mapping = new XMLCompositeObjectMapping();
            mapping.setAttributeName(attributeName);
            mapping.setXPath(attributeName);
            if (typeIsObject) {
                mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                ((XMLField)mapping.getField()).setIsTypedTextField(true);
                ((XMLField)mapping.getField()).setSchemaType(XMLConstants.ANY_TYPE_QNAME);
            } else {
                mapping.setReferenceClassName(theType.getQualifiedName());
            }
        } else {
            mapping = new XMLDirectMapping();
            mapping.setAttributeName(attributeName);
            ((XMLDirectMapping)mapping).setXPath(String.valueOf(attributeName) + TXT);
            QName schemaType = this.userDefinedSchemaTypes.get(theType.getQualifiedName());
            if (schemaType == null) {
                schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(theType);
            }
            ((XMLField)((XMLDirectMapping)mapping).getField()).setSchemaType(schemaType);
            if (info != null && info.isEnumerationType()) {
                ((XMLDirectMapping)mapping).setConverter((Converter)this.buildJAXBEnumTypeConverter((DatabaseMapping)mapping, (EnumTypeInfo)info));
            }
        }
        return mapping;
    }

    public XMLCompositeCollectionMapping generateCompositeCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, String referenceClassName) {
        JavaClass collectionType;
        XMLCompositeCollectionMapping mapping = new XMLCompositeCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping);
        if (property.isSetReadOnly()) {
            mapping.setIsReadOnly(property.isReadOnly());
        }
        if (property.isSetWriteOnly()) {
            mapping.setIsWriteOnly(property.isWriteOnly());
        }
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.isSetNullPolicy()) {
            mapping.setNullPolicy(this.getNullPolicyFromProperty(property, namespaceInfo.getNamespaceResolverForDescriptor()));
        } else if (property.isNillable()) {
            mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
            mapping.getNullPolicy().setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
        }
        if (property.isSetXmlElementWrapper()) {
            mapping.setWrapperNullPolicy(this.getWrapperNullPolicyFromProperty(property));
        }
        if ((collectionType = property.getType()).isArray()) {
            JAXBArrayAttributeAccessor accessor = new JAXBArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy(), this.helper.getClassLoader());
            JavaClass componentType = collectionType.getComponentType();
            if (componentType.isArray()) {
                Class adaptedClass = this.classToGeneratedClasses.get(componentType.getName());
                referenceClassName = adaptedClass.getName();
                accessor.setAdaptedClassName(referenceClassName);
                JavaClass baseComponentType = this.getBaseComponentType(componentType);
                if (baseComponentType.isPrimitive()) {
                    Class primitiveClass = XMLConversionManager.getDefaultManager().convertClassNameToClass(baseComponentType.getRawName());
                    accessor.setComponentClass(primitiveClass);
                } else {
                    accessor.setComponentClassName(baseComponentType.getQualifiedName());
                }
            } else {
                accessor.setComponentClassName(componentType.getQualifiedName());
            }
            mapping.setAttributeAccessor((AttributeAccessor)accessor);
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        XMLField xmlField = this.getXPathForField(property, namespaceInfo, false);
        mapping.setXPath(xmlField.getXPath());
        if (referenceClassName == null) {
            ((XMLField)mapping.getField()).setIsTypedTextField(true);
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.ANY_TYPE_QNAME);
        } else {
            mapping.setReferenceClassName(referenceClassName);
        }
        if (property.isRequired()) {
            ((XMLField)mapping.getField()).setRequired(true);
        }
        if (property.getInverseReferencePropertyName() != null) {
            mapping.setContainerAttributeName(property.getInverseReferencePropertyName());
            JavaClass backPointerPropertyType = null;
            JavaClass referenceClass = property.getActualType();
            if (property.getInverseReferencePropertyGetMethodName() != null && property.getInverseReferencePropertySetMethodName() != null && !property.getInverseReferencePropertyGetMethodName().equals("") && !property.getInverseReferencePropertySetMethodName().equals("")) {
                mapping.setContainerGetMethodName(property.getInverseReferencePropertySetMethodName());
                mapping.setContainerSetMethodName(property.getInverseReferencePropertySetMethodName());
                JavaMethod getMethod = referenceClass.getDeclaredMethod(mapping.getContainerGetMethodName(), new JavaClass[0]);
                if (getMethod != null) {
                    backPointerPropertyType = getMethod.getReturnType();
                }
            } else {
                JavaField backpointerField = referenceClass.getDeclaredField(property.getInverseReferencePropertyName());
                if (backpointerField != null) {
                    backPointerPropertyType = backpointerField.getResolvedType();
                }
            }
            if (this.isCollectionType(backPointerPropertyType)) {
                mapping.getInverseReferenceMapping().setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
            }
        }
        return mapping;
    }

    public XMLCompositeDirectCollectionMapping generateDirectCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        JavaClass collectionType;
        XMLCompositeDirectCollectionMapping mapping = new XMLCompositeDirectCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping);
        if (property.isSetReadOnly()) {
            mapping.setIsReadOnly(property.isReadOnly());
        }
        if (property.isSetWriteOnly()) {
            mapping.setIsWriteOnly(property.isWriteOnly());
        }
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if ((collectionType = property.getType()).isArray()) {
            JAXBArrayAttributeAccessor accessor = new JAXBArrayAttributeAccessor(mapping.getAttributeAccessor(), mapping.getContainerPolicy(), this.helper.getClassLoader());
            String componentClassName = collectionType.getComponentType().getQualifiedName();
            if (collectionType.getComponentType().isPrimitive()) {
                Class primitiveClass = XMLConversionManager.getDefaultManager().convertClassNameToClass(componentClassName);
                accessor.setComponentClass(primitiveClass);
                mapping.setAttributeAccessor((AttributeAccessor)accessor);
                XMLConversionManager.getDefaultManager();
                Class declaredClass = ConversionManager.getObjectClass((Class)primitiveClass);
                mapping.setAttributeElementClass(declaredClass);
            } else {
                accessor.setComponentClassName(componentClassName);
                mapping.setAttributeAccessor((AttributeAccessor)accessor);
                JavaClass componentType = collectionType.getComponentType();
                try {
                    Class declaredClass = PrivilegedAccessHelper.getClassForName((String)componentType.getRawName(), (boolean)false, (ClassLoader)this.helper.getClassLoader());
                    mapping.setAttributeElementClass(declaredClass);
                }
                catch (Exception exception) {}
            }
            collectionType = this.jotArrayList;
        } else if (this.isCollectionType(collectionType) && collectionType.hasActualTypeArguments()) {
            JavaClass itemType = (JavaClass)collectionType.getActualTypeArguments().toArray()[0];
            try {
                Class declaredClass = PrivilegedAccessHelper.getClassForName((String)itemType.getRawName(), (boolean)false, (ClassLoader)this.helper.getClassLoader());
                mapping.setAttributeElementClass(declaredClass);
            }
            catch (Exception exception) {}
        }
        if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        XMLField xmlField = this.getXPathForField(property, namespaceInfo, true);
        mapping.setField((DatabaseField)xmlField);
        if (this.helper.isAnnotationPresent(property.getElement(), XmlMixed.class)) {
            xmlField.setXPath("text()");
        }
        if (XMLConstants.QNAME_QNAME.equals(property.getSchemaType())) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.QNAME_QNAME);
        }
        if (property.isSetNullPolicy()) {
            mapping.setNullPolicy(this.getNullPolicyFromProperty(property, namespaceInfo.getNamespaceResolverForDescriptor()));
        } else if (property.isNillable()) {
            mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
            mapping.getNullPolicy().setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
        }
        mapping.getNullPolicy().setNullRepresentedByEmptyNode(false);
        if (property.isSetXmlElementWrapper()) {
            mapping.setWrapperNullPolicy(this.getWrapperNullPolicyFromProperty(property));
        }
        if (property.isRequired()) {
            ((XMLField)mapping.getField()).setRequired(true);
        }
        if (property.isXmlElementType() && property.getGenericType() != null) {
            Class theClass = this.helper.getClassForJavaClass(property.getGenericType());
            mapping.setAttributeElementClass(theClass);
        }
        if (xmlField.getXPathFragment().isAttribute() || property.isXmlList() || xmlField.getXPathFragment().nameIsText()) {
            mapping.setUsesSingleNode(true);
        }
        if (property.isSetCdata()) {
            mapping.setIsCDATA(property.isCdata());
        }
        return mapping;
    }

    public String getPrefixForNamespace(String URI2, NamespaceResolver namespaceResolver, String suggestedPrefix) {
        return this.getPrefixForNamespace(URI2, namespaceResolver, suggestedPrefix, true);
    }

    public String getPrefixForNamespace(String URI2, NamespaceResolver namespaceResolver, String suggestedPrefix, boolean addPrefixToNR) {
        String defaultNS = namespaceResolver.getDefaultNamespaceURI();
        if (defaultNS != null && URI2.equals(defaultNS)) {
            return null;
        }
        Enumeration keys = namespaceResolver.getPrefixes();
        while (keys.hasMoreElements()) {
            String next = (String)keys.nextElement();
            String nextUri = namespaceResolver.resolveNamespacePrefix(next);
            if (!nextUri.equals(URI2)) continue;
            return next;
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(URI2)) {
            return "xml";
        }
        String prefix = this.globalNamespaceResolver.resolveNamespaceURI(URI2);
        if (prefix == null) {
            prefix = suggestedPrefix != null ? this.globalNamespaceResolver.generatePrefix(suggestedPrefix) : this.globalNamespaceResolver.generatePrefix();
        }
        String nrUri = namespaceResolver.resolveNamespacePrefix(prefix);
        while (nrUri != null && !URI2.equals(nrUri)) {
            prefix = this.globalNamespaceResolver.generatePrefix();
            nrUri = namespaceResolver.resolveNamespacePrefix(prefix);
        }
        if (addPrefixToNR) {
            namespaceResolver.put(prefix, URI2);
        }
        this.globalNamespaceResolver.put(prefix, URI2);
        return prefix;
    }

    public boolean isCollectionType(Property field) {
        JavaClass type = field.getType();
        return this.isCollectionType(type);
    }

    public boolean isCollectionType(JavaClass type) {
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(type) || this.helper.getJavaClass(List.class).isAssignableFrom(type) || this.helper.getJavaClass(Set.class).isAssignableFrom(type);
    }

    private void setupInheritance(JavaClass jClass) {
        TypeInfo tInfo = this.typeInfo.get(jClass.getName());
        XMLDescriptor descriptor = tInfo.getDescriptor();
        if (descriptor == null) {
            return;
        }
        JavaClass superClass = CompilerHelper.getNextMappedSuperClass(jClass, this.typeInfo, this.helper);
        if (superClass == null) {
            return;
        }
        TypeInfo superTypeInfo = this.typeInfo.get(superClass.getName());
        if (superTypeInfo == null) {
            return;
        }
        XMLDescriptor superDescriptor = superTypeInfo.getDescriptor();
        if (superDescriptor != null) {
            Object value;
            XMLSchemaReference sRef = descriptor.getSchemaReference();
            if (sRef == null || sRef.getSchemaContext() == null) {
                return;
            }
            JavaClass rootMappedSuperClass = this.getRootMappedSuperClass(superClass);
            TypeInfo rootTypeInfo = this.typeInfo.get(rootMappedSuperClass.getName());
            XMLDescriptor rootDescriptor = rootTypeInfo.getDescriptor();
            if (rootDescriptor.getNamespaceResolver() == null) {
                rootDescriptor.setNamespaceResolver(new NamespaceResolver());
            }
            if (rootDescriptor.getInheritancePolicy().getClassIndicatorField() == null) {
                XMLField classIndicatorField;
                if (rootTypeInfo.isSetXmlDiscriminatorNode()) {
                    classIndicatorField = new XMLField(rootTypeInfo.getXmlDiscriminatorNode());
                } else {
                    classIndicatorField = new XMLField("@type");
                    classIndicatorField.getXPathFragment().setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
                }
                rootDescriptor.getInheritancePolicy().setClassIndicatorField((DatabaseField)classIndicatorField);
            }
            Object sCtx = null;
            if (tInfo.isSetXmlDiscriminatorValue()) {
                sCtx = tInfo.getXmlDiscriminatorValue();
            } else if (!tInfo.isAnonymousComplexType()) {
                sCtx = sRef.getSchemaContextAsQName();
            }
            if (sCtx != null) {
                descriptor.getInheritancePolicy().setParentClassName(superClass.getName());
                rootDescriptor.getInheritancePolicy().addClassNameIndicator(jClass.getName(), sCtx);
            }
            if ((value = rootDescriptor.getInheritancePolicy().getClassNameIndicatorMapping().get(rootDescriptor.getJavaClassName())) == null) {
                if (rootTypeInfo.isSetXmlDiscriminatorValue()) {
                    rootDescriptor.getInheritancePolicy().addClassNameIndicator(rootDescriptor.getJavaClassName(), (Object)rootTypeInfo.getXmlDiscriminatorValue());
                } else {
                    XMLSchemaReference rootSRef = rootDescriptor.getSchemaReference();
                    if (rootSRef != null && rootSRef.getSchemaContext() != null) {
                        QName rootSCtx = rootSRef.getSchemaContextAsQName();
                        rootDescriptor.getInheritancePolicy().addClassNameIndicator(rootDescriptor.getJavaClassName(), (Object)rootSCtx);
                    }
                }
            }
            rootDescriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        }
    }

    private JavaClass getRootMappedSuperClass(JavaClass javaClass) {
        JavaClass rootMappedSuperClass;
        JavaClass nextMappedSuperClass = rootMappedSuperClass = javaClass;
        while (nextMappedSuperClass != null) {
            if ((nextMappedSuperClass = CompilerHelper.getNextMappedSuperClass(nextMappedSuperClass, this.typeInfo, this.helper)) == null) {
                return rootMappedSuperClass;
            }
            rootMappedSuperClass = nextMappedSuperClass;
        }
        return rootMappedSuperClass;
    }

    public void generateMappings() {
        for (String next : this.typeInfo.keySet()) {
            DatabaseMapping mapping;
            JavaClass javaClass = this.helper.getJavaClass(next);
            TypeInfo info = this.typeInfo.get(next);
            if (info.isEnumerationType()) continue;
            NamespaceInfo namespaceInfo = this.packageToPackageInfoMappings.get(javaClass.getPackageName()).getNamespaceInfo();
            XMLDescriptor descriptor = info.getDescriptor();
            if (descriptor != null) {
                this.generateMappings(info, descriptor, namespaceInfo);
            }
            if (info.isIDSet() && (mapping = descriptor.getMappingForAttributeName(info.getIDProperty().getPropertyName())) != null) {
                descriptor.addPrimaryKeyField(mapping.getField());
            }
            if (info.hasXmlKeyProperties()) {
                for (Property keyProp : info.getXmlKeyProperties()) {
                    mapping = descriptor.getMappingForAttributeName(keyProp.getPropertyName());
                    if (mapping == null) continue;
                    descriptor.addPrimaryKeyField(mapping.getField());
                }
            }
            info.postInitialize();
        }
    }

    public void generateMappings(TypeInfo info, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        if (info.isAnonymousComplexType()) {
            this.generateInheritedMappingsForAnonymousType(info, descriptor, namespaceInfo);
        }
        List<Property> propertiesInOrder = info.getNonTransientPropertiesInPropOrder();
        int i = 0;
        while (i < propertiesInOrder.size()) {
            Property next = propertiesInOrder.get(i);
            if (next != null && (!next.isTransient() || next.isTransient() && next.isXmlLocation())) {
                DatabaseMapping mapping = this.generateMapping(next, descriptor, namespaceInfo);
                if (next.isVirtual()) {
                    VirtualAttributeAccessor accessor = new VirtualAttributeAccessor();
                    accessor.setAttributeName(mapping.getAttributeName());
                    String getMethod = info.getXmlVirtualAccessMethods().getGetMethod();
                    String setMethod = info.getXmlVirtualAccessMethods().getSetMethod();
                    if (mapping.getAttributeAccessor().isMethodAttributeAccessor()) {
                        getMethod = ((MethodAttributeAccessor)mapping.getAttributeAccessor()).getGetMethodName();
                        setMethod = ((MethodAttributeAccessor)mapping.getAttributeAccessor()).getSetMethodName();
                        accessor.setValueType(mapping.getAttributeClassification());
                    }
                    accessor.setGetMethodName(getMethod);
                    accessor.setSetMethodName(setMethod);
                    if (mapping.getAttributeAccessor() instanceof JAXBArrayAttributeAccessor) {
                        JAXBArrayAttributeAccessor jaa = (JAXBArrayAttributeAccessor)mapping.getAttributeAccessor();
                        jaa.setNestedAccessor((AttributeAccessor)accessor);
                    } else {
                        mapping.setAttributeAccessor((AttributeAccessor)accessor);
                    }
                }
                if (mapping != null) {
                    descriptor.addMapping(mapping);
                }
                if (next.isSetUserProperties()) {
                    mapping.setProperties(next.getUserProperties());
                }
            }
            next.postInitialize();
            ++i;
        }
    }

    private void generateInheritedMappingsForAnonymousType(TypeInfo info, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        ArrayList<TypeInfo> mappedParents = new ArrayList<TypeInfo>();
        JavaClass next = CompilerHelper.getNextMappedSuperClass(this.helper.getJavaClass(info.getJavaClassName()), this.typeInfo, this.helper);
        while (next != null) {
            TypeInfo nextInfo = this.typeInfo.get(next.getName());
            mappedParents.add(0, nextInfo);
            next = CompilerHelper.getNextMappedSuperClass(this.helper.getJavaClass(nextInfo.getJavaClassName()), this.typeInfo, this.helper);
        }
        for (TypeInfo nextInfo : mappedParents) {
            List<Property> propertiesInOrder = nextInfo.getNonTransientPropertiesInPropOrder();
            int i = 0;
            while (i < propertiesInOrder.size()) {
                Property nextProp = propertiesInOrder.get(i);
                if (nextProp != null) {
                    DatabaseMapping mapping = this.generateMapping(nextProp, descriptor, namespaceInfo);
                    descriptor.addMapping(mapping);
                    if (nextProp.isSetUserProperties()) {
                        mapping.setProperties(nextProp.getUserProperties());
                    }
                }
                ++i;
            }
        }
    }

    public XMLCollectionReferenceMapping generateXMLCollectionReferenceMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, JavaClass referenceClass) {
        XMLCollectionReferenceMapping mapping = new XMLCollectionReferenceMapping();
        mapping.setAttributeName(property.getPropertyName());
        this.initializeXMLContainerMapping((XMLContainerMapping)mapping);
        mapping.setUsesSingleNode(property.isXmlList() || property.isAttribute());
        if (property.isSetReadOnly()) {
            mapping.setIsReadOnly(property.isReadOnly());
        }
        if (property.isSetWriteOnly()) {
            mapping.setIsWriteOnly(property.isWriteOnly());
        }
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setReferenceClassName(referenceClass.getQualifiedName());
        JavaClass collectionType = property.getType();
        if (collectionType.isArray() || this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        if (property.isSetXmlJoinNodes()) {
            for (XmlJoinNodes.XmlJoinNode xmlJoinNode : property.getXmlJoinNodes().getXmlJoinNode()) {
                this.validateJoinNode(descriptor.getJavaClassName(), property, xmlJoinNode.getReferencedXmlPath(), referenceClass);
                mapping.addSourceToTargetKeyFieldAssociation(xmlJoinNode.getXmlPath(), xmlJoinNode.getReferencedXmlPath());
            }
        } else {
            TypeInfo referenceType = this.typeInfo.get(referenceClass.getQualifiedName());
            String tgtXPath = null;
            if (referenceType != null && referenceType.isIDSet()) {
                Property prop;
                tgtXPath = this.getXPathForField(prop, namespaceInfo, !(prop = referenceType.getIDProperty()).isAttribute()).getXPath();
            }
            XMLField srcXPath = property.getXmlPath() != null ? new XMLField(property.getXmlPath()) : this.getXPathForField(property, namespaceInfo, true);
            mapping.addSourceToTargetKeyFieldAssociation(srcXPath.getXPath(), tgtXPath);
        }
        if (property.getInverseReferencePropertyName() != null) {
            mapping.getInverseReferenceMapping().setAttributeName(property.getInverseReferencePropertyName());
            JavaClass backPointerPropertyType = null;
            if (property.getInverseReferencePropertyGetMethodName() != null && property.getInverseReferencePropertySetMethodName() != null && !property.getInverseReferencePropertyGetMethodName().equals("") && !property.getInverseReferencePropertySetMethodName().equals("")) {
                mapping.getInverseReferenceMapping().setGetMethodName(property.getInverseReferencePropertySetMethodName());
                mapping.getInverseReferenceMapping().setSetMethodName(property.getInverseReferencePropertySetMethodName());
                JavaMethod getMethod = referenceClass.getDeclaredMethod(mapping.getInverseReferenceMapping().getGetMethodName(), new JavaClass[0]);
                if (getMethod != null) {
                    backPointerPropertyType = getMethod.getReturnType();
                }
            } else {
                JavaField backpointerField = referenceClass.getDeclaredField(property.getInverseReferencePropertyName());
                if (backpointerField != null) {
                    backPointerPropertyType = backpointerField.getResolvedType();
                }
            }
            if (this.isCollectionType(backPointerPropertyType)) {
                mapping.getInverseReferenceMapping().setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
            }
        }
        return mapping;
    }

    public XMLObjectReferenceMapping generateXMLObjectReferenceMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, JavaClass referenceClass) {
        XMLObjectReferenceMapping mapping = new XMLObjectReferenceMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isSetReadOnly()) {
            mapping.setIsReadOnly(property.isReadOnly());
        }
        if (property.isSetWriteOnly()) {
            mapping.setIsWriteOnly(property.isWriteOnly());
        }
        if (property.isMethodProperty()) {
            if (property.getGetMethodName() == null) {
                String paramTypeAsString = property.getType().getName();
                mapping.setAttributeAccessor((AttributeAccessor)new JAXBSetMethodAttributeAccessor(paramTypeAsString, this.helper.getClassLoader()));
                mapping.setIsReadOnly(true);
                mapping.setSetMethodName(property.getSetMethodName());
            } else if (property.getSetMethodName() == null) {
                mapping.setGetMethodName(property.getGetMethodName());
                mapping.setIsWriteOnly(true);
            } else {
                mapping.setSetMethodName(property.getSetMethodName());
                mapping.setGetMethodName(property.getGetMethodName());
            }
        }
        mapping.setReferenceClassName(referenceClass.getQualifiedName());
        if (property.isSetXmlJoinNodes()) {
            for (XmlJoinNodes.XmlJoinNode xmlJoinNode : property.getXmlJoinNodes().getXmlJoinNode()) {
                this.validateJoinNode(descriptor.getJavaClassName(), property, xmlJoinNode.getReferencedXmlPath(), referenceClass);
                mapping.addSourceToTargetKeyFieldAssociation(xmlJoinNode.getXmlPath(), xmlJoinNode.getReferencedXmlPath());
            }
        } else {
            String tgtXPath = null;
            TypeInfo referenceType = this.typeInfo.get(referenceClass.getQualifiedName());
            if (referenceType != null && referenceType.isIDSet()) {
                Property prop;
                tgtXPath = this.getXPathForField(prop, namespaceInfo, !(prop = referenceType.getIDProperty()).isAttribute()).getXPath();
            }
            XMLField srcXPath = property.getXmlPath() != null ? new XMLField(property.getXmlPath()) : this.getXPathForField(property, namespaceInfo, true);
            mapping.addSourceToTargetKeyFieldAssociation(srcXPath.getXPath(), tgtXPath);
        }
        if (property.getInverseReferencePropertyName() != null) {
            mapping.getInverseReferenceMapping().setAttributeName(property.getInverseReferencePropertyName());
            JavaClass backPointerPropertyType = null;
            if (property.getInverseReferencePropertyGetMethodName() != null && property.getInverseReferencePropertySetMethodName() != null && !property.getInverseReferencePropertyGetMethodName().equals("") && !property.getInverseReferencePropertySetMethodName().equals("")) {
                mapping.getInverseReferenceMapping().setGetMethodName(property.getInverseReferencePropertySetMethodName());
                mapping.getInverseReferenceMapping().setSetMethodName(property.getInverseReferencePropertySetMethodName());
                JavaMethod getMethod = referenceClass.getDeclaredMethod(mapping.getInverseReferenceMapping().getGetMethodName(), new JavaClass[0]);
                if (getMethod != null) {
                    backPointerPropertyType = getMethod.getReturnType();
                }
            } else {
                JavaField backpointerField = referenceClass.getDeclaredField(property.getInverseReferencePropertyName());
                if (backpointerField != null) {
                    backPointerPropertyType = backpointerField.getResolvedType();
                }
            }
            if (this.isCollectionType(backPointerPropertyType)) {
                mapping.getInverseReferenceMapping().setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
            }
        }
        return mapping;
    }

    private void validateJoinNode(String className, Property property, String referencedXmlPath, JavaClass referenceClass) {
        TypeInfo targetInfo = this.typeInfo.get(referenceClass.getQualifiedName());
        NamespaceInfo namespaceInfo = this.packageToPackageInfoMappings.get(referenceClass.getPackageName()).getNamespaceInfo();
        Property idProp = targetInfo.getIDProperty();
        if (idProp != null) {
            String idXpath = idProp.getXmlPath();
            if (idXpath == null) {
                idXpath = this.getXPathForField(idProp, namespaceInfo, !idProp.isAttribute()).getXPath();
            }
            if (referencedXmlPath.equals(idXpath)) {
                return;
            }
        }
        boolean matched = false;
        if (targetInfo.getXmlKeyProperties() != null) {
            for (Property xmlkeyProperty : targetInfo.getXmlKeyProperties()) {
                String keyXpath = xmlkeyProperty.getXmlPath();
                if (keyXpath == null) {
                    keyXpath = this.getXPathForField(xmlkeyProperty, namespaceInfo, !xmlkeyProperty.isAttribute()).getXPath();
                }
                if (!referencedXmlPath.equals(keyXpath)) continue;
                matched = true;
                break;
            }
        }
        if (!matched) {
            throw JAXBException.invalidReferencedXmlPathOnJoin((String)className, (String)property.getPropertyName(), (String)referenceClass.getQualifiedName(), (String)referencedXmlPath);
        }
    }

    public XMLField getXPathForField(Property property, NamespaceInfo namespaceInfo, boolean isTextMapping) {
        return this.getXPathForField(property, namespaceInfo, isTextMapping, false);
    }

    public XMLField getXPathForField(Property property, NamespaceInfo namespaceInfo, boolean isTextMapping, boolean isAny) {
        XMLField xmlField = null;
        if (property.getXmlPath() != null) {
            xmlField = new XMLField(property.getXmlPath());
        } else {
            String prefix;
            String namespace;
            String xPath = "";
            if (property.isSetXmlElementWrapper()) {
                XmlElementWrapper wrapper = property.getXmlElementWrapper();
                namespace = wrapper.getNamespace();
                if (namespace.equals("##default")) {
                    namespace = namespaceInfo.isElementFormQualified() ? namespaceInfo.getNamespace() : "";
                }
                if (namespace.equals("")) {
                    xPath = String.valueOf(xPath) + wrapper.getName() + "/";
                } else {
                    prefix = this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolverForDescriptor(), null);
                    xPath = String.valueOf(xPath) + this.getQualifiedString(prefix, String.valueOf(wrapper.getName()) + "/");
                }
                if (isAny) {
                    xPath = xPath.substring(0, xPath.length() - 1);
                    xmlField = new XMLField(xPath);
                    return xmlField;
                }
            }
            if (property.isAttribute()) {
                if (property.isSetXmlPath()) {
                    xPath = String.valueOf(xPath) + property.getXmlPath();
                } else {
                    QName name = property.getSchemaName();
                    namespace = "";
                    if (namespaceInfo.isAttributeFormQualified()) {
                        namespace = namespaceInfo.getNamespace();
                    }
                    if (!name.getNamespaceURI().equals("")) {
                        namespace = name.getNamespaceURI();
                    }
                    if (namespace.equals("")) {
                        xPath = String.valueOf(xPath) + ATT + name.getLocalPart();
                    } else {
                        prefix = this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolverForDescriptor(), null);
                        xPath = String.valueOf(xPath) + ATT + this.getQualifiedString(prefix, name.getLocalPart());
                    }
                }
                xmlField = new XMLField(xPath);
            } else if (property.isXmlValue()) {
                xmlField = this.isBinaryData(property.getActualType()) ? new XMLField(".") : new XMLField("text()");
            } else {
                QName elementName = property.getSchemaName();
                xmlField = this.getXPathForElement(xPath, elementName, namespaceInfo, isTextMapping);
            }
        }
        QName schemaType = this.userDefinedSchemaTypes.get(property.getActualType().getQualifiedName());
        if (property.getSchemaType() != null) {
            schemaType = property.getSchemaType();
        }
        if (schemaType == null) {
            String propertyActualTypeRawName = property.getActualType().getRawName();
            if (QName.class.getCanonicalName().equals(propertyActualTypeRawName)) {
                schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(propertyActualTypeRawName);
            }
        }
        if (schemaType != null && !schemaType.equals(XMLConstants.NORMALIZEDSTRING_QNAME)) {
            xmlField.setSchemaType(schemaType);
        }
        return xmlField;
    }

    public XMLField getXPathForElement(String path, QName elementName, NamespaceInfo namespaceInfo, boolean isText) {
        String namespace = "";
        if (!elementName.getNamespaceURI().equals("")) {
            namespace = elementName.getNamespaceURI();
        }
        if (namespace.equals("")) {
            path = String.valueOf(path) + elementName.getLocalPart();
            if (isText) {
                path = String.valueOf(path) + TXT;
            }
        } else {
            String prefix = this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolverForDescriptor(), null);
            path = String.valueOf(path) + this.getQualifiedString(prefix, elementName.getLocalPart());
            if (isText) {
                path = String.valueOf(path) + TXT;
            }
        }
        return new XMLField(path);
    }

    public Property getXmlValueFieldForSimpleContent(ArrayList<Property> properties) {
        boolean foundValue = false;
        boolean foundNonAttribute = false;
        Property valueField = null;
        for (Property prop : properties) {
            if (this.helper.isAnnotationPresent(prop.getElement(), XmlValue.class)) {
                foundValue = true;
                valueField = prop;
                continue;
            }
            if (this.helper.isAnnotationPresent(prop.getElement(), XmlAttribute.class) || this.helper.isAnnotationPresent(prop.getElement(), XmlTransient.class) || prop.isAnyAttribute()) continue;
            foundNonAttribute = true;
        }
        if (foundValue && !foundNonAttribute) {
            return valueField;
        }
        return null;
    }

    public String getSchemaTypeNameForClassName(String className) {
        String typeName = Introspector.decapitalize(className.substring(className.lastIndexOf(46) + 1));
        return typeName;
    }

    public boolean isMapType(Property property) {
        JavaClass mapCls = this.helper.getJavaClass(Map.class);
        return mapCls.isAssignableFrom(property.getType());
    }

    public void processGlobalElements(Project project) {
        if (this.globalElements == null && this.localElements == null) {
            return;
        }
        ArrayList<ElementDeclaration> elements = new ArrayList<ElementDeclaration>();
        elements.addAll(this.localElements);
        elements.addAll(this.globalElements.values());
        for (ElementDeclaration nextElement : elements) {
            QName next = nextElement.getElementName();
            String nextClassName = nextElement.getJavaTypeName();
            TypeInfo type = this.typeInfo.get(nextClassName);
            if (this.helper.isBuiltInJavaType(nextElement.getJavaType()) || type != null && type.isEnumerationType()) {
                Class declaredClass;
                Class generatedClass;
                String attributeTypeName = nextClassName;
                if (nextElement.getJavaType().isPrimitive()) {
                    attributeTypeName = this.helper.getClassForJavaClass(nextElement.getJavaType()).getName();
                }
                if (nextElement.getAdaptedJavaTypeName() != null) {
                    attributeTypeName = nextElement.getAdaptedJavaTypeName();
                }
                if (next == null) {
                    if (this.isBinaryData(nextElement.getJavaType())) {
                        generatedClass = this.addByteArrayWrapperAndDescriptor(type, nextElement.getJavaType().getRawName(), nextElement, nextClassName, attributeTypeName);
                        this.qNamesToGeneratedClasses.put(next, generatedClass);
                        if (nextElement.getTypeMappingInfo() != null) {
                            this.typeMappingInfoToGeneratedClasses.put(nextElement.getTypeMappingInfo(), generatedClass);
                        }
                        try {
                            declaredClass = PrivilegedAccessHelper.getClassForName((String)nextClassName, (boolean)false, (ClassLoader)this.helper.getClassLoader());
                            this.qNamesToDeclaredClasses.put(next, declaredClass);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (!nextElement.getJavaType().isEnum() || this.helper.getClassLoader() instanceof DynamicClassLoader) continue;
                    generatedClass = this.addEnumerationWrapperAndDescriptor(type, nextElement.getJavaType().getRawName(), nextElement, nextClassName, attributeTypeName);
                    this.qNamesToGeneratedClasses.put(next, generatedClass);
                    if (nextElement.getTypeMappingInfo() != null) {
                        this.typeMappingInfoToGeneratedClasses.put(nextElement.getTypeMappingInfo(), generatedClass);
                    }
                    try {
                        declaredClass = PrivilegedAccessHelper.getClassForName((String)nextClassName, (boolean)false, (ClassLoader)this.helper.getClassLoader());
                        this.qNamesToDeclaredClasses.put(next, declaredClass);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                generatedClass = this.generateWrapperClassAndDescriptor(type, next, nextElement, nextClassName, attributeTypeName);
                this.qNamesToGeneratedClasses.put(next, generatedClass);
                try {
                    declaredClass = PrivilegedAccessHelper.getClassForName((String)nextClassName, (boolean)false, (ClassLoader)this.helper.getClassLoader());
                    this.qNamesToDeclaredClasses.put(next, declaredClass);
                }
                catch (Exception exception) {}
                continue;
            }
            if (type == null || type.isTransient()) continue;
            if (next.getNamespaceURI() == null || next.getNamespaceURI().equals("")) {
                if (type.getDescriptor().getDefaultRootElement() == null) {
                    type.getDescriptor().setDefaultRootElement(next.getLocalPart());
                    continue;
                }
                type.getDescriptor().addRootElement(next.getLocalPart());
                continue;
            }
            XMLDescriptor descriptor = type.getDescriptor();
            String uri = next.getNamespaceURI();
            String prefix = this.getPrefixForNamespace(uri, descriptor.getNamespaceResolver(), null);
            if (type.getDescriptor().getDefaultRootElement() == null) {
                descriptor.setDefaultRootElement(this.getQualifiedString(prefix, next.getLocalPart()));
                continue;
            }
            descriptor.addRootElement(this.getQualifiedString(prefix, next.getLocalPart()));
        }
    }

    private Class addByteArrayWrapperAndDescriptor(TypeInfo type, String javaClassName, ElementDeclaration nextElement, String nextClassName, String attributeTypeName) {
        Class generatedClass = this.classToGeneratedClasses.get(javaClassName);
        if (generatedClass == null) {
            generatedClass = this.generateWrapperClassAndDescriptor(type, null, nextElement, nextClassName, attributeTypeName);
            this.classToGeneratedClasses.put(javaClassName, generatedClass);
        }
        return generatedClass;
    }

    private Class addEnumerationWrapperAndDescriptor(TypeInfo type, String javaClassName, ElementDeclaration nextElement, String nextClassName, String attributeTypeName) {
        Class generatedClass = this.classToGeneratedClasses.get(javaClassName);
        if (generatedClass == null) {
            generatedClass = this.generateWrapperClassAndDescriptor(type, null, nextElement, nextClassName, attributeTypeName);
            this.classToGeneratedClasses.put(javaClassName, generatedClass);
        }
        return generatedClass;
    }

    private Class generateWrapperClassAndDescriptor(TypeInfo type, QName next, ElementDeclaration nextElement, String nextClassName, String attributeTypeName) {
        String namespaceUri = null;
        if (next != null && ((namespaceUri = next.getNamespaceURI()) == null || namespaceUri.equals("##default"))) {
            namespaceUri = "";
        }
        TypeMappingInfo tmi = nextElement.getTypeMappingInfo();
        Class generatedClass = null;
        JaxbClassLoader loader = this.getJaxbClassLoader();
        if (tmi != null) {
            generatedClass = CompilerHelper.getExisitingGeneratedClass(tmi, this.typeMappingInfoToGeneratedClasses, this.typeMappingInfoToAdapterClasses, this.helper.getClassLoader());
            if (generatedClass == null) {
                generatedClass = this.generateWrapperClass(loader.nextAvailableGeneratedClassName(), attributeTypeName, nextElement.isList(), next);
            }
            this.typeMappingInfoToGeneratedClasses.put(tmi, generatedClass);
        } else {
            generatedClass = this.generateWrapperClass(loader.nextAvailableGeneratedClassName(), attributeTypeName, nextElement.isList(), next);
        }
        this.qNamesToGeneratedClasses.put(next, generatedClass);
        try {
            Class declaredClass = PrivilegedAccessHelper.getClassForName((String)nextClassName, (boolean)false, (ClassLoader)this.helper.getClassLoader());
            this.qNamesToDeclaredClasses.put(next, declaredClass);
        }
        catch (Exception exception) {}
        XMLDescriptor desc = (XMLDescriptor)this.project.getDescriptor(generatedClass);
        if (desc == null) {
            Class attributeClassification;
            XMLCompositeDirectCollectionMapping mapping;
            desc = new XMLDescriptor();
            desc.setJavaClass(generatedClass);
            if (nextElement.isList()) {
                mapping = new XMLCompositeDirectCollectionMapping();
                mapping.setAttributeName("value");
                mapping.setXPath("text()");
                mapping.setUsesSingleNode(true);
                mapping.setReuseContainer(true);
                if (type != null && type.isEnumerationType()) {
                    mapping.setValueConverter((Converter)this.buildJAXBEnumTypeConverter((DatabaseMapping)mapping, (EnumTypeInfo)type));
                } else {
                    try {
                        Class fieldElementClass = PrivilegedAccessHelper.getClassForName((String)nextClassName, (boolean)false, (ClassLoader)this.helper.getClassLoader());
                        mapping.setFieldElementClass(fieldElementClass);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                if (nextClassName.equals("[B") || nextClassName.equals("[Ljava.lang.Byte;")) {
                    ((XMLField)mapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
                } else if (nextClassName.equals("javax.xml.namespace.QName")) {
                    ((XMLField)mapping.getField()).setSchemaType(XMLConstants.QNAME_QNAME);
                }
                desc.addMapping((DatabaseMapping)mapping);
            } else if (nextElement.getJavaTypeName().equals(OBJECT_CLASS_NAME)) {
                mapping = new XMLCompositeObjectMapping();
                mapping.setAttributeName("value");
                mapping.setSetMethodName("setValue");
                mapping.setGetMethodName("getValue");
                mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                mapping.setXPath(".");
                ((XMLField)mapping.getField()).setIsTypedTextField(true);
                ((XMLField)mapping.getField()).setSchemaType(XMLConstants.ANY_TYPE_QNAME);
                desc.addMapping((DatabaseMapping)mapping);
            } else if (this.isBinaryData(nextElement.getJavaType())) {
                mapping = new XMLBinaryDataMapping();
                mapping.setAttributeName("value");
                mapping.setXPath(".");
                ((XMLField)mapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
                mapping.setSetMethodName("setValue");
                mapping.setGetMethodName("getValue");
                attributeClassification = Helper.getClassFromClasseName((String)attributeTypeName, (ClassLoader)this.getClass().getClassLoader());
                mapping.setAttributeClassification(attributeClassification);
                mapping.setShouldInlineBinaryData(false);
                if (nextElement.getTypeMappingInfo() != null) {
                    mapping.setSwaRef(nextElement.isXmlAttachmentRef());
                    mapping.setMimeType(nextElement.getXmlMimeType());
                }
                desc.addMapping((DatabaseMapping)mapping);
            } else {
                mapping = new XMLDirectMapping();
                mapping.setAttributeName("value");
                mapping.setXPath("text()");
                mapping.setSetMethodName("setValue");
                mapping.setGetMethodName("getValue");
                if (nextElement.getDefaultValue() != null) {
                    mapping.setNullValue((Object)nextElement.getDefaultValue());
                    mapping.getNullPolicy().setNullRepresentedByXsiNil(true);
                }
                if (this.helper.isBuiltInJavaType(nextElement.getJavaType())) {
                    attributeClassification = null;
                    attributeClassification = nextElement.getJavaType().isPrimitive() ? XMLConversionManager.getDefaultManager().convertClassNameToClass(attributeTypeName) : Helper.getClassFromClasseName((String)attributeTypeName, (ClassLoader)this.getClass().getClassLoader());
                    mapping.setAttributeClassification(attributeClassification);
                }
                IsSetNullPolicy nullPolicy = new IsSetNullPolicy("isSetValue", false, true, XMLNullRepresentationType.ABSENT_NODE);
                mapping.setNullPolicy((AbstractNullPolicy)nullPolicy);
                if (type != null && type.isEnumerationType()) {
                    mapping.setConverter((Converter)this.buildJAXBEnumTypeConverter((DatabaseMapping)mapping, (EnumTypeInfo)type));
                }
                if (nextClassName.equals("[B") || nextClassName.equals("[Ljava.lang.Byte;")) {
                    ((XMLField)mapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
                } else if (nextClassName.equals("javax.xml.namespace.QName")) {
                    ((XMLField)mapping.getField()).setSchemaType(XMLConstants.QNAME_QNAME);
                }
                if (nextElement.getJavaTypeAdapterClass() != null) {
                    mapping.setConverter((Converter)new XMLJavaTypeConverter(nextElement.getJavaTypeAdapterClass()));
                }
                desc.addMapping((DatabaseMapping)mapping);
            }
            if (next != null) {
                NamespaceResolver resolver;
                NamespaceInfo info = this.getNamespaceInfoForURI(namespaceUri);
                if (info != null) {
                    resolver = info.getNamespaceResolverForDescriptor();
                    String prefix = null;
                    if (namespaceUri != "" && (prefix = resolver.resolveNamespaceURI(namespaceUri)) == null) {
                        prefix = this.getPrefixForNamespace(namespaceUri, resolver, null);
                    }
                    desc.setNamespaceResolver(resolver);
                    desc.setDefaultRootElement("");
                    desc.addRootElement(this.getQualifiedString(prefix, next.getLocalPart()));
                } else if (namespaceUri.equals("")) {
                    desc.setDefaultRootElement(next.getLocalPart());
                } else {
                    resolver = new NamespaceResolver();
                    String prefix = this.getPrefixForNamespace(namespaceUri, resolver, null);
                    desc.setNamespaceResolver(resolver);
                    desc.setDefaultRootElement("");
                    desc.addRootElement(this.getQualifiedString(prefix, next.getLocalPart()));
                }
            }
            this.project.addDescriptor((ClassDescriptor)desc);
        }
        return generatedClass;
    }

    private String getQualifiedString(String prefix, String localPart) {
        if (prefix == null) {
            return localPart;
        }
        return String.valueOf(prefix) + ':' + localPart;
    }

    private NamespaceInfo getNamespaceInfoForURI(String namespaceUri) {
        Iterator<PackageInfo> namespaces = this.packageToPackageInfoMappings.values().iterator();
        while (namespaces.hasNext()) {
            NamespaceInfo next = namespaces.next().getNamespaceInfo();
            if (!next.getNamespace().equals(namespaceUri)) continue;
            return next;
        }
        return null;
    }

    private String getPackageNameForURI(String namespaceUri) {
        for (String next : this.packageToPackageInfoMappings.keySet()) {
            if (!this.packageToPackageInfoMappings.get(next).getNamespace().equals(namespaceUri)) continue;
            return next;
        }
        return null;
    }

    public Class generateWrapperClass(String className, String attributeType, boolean isList, QName theQName) {
        ClassWriter cw = new ClassWriter(2);
        String sig = null;
        cw.visit(49, 1, className.replace(".", "/"), sig, Type.getType(WrappedValue.class).getInternalName(), null);
        String fieldType = null;
        if (isList) {
            fieldType = "Ljava/util/List;";
        } else {
            fieldType = attributeType.replace(".", "/");
            if (!fieldType.startsWith("[")) {
                fieldType = "L" + fieldType + ";";
            }
        }
        if (theQName == null) {
            theQName = RESERVED_QNAME;
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, "javax/xml/namespace/QName");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)theQName.getNamespaceURI());
        mv.visitLdcInsn((Object)theQName.getLocalPart());
        mv.visitMethodInsn(183, "javax/xml/namespace/QName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V");
        mv.visitLdcInsn((Object)Type.getType((String)fieldType));
        mv.visitInsn(1);
        mv.visitMethodInsn(183, "org/eclipse/persistence/internal/jaxb/WrappedValue", "<init>", "(Ljavax/xml/namespace/QName;Ljava/lang/Class;Ljava/lang/Object;)V");
        mv.visitInsn(177);
        mv.visitMaxs(5, 1);
        mv.visitEnd();
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        Class generatedClass = this.getJaxbClassLoader().generateClass(className, classBytes);
        return generatedClass;
    }

    public HashMap<QName, Class> getQNamesToGeneratedClasses() {
        return this.qNamesToGeneratedClasses;
    }

    public HashMap<String, Class> getClassToGeneratedClasses() {
        return this.classToGeneratedClasses;
    }

    public HashMap<QName, Class> getQNamesToDeclaredClasses() {
        return this.qNamesToDeclaredClasses;
    }

    private Map<MapEntryGeneratedKey, Class> getGeneratedMapEntryClasses() {
        if (this.generatedMapEntryClasses == null) {
            this.generatedMapEntryClasses = new HashMap<MapEntryGeneratedKey, Class>();
        }
        return this.generatedMapEntryClasses;
    }

    private AbstractNullPolicy getWrapperNullPolicyFromProperty(Property property) {
        NullPolicy nullPolicy = null;
        if (property.isSetXmlElementWrapper()) {
            nullPolicy = new NullPolicy();
            nullPolicy.setNullRepresentedByEmptyNode(false);
            nullPolicy.setSetPerformedForAbsentNode(false);
            if (property.getXmlElementWrapper().isNillable()) {
                nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
                nullPolicy.setNullRepresentedByXsiNil(true);
            } else {
                nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.ABSENT_NODE);
                nullPolicy.setNullRepresentedByXsiNil(false);
            }
        }
        return nullPolicy;
    }

    private AbstractNullPolicy getNullPolicyFromProperty(Property property, NamespaceResolver nsr) {
        NullPolicy absNullPolicy = null;
        XmlAbstractNullPolicy xmlAbsNullPolicy = property.getNullPolicy();
        if (xmlAbsNullPolicy instanceof XmlNullPolicy) {
            XmlNullPolicy xmlNullPolicy = (XmlNullPolicy)xmlAbsNullPolicy;
            NullPolicy nullPolicy = new NullPolicy();
            nullPolicy.setSetPerformedForAbsentNode(xmlNullPolicy.isIsSetPerformedForAbsentNode());
            absNullPolicy = nullPolicy;
        } else {
            XmlIsSetNullPolicy xmlIsSetNullPolicy = (XmlIsSetNullPolicy)xmlAbsNullPolicy;
            IsSetNullPolicy isSetNullPolicy = new IsSetNullPolicy();
            isSetNullPolicy.setIsSetMethodName(xmlIsSetNullPolicy.getIsSetMethodName());
            ArrayList<Object> parameters = new ArrayList<Object>();
            ArrayList<Class> parameterTypes = new ArrayList<Class>();
            List<XmlIsSetNullPolicy.IsSetParameter> params = xmlIsSetNullPolicy.getIsSetParameter();
            for (XmlIsSetNullPolicy.IsSetParameter param : params) {
                String valueStr = param.getValue();
                String typeStr = param.getType();
                XMLConversionManager mgr = new XMLConversionManager();
                mgr.setLoader(this.helper.getClassLoader());
                Class typeClass = mgr.convertClassNameToClass(typeStr);
                Object parameterValue = mgr.convertObject((Object)valueStr, typeClass);
                parameters.add(parameterValue);
                parameterTypes.add(typeClass);
            }
            isSetNullPolicy.setIsSetParameters(parameters.toArray());
            isSetNullPolicy.setIsSetParameterTypes(parameterTypes.toArray(new Class[parameterTypes.size()]));
            absNullPolicy = isSetNullPolicy;
        }
        absNullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.valueOf((String)xmlAbsNullPolicy.getNullRepresentationForXml().name()));
        absNullPolicy.setNullRepresentedByEmptyNode(xmlAbsNullPolicy.isEmptyNodeRepresentsNull());
        boolean xsiRepresentsNull = xmlAbsNullPolicy.isXsiNilRepresentsNull();
        if (xsiRepresentsNull) {
            absNullPolicy.setNullRepresentedByXsiNil(true);
        }
        return absNullPolicy;
    }

    private JavaClass getBaseComponentType(JavaClass javaClass) {
        JavaClass componentType = javaClass.getComponentType();
        if (componentType == null) {
            return javaClass;
        }
        if (!componentType.isArray()) {
            return componentType;
        }
        return this.getBaseComponentType(componentType);
    }

    public JaxbClassLoader getJaxbClassLoader() {
        if (this.helper.getClassLoader() instanceof DynamicClassLoader) {
            return (JaxbClassLoader)this.helper.getClassLoader().getParent();
        }
        return (JaxbClassLoader)this.helper.getClassLoader();
    }

    private boolean isBinaryData(JavaClass type) {
        return this.areEquals(type, ClassConstants.APBYTE) || this.areEquals(type, "javax.activation.DataHandler") || this.areEquals(type, "java.awt.Image") || this.areEquals(type, "javax.xml.transform.Source") || this.areEquals(type, "javax.mail.internet.MimeMultipart");
    }

    private void initializeXMLContainerMapping(XMLContainerMapping xmlContainerMapping) {
        xmlContainerMapping.setReuseContainer(true);
        xmlContainerMapping.setDefaultEmptyContainer(false);
    }

    private class MapEntryGeneratedKey {
        String keyClassName;
        String valueClassName;

        public MapEntryGeneratedKey(String keyClass, String valueClass) {
            this.keyClassName = keyClass;
            this.valueClassName = valueClass;
        }
    }

    private class NullInstantiationPolicy
    extends InstantiationPolicy {
        private NullInstantiationPolicy() {
        }

        public Object buildNewInstance() throws DescriptorException {
            return null;
        }
    }
}

