/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.AbstractSemanticValidator;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IType;

public final class DefaultSemanticValidator
extends AbstractSemanticValidator {
    public DefaultSemanticValidator(JPQLQueryContext context) {
        super(context);
    }

    protected void validateIdentificationVariable(IdentificationVariable expression, String variable) {
        for (IEntity entity : this.getProvider().entities()) {
            String entityName = entity.getName();
            if (!variable.equalsIgnoreCase(entityName) || this.isValidWithFindQueryBNF(expression, "literal")) continue;
            int startIndex = this.position(expression);
            int endIndex = startIndex + variable.length();
            this.addProblem((Expression)expression, startIndex, endIndex, "IDENTIFICATION_VARIABLE_ENTITY_NAME", new String[0]);
            break;
        }
    }

    public void visit(NullComparisonExpression expression) {
        IType type;
        StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(expression.getExpression());
        if (pathExpression != null && this.getEmbeddable(type = this.getType(pathExpression)) != null) {
            this.addProblem((Expression)pathExpression, "NULL_COMPARISON_EXPRESSION_INVALID_TYPE", pathExpression.toParsedText());
            return;
        }
        super.visit(expression);
    }
}

