/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.AbstractContentAssistVisitor;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.FuncExpression;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.jpql.spi.IType;

public class EclipseLinkContentAssistVisitor
extends AbstractContentAssistVisitor
implements EclipseLinkExpressionVisitor {
    public EclipseLinkContentAssistVisitor(JPQLQueryContext queryContext) {
        super(queryContext);
    }

    protected AbstractContentAssistVisitor.MappingFilterBuilder buildMappingFilterBuilder() {
        return new ELMappingFilterBuilder();
    }

    protected AbstractContentAssistVisitor.SelectClauseCompletenessVisitor buildSelectClauseCompleteness() {
        return new ELSelectClauseCompletenessVisitor();
    }

    protected AbstractContentAssistVisitor.TrailingCompletenessVisitor buildTrailingCompleteness() {
        return new ELTrailingCompletenessVisitor();
    }

    protected boolean isJoinFetchIdentifiable() {
        return this.getGrammar().getProviderVersion() == "2.4";
    }

    public void visit(FuncExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, AbstractContentAssistVisitor.IdentificationVariableType.ALL);
    }

    public void visit(TreatExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.getCorrections().peek();
        if (this.isPositionWithin(position, "TREAT")) {
            if (this.isValidVersion("TREAT")) {
                this.getProposals().addIdentifier("TREAT");
            }
        } else if (expression.hasLeftParenthesis()) {
            Expression collectionValuedPathExpression;
            int length = "TREAT".length() + 1;
            if (position == length) {
                this.addLeftIdentificationVariables(expression);
            }
            if (expression.hasCollectionValuedPathExpression() && expression.hasSpaceAfterCollectionValuedPathExpression() && this.isPositionWithin(position, length += this.length(collectionValuedPathExpression = expression.getCollectionValuedPathExpression()) + 1, "AS")) {
                this.getProposals().addIdentifier("AS");
                if (!expression.hasEntityType()) {
                    IType type = this.getType(collectionValuedPathExpression);
                    if (type.isResolvable()) {
                        this.addEntities(type);
                    } else {
                        this.addEntities();
                    }
                }
            }
            if (expression.hasAs() && expression.hasSpaceAfterAs() && position == (length += "AS".length() + 1)) {
                IType type = this.getType(expression.getCollectionValuedPathExpression());
                if (type.isResolvable()) {
                    this.addEntities(type);
                } else {
                    this.addEntities();
                }
            }
        }
    }

    protected class ELMappingFilterBuilder
    extends AbstractContentAssistVisitor.MappingFilterBuilder
    implements EclipseLinkExpressionVisitor {
        protected ELMappingFilterBuilder() {
        }

        public void visit(FuncExpression expression) {
            expression.getParent().accept(this);
        }

        public void visit(TreatExpression expression) {
            this.filter = EclipseLinkContentAssistVisitor.this.getMappingCollectionFilter();
        }
    }

    protected class ELSelectClauseCompletenessVisitor
    extends AbstractContentAssistVisitor.SelectClauseCompletenessVisitor
    implements EclipseLinkExpressionVisitor {
        protected ELSelectClauseCompletenessVisitor() {
        }

        public void visit(FuncExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(TreatExpression expression) {
        }
    }

    protected class ELTrailingCompletenessVisitor
    extends AbstractContentAssistVisitor.TrailingCompletenessVisitor
    implements EclipseLinkExpressionVisitor {
        protected ELTrailingCompletenessVisitor() {
        }

        public void visit(FuncExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(TreatExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }
    }
}

