/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractFromClauseStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractSelectClauseStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.CollectionMemberDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.DeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.GroupByClauseStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.HavingClauseStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.IdentificationVariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.IdentificationVariableStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.VariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.WhereClauseStateObject;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectStatementStateObject
extends AbstractStateObject {
    private AbstractFromClauseStateObject fromClause;
    private GroupByClauseStateObject groupByClause;
    private HavingClauseStateObject havingClause;
    private AbstractSelectClauseStateObject selectClause;
    private WhereClauseStateObject whereClause;
    public static String GROUP_BY_CLAUSE_PROPERTY = "groupByClause";
    public static String HAVING_CLAUSE_PROPERTY = "havingClause";
    public static String WHERE_CLAUSE_PROPERTY = "whereClause";

    protected AbstractSelectStatementStateObject(StateObject parent) {
        super(parent);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        children.add(this.selectClause);
        children.add(this.fromClause);
        if (this.whereClause != null) {
            children.add(this.whereClause);
        }
        if (this.groupByClause != null) {
            children.add(this.groupByClause);
        }
        if (this.havingClause != null) {
            children.add(this.havingClause);
        }
    }

    public CollectionMemberDeclarationStateObject addCollectionDeclaration() {
        return this.getFromClause().addCollectionDeclaration();
    }

    public CollectionMemberDeclarationStateObject addCollectionDeclaration(String collectionValuedPath, String identificationVariable) {
        return this.getFromClause().addCollectionDeclaration(collectionValuedPath, identificationVariable);
    }

    public GroupByClauseStateObject addGroupByClause() {
        if (!this.hasGroupByClause()) {
            this.setGroupByClause(new GroupByClauseStateObject(this));
        }
        return this.groupByClause;
    }

    public GroupByClauseStateObject addGroupByClause(String jpqlFragment) {
        GroupByClauseStateObject stateObject = this.addGroupByClause();
        stateObject.parse(jpqlFragment);
        return stateObject;
    }

    public HavingClauseStateObject addHavingClause() {
        if (!this.hasHavingClause()) {
            this.setHavingClause(new HavingClauseStateObject(this));
        }
        return this.havingClause;
    }

    public HavingClauseStateObject addHavingClause(String jpqlFragment) {
        HavingClauseStateObject stateObject = this.addHavingClause();
        stateObject.parse(jpqlFragment);
        return stateObject;
    }

    public IdentificationVariableDeclarationStateObject addRangeDeclaration() {
        return this.getFromClause().addRangeDeclaration();
    }

    public IdentificationVariableDeclarationStateObject addRangeDeclaration(IEntity entity, String identificationVariable) {
        return this.getFromClause().addRangeDeclaration(entity, identificationVariable);
    }

    public IdentificationVariableDeclarationStateObject addRangeDeclaration(String abstractSchemaName, String identificationVariable) {
        return this.getFromClause().addRangeDeclaration(abstractSchemaName, identificationVariable);
    }

    public WhereClauseStateObject addWhereClause() {
        if (!this.hasWhereClause()) {
            this.setWhereClause(new WhereClauseStateObject(this));
        }
        return this.whereClause;
    }

    public WhereClauseStateObject addWhereClause(String jpqlFragment) {
        WhereClauseStateObject stateObject = this.addWhereClause();
        stateObject.parse(jpqlFragment);
        return stateObject;
    }

    protected abstract AbstractFromClauseStateObject buildFromClause();

    protected abstract AbstractSelectClauseStateObject buildSelectClause();

    public Iterator<? extends VariableDeclarationStateObject> declarations() {
        return this.fromClause.items();
    }

    @Override
    public IdentificationVariableStateObject findIdentificationVariable(String identificationVariable) {
        return this.fromClause.findIdentificationVariable(identificationVariable);
    }

    @Override
    public DeclarationStateObject getDeclaration() {
        return this.fromClause;
    }

    @Override
    public AbstractSelectStatement getExpression() {
        return (AbstractSelectStatement)super.getExpression();
    }

    public AbstractFromClauseStateObject getFromClause() {
        return this.fromClause;
    }

    public GroupByClauseStateObject getGroupByClause() {
        return this.groupByClause;
    }

    public HavingClauseStateObject getHavingClause() {
        return this.havingClause;
    }

    public AbstractSelectClauseStateObject getSelectClause() {
        return this.selectClause;
    }

    public WhereClauseStateObject getWhereClause() {
        return this.whereClause;
    }

    public boolean hasGroupByClause() {
        return this.groupByClause != null;
    }

    public boolean hasHavingClause() {
        return this.havingClause != null;
    }

    public boolean hasWhereClause() {
        return this.whereClause != null;
    }

    public Iterator<IdentificationVariableStateObject> identificationVariables() {
        return this.fromClause.identificationVariables();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.selectClause = this.buildSelectClause();
        this.fromClause = this.buildFromClause();
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            AbstractSelectStatementStateObject select = (AbstractSelectStatementStateObject)stateObject;
            return this.areEquivalent(this.selectClause, select.selectClause) && this.areEquivalent(this.fromClause, select.fromClause) && this.areEquivalent(this.fromClause, select.fromClause) && this.areEquivalent(this.whereClause, select.whereClause) && this.areEquivalent(this.groupByClause, select.groupByClause) && this.areEquivalent(this.havingClause, select.havingClause);
        }
        return false;
    }

    public void parseSelect(String jpqlFragment) {
        this.getSelectClause().parse(jpqlFragment);
    }

    public void removeGroupByClause() {
        this.setGroupByClause(null);
    }

    public void removeHavingClause() {
        this.setHavingClause(null);
    }

    public void removeWhereClause() {
        this.setWhereClause(null);
    }

    private void setGroupByClause(GroupByClauseStateObject groupByClause) {
        GroupByClauseStateObject oldGroupByClause = this.groupByClause;
        this.groupByClause = groupByClause;
        this.firePropertyChanged(GROUP_BY_CLAUSE_PROPERTY, oldGroupByClause, groupByClause);
    }

    private void setHavingClause(HavingClauseStateObject havingClause) {
        HavingClauseStateObject oldHavingClause = this.havingClause;
        this.havingClause = havingClause;
        this.firePropertyChanged(HAVING_CLAUSE_PROPERTY, oldHavingClause, havingClause);
    }

    private void setWhereClause(WhereClauseStateObject whereClause) {
        WhereClauseStateObject oldWhereClause = this.whereClause;
        this.whereClause = whereClause;
        this.firePropertyChanged(WHERE_CLAUSE_PROPERTY, oldWhereClause, whereClause);
    }

    public void toggleGroupByClause() {
        if (this.hasGroupByClause()) {
            this.removeGroupByClause();
        } else {
            this.addGroupByClause();
        }
    }

    public void toggleHavingClause() {
        if (this.hasHavingClause()) {
            this.removeHavingClause();
        } else {
            this.addHavingClause();
        }
    }

    public void toggleWhereClause() {
        if (this.hasWhereClause()) {
            this.removeWhereClause();
        } else {
            this.addWhereClause();
        }
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        this.selectClause.toString(writer);
        writer.append(' ');
        this.fromClause.toString(writer);
        if (this.whereClause != null) {
            writer.append(' ');
            this.whereClause.toString(writer);
        }
        if (this.groupByClause != null) {
            writer.append(' ');
            this.groupByClause.toString(writer);
        }
        if (this.havingClause != null) {
            writer.append(' ');
            this.havingClause.toString(writer);
        }
    }
}

