/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.OnClause;
import org.eclipse.persistence.jpa.jpql.parser.StringExpression;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Join
extends AbstractExpression {
    private String asIdentifier;
    private boolean hasAs;
    private boolean hasSpaceAfterAs;
    private boolean hasSpaceAfterIdentificationVariable;
    private boolean hasSpaceAfterJoin;
    private boolean hasSpaceAfterJoinAssociation;
    private AbstractExpression identificationVariable;
    private AbstractExpression joinAssociationPath;
    private String joinIdentifier;
    private AbstractExpression onClause;
    private boolean parsingIdentificationVariable;

    public Join(AbstractExpression parent, String identifier) {
        super(parent, identifier);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getJoinAssociationPath().accept(visitor);
        this.getIdentificationVariable().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getJoinAssociationPath());
        children.add(this.getIdentificationVariable());
        children.add(this.getOnClause());
    }

    @Override
    protected void addOrderedChildrenTo(List<StringExpression> children) {
        String space;
        String join = this.getText();
        if (join.indexOf(space = " ") != -1) {
            StringTokenizer tokenizer = new StringTokenizer(join, space, true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                children.add(this.buildStringExpression(token));
            }
        } else {
            children.add(this.buildStringExpression(join));
        }
        if (this.hasSpaceAfterJoin) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.joinAssociationPath != null) {
            children.add(this.joinAssociationPath);
        }
        if (this.hasSpaceAfterJoinAssociation) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasAs) {
            children.add(this.buildStringExpression("AS"));
            if (this.hasSpaceAfterAs) {
                children.add(this.buildStringExpression(' '));
            }
        }
        if (this.identificationVariable != null) {
            children.add(this.identificationVariable);
        }
        if (this.hasSpaceAfterIdentificationVariable) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.onClause != null) {
            children.add(this.onClause);
        }
    }

    public String getActualAsIdentifier() {
        return this.asIdentifier;
    }

    public String getActualIdentifier() {
        return this.joinIdentifier;
    }

    public Expression getIdentificationVariable() {
        if (this.identificationVariable == null) {
            this.identificationVariable = this.buildNullExpression();
        }
        return this.identificationVariable;
    }

    public String getIdentifier() {
        return this.getText();
    }

    public Expression getJoinAssociationPath() {
        if (this.joinAssociationPath == null) {
            this.joinAssociationPath = this.buildNullExpression();
        }
        return this.joinAssociationPath;
    }

    public Expression getOnClause() {
        if (this.onClause == null) {
            this.onClause = this.buildNullExpression();
        }
        return this.onClause;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("join");
    }

    public boolean hasAs() {
        return this.hasAs;
    }

    public boolean hasFetch() {
        String identifier = this.getText();
        return identifier == "JOIN FETCH" || identifier == "INNER JOIN FETCH" || identifier == "LEFT JOIN FETCH" || identifier == "LEFT OUTER JOIN FETCH";
    }

    public boolean hasIdentificationVariable() {
        return this.identificationVariable != null && !this.identificationVariable.isNull() && !this.identificationVariable.isVirtual();
    }

    public boolean hasJoinAssociationPath() {
        return this.joinAssociationPath != null && !this.joinAssociationPath.isNull();
    }

    public boolean hasOnClause() {
        return this.onClause != null && !this.onClause.isNull();
    }

    public boolean hasSpaceAfterAs() {
        return this.hasSpaceAfterAs;
    }

    public boolean hasSpaceAfterIdentificationVariable() {
        return this.hasSpaceAfterIdentificationVariable;
    }

    public boolean hasSpaceAfterJoin() {
        return this.hasSpaceAfterJoin;
    }

    public boolean hasSpaceAfterJoinAssociation() {
        return this.hasSpaceAfterJoinAssociation;
    }

    public boolean isLeftJoin() {
        String identifier = this.getIdentifier();
        return identifier == "LEFT JOIN" || identifier == "LEFT OUTER JOIN" || identifier == "LEFT JOIN FETCH" || identifier == "LEFT OUTER JOIN FETCH";
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        if (this.parsingIdentificationVariable && word.equalsIgnoreCase("ON")) {
            return true;
        }
        return word.equalsIgnoreCase("AS") || word.equalsIgnoreCase("INNER") || word.equalsIgnoreCase("JOIN") || word.equalsIgnoreCase("LEFT") || word.equalsIgnoreCase("OUTER") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.joinIdentifier = wordParser.moveForward(this.getText());
        boolean bl = this.hasSpaceAfterJoin = wordParser.skipLeadingWhitespace() > 0;
        if (tolerant) {
            this.joinAssociationPath = this.parse(wordParser, this.getQueryBNF("join_association_path_expression*"), tolerant);
        } else if (wordParser.startsWithIdentifier("TREAT")) {
            this.joinAssociationPath = new TreatExpression(this);
            this.joinAssociationPath.parse(wordParser, tolerant);
        } else {
            this.joinAssociationPath = new CollectionValuedPathExpression((AbstractExpression)this, wordParser.word());
            this.joinAssociationPath.parse(wordParser, tolerant);
        }
        int count = wordParser.skipLeadingWhitespace();
        this.hasSpaceAfterJoinAssociation = count > 0;
        this.hasAs = wordParser.startsWithIdentifier("AS");
        if (this.hasAs) {
            this.asIdentifier = wordParser.moveForward("AS");
            this.hasSpaceAfterAs = wordParser.skipLeadingWhitespace() > 0;
        }
        this.parsingIdentificationVariable = true;
        if (tolerant) {
            this.identificationVariable = this.parse(wordParser, this.getQueryBNF("identification_variable"), tolerant);
        } else {
            String word = wordParser.word();
            if (word.length() > 0 && !this.isParsingComplete(wordParser, word, null)) {
                this.identificationVariable = new IdentificationVariable(this, word);
                this.identificationVariable.parse(wordParser, tolerant);
            }
        }
        this.parsingIdentificationVariable = false;
        if (!this.hasAs && this.hasSpaceAfterJoinAssociation && this.identificationVariable == null && this.hasFetch() && !wordParser.startsWithIdentifier("ON")) {
            this.hasSpaceAfterJoinAssociation = false;
            wordParser.moveBackward(count);
            count = 0;
        } else {
            count = wordParser.skipLeadingWhitespace();
        }
        if (tolerant) {
            this.onClause = this.parse(wordParser, this.getQueryBNF("where_clause"), tolerant);
        } else if (wordParser.startsWithIdentifier("ON")) {
            this.onClause = new OnClause(this);
            this.onClause.parse(wordParser, tolerant);
        }
        if (this.onClause != null) {
            this.hasSpaceAfterIdentificationVariable = count > 0;
        } else {
            wordParser.moveBackward(count);
        }
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.joinIdentifier : this.getText());
        if (this.hasSpaceAfterJoin) {
            writer.append(' ');
        }
        if (this.joinAssociationPath != null) {
            this.joinAssociationPath.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterJoinAssociation) {
            writer.append(' ');
        }
        if (this.hasAs) {
            writer.append(actual ? this.asIdentifier : "AS");
            if (this.hasSpaceAfterAs) {
                writer.append(' ');
            }
        }
        if (this.identificationVariable != null) {
            this.identificationVariable.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterIdentificationVariable) {
            writer.append(' ');
        }
        if (this.onClause != null) {
            this.onClause.toParsedText(writer, actual);
        }
    }
}

