/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.namespaces;

import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.oxm.NamespacePrefixMapper;
import org.eclipse.persistence.oxm.NamespaceResolver;

public class PrefixMapperNamespaceResolver
extends NamespaceResolver {
    private NamespacePrefixMapper prefixMapper;
    private NamespaceResolver contextualNamespaces;

    public PrefixMapperNamespaceResolver(NamespacePrefixMapper mapper, NamespaceResolver nestedResolver) {
        String[] uris;
        String uri;
        String prefix;
        this.prefixMapper = mapper;
        String[] declarations = mapper.getContextualNamespaceDecls();
        if (declarations != null && declarations.length > 0) {
            this.contextualNamespaces = new NamespaceResolver();
            int i = 0;
            while (i < declarations.length - 1) {
                prefix = declarations[i];
                String uri2 = declarations[i + 1];
                this.contextualNamespaces.put(prefix, uri2);
                i += 2;
            }
        }
        String defaultUri = null;
        if (nestedResolver != null) {
            for (Object next : nestedResolver.getNamespaces()) {
                String originalPrefix;
                Namespace ns = (Namespace)next;
                uri = ns.getNamespaceURI();
                String prefix2 = this.prefixMapper.getPreferredPrefix(uri, originalPrefix = ns.getPrefix(), true);
                if (prefix2 != null) {
                    this.put(prefix2, uri);
                    continue;
                }
                this.put(originalPrefix, uri);
            }
            defaultUri = nestedResolver.getDefaultNamespaceURI();
        }
        if (defaultUri != null) {
            prefix = this.prefixMapper.getPreferredPrefix(defaultUri, "", false);
            if ("".equals(prefix) || prefix == null) {
                this.setDefaultNamespaceURI(defaultUri);
            } else {
                this.put(prefix, defaultUri);
            }
        }
        if ((uris = mapper.getPreDeclaredNamespaceUris()) != null && uris.length > 0) {
            int i = 0;
            while (i < uris.length) {
                String uri3 = uris[i];
                String prefix3 = this.prefixMapper.getPreferredPrefix(uri3, null, true);
                if (prefix3 != null) {
                    this.put(prefix3, uri3);
                }
                ++i;
            }
        }
        if ((declarations = this.prefixMapper.getPreDeclaredNamespaceUris2()) != null && declarations.length > 0) {
            int i = 0;
            while (i < declarations.length - 1) {
                String prefix4 = declarations[i];
                uri = declarations[i + 1];
                this.put(prefix4, uri);
                i += 2;
            }
        }
    }

    public String resolveNamespaceURI(String uri) {
        String prefix = null;
        if (this.contextualNamespaces != null) {
            prefix = this.contextualNamespaces.resolveNamespaceURI(uri);
        }
        if (prefix == null) {
            prefix = super.resolveNamespaceURI(uri);
        }
        return prefix;
    }

    public void put(String prefix, String uri) {
        String newPrefix = this.prefixMapper.getPreferredPrefix(uri, prefix, true);
        if (newPrefix == null || newPrefix.length() == 0) {
            super.put(prefix, uri);
        } else {
            super.put(newPrefix, uri);
        }
    }
}

