/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.XMLContainerMapping;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLInverseReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLNillableMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLCompositeCollectionMapping
extends AbstractCompositeCollectionMapping
implements XMLMapping,
XMLNillableMapping,
XMLContainerMapping {
    AbstractNullPolicy nullPolicy = new NullPolicy();
    private AbstractNullPolicy wrapperNullPolicy;
    private UnmarshalKeepAsElementPolicy keepAsElementPolicy;
    private XMLInverseReferenceMapping inverseReferenceMapping;
    private boolean defaultEmptyContainer = true;
    private boolean isWriteOnly;
    private boolean reuseContainer = false;

    @Deprecated
    public AttributeAccessor getContainerAccessor() {
        if (this.inverseReferenceMapping == null) {
            return null;
        }
        return this.inverseReferenceMapping.getAttributeAccessor();
    }

    @Deprecated
    public void setContainerAccessor(AttributeAccessor anAttributeAccessor) {
        if (this.inverseReferenceMapping == null) {
            return;
        }
        this.inverseReferenceMapping.setAttributeAccessor(anAttributeAccessor);
    }

    @Deprecated
    public void setContainerAttributeName(String attributeName) {
        if (this.inverseReferenceMapping == null) {
            return;
        }
        this.inverseReferenceMapping.setAttributeName(attributeName);
    }

    @Deprecated
    public String getContainerAttributeName() {
        if (this.inverseReferenceMapping == null) {
            return null;
        }
        return this.inverseReferenceMapping.getAttributeName();
    }

    @Deprecated
    public void setContainerGetMethodName(String methodName) {
        if (this.inverseReferenceMapping == null) {
            return;
        }
        this.inverseReferenceMapping.setGetMethodName(methodName);
    }

    @Deprecated
    public String getContainerGetMethodName() {
        if (this.inverseReferenceMapping == null) {
            return null;
        }
        return this.inverseReferenceMapping.getGetMethodName();
    }

    @Deprecated
    public String getContainerSetMethodName() {
        if (this.inverseReferenceMapping == null) {
            return null;
        }
        return this.inverseReferenceMapping.getSetMethodName();
    }

    @Deprecated
    public void setContainerSetMethodName(String methodName) {
        if (this.inverseReferenceMapping == null) {
            return;
        }
        this.inverseReferenceMapping.setSetMethodName(methodName);
    }

    public boolean isXMLMapping() {
        return true;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.getReferenceClass() == null && this.getReferenceClassName() != null) {
            this.setReferenceClass(session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(this.getReferenceClassName()));
        }
        if (this.getReferenceClass() != null) {
            super.initialize(session);
        } else {
            if (this.getField() == null) {
                throw DescriptorException.fieldNameNotSetInMapping(this);
            }
            this.setField(this.getDescriptor().buildField(this.getField()));
            this.setFields(this.collectFields());
            if (this.hasConverter()) {
                this.getConverter().initialize(this, session);
            }
        }
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp != null) {
            if (cp.getContainerClass() == null) {
                Class cls = session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(cp.getContainerClassName());
                cp.setContainerClass(cls);
            }
            if (cp instanceof MapContainerPolicy) {
                ((MapContainerPolicy)cp).setElementClass(this.getReferenceClass());
            }
        }
        if (this.getContainerAccessor() != null) {
            this.getContainerAccessor().initializeAttributes(this.referenceClass);
        }
    }

    public String getXPath() {
        return this.getField().getName();
    }

    public void setXPath(String xpathString) {
        this.setField(new XMLField(xpathString));
    }

    protected Object buildCompositeObject(ClassDescriptor descriptor, AbstractRecord nestedRow, ObjectBuildingQuery query, CacheKey parentCacheKey, JoinedAttributeManager joinManger, AbstractSession targetSession) {
        return descriptor.getObjectBuilder().buildObject(query, nestedRow, joinManger);
    }

    protected AbstractRecord buildCompositeRow(Object attributeValue, AbstractSession session, AbstractRecord parentRow, DatabaseMapping.WriteType writeType) {
        ClassDescriptor classDesc = null;
        try {
            classDesc = this.getReferenceDescriptor(attributeValue, session);
        }
        catch (Exception exception) {}
        XMLField xmlFld = (XMLField)this.getField();
        if (xmlFld.hasLastXPathFragment() && xmlFld.getLastXPathFragment().hasLeafElementType()) {
            XMLRecord xmlRec = (XMLRecord)parentRow;
            xmlRec.setLeafElementType(xmlFld.getLastXPathFragment().getLeafElementType());
        }
        XMLRecord parent = (XMLRecord)parentRow;
        if (classDesc != null) {
            XMLObjectBuilder objectBuilder = (XMLObjectBuilder)classDesc.getObjectBuilder();
            XMLRecord child = (XMLRecord)objectBuilder.createRecordFor(attributeValue, (XMLField)this.getField(), parent, this);
            child.setNamespaceResolver(parent.getNamespaceResolver());
            child.setSession(session);
            objectBuilder.buildIntoNestedRow(child, attributeValue, session, (XMLDescriptor)this.getReferenceDescriptor(), (XMLField)this.getField());
            return child;
        }
        if (attributeValue instanceof Element && this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT) {
            return new DOMRecord((Element)attributeValue);
        }
        Node newNode = XPathEngine.getInstance().create((XMLField)this.getField(), parent.getDOM(), attributeValue, session);
        DOMRecord newRow = new DOMRecord(newNode);
        return newRow;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            row.put(this.getField(), (Object)null);
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Vector<Object> nestedRows = new Vector<Object>(cp.sizeFor(attributeValue));
        Object iter = cp.iteratorFor(attributeValue);
        if (iter != null) {
            while (cp.hasNext(iter)) {
                Object element = cp.next(iter, session);
                if (this.hasConverter()) {
                    element = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertObjectValueToDataValue(element, session, ((XMLRecord)row).getMarshaller()) : this.getConverter().convertObjectValueToDataValue(element, session);
                }
                if (element == null) {
                    XMLNullRepresentationType nullRepresentation = this.getNullPolicy().getMarshalNullRepresentation();
                    if (nullRepresentation == XMLNullRepresentationType.XSI_NIL) {
                        nestedRows.add(XMLRecord.NIL);
                        continue;
                    }
                    if (nullRepresentation != XMLNullRepresentationType.EMPTY_NODE) continue;
                    Element emptyNode = XPathEngine.getInstance().createUnownedElement(((XMLRecord)row).getDOM(), (XMLField)this.field);
                    DOMRecord nestedRow = new DOMRecord((Node)emptyNode);
                    nestedRows.add(nestedRow);
                    continue;
                }
                nestedRows.addElement(this.buildCompositeRow(element, session, row, writeType));
            }
        }
        Object fieldValue = null;
        if (!nestedRows.isEmpty()) {
            fieldValue = this.getDescriptor().buildFieldValueFromNestedRows(nestedRows, this.getStructureName(), session);
        }
        row.put(this.getField(), fieldValue);
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        ContainerPolicy cp = this.getContainerPolicy();
        Object fieldValue = row.getValues(this.getField());
        if (fieldValue == null || fieldValue instanceof String) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = this.getAttributeAccessor().getAttributeValueFromObject(currentObject);
                return container != null ? container : cp.containerInstance();
            }
            return cp.containerInstance();
        }
        Vector nestedRows = this.getDescriptor().buildNestedRowsFromFieldValue(fieldValue, executionSession);
        if (nestedRows == null) {
            if (this.reuseContainer) {
                Object currentObject = ((XMLRecord)row).getCurrentObject();
                Object container = this.getAttributeAccessor().getAttributeValueFromObject(currentObject);
                return container != null ? container : cp.containerInstance();
            }
            return cp.containerInstance();
        }
        Object result = null;
        if (this.reuseContainer) {
            Object currentObject = ((XMLRecord)row).getCurrentObject();
            Object container = this.getAttributeAccessor().getAttributeValueFromObject(currentObject);
            result = container != null ? container : cp.containerInstance();
        } else {
            result = cp.containerInstance(nestedRows.size());
        }
        Enumeration stream = nestedRows.elements();
        while (stream.hasMoreElements()) {
            XMLRecord nestedRow = (XMLRecord)stream.nextElement();
            Object objectToAdd = this.getNullPolicy().valueIsNull((Element)nestedRow.getDOM()) ? null : this.buildObjectFromNestedRow(nestedRow, joinManager, sourceQuery, executionSession, isTargetProtected);
            cp.addInto(objectToAdd, result, sourceQuery.getSession());
            if (this.getContainerAccessor() == null) continue;
            Object currentObject = ((XMLRecord)row).getCurrentObject();
            if (this.inverseReferenceMapping.getContainerPolicy() == null) {
                this.getContainerAccessor().setAttributeValueInObject(objectToAdd, currentObject);
                continue;
            }
            Object backpointerContainer = this.getContainerAccessor().getAttributeValueFromObject(objectToAdd);
            if (backpointerContainer == null) {
                backpointerContainer = this.inverseReferenceMapping.getContainerPolicy().containerInstance();
                this.getContainerAccessor().setAttributeValueInObject(objectToAdd, backpointerContainer);
            }
            this.inverseReferenceMapping.getContainerPolicy().addInto(currentObject, backpointerContainer, executionSession);
        }
        return result;
    }

    public Object buildObjectFromNestedRow(AbstractRecord nestedRow, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession, boolean isTargetProtected) {
        Object objectToAdd = null;
        ClassDescriptor aDescriptor = this.getReferenceDescriptor((DOMRecord)nestedRow);
        if (aDescriptor == null) {
            if (this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
                XMLPlatformFactory.getInstance().getXMLPlatform().namespaceQualifyFragment((Element)((DOMRecord)nestedRow).getDOM());
                objectToAdd = ((DOMRecord)nestedRow).getDOM();
                if (this.getConverter() != null) {
                    objectToAdd = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertDataValueToObjectValue(objectToAdd, executionSession, ((XMLRecord)nestedRow).getUnmarshaller()) : this.getConverter().convertDataValueToObjectValue(objectToAdd, executionSession);
                }
                objectToAdd = this.convertToSimpleTypeIfPresent(objectToAdd, nestedRow, executionSession);
            } else {
                NodeList children = ((Element)((DOMRecord)nestedRow).getDOM()).getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    Node nextNode = children.item(i);
                    if (nextNode.getNodeType() == 1) {
                        String type = ((Element)((DOMRecord)nestedRow).getDOM()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                        if (type != null && type.length() > 0) {
                            throw XMLMarshalException.unknownXsiTypeValue(type, this);
                        }
                        throw XMLMarshalException.noDescriptorFound(this);
                    }
                    ++i;
                }
                objectToAdd = this.convertToSimpleTypeIfPresent(objectToAdd, nestedRow, executionSession);
            }
        } else {
            if (aDescriptor.hasInheritance()) {
                QName leafElementType;
                Class newElementClass = aDescriptor.getInheritancePolicy().classFromRow(nestedRow, executionSession);
                if (newElementClass == null && (leafElementType = ((XMLField)this.getField()).getLeafElementType()) != null) {
                    XPathQName leafElementXPathQName = new XPathQName(leafElementType, ((XMLRecord)nestedRow).isNamespaceAware());
                    Object indicator = aDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(leafElementXPathQName);
                    if (indicator != null) {
                        newElementClass = (Class)indicator;
                    }
                }
                if (newElementClass != null) {
                    aDescriptor = this.getReferenceDescriptor(newElementClass, executionSession);
                } else if (Modifier.isAbstract(aDescriptor.getJavaClass().getModifiers())) {
                    throw DescriptorException.missingClassIndicatorField(nestedRow, aDescriptor.getInheritancePolicy().getDescriptor());
                }
            }
            objectToAdd = this.buildCompositeObject(aDescriptor, nestedRow, sourceQuery, null, joinManager, executionSession);
            if (this.hasConverter()) {
                objectToAdd = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertDataValueToObjectValue(objectToAdd, executionSession, ((XMLRecord)nestedRow).getUnmarshaller()) : this.getConverter().convertDataValueToObjectValue(objectToAdd, executionSession);
            }
        }
        return objectToAdd;
    }

    private Object convertToSimpleTypeIfPresent(Object objectToAdd, AbstractRecord nestedRow, AbstractSession executionSession) {
        String stringValue = null;
        Element theElement = (Element)((DOMRecord)nestedRow).getDOM();
        Node textchild = theElement.getFirstChild();
        if (textchild != null && textchild.getNodeType() == 3 && (stringValue = ((Text)textchild).getNodeValue()) != null && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
            objectToAdd = stringValue;
        }
        if (stringValue == null || stringValue.length() == 0) {
            return objectToAdd;
        }
        String type = theElement.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (type != null && type.length() > 0) {
            XPathFragment typeFragment = new XPathFragment(type);
            String namespaceURI = ((DOMRecord)nestedRow).resolveNamespacePrefix(typeFragment.getPrefix());
            typeFragment.setNamespaceURI(namespaceURI);
            QName schemaTypeQName = new QName(namespaceURI, typeFragment.getLocalName());
            Class theClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(schemaTypeQName);
            if (theClass != null) {
                objectToAdd = ((XMLConversionManager)executionSession.getDatasourcePlatform().getConversionManager()).convertObject(stringValue, theClass, schemaTypeQName);
            }
        }
        return objectToAdd;
    }

    public ClassDescriptor getReferenceDescriptor(DOMRecord xmlRecord) {
        ClassDescriptor returnDescriptor = this.referenceDescriptor;
        if (returnDescriptor == null) {
            String type = ((Element)xmlRecord.getDOM()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (type != null && type.length() > 0) {
                XPathFragment typeFragment = new XPathFragment(type);
                String namespaceURI = xmlRecord.resolveNamespacePrefix(typeFragment.getPrefix());
                typeFragment.setNamespaceURI(namespaceURI);
                returnDescriptor = xmlRecord.getUnmarshaller().getXMLContext().getDescriptorByGlobalType(typeFragment);
            } else {
                QName leafType = ((XMLField)this.getField()).getLastXPathFragment().getLeafElementType();
                if (leafType != null) {
                    XPathFragment frag = new XPathFragment();
                    String xpath = leafType.getLocalPart();
                    String uri = leafType.getNamespaceURI();
                    if (uri != null && uri.length() > 0) {
                        frag.setNamespaceURI(uri);
                        String prefix = ((XMLDescriptor)this.getDescriptor()).getNonNullNamespaceResolver().resolveNamespaceURI(uri);
                        if (prefix != null && prefix.length() > 0) {
                            xpath = String.valueOf(prefix) + ':' + xpath;
                        }
                    }
                    frag.setXPath(xpath);
                    returnDescriptor = xmlRecord.getUnmarshaller().getXMLContext().getDescriptorByGlobalType(frag);
                }
            }
        }
        return returnDescriptor;
    }

    protected ClassDescriptor getReferenceDescriptor(Class theClass, AbstractSession session) {
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor().getJavaClass().equals(theClass)) {
            return this.getReferenceDescriptor();
        }
        ClassDescriptor subDescriptor = session.getDescriptor(theClass);
        if (subDescriptor == null && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT) {
            throw DescriptorException.noSubClassMatch(theClass, this);
        }
        return subDescriptor;
    }

    public void writeSingleValue(Object value, Object parent, XMLRecord record, AbstractSession session) {
        Object element = value;
        if (this.hasConverter()) {
            element = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertObjectValueToDataValue(element, session, record.getMarshaller()) : this.getConverter().convertObjectValueToDataValue(element, session);
        }
        XMLRecord nestedRow = (XMLRecord)this.buildCompositeRow(element, session, record, DatabaseMapping.WriteType.UNDEFINED);
        record.add(this.getField(), nestedRow);
    }

    public void setNullPolicy(AbstractNullPolicy aNullPolicy) {
        this.nullPolicy = aNullPolicy;
    }

    public AbstractNullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    public UnmarshalKeepAsElementPolicy getKeepAsElementPolicy() {
        return this.keepAsElementPolicy;
    }

    public void setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy keepAsElementPolicy) {
        this.keepAsElementPolicy = keepAsElementPolicy;
    }

    protected XMLDescriptor getDescriptor(XMLRecord xmlRecord, AbstractSession session, QName rootQName) throws XMLMarshalException {
        XMLContext xmlContext;
        XMLDescriptor xmlDescriptor;
        if (rootQName == null) {
            rootQName = new QName(xmlRecord.getNamespaceURI(), xmlRecord.getLocalName());
        }
        if ((xmlDescriptor = (xmlContext = xmlRecord.getUnmarshaller().getXMLContext()).getDescriptor(rootQName)) == null && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
            throw XMLMarshalException.noDescriptorWithMatchingRootElement(xmlRecord.getLocalName());
        }
        return xmlDescriptor;
    }

    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        this.getAttributeAccessor().setIsWriteOnly(this.isWriteOnly());
        this.getAttributeAccessor().setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value);
    }

    public boolean getReuseContainer() {
        return this.reuseContainer;
    }

    public void setReuseContainer(boolean reuseContainer) {
        this.reuseContainer = reuseContainer;
    }

    public XMLInverseReferenceMapping getInverseReferenceMapping() {
        return this.inverseReferenceMapping;
    }

    void setInverseReferenceMapping(XMLInverseReferenceMapping inverseReferenceMapping) {
        this.inverseReferenceMapping = inverseReferenceMapping;
    }

    public boolean isDefaultEmptyContainer() {
        return this.defaultEmptyContainer;
    }

    public void setDefaultEmptyContainer(boolean defaultEmptyContainer) {
        this.defaultEmptyContainer = defaultEmptyContainer;
    }

    public AbstractNullPolicy getWrapperNullPolicy() {
        return this.wrapperNullPolicy;
    }

    public void setWrapperNullPolicy(AbstractNullPolicy policy) {
        this.wrapperNullPolicy = policy;
    }
}

