/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.queries.JPAQueryBuilder;

public final class JPAQueryBuilderManager {
    private static JPAQueryBuilder systemQueryBuilder;

    private static JPAQueryBuilder buildDefaultQueryBuilder() {
        block9: {
            try {
                Class parserClass = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        parserClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName("org.eclipse.persistence.queries.ANTLRQueryBuilder"));
                    }
                    catch (PrivilegedActionException privilegedActionException) {}
                } else {
                    parserClass = PrivilegedAccessHelper.getClassForName("org.eclipse.persistence.queries.ANTLRQueryBuilder");
                }
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return (JPAQueryBuilder)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(parserClass));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        break block9;
                    }
                }
                return (JPAQueryBuilder)PrivilegedAccessHelper.newInstanceFromClass(parserClass);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("Could not load the ANTLRQueryBuilder class.", e);
            }
        }
        return null;
    }

    public static JPAQueryBuilder getQueryBuilder() {
        if (systemQueryBuilder == null) {
            systemQueryBuilder = JPAQueryBuilderManager.buildDefaultQueryBuilder();
        }
        return systemQueryBuilder;
    }

    public static void setQueryBuilder(JPAQueryBuilder queryBuilder) {
        systemQueryBuilder = queryBuilder;
    }
}

