/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.jpql.parser.CompoundExpression;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;

public final class ArithmeticExpressionFactory
extends ExpressionFactory {
    private ArithmeticExpressionVisitor visitor;
    public static final String ID = "*/-+";

    public ArithmeticExpressionFactory() {
        super(ID, "+", "-", "/", "*");
    }

    private CompoundExpression buildExpression(AbstractExpression parent, char character) {
        if (character == '*') {
            return new MultiplicationExpression(parent);
        }
        return new DivisionExpression(parent);
    }

    protected final AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        Boolean type = wordParser.startsWithDigit();
        if (type == Boolean.TRUE && expression == null) {
            expression = new NumericLiteral(parent, wordParser.word());
            expression.parse(wordParser, tolerant);
            return expression;
        }
        if (type == Boolean.FALSE && expression == null) {
            expression = new ArithmeticFactor(parent, word);
            expression.parse(wordParser, tolerant);
            return expression;
        }
        char character = wordParser.character();
        if (character == '-') {
            SubtractionExpression substractionExpression = new SubtractionExpression(parent);
            substractionExpression.setLeftExpression(expression);
            substractionExpression.parse(wordParser, tolerant);
            return substractionExpression;
        }
        if (character == '+') {
            AdditionExpression additionExpression = new AdditionExpression(parent);
            additionExpression.setLeftExpression(expression);
            additionExpression.parse(wordParser, tolerant);
            return additionExpression;
        }
        if (expression != null) {
            expression.accept(this.visitor());
        }
        if (this.visitor != null && this.visitor.found) {
            this.visitor.found = false;
            ArithmeticExpression arithmeticException = (ArithmeticExpression)expression;
            CompoundExpression compoundExpression = this.buildExpression(parent, character);
            compoundExpression.setLeftExpression((AbstractExpression)arithmeticException.getRightExpression());
            compoundExpression.parse(wordParser, tolerant);
            arithmeticException.setRightExpression(compoundExpression);
            return arithmeticException;
        }
        CompoundExpression compoundExpression = this.buildExpression(parent, character);
        compoundExpression.setLeftExpression(expression);
        compoundExpression.parse(wordParser, tolerant);
        return compoundExpression;
    }

    private ArithmeticExpressionVisitor visitor() {
        if (this.visitor == null) {
            this.visitor = new ArithmeticExpressionVisitor();
        }
        return this.visitor;
    }

    private class ArithmeticExpressionVisitor
    extends AbstractExpressionVisitor {
        boolean found;

        private ArithmeticExpressionVisitor() {
        }

        public void visit(AdditionExpression expression) {
            this.found = true;
        }

        public void visit(SubtractionExpression expression) {
            this.found = true;
        }
    }
}

