/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.List;
import java.util.Map;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.QueryImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.SQLResultSetMapping;
import org.eclipse.persistence.queries.StoredProcedureCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcedureQueryImpl
extends QueryImpl {
    protected List resultList;

    protected StoredProcedureQueryImpl(EntityManagerImpl entityManager) {
        super(entityManager);
    }

    public StoredProcedureQueryImpl(DatabaseQuery query, EntityManagerImpl entityManager) {
        super(query, entityManager);
    }

    public StoredProcedureQueryImpl(String name, EntityManagerImpl entityManager) {
        super(entityManager);
        this.queryName = name;
    }

    public static DatabaseQuery buildResultSetMappingNameQuery(List<String> resultSetMappingNames, StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        call.setReturnMultipleResultSetCollections(call.hasMultipleResultSets());
        query.setCall(call);
        query.setIsUserDefined(true);
        query.setSQLResultSetMappingNames(resultSetMappingNames);
        DatabaseQuery hintQuery = StoredProcedureQueryImpl.applyHints(hints, query, classLoader, session);
        StoredProcedureQueryImpl.applyArguments(call, hintQuery);
        return hintQuery;
    }

    public static DatabaseQuery buildResultSetMappingQuery(List<SQLResultSetMapping> resultSetMappings, StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        call.setReturnMultipleResultSetCollections(call.hasMultipleResultSets());
        query.setCall(call);
        query.setIsUserDefined(true);
        query.setSQLResultSetMappings(resultSetMappings);
        DatabaseQuery hintQuery = StoredProcedureQueryImpl.applyHints(hints, query, classLoader, session);
        StoredProcedureQueryImpl.applyArguments(call, hintQuery);
        return hintQuery;
    }

    public static DatabaseQuery buildStoredProcedureQuery(Class resultClass, StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        DatabaseQuery query = new ReadAllQuery(resultClass);
        query.setCall(call);
        query.setIsUserDefined(true);
        query = StoredProcedureQueryImpl.applyHints(hints, query, classLoader, session);
        StoredProcedureQueryImpl.applyArguments(call, query);
        return query;
    }

    public static DatabaseQuery buildStoredProcedureQuery(StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        DataReadQuery query = new DataReadQuery();
        query.setResultType(4);
        query.setCall(call);
        query.setIsUserDefined(true);
        DatabaseQuery hintQuery = StoredProcedureQueryImpl.applyHints(hints, query, classLoader, session);
        StoredProcedureQueryImpl.applyArguments(call, hintQuery);
        return hintQuery;
    }

    public static DatabaseQuery buildStoredProcedureQuery(String sqlResultSetMappingName, StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        query.setSQLResultSetMappingName(sqlResultSetMappingName);
        query.setCall(call);
        query.setIsUserDefined(true);
        DatabaseQuery hintQuery = StoredProcedureQueryImpl.applyHints(hints, query, classLoader, session);
        StoredProcedureQueryImpl.applyArguments(call, hintQuery);
        return hintQuery;
    }

    public boolean execute() {
        return false;
    }

    public Object getOutputParameterValue(int position) {
        return null;
    }

    public Object getOutputParameterValue(String parameterName) {
        return null;
    }

    @Override
    public List getResultList() {
        if (this.resultList == null) {
            this.resultList = super.getResultList();
        }
        return (List)this.resultList.remove(0);
    }

    public int getUpdateCount() {
        return -1;
    }

    public boolean hasMoreResults() {
        return this.resultList != null && !this.resultList.isEmpty();
    }

    @Override
    public StoredProcedureQueryImpl setFirstResult(int startPosition) {
        return (StoredProcedureQueryImpl)super.setFirstResult(startPosition);
    }

    @Override
    public StoredProcedureQueryImpl setFlushMode(FlushModeType flushMode) {
        return (StoredProcedureQueryImpl)super.setFlushMode(flushMode);
    }

    @Override
    public StoredProcedureQueryImpl setLockMode(LockModeType lockMode) {
        return (StoredProcedureQueryImpl)super.setLockMode(lockMode);
    }

    @Override
    public StoredProcedureQueryImpl setMaxResults(int maxResult) {
        return (StoredProcedureQueryImpl)super.setMaxResults(maxResult);
    }
}

