/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataMethod
extends MetadataAnnotatedElement {
    protected MetadataClass m_metadataClass;
    protected String m_returnType;
    protected List<String> m_parameters;
    protected MetadataMethod m_setMethod;
    protected MetadataMethod m_next;

    public MetadataMethod(MetadataFactory factory, MetadataClass metadataClass) {
        super(factory);
        this.m_metadataClass = metadataClass;
        this.m_parameters = new ArrayList<String>();
    }

    public void addParameter(String parameter) {
        this.m_parameters.add(parameter);
    }

    public MetadataClass getMetadataClass() {
        return this.m_metadataClass;
    }

    public MetadataMethod getNext() {
        return this.m_next;
    }

    public List<String> getParameters() {
        return this.m_parameters;
    }

    public String getReturnType() {
        return this.m_returnType;
    }

    public MetadataMethod getSetMethod() {
        if (this.m_setMethod == null) {
            this.m_setMethod = this.getSetMethod(this.getMetadataClass());
        }
        return this.m_setMethod;
    }

    public void setSetMethod(MetadataMethod method) {
        this.m_setMethod = method;
    }

    public MetadataMethod getSetMethod(MetadataClass cls) {
        String getMethodName = this.getName();
        List<String> params = Arrays.asList(this.getReturnType());
        MetadataMethod setMethod = null;
        if (getMethodName.startsWith("get")) {
            setMethod = cls.getMethod("set" + getMethodName.substring(3), params);
        } else {
            setMethod = cls.getMethod("set" + getMethodName.substring(2), params);
            if (setMethod == null) {
                setMethod = cls.getMethod("setIs" + getMethodName.substring(2), params);
            }
        }
        return setMethod;
    }

    public String getSetMethodName() {
        return this.getSetMethod().getName();
    }

    public boolean hasAttributeName() {
        return !this.getAttributeName().equals("");
    }

    public boolean hasParameters() {
        return this.getParameters().size() > 0;
    }

    public boolean hasSetMethod() {
        return this.getSetMethod() != null;
    }

    public boolean isALifeCycleCallbackMethod() {
        return this.isAnnotationPresent("javax.persistence.PostLoad") || this.isAnnotationPresent("javax.persistence.PostPersist") || this.isAnnotationPresent("javax.persistence.PostRemove") || this.isAnnotationPresent("javax.persistence.PostUpdate") || this.isAnnotationPresent("javax.persistence.PrePersist") || this.isAnnotationPresent("javax.persistence.PreRemove") || this.isAnnotationPresent("javax.persistence.PreUpdate");
    }

    protected boolean isValidPersistenceMethod() {
        return this.isValidPersistenceMethodName() && !this.hasParameters() && this.hasSetMethod();
    }

    public boolean isValidPersistenceMethod(boolean mustBeExplicit, ClassAccessor classAccessor) {
        if (this.isValidPersistenceElement(mustBeExplicit, "PROPERTY", classAccessor)) {
            return !this.isALifeCycleCallbackMethod() && this.isValidPersistenceMethod(classAccessor, this.hasDeclaredAnnotations(classAccessor));
        }
        return false;
    }

    public boolean isValidPersistenceMethod(ClassAccessor classAccessor, boolean userDecorated) {
        if (!this.isValidPersistenceElement(this.getModifiers()) || !this.isValidPersistenceMethod()) {
            if (userDecorated) {
                if (this.hasParameters()) {
                    throw ValidationException.mappingMetadataAppliedToMethodWithArguments(this, classAccessor.getDescriptorJavaClass());
                }
                if (!this.hasSetMethod()) {
                    throw ValidationException.noCorrespondingSetterMethodDefined(classAccessor.getDescriptorJavaClass(), this);
                }
                this.getLogger().logConfigMessage("metadata_warning_ignore_mapping_metadata", this, (Object)classAccessor.getDescriptorJavaClass());
            }
            return false;
        }
        return true;
    }

    public boolean isValidPersistenceMethodName() {
        return (this.getName().startsWith("get") || this.getName().startsWith("is")) && this.hasAttributeName();
    }

    public void setMetadataClass(MetadataClass metadataClass) {
        this.m_metadataClass = metadataClass;
    }

    public void setNext(MetadataMethod next) {
        this.m_next = next;
    }

    public void setParameters(List<String> parameters) {
        this.m_parameters = parameters;
    }

    public void setReturnType(String returnType) {
        this.m_returnType = returnType;
        this.setType(returnType);
    }
}

