/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.xr.Invocation;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;

public class DeleteOperation
extends Operation {
    protected String descriptorName;
    protected ClassDescriptor classDescriptor;

    public String getDescriptorName() {
        return this.descriptorName;
    }

    public void setDescriptorName(String descriptorName) {
        this.descriptorName = descriptorName;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public void validate(XRServiceAdapter xrService) {
        super.validate(xrService);
        if (this.descriptorName == null) {
            throw DBWSException.couldNotLocateDescriptorForOperation(this.descriptorName, this.getName());
        }
        if (!xrService.getORSession().getProject().getAliasDescriptors().containsKey(this.descriptorName)) {
            throw DBWSException.couldNotLocateDescriptorForOperation(this.descriptorName, this.getName());
        }
        this.classDescriptor = xrService.getORSession().getProject().getDescriptorForAlias(this.descriptorName);
    }

    public Object invoke(XRServiceAdapter xrService, Invocation invocation) {
        ReadObjectQuery roq = (ReadObjectQuery)this.classDescriptor.getQueryManager().getQuery("findByPrimaryKey");
        List<String> queryArguments = roq.getArguments();
        int queryArgumentsSize = queryArguments.size();
        NonSynchronizedVector executeArguments = new NonSynchronizedVector();
        int i = 0;
        while (i < queryArgumentsSize) {
            String argName = queryArguments.get(i);
            ((Vector)executeArguments).add(invocation.getParameter(argName));
            ++i;
        }
        UnitOfWork uow = xrService.getORSession().acquireUnitOfWork();
        Object toBeDeleted = uow.executeQuery(roq, (List)executeArguments);
        if (toBeDeleted != null) {
            uow.deleteObject(toBeDeleted);
            uow.commit();
        }
        return null;
    }
}

