/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.ProcedureArgument;
import org.eclipse.persistence.internal.xr.ProcedureOutputArgument;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.queries.ValueReadQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcedureQueryHandler
extends QueryHandler {
    protected String name;
    protected List<ProcedureArgument> inArguments = new ArrayList<ProcedureArgument>();
    protected List<ProcedureOutputArgument> inOutArguments = new ArrayList<ProcedureOutputArgument>();
    protected List<ProcedureOutputArgument> outArguments = new ArrayList<ProcedureOutputArgument>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ProcedureArgument> getInArguments() {
        return this.inArguments;
    }

    public List<ProcedureOutputArgument> getInOutArguments() {
        return this.inOutArguments;
    }

    public List<ProcedureOutputArgument> getOutArguments() {
        return this.outArguments;
    }

    public boolean isStoredFunctionQueryHandler() {
        return false;
    }

    @Override
    public void initializeDatabaseQuery(XRServiceAdapter xrService, QueryOperation queryOperation) {
        DatabaseQuery databaseQueryToInitialize;
        if (queryOperation.hasResponse()) {
            QName type = queryOperation.getResult().getType();
            if (queryOperation.isCollection()) {
                if (queryOperation.isSimpleXMLFormat()) {
                    databaseQueryToInitialize = new DataReadQuery();
                } else if (!xrService.descriptorsByQName.containsKey(type)) {
                    databaseQueryToInitialize = new DataReadQuery();
                } else {
                    Class<?> typeClass = xrService.getTypeClass(type);
                    databaseQueryToInitialize = xrService.getORSession().getDescriptor(typeClass).isAggregateDescriptor() ? new DataReadQuery() : new ReadAllQuery(typeClass);
                }
            } else {
                databaseQueryToInitialize = this.getOutArguments().size() == 0 && this.getInOutArguments().size() == 0 ? (this.isStoredFunctionQueryHandler() ? (!xrService.descriptorsByQName.containsKey(type) ? new ValueReadQuery() : new ReadObjectQuery(xrService.getTypeClass(type))) : new DataModifyQuery()) : (!xrService.descriptorsByQName.containsKey(type) ? (type.equals(Util.SXF_QNAME) ? new DataReadQuery() : new ValueReadQuery()) : new ReadObjectQuery(xrService.getTypeClass(type)));
            }
        } else {
            databaseQueryToInitialize = new ValueReadQuery();
        }
        databaseQueryToInitialize.bindAllParameters();
        this.setDatabaseQuery(databaseQueryToInitialize);
    }

    @Override
    public void initializeCall(XRServiceAdapter xrService, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
        StoredProcedureCall spCall = this.createCall();
        if (this.getName() != null) {
            spCall.setProcedureName(this.getName());
        } else {
            spCall.setProcedureName(queryOperation.getName());
        }
        QName resultType = queryOperation.getResultType();
        if (this.getInOutArguments().size() + this.getOutArguments().size() > 1 && !queryOperation.isSimpleXMLFormat()) {
            throw DBWSException.multipleOutputArgumentsOnlySupportedForSimpleXML();
        }
        for (Parameter p : queryOperation.getParameters()) {
            ProcedureArgument arg = this.findInOutArgument(p.getName());
            String argName = p.getName();
            if (arg != null) {
                argName = arg.getName();
            }
            if (arg != null && arg instanceof ProcedureOutputArgument) {
                if (this.isCursorType(xrService, p.getType())) {
                    throw DBWSException.inoutCursorArgumentsNotSupported();
                }
                spCall.addNamedInOutputArgument(argName, p.getName());
                continue;
            }
            spCall.addNamedArgument(argName, p.getName());
        }
        if (queryOperation.hasResponse()) {
            if (!queryOperation.isSimpleXMLFormat() || spCall.isStoredFunctionCall() && !this.isCursorType(xrService, resultType)) {
                this.setSingleResult(xrService, spCall, resultType);
            } else if (spCall.isStoredFunctionCall() && this.isCursorType(xrService, resultType)) {
                spCall.useUnnamedCursorOutputAsResultSet();
            } else if (this.getOutArguments().isEmpty()) {
                spCall.setReturnsResultSet(true);
            } else {
                for (ProcedureOutputArgument arg : this.getOutArguments()) {
                    if (arg.getResultType() != null && this.isCursorType(xrService, arg.getResultType())) {
                        spCall.useNamedCursorOutputAsResultSet(arg.getName());
                        continue;
                    }
                    spCall.addNamedOutputArgument(arg.getName());
                }
            }
        }
        databaseQuery.setCall(spCall);
    }

    @Override
    public void initializeArguments(XRServiceAdapter xrService, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
        for (Parameter p : queryOperation.getParameters()) {
            databaseQuery.addArgument(p.getName());
        }
    }

    protected void setSingleResult(XRServiceAdapter xrService, StoredProcedureCall spCall, QName resultType) {
        if (this.getOutArguments().size() == 1) {
            ProcedureArgument arg = this.getOutArguments().get(0);
            if (this.isCursorType(xrService, resultType) || arg instanceof ProcedureOutputArgument && this.isCursorType(xrService, ((ProcedureOutputArgument)arg).getResultType())) {
                spCall.useNamedCursorOutputAsResultSet(arg.getName());
            } else {
                spCall.addNamedOutputArgument(arg.getName());
            }
        }
    }

    protected StoredProcedureCall createCall() {
        StoredProcedureCall spCall = new StoredProcedureCall();
        return spCall;
    }

    private ProcedureArgument findInOutArgument(String name) {
        for (ProcedureArgument procedureArgument : this.getInArguments()) {
            if (procedureArgument.getParameterName() != null && procedureArgument.getParameterName().equalsIgnoreCase(name)) {
                return procedureArgument;
            }
            if (!procedureArgument.getName().equalsIgnoreCase(name)) continue;
            return procedureArgument;
        }
        for (ProcedureArgument procedureArgument : this.getInOutArguments()) {
            if (procedureArgument.getParameterName() != null && procedureArgument.getParameterName().equalsIgnoreCase(name)) {
                return procedureArgument;
            }
            if (!procedureArgument.getName().equalsIgnoreCase(name)) continue;
            return procedureArgument;
        }
        return null;
    }

    protected boolean isCursorType(XRServiceAdapter xrService, QName type) {
        return type.getLocalPart().startsWith("cursor of");
    }
}

