/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.metadata;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.jpa.metadata.MetadataSourceAdapter;
import org.eclipse.persistence.logging.SessionLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLMetadataSource
extends MetadataSourceAdapter {
    public Reader getEntityMappingsReader(Map<String, Object> properties, ClassLoader classLoader, SessionLog log) {
        String mappingFileName;
        InputStreamReader reader = null;
        String mappingURLName = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.metadata-source.xml.url", properties);
        if (mappingURLName != null && mappingURLName.length() != 0) {
            try {
                URL url = new URL(mappingURLName);
                reader = new InputStreamReader(url.openStream());
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
        if (reader == null && (mappingFileName = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.metadata-source.xml.file", properties)) != null && mappingFileName.length() > 0) {
            try {
                URL fileURL = XMLMetadataSource.getFileURL(mappingFileName, classLoader, log);
                if (fileURL != null) {
                    reader = new InputStreamReader(fileURL.openStream());
                }
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
        if (reader == null) {
            throw ValidationException.missingXMLMetadataRepositoryConfig();
        }
        return reader;
    }

    @Override
    public XMLEntityMappings getEntityMappings(Map<String, Object> properties, ClassLoader classLoader, SessionLog log) {
        XMLEntityMappings xMLEntityMappings;
        block8: {
            Reader reader = this.getEntityMappingsReader(properties, classLoader, log);
            if (reader == null) {
                return null;
            }
            try {
                xMLEntityMappings = XMLEntityMappingsReader.read(this.getRepositoryName(), reader, classLoader, properties);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return xMLEntityMappings;
    }

    public String getRepositoryName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Map<String, Object> getPropertyOverrides(Map<String, Object> properties, ClassLoader classLoader, SessionLog log) {
        String propertiesFileName;
        block5: {
            propertiesFileName = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.metadata-source.properties.file", properties);
            if (propertiesFileName == null || propertiesFileName.length() == 0) {
                return null;
            }
            try {
                URL fileURL = XMLMetadataSource.getFileURL(propertiesFileName, classLoader, log);
                if (fileURL == null) break block5;
                Properties propertiesFromFile = new Properties();
                propertiesFromFile.load(fileURL.openStream());
                if (!propertiesFromFile.isEmpty()) {
                    return new HashMap<Object, Object>(propertiesFromFile);
                }
                return null;
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
        throw ValidationException.missingPropertiesFileForMetadataRepositoryConfig(propertiesFileName);
    }

    protected static URL getFileURL(String fileName, ClassLoader classLoader, SessionLog log) throws IOException {
        Enumeration<URL> fileURLs = classLoader.getResources(fileName);
        if (!fileURLs.hasMoreElements()) {
            fileURLs = classLoader.getResources("/./" + fileName);
        }
        if (fileURLs.hasMoreElements()) {
            URL nextURL = fileURLs.nextElement();
            if (fileURLs.hasMoreElements()) {
                log.logThrowable(2, "metadata", ValidationException.nonUniqueRepositoryFileName(fileName));
            }
            return nextURL;
        }
        return null;
    }
}

