/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.nosql.adapters.mongo;

import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISPlatform;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.eis.interactions.MappedInteraction;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.QueryStringCall;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.LogicalExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoInteractionSpec;
import org.eclipse.persistence.internal.nosql.adapters.mongo.MongoOperation;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeObjectMapping;
import org.eclipse.persistence.nosql.adapters.mongo.OIDSequence;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class MongoPlatform
extends EISPlatform {
    public static String OPERATION = "mongo.operation";
    public static String COLLECTION = "mongo.collection";
    public static String OPTIONS = "mongo.options";
    public static String READ_PREFERENCE = "mongo.read-preference";
    public static String WRITE_CONCERN = "mongo.write-concern";
    public static String SKIP = "mongo.skip";
    public static String LIMIT = "mongo.limit";
    public static String BATCH_SIZE = "mongo.batch-size";
    protected boolean isLikeRegex;

    public MongoPlatform() {
        this.setIsMappedRecordSupported(true);
        this.setIsIndexedRecordSupported(false);
        this.setIsDOMRecordSupported(true);
        this.setSupportsLocalTransactions(true);
    }

    @Override
    public void setValueInRecord(String key, Object value, MappedRecord record, EISAccessor accessor) {
        Object recordValue = value;
        if (value instanceof BigDecimal || value instanceof BigInteger) {
            recordValue = this.getConversionManager().convertObject(value, ClassConstants.STRING);
        }
        record.put((Object)key, recordValue);
    }

    public boolean isLikeRegex() {
        return this.isLikeRegex;
    }

    public void setIsLikeRegex(boolean isLikeRegex) {
        this.isLikeRegex = isLikeRegex;
    }

    @Override
    public InteractionSpec buildInteractionSpec(EISInteraction interaction) {
        InteractionSpec spec = interaction.getInteractionSpec();
        if (spec == null) {
            Object preference;
            MongoInteractionSpec mongoSpec = new MongoInteractionSpec();
            Object operation = interaction.getProperty(OPERATION);
            if (interaction.isQueryStringCall()) {
                mongoSpec.setCode(((QueryStringCall)((Object)interaction)).getQueryString());
                operation = MongoOperation.EVAL;
            }
            if (operation == null) {
                throw new EISException("'" + OPERATION + "' property must be set on the query's interation.");
            }
            if (operation instanceof String) {
                operation = MongoOperation.valueOf((String)operation);
            }
            mongoSpec.setOperation((MongoOperation)((Object)operation));
            Object collection = interaction.getProperty(COLLECTION);
            if (collection != null) {
                mongoSpec.setCollection((String)collection);
            }
            if ((preference = interaction.getProperty(READ_PREFERENCE)) instanceof ReadPreference) {
                mongoSpec.setReadPreference((ReadPreference)preference);
            } else if (preference instanceof String) {
                String constant = (String)preference;
                if (constant.equals("PRIMARY")) {
                    mongoSpec.setReadPreference(ReadPreference.PRIMARY);
                } else if (constant.equals("SECONDARY")) {
                    mongoSpec.setReadPreference(ReadPreference.SECONDARY);
                } else {
                    throw new EISException("Invalid read preference property value: " + constant);
                }
            }
            Object concern = interaction.getProperty(WRITE_CONCERN);
            if (concern instanceof WriteConcern) {
                mongoSpec.setWriteConcern((WriteConcern)concern);
            } else if (concern instanceof String) {
                String constant = (String)concern;
                if (constant.equals("FSYNC_SAFE")) {
                    mongoSpec.setWriteConcern(WriteConcern.FSYNC_SAFE);
                } else if (constant.equals("JOURNAL_SAFE")) {
                    mongoSpec.setWriteConcern(WriteConcern.JOURNAL_SAFE);
                } else if (constant.equals("MAJORITY")) {
                    mongoSpec.setWriteConcern(WriteConcern.MAJORITY);
                } else if (constant.equals("NONE")) {
                    mongoSpec.setWriteConcern(WriteConcern.NONE);
                } else if (constant.equals("NORMAL")) {
                    mongoSpec.setWriteConcern(WriteConcern.NORMAL);
                } else if (constant.equals("REPLICAS_SAFE")) {
                    mongoSpec.setWriteConcern(WriteConcern.REPLICAS_SAFE);
                } else if (constant.equals("SAFE")) {
                    mongoSpec.setWriteConcern(WriteConcern.SAFE);
                } else {
                    throw new EISException("Invalid read preference property value: " + constant);
                }
            }
            Object options = interaction.getProperty(OPTIONS);
            if (options instanceof Number) {
                mongoSpec.setOptions(((Number)options).intValue());
            } else if (options instanceof String) {
                mongoSpec.setOptions(Integer.valueOf((String)options));
            }
            Object skip = interaction.getProperty(SKIP);
            if (skip instanceof Number) {
                mongoSpec.setSkip(((Number)skip).intValue());
            } else if (skip instanceof String) {
                mongoSpec.setSkip(Integer.valueOf((String)skip));
            }
            Object limit = interaction.getProperty(LIMIT);
            if (limit instanceof Number) {
                mongoSpec.setLimit(((Number)limit).intValue());
            } else if (skip instanceof String) {
                mongoSpec.setLimit(Integer.valueOf((String)limit));
            }
            Object batchSize = interaction.getProperty(BATCH_SIZE);
            if (batchSize instanceof Number) {
                mongoSpec.setBatchSize(((Number)batchSize).intValue());
            } else if (skip instanceof String) {
                mongoSpec.setBatchSize(Integer.valueOf((String)batchSize));
            }
            spec = mongoSpec;
        }
        return spec;
    }

    @Override
    public Record createOutputRecord(EISInteraction interaction, AbstractRecord translationRow, EISAccessor accessor) {
        if (interaction.getInteractionSpec() != null && ((MongoInteractionSpec)interaction.getInteractionSpec()).getOperation() == MongoOperation.UPDATE || interaction.getProperty(OPERATION) != null && (interaction.getProperty(OPERATION) == MongoOperation.UPDATE || interaction.getProperty(OPERATION).equals(MongoOperation.UPDATE.name()))) {
            return (Record)interaction.createRecordElement(interaction.getInputRecordName(), translationRow, accessor);
        }
        return null;
    }

    @Override
    public void initializeDefaultQueries(DescriptorQueryManager queryManager, AbstractSession session) {
        MappedInteraction call;
        if (!queryManager.hasInsertQuery()) {
            call = new MappedInteraction();
            call.setProperty(OPERATION, (Object)MongoOperation.INSERT);
            call.setProperty(COLLECTION, ((EISDescriptor)queryManager.getDescriptor()).getDataTypeName());
            queryManager.setInsertCall(call);
        }
        if (!queryManager.hasUpdateQuery()) {
            call = new MappedInteraction();
            call.setProperty(OPERATION, (Object)MongoOperation.UPDATE);
            call.setProperty(COLLECTION, ((EISDescriptor)queryManager.getDescriptor()).getDataTypeName());
            queryManager.setUpdateCall(call);
        }
        if (!queryManager.hasReadObjectQuery()) {
            call = new MappedInteraction();
            call.setProperty(OPERATION, (Object)MongoOperation.FIND);
            call.setProperty(COLLECTION, ((EISDescriptor)queryManager.getDescriptor()).getDataTypeName());
            for (DatabaseField field : queryManager.getDescriptor().getPrimaryKeyFields()) {
                call.addArgument(field.getName());
            }
            queryManager.setReadObjectCall(call);
        }
        if (!queryManager.hasDeleteQuery()) {
            call = new MappedInteraction();
            call.setProperty(OPERATION, (Object)MongoOperation.REMOVE);
            call.setProperty(COLLECTION, ((EISDescriptor)queryManager.getDescriptor()).getDataTypeName());
            for (DatabaseField field : queryManager.getDescriptor().getPrimaryKeyFields()) {
                call.addArgument(field.getName());
            }
            queryManager.setDeleteCall(call);
        }
    }

    @Override
    public DatasourceCall buildCallFromStatement(SQLStatement statement, DatabaseQuery query, AbstractSession session) {
        if (query.isObjectLevelReadQuery()) {
            ObjectLevelReadQuery readQuery = (ObjectLevelReadQuery)query;
            MappedInteraction interaction = new MappedInteraction();
            interaction.setProperty(OPERATION, (Object)MongoOperation.FIND);
            interaction.setProperty(COLLECTION, ((EISDescriptor)query.getDescriptor()).getDataTypeName());
            if (readQuery.getFirstResult() > 0) {
                interaction.setProperty(SKIP, readQuery.getFirstResult());
            }
            if (readQuery.getMaxRows() > 0) {
                interaction.setProperty(LIMIT, readQuery.getMaxRows());
            }
            if (readQuery.getFetchSize() > 0) {
                interaction.setProperty(BATCH_SIZE, readQuery.getMaxRows());
            }
            DatabaseRecord row = new DatabaseRecord();
            if (statement.getWhereClause() != null) {
                this.appendExpressionToQueryRow(statement.getWhereClause(), row, query);
            }
            if (readQuery.hasOrderByExpressions()) {
                DatabaseRecord sort = new DatabaseRecord();
                for (Expression orderBy : readQuery.getOrderByExpressions()) {
                    this.appendExpressionToSortRow(orderBy, sort, query);
                }
                row.put("$sort", (Object)sort);
            }
            if (readQuery.isReportQuery()) {
                DatabaseRecord select = new DatabaseRecord();
                for (Expression field : ((SQLSelectStatement)statement).getFields()) {
                    if (field instanceof DatabaseField) {
                        select.put((DatabaseField)((Object)field), (Object)1);
                        continue;
                    }
                    if (!(field instanceof Expression)) continue;
                    Object value = this.extractValueFromExpression(field, readQuery);
                    if (!(value instanceof DatabaseField)) {
                        throw new EISException("Query too complex for Mongo translation, only field selects are supported in query: " + query);
                    }
                    select.put((DatabaseField)value, (Object)1);
                }
                row.put("$select", (Object)select);
            }
            interaction.setInputRow(row);
            return interaction;
        }
        throw new EISException("Query too complex for Mongo translation, only select queries are supported in query: " + query);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void appendExpressionToQueryRow(Expression expression, AbstractRecord row, DatabaseQuery query) {
        if (expression.isRelationExpression()) {
            RelationExpression relation = (RelationExpression)expression;
            Object left = this.extractValueFromExpression(relation.getFirstChild(), query);
            Object right = this.extractValueFromExpression(relation.getSecondChild(), query);
            if (relation.getOperator().getSelector() == 4) {
                row.put(left, right);
                return;
            } else {
                DatabaseRecord nested = new DatabaseRecord();
                if (relation.getOperator().getSelector() == 9) {
                    nested.put("$gt", right);
                } else if (relation.getOperator().getSelector() == 7) {
                    nested.put("$lt", right);
                } else if (relation.getOperator().getSelector() == 8) {
                    nested.put("$lte", right);
                } else if (relation.getOperator().getSelector() == 10) {
                    nested.put("$gte", right);
                } else if (relation.getOperator().getSelector() == 5) {
                    nested.put("$ne", right);
                } else if (relation.getOperator().getSelector() == 13) {
                    nested.put("$in", right);
                    row.put(left, (Object)nested);
                } else {
                    if (relation.getOperator().getSelector() != 14) throw new EISException("Query too complex for Mongo translation, relation [" + expression + "] not supported in query: " + query);
                    nested.put("$nin", right);
                    row.put(left, (Object)nested);
                }
                row.put(left, (Object)nested);
            }
            return;
        } else if (expression.isLogicalExpression()) {
            LogicalExpression logic = (LogicalExpression)expression;
            DatabaseRecord first = new DatabaseRecord();
            DatabaseRecord second = new DatabaseRecord();
            this.appendExpressionToQueryRow(logic.getFirstChild(), first, query);
            this.appendExpressionToQueryRow(logic.getSecondChild(), second, query);
            Vector<DatabaseRecord> nested = new Vector<DatabaseRecord>();
            nested.add(first);
            nested.add(second);
            if (logic.getOperator().getSelector() == 1) {
                row.put("$and", (Object)nested);
                return;
            } else {
                if (logic.getOperator().getSelector() != 2) throw new EISException("Query too complex for Mongo translation, logic [" + expression + "] not supported in query: " + query);
                row.put("$or", (Object)nested);
            }
            return;
        } else {
            if (!expression.isFunctionExpression()) throw new EISException("Query too complex for Mongo translation, expression [" + expression + "] not supported in query: " + query);
            FunctionExpression function = (FunctionExpression)expression;
            if (function.getOperator().getSelector() == 11) {
                Object left = this.extractValueFromExpression((Expression)function.getChildren().get(0), query);
                Object right = this.extractValueFromExpression((Expression)function.getChildren().get(1), query);
                if (!(right instanceof String)) {
                    throw new EISException("Query too complex for Mongo translation, like with [" + right + "] not supported in query: " + query);
                }
                String pattern = (String)right;
                DatabaseRecord nested = new DatabaseRecord();
                if (!this.isLikeRegex) {
                    pattern = Helper.convertLikeToRegex(pattern);
                }
                nested.put("$regex", (Object)pattern);
                row.put(left, (Object)nested);
                return;
            } else {
                if (function.getOperator().getSelector() != 3) throw new EISException("Query too complex for Mongo translation, function [" + expression + "] not supported in query: " + query);
                DatabaseRecord nested = new DatabaseRecord();
                this.appendExpressionToQueryRow((Expression)function.getChildren().get(0), nested, query);
                row.put("$not", (Object)nested);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void appendExpressionToSortRow(Expression expression, AbstractRecord row, DatabaseQuery query) {
        if (expression.isFunctionExpression()) {
            FunctionExpression function = (FunctionExpression)expression;
            if (function.getOperator().getSelector() == 26) {
                Object field = this.extractValueFromExpression((Expression)function.getChildren().get(0), query);
                row.put(field, (Object)1);
                return;
            } else {
                if (function.getOperator().getSelector() != 27) throw new EISException("Query too complex for Mongo translation, order by [" + expression + "] not supported in query: " + query);
                Object field = this.extractValueFromExpression((Expression)function.getChildren().get(0), query);
                row.put(field, (Object)-1);
            }
            return;
        } else {
            Object field = this.extractValueFromExpression(expression, query);
            row.put(field, (Object)1);
        }
    }

    protected Object extractValueFromExpression(Expression expression, DatabaseQuery query) {
        Object value = null;
        expression.getBuilder().setSession(query.getSession());
        if (expression.isQueryKeyExpression()) {
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)expression;
            value = queryKeyExpression.getField();
            if (queryKeyExpression.getMapping() != null && queryKeyExpression.getMapping().getDescriptor().isDescriptorTypeAggregate()) {
                String name = queryKeyExpression.getField().getName();
                while (queryKeyExpression.getBaseExpression().isQueryKeyExpression() && (((QueryKeyExpression)queryKeyExpression.getBaseExpression()).getMapping().isAbstractCompositeObjectMapping() || ((QueryKeyExpression)queryKeyExpression.getBaseExpression()).getMapping().isAbstractCompositeCollectionMapping() || ((QueryKeyExpression)queryKeyExpression.getBaseExpression()).getMapping().isAbstractCompositeDirectCollectionMapping())) {
                    if ((queryKeyExpression = (QueryKeyExpression)queryKeyExpression.getBaseExpression()).getMapping().isAbstractCompositeObjectMapping()) {
                        name = ((AbstractCompositeObjectMapping)queryKeyExpression.getMapping()).getField().getName() + "." + name;
                        continue;
                    }
                    if (queryKeyExpression.getMapping().isAbstractCompositeCollectionMapping()) {
                        name = ((AbstractCompositeCollectionMapping)queryKeyExpression.getMapping()).getField().getName() + "." + name;
                        continue;
                    }
                    if (!queryKeyExpression.getMapping().isAbstractCompositeDirectCollectionMapping()) continue;
                    name = ((AbstractCompositeDirectCollectionMapping)queryKeyExpression.getMapping()).getField().getName() + "." + name;
                }
                DatabaseField field = new DatabaseField();
                field.setName(name);
                value = field;
            }
        } else if (expression.isFieldExpression()) {
            value = ((FieldExpression)expression).getField();
        } else if (expression.isConstantExpression()) {
            value = ((ConstantExpression)expression).getValue();
        } else if (expression.isParameterExpression()) {
            value = query.getTranslationRow().get(((ParameterExpression)expression).getField());
        } else {
            throw new EISException("Query too complex for Mongo translation, comparison of [" + expression + "] not supported in query: " + query);
        }
        if (value instanceof List) {
            List values = (List)value;
            for (int index = 0; index < values.size(); ++index) {
                Object element = values.get(index);
                if (!(element instanceof Expression)) continue;
                element = this.extractValueFromExpression((Expression)element, query);
                values.set(index, element);
            }
        }
        return value;
    }

    @Override
    public boolean shouldPrepare(DatabaseQuery query) {
        return query.getDatasourceCall() instanceof EISInteraction;
    }

    @Override
    protected Sequence createPlatformDefaultSequence() {
        return new OIDSequence();
    }
}

