/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.nosql.adapters.nosql;

import java.util.Properties;
import javax.resource.cci.Connection;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISConnectionSpec;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLConnectionFactory;
import org.eclipse.persistence.internal.nosql.adapters.nosql.OracleNoSQLJCAConnectionSpec;

public class OracleNoSQLConnectionSpec
extends EISConnectionSpec {
    public static String STORE = "nosql.store";
    public static String HOST = "nosql.host";

    @Override
    public Connection connectToDataSource(EISAccessor accessor, Properties properties) throws DatabaseException, ValidationException {
        if (this.connectionFactory == null && this.name == null) {
            this.connectionFactory = new OracleNoSQLConnectionFactory();
        }
        if (!properties.isEmpty()) {
            String host;
            if (this.connectionSpec == null) {
                this.connectionSpec = new OracleNoSQLJCAConnectionSpec();
            }
            OracleNoSQLJCAConnectionSpec spec = (OracleNoSQLJCAConnectionSpec)this.connectionSpec;
            String store = (String)properties.get(STORE);
            if (store != null) {
                spec.setStore(store);
            }
            if ((host = (String)properties.get(HOST)) != null) {
                if (host.indexOf(44) == -1) {
                    spec.getHosts().add(host);
                } else {
                    int startIndex = 0;
                    while (startIndex < host.length() - 1) {
                        int endIndex = host.indexOf(44, startIndex);
                        if (endIndex == -1) {
                            endIndex = host.length();
                        }
                        String nextHost = host.substring(startIndex, endIndex);
                        spec.getHosts().add(nextHost);
                        startIndex = endIndex + 1;
                    }
                }
            }
        }
        return super.connectToDataSource(accessor, properties);
    }
}

