/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeListener;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class AbstractModel
implements Model {
    private ChangeSupport changeSupport;

    protected AbstractModel() {
        this.initialize();
    }

    protected void initialize() {
    }

    private ChangeSupport changeSupport() {
        if (this.changeSupport == null) {
            this.changeSupport = this.buildDefaultChangeSupport();
        }
        return this.changeSupport;
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ChangeSupport(this);
    }

    @Override
    public synchronized void addStateChangeListener(StateChangeListener listener) {
        this.changeSupport().addStateChangeListener(listener);
    }

    @Override
    public synchronized void removeStateChangeListener(StateChangeListener listener) {
        this.changeSupport().removeStateChangeListener(listener);
    }

    protected final void fireStateChanged() {
        this.changeSupport().fireStateChanged();
    }

    protected final void fireStateChanged(StateChangeEvent evt) {
        this.changeSupport().fireStateChanged(evt);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport().addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport().addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport().removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport().removePropertyChangeListener(propertyName, listener);
    }

    protected final void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport().firePropertyChanged(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChanged(String propertyName, int oldValue, int newValue) {
        this.changeSupport().firePropertyChanged(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChanged(String propertyName, boolean oldValue, boolean newValue) {
        this.changeSupport().firePropertyChanged(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChanged(String propertyName, Object newValue) {
        this.changeSupport().firePropertyChanged(propertyName, null, newValue);
    }

    protected final void firePropertyChanged(PropertyChangeEvent evt) {
        this.changeSupport().firePropertyChanged(evt);
    }

    @Override
    public synchronized void addCollectionChangeListener(CollectionChangeListener listener) {
        this.changeSupport().addCollectionChangeListener(listener);
    }

    @Override
    public synchronized void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.changeSupport().addCollectionChangeListener(collectionName, listener);
    }

    @Override
    public synchronized void removeCollectionChangeListener(CollectionChangeListener listener) {
        this.changeSupport().removeCollectionChangeListener(listener);
    }

    @Override
    public synchronized void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.changeSupport().removeCollectionChangeListener(collectionName, listener);
    }

    protected final void fireItemAdded(String collectionName, Object addedItem) {
        this.changeSupport().fireItemAdded(collectionName, addedItem);
    }

    protected final void fireItemsAdded(String collectionName, Collection addedItems) {
        this.changeSupport().fireItemsAdded(collectionName, addedItems);
    }

    protected final void fireItemsAdded(CollectionChangeEvent evt) {
        this.changeSupport().fireItemsAdded(evt);
    }

    protected final void fireItemRemoved(String collectionName, Object removedItem) {
        this.changeSupport().fireItemRemoved(collectionName, removedItem);
    }

    protected final void fireItemsRemoved(String collectionName, Collection removedItems) {
        this.changeSupport().fireItemsRemoved(collectionName, removedItems);
    }

    protected final void fireItemsRemoved(CollectionChangeEvent evt) {
        this.changeSupport().fireItemsRemoved(evt);
    }

    protected final void fireCollectionChanged(String collectionName) {
        this.changeSupport().fireCollectionChanged(collectionName);
    }

    protected final void fireCollectionChanged(CollectionChangeEvent evt) {
        this.changeSupport().fireCollectionChanged(evt);
    }

    protected boolean addItemToCollection(Object item, Collection collection, String collectionName) {
        if (collection.add(item)) {
            this.fireItemAdded(collectionName, item);
            return true;
        }
        return false;
    }

    protected boolean addItemsToCollection(Collection items, Collection collection, String collectionName) {
        return this.addItemsToCollection(items.iterator(), collection, collectionName);
    }

    protected boolean addItemsToCollection(Iterator items, Collection collection, String collectionName) {
        ArrayList addedItems = null;
        while (items.hasNext()) {
            Object item = items.next();
            if (!collection.add(item)) continue;
            if (addedItems == null) {
                addedItems = new ArrayList();
            }
            addedItems.add(item);
        }
        if (addedItems != null) {
            this.fireItemsAdded(collectionName, addedItems);
            return true;
        }
        return false;
    }

    protected boolean removeItemFromCollection(Object item, Collection collection, String collectionName) {
        if (collection.remove(item)) {
            this.fireItemRemoved(collectionName, item);
            return true;
        }
        return false;
    }

    protected boolean removeItemsFromCollection(Collection items, Collection collection, String collectionName) {
        return this.removeItemsFromCollection(items.iterator(), collection, collectionName);
    }

    protected boolean removeItemsFromCollection(Iterator items, Collection collection, String collectionName) {
        Collection removedItems = CollectionTools.collection(items);
        removedItems.retainAll(collection);
        boolean changed = collection.removeAll(removedItems);
        if (!removedItems.isEmpty()) {
            this.fireItemsRemoved(collectionName, removedItems);
        }
        return changed;
    }

    protected boolean clearCollection(Collection collection, String collectionName) {
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        this.fireCollectionChanged(collectionName);
        return true;
    }

    protected void synchronizeCollection(Collection newCollection, Collection collection, String collectionName) {
        HashBag removedItems = new HashBag(collection);
        removedItems.removeAll(newCollection);
        this.removeItemsFromCollection(removedItems, collection, collectionName);
        HashBag addedItems = new HashBag(newCollection);
        addedItems.removeAll(collection);
        this.addItemsToCollection(addedItems, collection, collectionName);
    }

    protected void synchronizeCollection(Iterator newItems, Collection collection, String collectionName) {
        this.synchronizeCollection(CollectionTools.collection(newItems), collection, collectionName);
    }

    @Override
    public synchronized void addListChangeListener(ListChangeListener listener) {
        this.changeSupport().addListChangeListener(listener);
    }

    @Override
    public synchronized void addListChangeListener(String listName, ListChangeListener listener) {
        this.changeSupport().addListChangeListener(listName, listener);
    }

    @Override
    public synchronized void removeListChangeListener(ListChangeListener listener) {
        this.changeSupport().removeListChangeListener(listener);
    }

    @Override
    public synchronized void removeListChangeListener(String listName, ListChangeListener listener) {
        this.changeSupport().removeListChangeListener(listName, listener);
    }

    protected final void fireItemAdded(String listName, int index, Object addedItem) {
        this.changeSupport().fireItemAdded(listName, index, addedItem);
    }

    protected final void fireItemsAdded(String listName, int index, List addedItems) {
        this.changeSupport().fireItemsAdded(listName, index, addedItems);
    }

    protected final void fireItemsAdded(ListChangeEvent evt) {
        this.changeSupport().fireItemsAdded(evt);
    }

    protected final void fireItemRemoved(String listName, int index, Object removedItem) {
        this.changeSupport().fireItemRemoved(listName, index, removedItem);
    }

    protected final void fireItemsRemoved(String listName, int index, List removedItems) {
        this.changeSupport().fireItemsRemoved(listName, index, removedItems);
    }

    protected final void fireItemsRemoved(ListChangeEvent evt) {
        this.changeSupport().fireItemsRemoved(evt);
    }

    protected final void fireItemReplaced(String listName, int index, Object newItem, Object replacedItem) {
        this.changeSupport().fireItemReplaced(listName, index, newItem, replacedItem);
    }

    protected final void fireItemsReplaced(String listName, int index, List newItems, List replacedItems) {
        this.changeSupport().fireItemsReplaced(listName, index, newItems, replacedItems);
    }

    protected final void fireItemsReplaced(ListChangeEvent evt) {
        this.changeSupport().fireItemsReplaced(evt);
    }

    protected final void fireListChanged(String listName) {
        this.changeSupport().fireListChanged(listName);
    }

    protected final void fireListChanged(ListChangeEvent evt) {
        this.changeSupport().fireListChanged(evt);
    }

    protected void addItemToList(int index, Object item, List list, String listName) {
        list.add(index, item);
        this.fireItemAdded(listName, index, item);
    }

    protected void addItemToList(Object item, List list, String listName) {
        this.addItemToList(list.size(), item, list, listName);
    }

    protected void addItemsToList(int index, List items, List list, String listName) {
        list.addAll(index, items);
        this.fireItemsAdded(listName, index, items);
    }

    protected void addItemsToList(List items, List list, String listName) {
        this.addItemsToList(list.size(), items, list, listName);
    }

    protected Object removeItemFromList(int index, List list, String listName) {
        Object item = list.remove(index);
        this.fireItemRemoved(listName, index, item);
        return item;
    }

    protected Object removeItemFromList(Object item, List list, String listName) {
        return this.removeItemFromList(list.indexOf(item), list, listName);
    }

    protected List removeItemsFromList(int index, int length, List list, String listName) {
        List subList = list.subList(index, index + length);
        ArrayList removedItems = new ArrayList(subList);
        subList.clear();
        this.fireItemsRemoved(listName, index, removedItems);
        return removedItems;
    }

    protected Object setItemInList(int index, Object item, List list, String listName) {
        Object replacedItem = list.set(index, item);
        this.fireItemReplaced(listName, index, item, replacedItem);
        return replacedItem;
    }

    protected Object replaceItemInList(Object oldItem, Object newItem, List list, String listName) {
        return this.setItemInList(list.indexOf(oldItem), newItem, list, listName);
    }

    protected List setItemsInList(int index, List items, List list, String listName) {
        List subList = list.subList(index, index + items.size());
        ArrayList replacedItems = new ArrayList(subList);
        for (int i = 0; i < items.size(); ++i) {
            subList.set(i, items.get(i));
        }
        this.fireItemsReplaced(listName, index, items, replacedItems);
        return replacedItems;
    }

    protected boolean clearList(List list, String listName) {
        if (list.isEmpty()) {
            return false;
        }
        list.clear();
        this.fireListChanged(listName);
        return true;
    }

    @Override
    public synchronized void addTreeChangeListener(TreeChangeListener listener) {
        this.changeSupport().addTreeChangeListener(listener);
    }

    @Override
    public synchronized void addTreeChangeListener(String treeName, TreeChangeListener listener) {
        this.changeSupport().addTreeChangeListener(treeName, listener);
    }

    @Override
    public synchronized void removeTreeChangeListener(TreeChangeListener listener) {
        this.changeSupport().removeTreeChangeListener(listener);
    }

    @Override
    public synchronized void removeTreeChangeListener(String treeName, TreeChangeListener listener) {
        this.changeSupport().removeTreeChangeListener(treeName, listener);
    }

    protected final void fireNodeAdded(String treeName, Object[] path) {
        this.changeSupport().fireNodeAdded(treeName, path);
    }

    protected final void fireNodeAdded(TreeChangeEvent evt) {
        this.changeSupport().fireNodeAdded(evt);
    }

    protected final void fireNodeRemoved(String treeName, Object[] path) {
        this.changeSupport().fireNodeRemoved(treeName, path);
    }

    protected final void fireNodeRemoved(TreeChangeEvent evt) {
        this.changeSupport().fireNodeRemoved(evt);
    }

    protected final void fireTreeStructureChanged(String treeName) {
        this.changeSupport().fireTreeChanged(treeName);
    }

    protected final void fireTreeStructureChanged(String treeName, Object[] path) {
        this.changeSupport().fireTreeChanged(treeName, path);
    }

    protected final void fireTreeStructureChanged(TreeChangeEvent evt) {
        this.changeSupport().fireTreeChanged(evt);
    }

    public boolean hasAnyStateChangeListeners() {
        return this.changeSupport().hasAnyStateChangeListeners();
    }

    public boolean hasNoStateChangeListeners() {
        return !this.hasAnyStateChangeListeners();
    }

    public boolean hasAnyPropertyChangeListeners(String propertyName) {
        return this.changeSupport().hasAnyPropertyChangeListeners(propertyName);
    }

    public boolean hasNoPropertyChangeListeners(String propertyName) {
        return !this.hasAnyPropertyChangeListeners(propertyName);
    }

    public boolean hasAnyCollectionChangeListeners(String collectionName) {
        return this.changeSupport().hasAnyCollectionChangeListeners(collectionName);
    }

    public boolean hasNoCollectionChangeListeners(String collectionName) {
        return !this.hasAnyCollectionChangeListeners(collectionName);
    }

    public boolean hasAnyListChangeListeners(String listName) {
        return this.changeSupport().hasAnyListChangeListeners(listName);
    }

    public boolean hasNoListChangeListeners(String listName) {
        return !this.hasAnyListChangeListeners(listName);
    }

    public boolean hasAnyTreeChangeListeners(String treeName) {
        return this.changeSupport().hasAnyTreeChangeListeners(treeName);
    }

    public boolean hasNoTreeChangeListeners(String treeName) {
        return !this.hasAnyTreeChangeListeners(treeName);
    }

    protected final boolean valuesAreEqual(Object value1, Object value2) {
        return this.changeSupport().valuesAreEqual(value1, value2);
    }

    protected final boolean attributeValueHasNotChanged(Object oldValue, Object newValue) {
        return this.valuesAreEqual(oldValue, newValue);
    }

    protected final boolean valuesAreDifferent(Object value1, Object value2) {
        return this.changeSupport().valuesAreDifferent(value1, value2);
    }

    protected final boolean attributeValueHasChanged(Object oldValue, Object newValue) {
        return this.valuesAreDifferent(oldValue, newValue);
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractModel clone = (AbstractModel)super.clone();
        clone.postClone();
        return clone;
    }

    protected void postClone() {
        this.changeSupport = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        StringTools.buildSimpleToStringOn(this, sb);
        sb.append(" (");
        this.toString(sb);
        sb.append(')');
        return sb.toString();
    }

    public void toString(StringBuffer sb) {
    }
}

