/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.queries.WriteObjectQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReturningPolicy
implements Serializable,
Cloneable {
    protected static final int INSERT = 0;
    protected static final int UPDATE = 1;
    protected static final int NUM_OPERATIONS = 2;
    protected static final int RETURN_ONLY = 0;
    protected static final int WRITE_RETURN = 1;
    protected static final int MAPPED = 2;
    protected static final int UNMAPPED = 3;
    protected static final int ALL = 4;
    protected static final int MAIN_SIZE = 5;
    protected ClassDescriptor descriptor;
    protected List<Info> infos = new ArrayList<Info>();
    protected Collection<DatabaseField>[][] main;
    protected Map<DatabaseTable, Vector<DatabaseField>>[] tableToFieldsForGenerationMap;
    protected boolean isUsedToSetPrimaryKey;
    protected Map<DatabaseField, DatabaseField> fieldsNotFromDescriptor_DefaultTable;
    protected Map<DatabaseField, DatabaseField> fieldsNotFromDescriptor_OtherTables;

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void fieldIsNotFromDescriptor(DatabaseField field) {
        if (field.getTable().equals(this.getDescriptor().getDefaultTable())) {
            if (this.fieldsNotFromDescriptor_DefaultTable == null) {
                this.fieldsNotFromDescriptor_DefaultTable = new HashMap<DatabaseField, DatabaseField>();
            }
            this.fieldsNotFromDescriptor_DefaultTable.put(field, field);
        } else {
            if (this.fieldsNotFromDescriptor_OtherTables == null) {
                this.fieldsNotFromDescriptor_OtherTables = new HashMap<DatabaseField, DatabaseField>();
            }
            this.fieldsNotFromDescriptor_OtherTables.put(field, field);
        }
    }

    public Vector getFieldsToGenerateInsert(DatabaseTable table) {
        return this.getVectorOfFieldsToGenerate(0, table);
    }

    public Vector getFieldsToGenerateUpdate(DatabaseTable table) {
        return this.getVectorOfFieldsToGenerate(1, table);
    }

    public List<Info> getFieldInfos() {
        return this.infos;
    }

    public void setFieldInfos(List<Info> infos) {
        this.infos = infos;
    }

    public boolean hasEqualFieldInfos(ReturningPolicy returningPolicyToCompare) {
        return this.hasEqualFieldInfos(returningPolicyToCompare.getFieldInfos());
    }

    public boolean hasEqualFieldInfos(List<Info> infosToCompare) {
        return ReturningPolicy.areCollectionsEqualAsSets(this.getFieldInfos(), infosToCompare);
    }

    public static boolean areCollectionsEqualAsSets(Collection col1, Collection col2) {
        if (col1 == col2) {
            return true;
        }
        if (col1.size() != col2.size()) {
            return false;
        }
        ArrayList c1 = new ArrayList(col1);
        ArrayList c2 = new ArrayList(col2);
        for (Object o : c1) {
            c2.remove(o);
        }
        return c2.isEmpty();
    }

    protected Vector<DatabaseField> getVectorOfFieldsToGenerate(int operation, DatabaseTable table) {
        NonSynchronizedVector fieldsForGeneration;
        if (this.main[operation][4] == null) {
            return null;
        }
        if (this.tableToFieldsForGenerationMap == null) {
            this.tableToFieldsForGenerationMap = new HashMap[2];
        }
        if (this.tableToFieldsForGenerationMap[operation] == null) {
            this.tableToFieldsForGenerationMap[operation] = new HashMap<DatabaseTable, Vector<DatabaseField>>();
        }
        if ((fieldsForGeneration = this.tableToFieldsForGenerationMap[operation].get(table)) == null) {
            fieldsForGeneration = new NonSynchronizedVector();
            for (DatabaseField field : this.main[operation][4]) {
                if (!field.getTable().equals(table)) continue;
                ((Vector)fieldsForGeneration).add(field);
            }
            this.tableToFieldsForGenerationMap[operation].put(table, fieldsForGeneration);
        }
        return fieldsForGeneration;
    }

    public Collection<DatabaseField> getFieldsToMergeInsert() {
        return this.main[0][2];
    }

    public Collection<DatabaseField> getFieldsToMergeUpdate() {
        return this.main[1][2];
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new InternalError("clone failed");
        }
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void addFieldForInsert(String qualifiedName) {
        this.addFieldForInsert(qualifiedName, null);
    }

    public void addFieldForInsert(String qualifiedName, Class type) {
        this.addFieldForInsert(this.createField(qualifiedName, type));
    }

    public void addFieldForInsert(DatabaseField field) {
        this.addField(field, true, false, false);
    }

    public void addFieldForInsertReturnOnly(String qualifiedName) {
        this.addFieldForInsertReturnOnly(qualifiedName, null);
    }

    public void addFieldForInsertReturnOnly(String qualifiedName, Class type) {
        this.addFieldForInsertReturnOnly(this.createField(qualifiedName, type));
    }

    public void addFieldForInsertReturnOnly(DatabaseField field) {
        this.addField(field, true, true, false);
    }

    public void addFieldForUpdate(String qualifiedName) {
        this.addFieldForUpdate(qualifiedName, null);
    }

    public void addFieldForUpdate(String qualifiedName, Class type) {
        this.addFieldForUpdate(this.createField(qualifiedName, type));
    }

    public void addFieldForUpdate(DatabaseField field) {
        this.addField(field, false, false, true);
    }

    protected void addField(DatabaseField field, boolean isInsert, boolean isInsertModeReturnOnly, boolean isUpdate) {
        this.getFieldInfos().add(new Info(field, isInsert, isInsertModeReturnOnly, isUpdate));
    }

    static Info mergeInfos(Info info1, Info info2, AbstractSession session, ClassDescriptor descriptor) {
        boolean ok = true;
        DatabaseField fieldMerged = info1.getField();
        if (info2.getField().getType() != null) {
            if (info1.getField().getType() == null) {
                fieldMerged = info2.field;
            } else if (!info1.getField().getType().equals(info2.getField().getType())) {
                session.getIntegrityChecker().handleError(DescriptorException.returningPolicyFieldTypeConflict(info1.getField().getName(), info1.getField().getType().getName(), info2.getField().getType().getName(), descriptor));
                ok = false;
            }
        }
        boolean isInsertMerged = false;
        boolean isInsertModeReturnOnlyMerged = false;
        if (info1.isInsert() && !info2.isInsert()) {
            isInsertMerged = true;
            isInsertModeReturnOnlyMerged = info1.isInsertModeReturnOnly();
        } else if (!info1.isInsert() && info2.isInsert()) {
            isInsertMerged = true;
            isInsertModeReturnOnlyMerged = info2.isInsertModeReturnOnly();
        } else if (info1.isInsert() && info2.isInsert()) {
            isInsertMerged = true;
            isInsertModeReturnOnlyMerged = info1.isInsertModeReturnOnly();
            if (info1.isInsertModeReturnOnly() != info2.isInsertModeReturnOnly()) {
                session.getIntegrityChecker().handleError(DescriptorException.returningPolicyFieldInsertConflict(info1.getField().getName(), descriptor));
                ok = false;
            }
        }
        if (ok) {
            boolean isUpdateMerged = info1.isUpdate() || info2.isUpdate();
            return new Info(fieldMerged, isInsertMerged, isInsertModeReturnOnlyMerged, isUpdateMerged);
        }
        return null;
    }

    protected static boolean isThereATypeConflict(DatabaseField field1, DatabaseField field2) {
        return field1.getType() != null && field2.getType() != null && !field1.getType().equals(field2.getType());
    }

    protected DatabaseField createField(String qualifiedName, Class type) {
        DatabaseField field = new DatabaseField(qualifiedName);
        field.setType(type);
        return field;
    }

    protected Collection createCollection() {
        return new HashSet();
    }

    protected void addFieldToMain(int operation, int state, DatabaseField field) {
        if (this.main[operation][state] == null) {
            this.main[operation][state] = this.createCollection();
        }
        this.main[operation][state].add(field);
    }

    protected void addCollectionToMain(int operation, int state, Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        if (this.main[operation][state] == null) {
            this.main[operation][state] = this.createCollection();
        }
        this.main[operation][state].addAll(collection);
    }

    protected void addMappedFieldToMain(DatabaseField field, Info info) {
        int operation = 0;
        while (operation <= 1) {
            int state = 0;
            while (state <= 1) {
                if (info.is(operation, state)) {
                    this.addFieldToMain(operation, state, field);
                    this.addFieldToMain(operation, 2, field);
                    this.addFieldToMain(operation, 4, field);
                }
                ++state;
            }
            ++operation;
        }
    }

    protected void addUnmappedFieldToMain(DatabaseField field, Info info) {
        int operation = 0;
        while (operation <= 1) {
            if (info.is(operation)) {
                this.addFieldToMain(operation, 3, field);
                this.addFieldToMain(operation, 4, field);
            }
            ++operation;
        }
    }

    protected Hashtable removeDuplicateAndValidateInfos(AbstractSession session) {
        Hashtable<DatabaseField, Info> infoHashtable = new Hashtable<DatabaseField, Info>();
        int i = 0;
        while (i < this.infos.size()) {
            Info info1 = this.infos.get(i);
            info1 = (Info)info1.clone();
            DatabaseField descField = this.getDescriptor().buildField(info1.getField());
            if (info1.getField().getType() == null) {
                info1.setField(descField);
            } else {
                info1.getField().setName(descField.getName());
                info1.getField().setTableName(this.getDescriptor().getDefaultTable().getQualifiedNameDelimited(session.getPlatform()));
            }
            Info info2 = (Info)infoHashtable.get(info1.getField());
            if (info2 == null) {
                infoHashtable.put(info1.getField(), info1);
            } else {
                Info infoMerged = ReturningPolicy.mergeInfos(info1, info2, session, this.getDescriptor());
                if (infoMerged != null) {
                    infoHashtable.put(infoMerged.getField(), infoMerged);
                } else {
                    infoHashtable.put(info1.getField(), info1);
                }
            }
            ++i;
        }
        return infoHashtable;
    }

    public void initialize(AbstractSession session) {
        ClassDescriptor parentDescriptor;
        this.clearInitialization();
        this.main = new Collection[2][5];
        if (this.getDescriptor().isChildDescriptor() && (parentDescriptor = this.getDescriptor().getInheritancePolicy().getParentDescriptor()).hasReturningPolicy()) {
            this.copyMainFrom(parentDescriptor.getReturningPolicy());
        }
        if (!this.infos.isEmpty()) {
            Info info;
            DatabaseField field;
            Hashtable infoHashtable = this.removeDuplicateAndValidateInfos(session);
            Hashtable infoHashtableUnmapped = (Hashtable)infoHashtable.clone();
            Enumeration<DatabaseField> fields = this.getDescriptor().getFields().elements();
            while (fields.hasMoreElements()) {
                field = fields.nextElement();
                info = (Info)infoHashtableUnmapped.get(field);
                if (info == null) continue;
                infoHashtableUnmapped.remove(field);
                if (!this.verifyFieldAndMapping(session, field)) continue;
                if (info.getField().getType() == null) {
                    this.addMappedFieldToMain(field, info);
                    continue;
                }
                this.addMappedFieldToMain(info.getField(), info);
                this.fieldIsNotFromDescriptor(info.getField());
            }
            if (!infoHashtableUnmapped.isEmpty()) {
                fields = infoHashtableUnmapped.keys();
                while (fields.hasMoreElements()) {
                    field = fields.nextElement();
                    info = (Info)infoHashtableUnmapped.get(field);
                    if (!ReturningPolicy.verifyField(session, field, this.getDescriptor())) continue;
                    if (field.getType() != null) {
                        this.addUnmappedFieldToMain(field, info);
                        this.fieldIsNotFromDescriptor(field);
                        session.log(1, "query", "added_unmapped_field_to_returning_policy", info.toString(), this.getDescriptor().getJavaClassName());
                        continue;
                    }
                    if (!this.getDescriptor().isReturnTypeRequiredForReturningPolicy()) continue;
                    session.getIntegrityChecker().handleError(DescriptorException.returningPolicyUnmappedFieldTypeNotSet(field.getName(), this.getDescriptor()));
                }
            }
        }
        this.initializeIsUsedToSetPrimaryKey();
    }

    protected void copyMainFrom(ReturningPolicy policy) {
        Collection<DatabaseField>[][] mainToCopy = policy.main;
        int operation = 0;
        while (operation <= 1) {
            int state = 0;
            while (state < 5) {
                this.addCollectionToMain(operation, state, mainToCopy[operation][state]);
                ++state;
            }
            ++operation;
        }
    }

    public boolean hasEqualMains(ReturningPolicy policy) {
        Collection<DatabaseField>[][] mainToCompare = policy.main;
        if (this.main == mainToCompare) {
            return true;
        }
        int operation = 0;
        while (operation <= 1) {
            int state = 0;
            while (state < 5) {
                if (this.main[operation][state] == null && mainToCompare[operation][state] != null) {
                    return false;
                }
                if (this.main[operation][state] != null && mainToCompare[operation][state] == null) {
                    return false;
                }
                if (!this.main[operation][state].equals(mainToCompare[operation][state])) {
                    return false;
                }
                ++state;
            }
            ++operation;
        }
        Hashtable<DatabaseField, DatabaseField> allFields = new Hashtable<DatabaseField, DatabaseField>();
        int operation2 = 0;
        while (operation2 <= 1) {
            if (this.main[operation2][4] != null) {
                for (DatabaseField field : this.main[operation2][4]) {
                    allFields.put(field, field);
                }
            }
            ++operation2;
        }
        operation2 = 0;
        while (operation2 <= 1) {
            if (mainToCompare[operation2][4] != null) {
                for (DatabaseField fieldToCompare : mainToCompare[operation2][4]) {
                    DatabaseField field = (DatabaseField)allFields.get(fieldToCompare);
                    if (field.getType().equals(fieldToCompare.getType())) continue;
                    return false;
                }
            }
            ++operation2;
        }
        return true;
    }

    public void trimModifyRowForInsert(AbstractRecord modifyRow) {
        this.trimModifyRow(modifyRow, 0);
    }

    protected void trimModifyRow(AbstractRecord modifyRow, int operation) {
        if (modifyRow == null || modifyRow.isEmpty()) {
            return;
        }
        Collection<DatabaseField> fields = this.main[operation][0];
        if (fields == null || fields.isEmpty()) {
            return;
        }
        int i = modifyRow.size() - 1;
        while (i >= 0) {
            DatabaseField field = (DatabaseField)modifyRow.getFields().get(i);
            if (fields.contains(field)) {
                modifyRow.remove(field);
            }
            --i;
        }
    }

    public boolean isUsedToSetPrimaryKey() {
        return this.isUsedToSetPrimaryKey;
    }

    protected void clearInitialization() {
        this.main = null;
        this.tableToFieldsForGenerationMap = null;
        this.fieldsNotFromDescriptor_DefaultTable = null;
        this.fieldsNotFromDescriptor_OtherTables = null;
    }

    protected void initializeIsUsedToSetPrimaryKey() {
        this.isUsedToSetPrimaryKey = false;
        if (this.main[0][2] == null || this.main[0][2].isEmpty()) {
            return;
        }
        List<DatabaseField> primaryKeys = this.getDescriptor().getPrimaryKeyFields();
        int index = 0;
        while (index < primaryKeys.size() && !this.isUsedToSetPrimaryKey) {
            this.isUsedToSetPrimaryKey = this.main[0][2].contains(primaryKeys.get(index));
            ++index;
        }
    }

    protected boolean verifyFieldAndMapping(AbstractSession session, DatabaseField field) {
        DatabaseMapping mapping;
        boolean ok = true;
        ReturningPolicy.verifyField(session, field, this.getDescriptor());
        List<DatabaseMapping> readOnlyMappings = this.getDescriptor().getObjectBuilder().getReadOnlyMappingsForField(field);
        if (readOnlyMappings != null) {
            int j = 0;
            while (j < readOnlyMappings.size()) {
                mapping = readOnlyMappings.get(j);
                ok &= ReturningPolicy.verifyFieldAndMapping(session, field, this.getDescriptor(), mapping);
                ++j;
            }
        }
        if ((mapping = this.getDescriptor().getObjectBuilder().getMappingForField(field)) != null) {
            ok &= ReturningPolicy.verifyFieldAndMapping(session, field, this.getDescriptor(), mapping);
        }
        return ok;
    }

    protected static boolean verifyFieldAndMapping(AbstractSession session, DatabaseField field, ClassDescriptor descriptor, DatabaseMapping mapping) {
        ReturningPolicy.verifyField(session, field, descriptor);
        while (mapping.isAggregateObjectMapping()) {
            ClassDescriptor referenceDescriptor = ((AggregateObjectMapping)mapping).getReferenceDescriptor();
            mapping = referenceDescriptor.getObjectBuilder().getMappingForField(field);
            ReturningPolicy.verifyFieldAndMapping(session, field, referenceDescriptor, mapping);
        }
        if (!mapping.isDirectToFieldMapping() && !mapping.isTransformationMapping()) {
            String mappingTypeName = Helper.getShortClassName(mapping);
            session.getIntegrityChecker().handleError(DescriptorException.returningPolicyMappingNotSupported(field.getName(), mappingTypeName, mapping));
            return false;
        }
        return true;
    }

    protected static boolean verifyField(AbstractSession session, DatabaseField field, ClassDescriptor descriptor) {
        VersionLockingPolicy versionLockingPolicy;
        OptimisticLockingPolicy optimisticLockingPolicy;
        boolean ok = true;
        if (field.equals(descriptor.getSequenceNumberField())) {
            ok = false;
            session.getIntegrityChecker().handleError(DescriptorException.returningPolicyFieldNotSupported(field.getName(), descriptor));
        } else if (descriptor.hasInheritance() && field.equals(descriptor.getInheritancePolicy().getClassIndicatorField())) {
            ok = false;
            session.getIntegrityChecker().handleError(DescriptorException.returningPolicyFieldNotSupported(field.getName(), descriptor));
        } else if (descriptor.usesOptimisticLocking() && (optimisticLockingPolicy = descriptor.getOptimisticLockingPolicy()) instanceof VersionLockingPolicy && field.equals((versionLockingPolicy = (VersionLockingPolicy)optimisticLockingPolicy).getWriteLockField())) {
            ok = false;
            session.getIntegrityChecker().handleError(DescriptorException.returningPolicyFieldNotSupported(field.getName(), descriptor));
        }
        return ok;
    }

    public void validationAfterDescriptorInitialization(AbstractSession session) {
        Hashtable<DatabaseField, DatabaseField> mapped = new Hashtable<DatabaseField, DatabaseField>();
        int operation = 0;
        while (operation <= 1) {
            if (this.main[operation][2] != null && !this.main[operation][2].isEmpty()) {
                for (DatabaseField field : this.main[operation][2]) {
                    mapped.put(field, field);
                }
            }
            ++operation;
        }
        if (!mapped.isEmpty()) {
            Enumeration<DatabaseField> fields = this.getDescriptor().getFields().elements();
            while (fields.hasMoreElements()) {
                DatabaseField fieldInDescriptor = fields.nextElement();
                DatabaseField fieldInMain = (DatabaseField)mapped.get(fieldInDescriptor);
                if (fieldInMain == null) continue;
                if (fieldInMain.getType() == null) {
                    if (!this.getDescriptor().isReturnTypeRequiredForReturningPolicy()) continue;
                    session.getIntegrityChecker().handleError(DescriptorException.returningPolicyMappedFieldTypeNotSet(fieldInMain.getName(), this.getDescriptor()));
                    continue;
                }
                if (!ReturningPolicy.isThereATypeConflict(fieldInMain, fieldInDescriptor)) continue;
                session.getIntegrityChecker().handleError(DescriptorException.returningPolicyAndDescriptorFieldTypeConflict(fieldInMain.getName(), fieldInMain.getType().getName(), fieldInDescriptor.getType().getName(), this.getDescriptor()));
            }
        }
        if (!(session.getDatasourcePlatform() instanceof DatabasePlatform)) {
            return;
        }
        WriteObjectQuery[] query = new WriteObjectQuery[]{this.getDescriptor().getQueryManager().getInsertQuery(), this.getDescriptor().getQueryManager().getUpdateQuery()};
        String[] queryTypeName = new String[]{"InsertObjectQuery", "UpdateObjectQuery"};
        int operation2 = 0;
        while (operation2 <= 1) {
            if (this.main[operation2][4] != null && !this.main[operation2][4].isEmpty()) {
                if (query[operation2] == null || query[operation2].getDatasourceCall() == null) {
                    if (!session.getPlatform().canBuildCallWithReturning()) {
                        session.getIntegrityChecker().handleError(DescriptorException.noCustomQueryForReturningPolicy(queryTypeName[operation2], Helper.getShortClassName(session.getPlatform()), this.getDescriptor()));
                    }
                } else if (query[operation2].getDatasourceCall() instanceof StoredProcedureCall) {
                    DatabaseCall customCall = (DatabaseCall)query[operation2].getDatasourceCall();
                    Enumeration outputRowFields = customCall.getOutputRowFields().elements();
                    Collection notFoundInOutputRow = this.createCollection();
                    notFoundInOutputRow.addAll(this.main[operation2][4]);
                    while (outputRowFields.hasMoreElements()) {
                        notFoundInOutputRow.remove(outputRowFields.nextElement());
                    }
                    if (!notFoundInOutputRow.isEmpty()) {
                        for (DatabaseField field : notFoundInOutputRow) {
                            session.getIntegrityChecker().handleError(DescriptorException.customQueryAndReturningPolicyFieldConflict(field.getName(), queryTypeName[operation2], this.getDescriptor()));
                        }
                    }
                }
            }
            ++operation2;
        }
    }

    public DatabaseField getField(DatabaseField field) {
        DatabaseField foundField = null;
        if (this.fieldsNotFromDescriptor_DefaultTable != null) {
            foundField = this.fieldsNotFromDescriptor_DefaultTable.get(field);
        }
        if (foundField == null && this.fieldsNotFromDescriptor_OtherTables != null) {
            foundField = this.fieldsNotFromDescriptor_OtherTables.get(field);
        }
        return foundField;
    }

    public static class Info
    implements Cloneable {
        private DatabaseField field;
        private boolean isInsert;
        private boolean isInsertModeReturnOnly;
        private boolean isUpdate;
        private Class referenceClass;
        private String referenceClassName;

        Info() {
        }

        Info(DatabaseField field, boolean isInsert, boolean isInsertModeReturnOnly, boolean isUpdate) {
            this.field = field;
            if (field != null && field.getType() != null) {
                this.setReferenceClass(field.getType());
            }
            this.isInsert = isInsert;
            this.isInsertModeReturnOnly = isInsertModeReturnOnly;
            this.isUpdate = isUpdate;
        }

        public DatabaseField getField() {
            return this.field;
        }

        public void setField(DatabaseField field) {
            this.field = field;
            if (field.getType() == null && this.referenceClass != null) {
                field.setType(this.referenceClass);
            }
        }

        public boolean isInsert() {
            return this.isInsert;
        }

        public void setIsInsert(boolean isInsert) {
            this.isInsert = isInsert;
        }

        public boolean isInsertModeReturnOnly() {
            return this.isInsertModeReturnOnly;
        }

        public void setIsInsertModeReturnOnly(boolean isInsertModeReturnOnly) {
            this.isInsertModeReturnOnly = isInsertModeReturnOnly;
        }

        public boolean isUpdate() {
            return this.isUpdate;
        }

        public void setIsUpdate(boolean isUpdate) {
            this.isUpdate = isUpdate;
        }

        public Class getReferenceClass() {
            return this.referenceClass;
        }

        public void setReferenceClass(Class referenceClass) {
            this.referenceClass = referenceClass;
            if (referenceClass != null) {
                this.referenceClassName = referenceClass.getName();
            }
        }

        public String getReferenceClassName() {
            return this.referenceClassName;
        }

        public void setReferenceClassName(String referenceClassName) {
            this.referenceClassName = referenceClassName;
        }

        boolean is(int operation, int stateToCheck) {
            if (operation == 0) {
                if (this.isInsert) {
                    if (stateToCheck == 0) {
                        return this.isInsertModeReturnOnly;
                    }
                    return !this.isInsertModeReturnOnly;
                }
            } else if (this.isUpdate) {
                return stateToCheck == 1;
            }
            return false;
        }

        boolean is(int operation) {
            if (operation == 0) {
                return this.isInsert;
            }
            return this.isUpdate;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception exception) {
                throw new InternalError("clone failed");
            }
        }

        public boolean equals(Object objectToCompare) {
            if (objectToCompare instanceof Info) {
                return this.equals((Info)objectToCompare);
            }
            return false;
        }

        boolean equals(Info infoToCompare) {
            if (this == infoToCompare) {
                return true;
            }
            if (!this.getField().equals(infoToCompare.getField())) {
                return false;
            }
            if (this.getField().getType() == null && infoToCompare.getField().getType() != null) {
                return false;
            }
            if (this.getField().getType() != null && !this.getField().getType().equals(infoToCompare.getField().getType())) {
                return false;
            }
            if (this.isInsert() != infoToCompare.isInsert()) {
                return false;
            }
            if (this.isInsertModeReturnOnly() != infoToCompare.isInsertModeReturnOnly()) {
                return false;
            }
            return this.isUpdate() == infoToCompare.isUpdate();
        }
    }
}

