/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.ObjectReferenceChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectReferenceMapping
extends ForeignReferenceMapping {
    protected boolean isForeignKeyRelationship;
    protected Vector<DatabaseField> foreignKeyFields;

    protected ObjectReferenceMapping() {
        this.setWeight(WEIGHT_TO_ONE);
    }

    @Override
    public Object buildBackupCloneForPartObject(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        return attributeValue;
    }

    @Override
    public Object buildCloneForPartObject(Object attributeValue, Object original, CacheKey cacheKey, Object clone, AbstractSession cloningSession, boolean isExisting) {
        if (attributeValue == null) {
            return null;
        }
        if (cloningSession.isUnitOfWork()) {
            return this.buildUnitofWorkCloneForPartObject(attributeValue, original, clone, (UnitOfWorkImpl)cloningSession, isExisting);
        }
        if (this.referenceDescriptor.getCachePolicy().isProtectedIsolation()) {
            ClassDescriptor descriptor = this.referenceDescriptor;
            if (descriptor.hasInterfacePolicy()) {
                descriptor = cloningSession.getClassDescriptor(attributeValue.getClass());
            }
            return cloningSession.createProtectedInstanceFromCachedData(attributeValue, descriptor);
        }
        return attributeValue;
    }

    public Object buildUnitofWorkCloneForPartObject(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        if (attributeValue == null) {
            return null;
        }
        Object registeredObject = null;
        if (isExisting) {
            registeredObject = unitOfWork.registerExistingObject(attributeValue);
        } else {
            registeredObject = unitOfWork.registerObject(attributeValue);
            if (this.isCandidateForPrivateOwnedRemoval() && unitOfWork.shouldDiscoverNewObjects() && registeredObject != null && unitOfWork.isCloneNewObject(registeredObject)) {
                unitOfWork.addPrivateOwnedObject(this, registeredObject);
            }
        }
        return registeredObject;
    }

    @Override
    public void buildCopy(Object copy, Object original, CopyGroup group) {
        Object copyValue;
        Object attributeValue = this.getRealAttributeValueFromObject(original, group.getSession());
        if (attributeValue != null && (group.shouldCascadeAllParts() || group.shouldCascadePrivateParts() && this.isPrivateOwned() || group.shouldCascadeTree())) {
            attributeValue = group.getSession().copyInternal(attributeValue, group);
        } else if (attributeValue != null && (copyValue = group.getCopies().get(attributeValue)) != null) {
            attributeValue = copyValue;
        }
        this.getIndirectionPolicy().reset(copy);
        this.setRealAttributeValueInObject(copy, attributeValue);
    }

    @Override
    public Expression buildExpression(Object queryObject, QueryByExamplePolicy policy, Expression expressionBuilder, Map processedObjects, AbstractSession session) {
        String attributeName = this.getAttributeName();
        Object attributeValue = this.getRealAttributeValueFromObject(queryObject, session);
        if (!policy.shouldIncludeInQuery(queryObject.getClass(), attributeName, attributeValue)) {
            return null;
        }
        if (attributeValue == null) {
            Expression expression = expressionBuilder.get(attributeName);
            return policy.completeExpressionForNull(expression);
        }
        ObjectBuilder objectBuilder = this.getReferenceDescriptor().getObjectBuilder();
        return objectBuilder.buildExpressionFromExample(attributeValue, policy, expressionBuilder.get(attributeName), processedObjects, session);
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        Object backUpAttribute = null;
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (!owner.isNew() && (backUpAttribute = this.getAttributeValueFromObject(backUp)) == null && cloneAttribute == null) {
            return null;
        }
        if (cloneAttribute != null && !this.indirectionPolicy.objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        Object cloneAttributeValue = null;
        Object backUpAttributeValue = null;
        if (cloneAttribute != null) {
            cloneAttributeValue = this.getRealAttributeValueFromAttribute(cloneAttribute, clone, session);
        }
        if (backUpAttribute != null) {
            backUpAttributeValue = this.getRealAttributeValueFromAttribute(backUpAttribute, backUp, session);
        }
        if (cloneAttributeValue == backUpAttributeValue && !owner.isNew()) {
            return null;
        }
        ObjectReferenceChangeRecord record = this.internalBuildChangeRecord(cloneAttributeValue, owner, session);
        if (!owner.isNew()) {
            record.setOldValue(backUpAttributeValue);
        }
        return record;
    }

    public ObjectReferenceChangeRecord internalBuildChangeRecord(Object newValue, ObjectChangeSet owner, AbstractSession session) {
        ObjectReferenceChangeRecord changeRecord = new ObjectReferenceChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        this.setNewValueInChangeRecord(newValue, changeRecord, owner, session);
        return changeRecord;
    }

    public void setNewValueInChangeRecord(Object newValue, ObjectReferenceChangeRecord changeRecord, ObjectChangeSet owner, AbstractSession session) {
        if (newValue != null) {
            ObjectChangeSet newSet = this.getDescriptorForTarget(newValue, session).getObjectBuilder().createObjectChangeSet(newValue, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), session);
            changeRecord.setNewValue(newSet);
        } else {
            changeRecord.setNewValue(null);
        }
    }

    @Override
    protected boolean compareObjectsWithoutPrivateOwned(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstReferencedObject = this.getRealAttributeValueFromObject(firstObject, session);
        Object secondReferencedObject = this.getRealAttributeValueFromObject(secondObject, session);
        if (firstReferencedObject == null && secondReferencedObject == null) {
            return true;
        }
        if (firstReferencedObject == null || secondReferencedObject == null) {
            return false;
        }
        Object firstKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(firstReferencedObject, session);
        Object secondKey = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(secondReferencedObject, session);
        if (firstKey == null) {
            return secondKey == null;
        }
        return firstKey.equals(secondKey);
    }

    @Override
    protected boolean compareObjectsWithPrivateOwned(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstPrivateObject = this.getRealAttributeValueFromObject(firstObject, session);
        Object secondPrivateObject = this.getRealAttributeValueFromObject(secondObject, session);
        return session.compareObjects(firstPrivateObject, secondPrivateObject);
    }

    @Override
    public void fixRealObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        Object attributeValue = this.getRealAttributeValueFromObject(object, session);
        attributeValue = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(attributeValue, session);
        ObjectLevelReadQuery tempQuery = query;
        if (!tempQuery.shouldMaintainCache() && (!tempQuery.shouldCascadeParts() || tempQuery.shouldCascadePrivateParts() && !this.isPrivateOwned())) {
            tempQuery = null;
        }
        Object remoteAttributeValue = session.getObjectCorrespondingTo(attributeValue, objectDescriptors, processedObjects, tempQuery);
        remoteAttributeValue = this.getReferenceDescriptor().getObjectBuilder().wrapObject(remoteAttributeValue, session);
        this.setRealAttributeValueInObject(object, remoteAttributeValue);
    }

    public ClassDescriptor getDescriptorForTarget(Object object, AbstractSession session) {
        return session.getDescriptor(object);
    }

    @Override
    public Object getRealAttributeValueFromAttribute(Object attributeValue, Object object, AbstractSession session) {
        Object value = super.getRealAttributeValueFromAttribute(attributeValue, object, session);
        value = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(value, session);
        return value;
    }

    @Override
    public boolean isObjectReferenceMapping() {
        return true;
    }

    @Override
    public void iterateOnRealAttributeValue(DescriptorIterator iterator, Object realAttributeValue) {
        Object unwrappedAttributeValue = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(realAttributeValue, iterator.getSession());
        iterator.iterateReferenceObjectForMapping(unwrappedAttributeValue, this);
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        ObjectChangeSet set;
        if (this.descriptor.getCachePolicy().isProtectedIsolation() && !this.isCacheable && !targetSession.isProtectedSession()) {
            this.setAttributeValueInObject(target, this.indirectionPolicy.buildIndirectObject(new ValueHolder(null)));
            return;
        }
        Object targetValueOfSource = null;
        if (this.shouldMergeCascadeParts(mergeManager) && (set = (ObjectChangeSet)((ObjectReferenceChangeRecord)changeRecord).getNewValue()) != null) {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                targetValueOfSource = set.getTargetVersionOfSourceObject(mergeManager, targetSession, false);
                if (targetValueOfSource == null && (set.isNew() || set.isAggregate()) && set.containsChangesFromSynchronization()) {
                    if (!mergeManager.isAlreadyMerged(set, targetSession)) {
                        Class objectClass = set.getClassType(mergeManager.getSession());
                        targetValueOfSource = mergeManager.getSession().getDescriptor(objectClass).getObjectBuilder().buildNewInstance();
                        mergeManager.recordMerge(set, targetValueOfSource, targetSession);
                    } else {
                        targetValueOfSource = mergeManager.getMergedObject(set, targetSession);
                    }
                } else {
                    targetValueOfSource = set.getTargetVersionOfSourceObject(mergeManager, targetSession, true);
                }
                if (set.containsChangesFromSynchronization()) {
                    mergeManager.mergeChanges(targetValueOfSource, set, targetSession);
                }
                if (targetValueOfSource == null) {
                    mergeManager.getSession().getIdentityMapAccessorInstance().invalidateObject(target);
                    return;
                }
            } else {
                mergeManager.mergeChanges(set.getUnitOfWorkClone(), set, targetSession);
            }
        }
        if (targetValueOfSource == null && ((ObjectReferenceChangeRecord)changeRecord).getNewValue() != null) {
            targetValueOfSource = ((ObjectChangeSet)((ObjectReferenceChangeRecord)changeRecord).getNewValue()).getTargetVersionOfSourceObject(mergeManager, targetSession);
        }
        if (this.isPrivateOwned() && source != null) {
            mergeManager.registerRemovedNewObjectIfRequired(this.getRealAttributeValueFromObject(source, mergeManager.getSession()));
        }
        targetValueOfSource = this.getReferenceDescriptor().getObjectBuilder().wrapObject(targetValueOfSource, targetSession);
        this.getIndirectionPolicy().reset(target);
        this.setRealAttributeValueInObject(target, targetValueOfSource);
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        if (this.descriptor.getCachePolicy().isProtectedIsolation() && !this.isCacheable && !targetSession.isProtectedSession()) {
            this.setAttributeValueInObject(target, this.indirectionPolicy.buildIndirectObject(new ValueHolder(null)));
            return;
        }
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal()) {
            if (!this.isAttributeValueInstantiated(source)) {
                this.setAttributeValueInObject(target, this.indirectionPolicy.getOriginalIndirectionObject(this.getAttributeValueFromObject(source), targetSession));
                return;
            }
            this.indirectionPolicy.reset(target);
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.mergeRemoteValueHolder(target, source, mergeManager);
            return;
        }
        if (mergeManager.isForRefresh() ? !this.isAttributeValueInstantiated(target) : !this.isAttributeValueInstantiated(source)) {
            return;
        }
        Object valueOfSource = this.getRealAttributeValueFromObject(source, mergeManager.getSession());
        Object targetValueOfSource = null;
        if (this.shouldMergeCascadeParts(mergeManager) && valueOfSource != null) {
            if (mergeManager.getSession().isUnitOfWork() && ((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet() != null) {
                ObjectChangeListener listener;
                Object targetValue = mergeManager.mergeChanges(mergeManager.getObjectToMerge(valueOfSource, this.referenceDescriptor, targetSession), (ObjectChangeSet)((UnitOfWorkChangeSet)((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet()).getObjectChangeSetForClone(valueOfSource), targetSession);
                if (target == source && targetValue != valueOfSource && this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy() && target instanceof ChangeTracker && ((ChangeTracker)target)._persistence_getPropertyChangeListener() != null && (listener = (ObjectChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()) != null) {
                    this.descriptor.getObjectChangePolicy().updateListenerForSelfMerge(listener, this, valueOfSource, targetValue, (UnitOfWorkImpl)mergeManager.getSession());
                }
            } else {
                mergeManager.mergeChanges(mergeManager.getObjectToMerge(valueOfSource, this.referenceDescriptor, targetSession), null, targetSession);
            }
        }
        if (valueOfSource != null) {
            targetValueOfSource = mergeManager.getTargetVersionOfSourceObject(valueOfSource, this.referenceDescriptor, targetSession);
        }
        if ((mergeManager.shouldMergeCloneIntoWorkingCopy() || mergeManager.shouldMergeCloneWithReferencesIntoWorkingCopy()) && !mergeManager.isForRefresh() && this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy()) {
            Object valueOfTarget = this.getRealAttributeValueFromObject(target, mergeManager.getSession());
            if (valueOfTarget != targetValueOfSource) {
                this.descriptor.getObjectChangePolicy().raiseInternalPropertyChangeEvent(target, this.getAttributeName(), valueOfTarget, targetValueOfSource);
            } else {
                return;
            }
        }
        targetValueOfSource = this.referenceDescriptor.getObjectBuilder().wrapObject(targetValueOfSource, mergeManager.getSession());
        this.setRealAttributeValueInObject(target, targetValueOfSource);
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        return this.getForeignKeyFields();
    }

    public Vector<DatabaseField> getForeignKeyFields() {
        return this.foreignKeyFields;
    }

    protected void setForeignKeyFields(Vector<DatabaseField> foreignKeyFields) {
        this.foreignKeyFields = foreignKeyFields;
        if (!foreignKeyFields.isEmpty()) {
            this.setIsForeignKeyRelationship(true);
        }
    }

    public boolean isForeignKeyRelationship() {
        return this.isForeignKeyRelationship;
    }

    public void setIsForeignKeyRelationship(boolean isForeignKeyRelationship) {
        this.isForeignKeyRelationship = isForeignKeyRelationship;
    }

    @Override
    public void preInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            this.insert(query);
        }
    }

    protected Object readPrivateOwnedForObject(ObjectLevelModifyQuery modifyQuery) throws DatabaseException {
        if (modifyQuery.getSession().isUnitOfWork()) {
            if (modifyQuery.getObjectChangeSet() != null) {
                ObjectReferenceChangeRecord record = (ObjectReferenceChangeRecord)modifyQuery.getObjectChangeSet().getChangesForAttributeNamed(this.getAttributeName());
                if (record != null) {
                    return record.getOldValue();
                }
            } else {
                return this.getRealAttributeValueFromObject(modifyQuery.getBackupClone(), modifyQuery.getSession());
            }
        }
        return null;
    }

    @Override
    public void preUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objectInDatabase;
        if (!this.isAttributeValueInstantiated(query.getObject())) {
            return;
        }
        if (this.isPrivateOwned() && (objectInDatabase = this.readPrivateOwnedForObject(query)) != null) {
            query.setProperty(this, objectInDatabase);
        }
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        this.update(query);
    }

    @Override
    public void postCalculateChanges(org.eclipse.persistence.sessions.changesets.ChangeRecord changeRecord, UnitOfWorkImpl uow) {
        Object oldValue = ((ObjectReferenceChangeRecord)changeRecord).getOldValue();
        if (oldValue != null) {
            uow.addDeletedPrivateOwnedObjects(this, oldValue);
        }
    }

    @Override
    public void recordPrivateOwnedRemovals(Object object, UnitOfWorkImpl uow) {
        Object target = this.getRealAttributeValueFromObject(object, uow);
        if (target != null) {
            this.referenceDescriptor.getObjectBuilder().recordPrivateOwnedRemovals(target, uow, false);
        }
    }

    @Override
    public void postDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object object = query.getProperty(this);
        if (this.isForeignKeyRelationship() && object != null) {
            query.removeProperty(this);
            AbstractSession session = query.getSession();
            if (query.isCascadeOfAggregateDelete()) {
                session.getCommitManager().addObjectToDelete(object);
            } else {
                if (session.getCommitManager().isCommitCompletedOrInPost(object)) {
                    return;
                }
                if (this.isCascadeOnDeleteSetOnDatabase && !this.hasRelationTableMechanism() && session.isUnitOfWork()) {
                    ((UnitOfWorkImpl)session).getCascadeDeleteObjects().add(object);
                }
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setIsExecutionClone(true);
                deleteQuery.setObject(object);
                deleteQuery.setCascadePolicy(query.getCascadePolicy());
                session.executeQuery(deleteQuery);
            }
        }
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            this.insert(query);
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objectInDatabase;
        if (!this.isAttributeValueInstantiated(query.getObject())) {
            return;
        }
        if (!this.isForeignKeyRelationship()) {
            this.update(query);
        }
        if ((objectInDatabase = query.getProperty(this)) == null) {
            return;
        }
        query.removeProperty(this);
        if (query.getObjectChangeSet() == null) {
            Object objectInMemory = this.getRealAttributeValueFromObject(query.getObject(), query.getSession());
            if (objectInDatabase != objectInMemory) {
                Object keyForObjectInDatabase = this.getPrimaryKeyForObject(objectInDatabase, query.getSession());
                Object keyForObjectInMemory = null;
                if (objectInMemory != null) {
                    keyForObjectInMemory = this.getPrimaryKeyForObject(objectInMemory, query.getSession());
                }
                if (keyForObjectInMemory != null && keyForObjectInDatabase.equals(keyForObjectInMemory)) {
                    return;
                }
            } else {
                return;
            }
        }
        if (!query.shouldCascadeOnlyDependentParts()) {
            query.getSession().deleteObject(objectInDatabase);
        }
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        AbstractSession session = query.getSession();
        Object objectInMemory = this.getRealAttributeValueFromObject(query.getObject(), session);
        Object objectFromDatabase = null;
        objectFromDatabase = this.readPrivateOwnedForObject(query);
        if (objectFromDatabase != null && objectFromDatabase != objectInMemory) {
            Object keyForObjectInMemory = null;
            Object keyForObjectInDatabase = this.getPrimaryKeyForObject(objectFromDatabase, session);
            if (objectInMemory != null) {
                keyForObjectInMemory = this.getPrimaryKeyForObject(objectInMemory, session);
            }
            if (!(keyForObjectInMemory != null && keyForObjectInDatabase.equals(keyForObjectInMemory) || objectFromDatabase == null)) {
                if (this.isCascadeOnDeleteSetOnDatabase && !this.hasRelationTableMechanism() && session.isUnitOfWork()) {
                    ((UnitOfWorkImpl)session).getCascadeDeleteObjects().add(objectFromDatabase);
                }
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setIsExecutionClone(true);
                deleteQuery.setObject(objectFromDatabase);
                deleteQuery.setCascadePolicy(query.getCascadePolicy());
                session.executeQuery(deleteQuery);
            }
        }
        if (!this.isForeignKeyRelationship()) {
            if (objectInMemory != null) {
                if (this.isCascadeOnDeleteSetOnDatabase && !this.hasRelationTableMechanism() && session.isUnitOfWork()) {
                    ((UnitOfWorkImpl)session).getCascadeDeleteObjects().add(objectInMemory);
                }
                if (session.getCommitManager().isCommitCompletedOrInPost(objectInMemory)) {
                    return;
                }
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setIsExecutionClone(true);
                deleteQuery.setObject(objectInMemory);
                deleteQuery.setCascadePolicy(query.getCascadePolicy());
                session.executeQuery(deleteQuery);
            }
        } else if (objectInMemory != null) {
            query.setProperty(this, objectInMemory);
        }
    }

    @Override
    public void earlyPreDelete(DeleteObjectQuery query, Object object) {
        AbstractSession session = query.getSession();
        Object attributeValue = this.getAttributeValueFromObject(object);
        Object targetObject = null;
        if (!this.indirectionPolicy.objectIsInstantiated(attributeValue) && !this.indirectionPolicy.objectIsEasilyInstantiated(attributeValue)) {
            AbstractRecord referenceRow = this.indirectionPolicy.extractReferenceRow(attributeValue);
            targetObject = this.selectionQuery.checkEarlyReturn(session, referenceRow);
        } else {
            targetObject = this.getRealAttributeValueFromAttribute(attributeValue, object, session);
        }
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)session;
        if (targetObject != null && unitOfWork.getDeletedObjects().containsKey(targetObject)) {
            unitOfWork.addDeletionDependency(targetObject, object);
        }
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        this.cascadePerformRemoveIfRequired(object, uow, visitedObjects, true);
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects, boolean getAttributeValueFromObject) {
        if (!this.cascadeRemove) {
            return;
        }
        Object attributeValue = null;
        attributeValue = getAttributeValueFromObject ? this.getAttributeValueFromObject(object) : object;
        if (attributeValue != null) {
            if (getAttributeValueFromObject) {
                attributeValue = this.indirectionPolicy.getRealAttributeValueFromObject(object, attributeValue);
            }
            if (attributeValue != null && !visitedObjects.containsKey(attributeValue)) {
                visitedObjects.put(attributeValue, attributeValue);
                if (this.isCascadeOnDeleteSetOnDatabase && !this.hasRelationTableMechanism()) {
                    uow.getCascadeDeleteObjects().add(attributeValue);
                }
                uow.performRemove(attributeValue, visitedObjects);
            }
        }
    }

    @Override
    public void cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object realValue;
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue != null && this.indirectionPolicy.objectIsInstantiated(attributeValue) && !visitedObjects.containsKey(realValue = this.getRealAttributeValueFromObject(object, uow))) {
            visitedObjects.put(realValue, realValue);
            uow.performRemovePrivateOwnedObjectFromChangeSet(realValue, visitedObjects);
        }
    }

    @Override
    public void collectQueryParameters(Set<DatabaseField> cacheFields) {
        for (DatabaseField field : this.foreignKeyFields) {
            cacheFields.add(field);
        }
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow, Set cascadeErrors) {
        this.cascadeDiscoverAndPersistUnregisteredNewObjects(object, newObjects, unregisteredExistingObjects, visitedObjects, uow, true, cascadeErrors);
    }

    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow, boolean getAttributeValueFromObject, Set cascadeErrors) {
        Object attributeValue = null;
        attributeValue = getAttributeValueFromObject ? this.getAttributeValueFromObject(object) : object;
        if (attributeValue != null && this.indirectionPolicy.objectIsInstantiated(attributeValue)) {
            if (getAttributeValueFromObject) {
                attributeValue = this.indirectionPolicy.getRealAttributeValueFromObject(object, attributeValue);
            }
            if (this.isCandidateForPrivateOwnedRemoval()) {
                uow.removePrivateOwnedObject(this, attributeValue);
            }
            uow.discoverAndPersistUnregisteredNewObjects(attributeValue, this.isCascadePersist(), newObjects, unregisteredExistingObjects, visitedObjects, cascadeErrors);
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        this.cascadeRegisterNewIfRequired(object, uow, visitedObjects, true);
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects, boolean getAttributeValueFromObject) {
        if (!this.isCascadePersist()) {
            return;
        }
        Object attributeValue = null;
        attributeValue = getAttributeValueFromObject ? this.getAttributeValueFromObject(object) : object;
        if (attributeValue != null && (this.indirectionPolicy.objectIsInstantiated(attributeValue) || uow.isCloneNewObject(object))) {
            if (getAttributeValueFromObject) {
                attributeValue = this.indirectionPolicy.getRealAttributeValueFromObject(object, attributeValue);
            }
            uow.registerNewObjectForPersist(attributeValue, visitedObjects);
            if (this.isCandidateForPrivateOwnedRemoval() && uow.shouldDiscoverNewObjects() && attributeValue != null && uow.isCloneNewObject(object)) {
                uow.addPrivateOwnedObject(this, attributeValue);
            }
        }
    }

    protected Object getPrimaryKeyForObject(Object object, AbstractSession session) {
        return this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, session);
    }

    @Override
    public boolean hasConstraintDependency() {
        return this.isForeignKeyRelationship();
    }

    @Override
    public DatabaseValueHolder createCloneValueHolder(ValueHolderInterface attributeValue, Object original, Object clone, AbstractRecord row, AbstractSession cloningSession, boolean buildDirectlyFromRow) {
        DatabaseValueHolder valueHolder = null;
        if (row == null && this.isPrimaryKeyMapping()) {
            AbstractRecord rowFromTargetObject = this.extractPrimaryKeyRowForSourceObject(original, cloningSession);
            valueHolder = cloningSession.createCloneQueryValueHolder(attributeValue, clone, rowFromTargetObject, this);
        } else {
            valueHolder = cloningSession.createCloneQueryValueHolder(attributeValue, clone, row, this);
        }
        if (buildDirectlyFromRow && attributeValue.isInstantiated()) {
            Object cloneAttributeValue = attributeValue.getValue();
            valueHolder.privilegedSetValue(cloneAttributeValue);
            valueHolder.setInstantiated();
        }
        return valueHolder;
    }

    public AbstractRecord extractPrimaryKeyRowForSourceObject(Object domainObject, AbstractSession session) {
        AbstractRecord databaseRow = this.getDescriptor().getObjectBuilder().createRecord(session);
        this.writeFromObjectIntoRow(domainObject, databaseRow, session, DatabaseMapping.WriteType.UNDEFINED);
        return databaseRow;
    }

    public Object extractPrimaryKeysForReferenceObject(Object domainObject, AbstractSession session) {
        return this.indirectionPolicy.extractPrimaryKeyForReferenceObject(this.getAttributeValueFromObject(domainObject), session);
    }

    public Object extractPrimaryKeysForReferenceObjectFromRow(AbstractRecord row) {
        return null;
    }

    public Object extractPrimaryKeysFromRealReferenceObject(Object object, AbstractSession session) {
        if (object == null) {
            return null;
        }
        Object implementation = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(object, session);
        return this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(implementation, session);
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        super.preInitialize(session);
        if (this.indirectionPolicy instanceof ProxyIndirectionPolicy && !((ProxyIndirectionPolicy)this.indirectionPolicy).hasTargetInterfaces()) {
            this.useProxyIndirection();
        }
    }

    protected void insert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        UnitOfWorkChangeSet uowChangeSet;
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object object = this.getRealAttributeValueFromObject(query.getObject(), query.getSession());
        if (object == null) {
            return;
        }
        AbstractSession session = query.getSession();
        if (session.getCommitManager().isCommitCompletedOrInPost(object)) {
            return;
        }
        ObjectChangeSet changeSet = null;
        if (session.isUnitOfWork() && ((UnitOfWorkImpl)session).getUnitOfWorkChangeSet() != null && ((changeSet = (ObjectChangeSet)(uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)session).getUnitOfWorkChangeSet()).getObjectChangeSetForClone(object)) == null || !changeSet.isNew())) {
            return;
        }
        WriteObjectQuery writeQuery = null;
        writeQuery = this.isPrivateOwned && (changeSet == null || changeSet.isNew()) ? new InsertObjectQuery() : new WriteObjectQuery();
        writeQuery.setIsExecutionClone(true);
        writeQuery.setObject(object);
        writeQuery.setObjectChangeSet(changeSet);
        writeQuery.setCascadePolicy(query.getCascadePolicy());
        session.executeQuery(writeQuery);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void update(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object sourceObject = query.getObject();
        Object attributeValue = this.getAttributeValueFromObject(sourceObject);
        if (!this.indirectionPolicy.objectIsInstantiated(attributeValue)) {
            return;
        }
        AbstractSession session = query.getSession();
        Object object = this.getRealAttributeValueFromAttribute(attributeValue, sourceObject, session);
        if (object == null) return;
        ObjectChangeSet changeSet = query.getObjectChangeSet();
        if (changeSet != null) {
            ObjectReferenceChangeRecord changeRecord = (ObjectReferenceChangeRecord)query.getObjectChangeSet().getChangesForAttributeNamed(this.getAttributeName());
            if (changeRecord == null) return;
            changeSet = (ObjectChangeSet)changeRecord.getNewValue();
            if (!changeSet.isNew()) {
                return;
            }
        } else {
            UnitOfWorkChangeSet uowChangeSet = null;
            if (session.isUnitOfWork() && ((UnitOfWorkImpl)session).getUnitOfWorkChangeSet() != null && ((changeSet = (ObjectChangeSet)(uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)session).getUnitOfWorkChangeSet()).getObjectChangeSetForClone(object)) == null || !changeSet.isNew())) {
                return;
            }
        }
        if (query.shouldCascadeOnlyDependentParts() && changeSet != null && !changeSet.isNew()) return;
        if (session.getCommitManager().isCommitCompletedOrInPost(object)) {
            return;
        }
        WriteObjectQuery writeQuery = new WriteObjectQuery();
        writeQuery.setIsExecutionClone(true);
        writeQuery.setObject(object);
        writeQuery.setObjectChangeSet(changeSet);
        writeQuery.setCascadePolicy(query.getCascadePolicy());
        session.executeQuery(writeQuery);
    }

    public boolean hasRelationTableMechanism() {
        return false;
    }

    public void useProxyIndirection() {
        Class[] targetInterfaces = this.getReferenceClass().getInterfaces();
        if (!this.getReferenceClass().isInterface() && this.getReferenceClass().getSuperclass() == null) {
            this.setIndirectionPolicy(new ProxyIndirectionPolicy(targetInterfaces));
        } else {
            HashSet<Class> targetInterfacesCol = new HashSet<Class>();
            if (this.getReferenceClass().getSuperclass() != null) {
                this.buildTargetInterfaces(this.getReferenceClass(), targetInterfacesCol);
            }
            if (this.getReferenceClass().isInterface()) {
                targetInterfacesCol.add(this.getReferenceClass());
            }
            targetInterfaces = targetInterfacesCol.toArray(targetInterfaces);
            this.setIndirectionPolicy(new ProxyIndirectionPolicy(targetInterfaces));
        }
    }

    @Override
    public Object[] buildReferencesPKList(Object entity, Object attribute, AbstractSession session) {
        ClassDescriptor referenceDescriptor = this.getReferenceDescriptor();
        Object target = this.indirectionPolicy.getRealAttributeValueFromObject(entity, attribute);
        if (target != null) {
            Object[] result = new Object[]{referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(target, session)};
            return result;
        }
        return new Object[0];
    }

    public Collection buildTargetInterfaces(Class aClass, Collection targetInterfacesCol) {
        Class<?>[] targetInterfaces = aClass.getInterfaces();
        int index = 0;
        while (index < targetInterfaces.length) {
            targetInterfacesCol.add(targetInterfaces[index]);
            ++index;
        }
        if (aClass.getSuperclass() == null) {
            return targetInterfacesCol;
        }
        return this.buildTargetInterfaces(aClass.getSuperclass(), targetInterfacesCol);
    }

    public void useProxyIndirection(Class[] targetInterfaces) {
        this.setIndirectionPolicy(new ProxyIndirectionPolicy(targetInterfaces));
    }

    public void useProxyIndirection(Class targetInterface) {
        Class[] targetInterfaces = new Class[]{targetInterface};
        this.setIndirectionPolicy(new ProxyIndirectionPolicy(targetInterfaces));
    }

    @Override
    public Object valueFromPKList(Object[] pks, AbstractRecord foreignKeys, AbstractSession session) {
        if (pks.length == 0 || pks[0] == null) {
            return null;
        }
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(this.getReferenceClass());
        query.setSelectionId(pks[0]);
        query.setIsExecutionClone(true);
        query.setSession(session);
        return session.executeQuery(query);
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        Object attributeValue;
        if ((this.isPrivateOwned() || this.isCascadeRemove()) && (attributeValue = this.getRealAttributeValueFromObject(object, session)) != null) {
            return session.verifyDelete(attributeValue);
        }
        return true;
    }

    @Override
    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery query, AbstractRecord databaseRow) {
        Object object = query.getObject();
        AbstractSession session = query.getSession();
        if (!this.isAttributeValueInstantiated(object)) {
            return;
        }
        if (session.isUnitOfWork() && this.compareObjectsWithoutPrivateOwned(query.getBackupClone(), object, session)) {
            return;
        }
        this.writeFromObjectIntoRow(object, databaseRow, session, DatabaseMapping.WriteType.UPDATE);
    }

    @Override
    public void writeFromObjectIntoRowForWhereClause(ObjectLevelModifyQuery query, AbstractRecord databaseRow) {
        if (this.isReadOnly()) {
            return;
        }
        if (query.isDeleteObjectQuery()) {
            this.writeFromObjectIntoRow(query.getObject(), databaseRow, query.getSession(), DatabaseMapping.WriteType.UNDEFINED);
        } else if (this.isAttributeValueInstantiated(query.getObject())) {
            this.writeFromObjectIntoRow(query.getBackupClone(), databaseRow, query.getSession(), DatabaseMapping.WriteType.UNDEFINED);
        } else {
            this.writeFromObjectIntoRow(query.getObject(), databaseRow, query.getSession(), DatabaseMapping.WriteType.UNDEFINED);
        }
    }

    @Override
    public boolean isChangeTrackingSupported(Project project) {
        return true;
    }

    @Override
    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        ObjectReferenceChangeRecord changeRecord;
        Object unwrappedNewValue = newValue;
        Object unwrappedOldValue = oldValue;
        if (newValue != null) {
            unwrappedNewValue = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(newValue, uow);
        }
        if (oldValue != null) {
            unwrappedOldValue = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(oldValue, uow);
        }
        if ((changeRecord = (ObjectReferenceChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName())) == null) {
            changeRecord = this.internalBuildChangeRecord(unwrappedNewValue, objectChangeSet, uow);
            changeRecord.setOldValue(unwrappedOldValue);
            objectChangeSet.addChange(changeRecord);
        } else {
            this.setNewValueInChangeRecord(unwrappedNewValue, changeRecord, objectChangeSet, uow);
        }
    }

    @Override
    public void updateChangeRecordForSelfMerge(ChangeRecord changeRecord, Object source, Object target, UnitOfWorkChangeSet parentUOWChangeSet, UnitOfWorkImpl unitOfWork) {
        ((ObjectReferenceChangeRecord)changeRecord).setNewValue(((UnitOfWorkChangeSet)unitOfWork.getUnitOfWorkChangeSet()).findOrCreateLocalObjectChangeSet(target, this.referenceDescriptor, unitOfWork.isCloneNewObject(target)));
    }

    @Override
    public ChangeRecord buildChangeRecord(Object clone, ObjectChangeSet owner, AbstractSession session) {
        return this.internalBuildChangeRecord(this.getRealAttributeValueFromObject(clone, session), owner, session);
    }
}

