/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.jpa.jpql.EntityResolver;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.FromSubqueryResolver;
import org.eclipse.persistence.jpa.jpql.IdentificationVariableResolver;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.JPQLQueryDeclaration;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.NullResolver;
import org.eclipse.persistence.jpa.jpql.Resolver;
import org.eclipse.persistence.jpa.jpql.ResolverVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarationResolver
extends Resolver {
    private List<Declaration> declarations;
    private DeclarationVisitor declarationVisitor;
    private QualifyRangeDeclarationVisitor qualifyRangeDeclarationVisitor;
    private JPQLQueryContext queryContext;
    private Map<String, Resolver> resolvers;
    private Map<IdentificationVariable, String> resultVariables;
    private RootObjectExpressionVisitor rootObjectExpressionVisitor;

    public DeclarationResolver(DeclarationResolver parent, JPQLQueryContext queryContext) {
        super(parent);
        this.initialize(queryContext);
    }

    @Override
    public void accept(ResolverVisitor visitor) {
    }

    public void addRangeVariableDeclaration(String entityName, String variableName) {
        String internalVariableName = variableName.toUpperCase();
        if (!this.resolvers.containsKey(internalVariableName)) {
            Resolver resolver = new EntityResolver(this, entityName);
            resolver = new IdentificationVariableResolver(resolver, variableName);
            this.resolvers.put(internalVariableName, resolver);
            Declaration declaration = new Declaration();
            declaration.rangeDeclaration = true;
            declaration.rootPath = entityName;
            declaration.identificationVariable = new IdentificationVariable(null, variableName);
            declaration.lockData();
            this.declarations.add(declaration);
        }
    }

    protected DeclarationVisitor buildDeclarationVisitor() {
        return new DeclarationVisitor();
    }

    protected RootObjectExpressionVisitor buildRootObjectExpressionVisitor() {
        return new RootObjectExpressionVisitor();
    }

    @Override
    protected IType buildType() {
        return this.getTypeHelper().unknownType();
    }

    @Override
    protected ITypeDeclaration buildTypeDeclaration() {
        return this.getTypeHelper().unknownTypeDeclaration();
    }

    @Override
    protected void checkParent(Resolver parent) {
    }

    public void convertUnqualifiedDeclaration(Declaration declaration, String outerVariableName) {
        QualifyRangeDeclarationVisitor visitor = this.qualifyRangeDeclarationVisitor();
        try {
            visitor.declaration = declaration;
            visitor.outerVariableName = outerVariableName;
            declaration.declarationExpression.accept(visitor);
        }
        finally {
            visitor.declaration = null;
            visitor.outerVariableName = null;
        }
    }

    public void dispose() {
        this.resolvers.clear();
        this.declarations.clear();
        this.resultVariables.clear();
    }

    public List<Declaration> getDeclarations() {
        return this.declarations;
    }

    protected DeclarationVisitor getDeclarationVisitor() {
        if (this.declarationVisitor == null) {
            this.declarationVisitor = this.buildDeclarationVisitor();
        }
        return this.declarationVisitor;
    }

    public Collection<Join> getJoins(String variableName) {
        Collection<Join> joins = this.getJoinsImp(variableName);
        if (joins.isEmpty() && this.getParent() != null) {
            joins = this.getParent().getJoinsImp(variableName);
        }
        return joins;
    }

    protected Collection<Join> getJoinsImp(String variableName) {
        for (Declaration declaration : this.declarations) {
            if (!declaration.getVariableName().equalsIgnoreCase(variableName)) continue;
            return declaration.getJoins();
        }
        return Collections.emptyList();
    }

    @Override
    public DeclarationResolver getParent() {
        return (DeclarationResolver)super.getParent();
    }

    @Override
    protected IQuery getQuery() {
        return this.queryContext.getQuery();
    }

    public Resolver getResolver(String variableName) {
        Resolver resolver = this.getResolverImp(variableName = variableName.toUpperCase());
        if (resolver == null && this.getParent() != null) {
            resolver = this.getParent().getResolver(variableName);
        }
        if (resolver == null) {
            resolver = new NullResolver(this);
            this.resolvers.put(variableName, resolver);
        }
        return resolver;
    }

    protected Resolver getResolverImp(String variableName) {
        return this.resolvers.get(variableName);
    }

    public Set<String> getResultVariables() {
        return new HashSet<String>(this.resultVariables.values());
    }

    public Map<IdentificationVariable, String> getResultVariablesMap() {
        return this.resultVariables;
    }

    protected RootObjectExpressionVisitor getRootObjectExpressionVisitor() {
        if (this.rootObjectExpressionVisitor == null) {
            this.rootObjectExpressionVisitor = this.buildRootObjectExpressionVisitor();
        }
        return this.rootObjectExpressionVisitor;
    }

    public boolean hasJoins() {
        for (Declaration declaration : this.declarations) {
            if (!declaration.hasJoins()) continue;
            return true;
        }
        return false;
    }

    protected void initialize(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
        this.resolvers = new HashMap<String, Resolver>();
        this.declarations = new ArrayList<Declaration>();
        this.resultVariables = new HashMap<IdentificationVariable, String>();
    }

    public boolean isCollectionIdentificationVariable(String variableName) {
        boolean result = this.isCollectionIdentificationVariableImp(variableName);
        if (!result && this.getParent() != null) {
            result = this.getParent().isCollectionIdentificationVariableImp(variableName);
        }
        return result;
    }

    protected boolean isCollectionIdentificationVariableImp(String variableName) {
        for (Declaration declaration : this.declarations) {
            if (!declaration.rangeDeclaration && declaration.getVariableName().equalsIgnoreCase(variableName)) {
                return true;
            }
            for (String joinIdentificationVariable : declaration.getJoinIdentificationVariables()) {
                IMapping mapping;
                if (!joinIdentificationVariable.equalsIgnoreCase(variableName)) continue;
                Resolver resolver = this.getResolver(variableName);
                IMapping iMapping = mapping = resolver != null ? resolver.getMapping() : null;
                return mapping != null && mapping.isCollection();
            }
        }
        return false;
    }

    public boolean isRangeIdentificationVariable(String variableName) {
        boolean result = this.isRangeIdentificationVariableImp(variableName);
        if (!result && this.getParent() != null) {
            result = this.getParent().isRangeIdentificationVariableImp(variableName);
        }
        return result;
    }

    protected boolean isRangeIdentificationVariableImp(String variableName) {
        for (Declaration declaration : this.declarations) {
            if (!declaration.rangeDeclaration || !declaration.getVariableName().equalsIgnoreCase(variableName)) continue;
            return true;
        }
        return false;
    }

    public boolean isResultVariable(String variable) {
        return this.resultVariables.containsValue(variable.toUpperCase());
    }

    public void populate(Expression expression) {
        expression.accept(this.getDeclarationVisitor());
    }

    protected QualifyRangeDeclarationVisitor qualifyRangeDeclarationVisitor() {
        if (this.qualifyRangeDeclarationVisitor == null) {
            this.qualifyRangeDeclarationVisitor = new QualifyRangeDeclarationVisitor();
        }
        return this.qualifyRangeDeclarationVisitor;
    }

    protected Resolver resolveRootObject(Expression expression) {
        RootObjectExpressionVisitor visitor = this.getRootObjectExpressionVisitor();
        try {
            expression.accept(visitor);
            Resolver resolver = visitor.resolver;
            return resolver;
        }
        finally {
            visitor.resolver = null;
        }
    }

    protected String visitDeclaration(Expression expression, Expression identificationVariable) {
        String variableName = this.queryContext.literal(identificationVariable, LiteralType.IDENTIFICATION_VARIABLE);
        if (ExpressionTools.stringIsNotEmpty(variableName)) {
            String internalVariableName = variableName.toUpperCase();
            if (!this.resolvers.containsKey(internalVariableName)) {
                Resolver resolver = this.resolveRootObject(expression);
                resolver = new IdentificationVariableResolver(resolver, variableName);
                this.resolvers.put(internalVariableName, resolver);
            }
            return variableName;
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Declaration
    implements JPQLQueryDeclaration {
        protected Expression baseExpression;
        protected Expression declarationExpression;
        protected boolean derived;
        protected IdentificationVariable identificationVariable;
        protected Set<String> joinIdentificationVariables;
        protected Map<Join, IdentificationVariable> joins;
        protected boolean rangeDeclaration;
        protected String rootPath;

        protected void addJoin(Join join, IdentificationVariable identificationVariable) {
            if (this.joins == null) {
                this.joins = new LinkedHashMap<Join, IdentificationVariable>();
            }
            this.joins.put(join, identificationVariable);
        }

        protected Set<String> buildJoinIdentificationVariables() {
            HashSet<String> variables = new HashSet<String>();
            HashSet upperCaseVariables = new HashSet();
            for (IdentificationVariable identificationVariable : this.joins.values()) {
                String joinVariable = identificationVariable.getText();
                if (joinVariable.length() <= 0 || upperCaseVariables.contains(joinVariable.toUpperCase())) continue;
                variables.add(joinVariable);
            }
            return Collections.unmodifiableSet(variables);
        }

        protected Map.Entry<Join, String> buildMapEntry(Map.Entry<Join, IdentificationVariable> entry) {
            IdentificationVariable variable = entry.getValue();
            String variableName = variable != null ? variable.getText() : "";
            return new SimpleEntry(entry.getKey(), variableName);
        }

        @Override
        public Expression getBaseExpression() {
            return this.baseExpression;
        }

        @Override
        public Expression getDeclarationExpression() {
            return this.declarationExpression;
        }

        public List<Map.Entry<Join, String>> getJoinEntries() {
            ArrayList<Map.Entry<Join, String>> entries = new ArrayList<Map.Entry<Join, String>>();
            for (Map.Entry<Join, IdentificationVariable> entry : this.joins.entrySet()) {
                entries.add(this.buildMapEntry(entry));
            }
            return entries;
        }

        public Set<String> getJoinIdentificationVariables() {
            if (this.joinIdentificationVariables == null) {
                this.joinIdentificationVariables = this.hasJoins() ? this.buildJoinIdentificationVariables() : Collections.emptySet();
            }
            return this.joinIdentificationVariables;
        }

        @Override
        public List<Join> getJoins() {
            return new LinkedList<Join>(this.joins.keySet());
        }

        public String getRootPath() {
            return this.rootPath;
        }

        public String getSuperqueryVariableName() {
            int index = this.derived ? this.rootPath.indexOf(46) : -1;
            return index > -1 ? this.rootPath.substring(0, index) : "";
        }

        @Override
        public String getVariableName() {
            if (this.identificationVariable == null) {
                return "";
            }
            return this.identificationVariable.getText();
        }

        @Override
        public boolean hasJoins() {
            return !this.joins.isEmpty();
        }

        @Override
        public boolean isCollection() {
            return !this.rangeDeclaration;
        }

        @Override
        public boolean isDerived() {
            return this.derived;
        }

        @Override
        public boolean isRange() {
            return this.rangeDeclaration;
        }

        protected void lockData() {
            this.joins = this.joins != null ? Collections.unmodifiableMap(this.joins) : Collections.emptyMap();
        }

        public String toString() {
            if (this.declarationExpression != null) {
                return this.declarationExpression.toParsedText();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.rootPath);
            sb.append(' ');
            sb.append(this.identificationVariable);
            return sb.toString();
        }
    }

    protected class DeclarationVisitor
    extends AbstractExpressionVisitor {
        protected boolean collectResultVariable;
        protected Declaration currentDeclaration;

        protected DeclarationVisitor() {
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren(this);
        }

        public void visit(CollectionMemberDeclaration expression) {
            Declaration declaration = new Declaration();
            Expression identificationVariable = expression.getIdentificationVariable();
            String variableName = DeclarationResolver.this.visitDeclaration(expression, identificationVariable);
            if (variableName.length() > 0) {
                declaration.identificationVariable = (IdentificationVariable)identificationVariable;
            }
            declaration.declarationExpression = expression;
            declaration.baseExpression = expression.getCollectionValuedPathExpression();
            declaration.lockData();
            DeclarationResolver.this.declarations.add(declaration);
        }

        public void visit(DeleteClause expression) {
            Declaration declaration = new Declaration();
            declaration.declarationExpression = expression;
            declaration.rangeDeclaration = true;
            DeclarationResolver.this.declarations.add(declaration);
            this.currentDeclaration = declaration;
            try {
                expression.getRangeVariableDeclaration().accept(this);
            }
            finally {
                this.currentDeclaration.lockData();
                this.currentDeclaration = null;
            }
        }

        public void visit(DeleteStatement expression) {
            expression.getDeleteClause().accept(this);
        }

        public void visit(FromClause expression) {
            expression.getDeclaration().accept(this);
        }

        public void visit(IdentificationVariable expression) {
            if (this.collectResultVariable) {
                DeclarationResolver.this.resultVariables.put(expression, expression.getText().toUpperCase());
            }
        }

        public void visit(IdentificationVariableDeclaration expression) {
            Declaration declaration = new Declaration();
            declaration.declarationExpression = expression;
            declaration.baseExpression = expression.getRangeVariableDeclaration();
            DeclarationResolver.this.declarations.add(declaration);
            this.currentDeclaration = declaration;
            try {
                expression.getRangeVariableDeclaration().accept(this);
                expression.getJoins().accept(this);
            }
            finally {
                this.currentDeclaration.lockData();
                this.currentDeclaration = null;
            }
        }

        public void visit(Join expression) {
            Expression identificationVariable = expression.getIdentificationVariable();
            String variableName = DeclarationResolver.this.visitDeclaration(expression, identificationVariable);
            if (variableName.length() > 0) {
                this.currentDeclaration.addJoin(expression, (IdentificationVariable)identificationVariable);
            } else {
                this.currentDeclaration.addJoin(expression, null);
            }
        }

        public void visit(JPQLExpression expression) {
            expression.getQueryStatement().accept(this);
        }

        public void visit(RangeVariableDeclaration expression) {
            String entityName;
            Expression identificationVariable;
            Expression abstractSchemaName = expression.getRootObject();
            String variableName = DeclarationResolver.this.visitDeclaration(abstractSchemaName, identificationVariable = expression.getIdentificationVariable());
            if (variableName.length() > 0) {
                this.currentDeclaration.identificationVariable = (IdentificationVariable)identificationVariable;
            }
            if (ExpressionTools.stringIsNotEmpty(entityName = DeclarationResolver.this.queryContext.literal(abstractSchemaName, LiteralType.ABSTRACT_SCHEMA_NAME))) {
                this.currentDeclaration.rangeDeclaration = true;
                this.currentDeclaration.rootPath = entityName;
            } else {
                String derivedPath = DeclarationResolver.this.queryContext.literal(abstractSchemaName, LiteralType.PATH_EXPRESSION_ALL_PATH);
                this.currentDeclaration.derived = true;
                this.currentDeclaration.rootPath = derivedPath;
            }
        }

        public void visit(ResultVariable expression) {
            this.collectResultVariable = true;
            expression.getResultVariable().accept(this);
            this.collectResultVariable = false;
        }

        public void visit(SelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        public void visit(SelectStatement expression) {
            expression.getFromClause().accept(this);
            expression.getSelectClause().accept(this);
        }

        public void visit(SimpleFromClause expression) {
            expression.getDeclaration().accept(this);
        }

        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        public void visit(SimpleSelectStatement expression) {
            expression.getFromClause().accept(this);
        }

        public void visit(UpdateClause expression) {
            Declaration declaration = new Declaration();
            declaration.declarationExpression = expression;
            declaration.rangeDeclaration = true;
            DeclarationResolver.this.declarations.add(declaration);
            this.currentDeclaration = declaration;
            try {
                expression.getRangeVariableDeclaration().accept(this);
            }
            finally {
                this.currentDeclaration.lockData();
                this.currentDeclaration = null;
            }
        }

        public void visit(UpdateStatement expression) {
            expression.getUpdateClause().accept(this);
        }
    }

    protected class QualifyRangeDeclarationVisitor
    extends AbstractExpressionVisitor {
        protected Declaration declaration;
        protected String outerVariableName;

        protected QualifyRangeDeclarationVisitor() {
        }

        public void visit(CollectionValuedPathExpression expression) {
            this.declaration.baseExpression = expression;
        }

        public void visit(IdentificationVariableDeclaration expression) {
            expression.getRangeVariableDeclaration().accept(this);
        }

        public void visit(RangeVariableDeclaration expression) {
            this.declaration.rangeDeclaration = false;
            expression.setVirtualIdentificationVariable(this.outerVariableName, this.declaration.rootPath);
            expression.getRootObject().accept(this);
        }
    }

    protected class RootObjectExpressionVisitor
    extends AnonymousExpressionVisitor {
        protected Resolver resolver;

        protected RootObjectExpressionVisitor() {
        }

        protected void visit(Expression expression) {
            this.resolver = DeclarationResolver.this.queryContext.getResolver(expression);
        }

        public void visit(SimpleSelectStatement expression) {
            this.resolver = new FromSubqueryResolver(DeclarationResolver.this, DeclarationResolver.this.queryContext, expression);
        }

        public void visit(SubExpression expression) {
            expression.getExpression().accept(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleEntry
    implements Map.Entry<Join, String> {
        private final Join key;
        private String value;

        SimpleEntry(Join key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Join getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            throw new IllegalAccessError("This Map.Entry is read-only");
        }
    }
}

