/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.jpa.jpql.DeclarationResolver;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.LiteralVisitor;
import org.eclipse.persistence.jpa.jpql.ParameterTypeVisitor;
import org.eclipse.persistence.jpa.jpql.Resolver;
import org.eclipse.persistence.jpa.jpql.ResolverBuilder;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTraverseChildrenVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTraverseParentVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionRegistry;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;
import org.eclipse.persistence.jpa.jpql.spi.JPAVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JPQLQueryContext {
    private Map<Expression, JPQLQueryContext> contexts;
    protected JPQLQueryContext currentContext;
    private Expression currentQuery;
    private DeclarationResolver declarationResolver;
    private InputParameterVisitor inputParameterVisitor;
    private JPQLExpression jpqlExpression;
    private JPQLGrammar jpqlGrammar;
    private LiteralVisitor literalVisitor;
    private ParameterTypeVisitor parameterTypeVisitor;
    protected JPQLQueryContext parent;
    private IQuery query;
    private QueryExpressionVisitor queryExpressionVisitor;
    private ResolverBuilder resolverBuilder;
    private boolean traversed;

    public JPQLQueryContext(JPQLGrammar jpqlGrammar) {
        this.initialize(jpqlGrammar);
    }

    protected JPQLQueryContext(JPQLQueryContext parent, Expression currentQuery) {
        this(parent.jpqlGrammar);
        this.store(parent, currentQuery);
    }

    protected DeclarationResolver buildDeclarationResolver() {
        DeclarationResolver parentResolver = this.parent != null ? this.parent.getDeclarationResolverImp() : null;
        return new DeclarationResolver(parentResolver, this);
    }

    protected InputParameterVisitor buildInputParameter() {
        return new InputParameterVisitor();
    }

    protected abstract JPQLQueryContext buildJPQLQueryContext(JPQLQueryContext var1, Expression var2);

    protected abstract LiteralVisitor buildLiteralVisitor();

    protected ParameterTypeVisitor buildParameterTypeVisitor() {
        return new ParameterTypeVisitor(this);
    }

    protected QueryExpressionVisitor buildQueryExpressionVisitor() {
        return new QueryExpressionVisitor();
    }

    protected abstract ResolverBuilder buildResolverBuilder();

    public void convertUnqualifiedDeclaration(DeclarationResolver.Declaration declaration) {
        if (this.parent != null) {
            DeclarationResolver.Declaration parentDeclaration = this.parent.getDeclarationResolverImp().getDeclarations().get(0);
            String outerVariableName = parentDeclaration.getVariableName();
            this.getDeclarationResolverImp().convertUnqualifiedDeclaration(declaration, outerVariableName);
        }
    }

    public void dispose() {
        this.query = null;
        this.traversed = false;
        this.currentQuery = null;
        this.currentContext = this;
        this.jpqlExpression = null;
        this.contexts.clear();
        if (this.declarationResolver != null) {
            this.declarationResolver.dispose();
        }
    }

    public void disposeSubqueryContext() {
        this.currentContext = this.currentContext.parent;
    }

    public Collection<InputParameter> findInputParameters(String parameterName) {
        InputParameterVisitor visitor = this.getInputParameterVisitor();
        try {
            visitor.parameterName = parameterName;
            visitor.inputParameters = new ArrayList<InputParameter>();
            this.jpqlExpression.accept(visitor);
            Collection<InputParameter> collection = visitor.inputParameters;
            return collection;
        }
        finally {
            visitor.parameterName = null;
            visitor.inputParameters = null;
        }
    }

    public Expression getActualCurrentQuery() {
        return this.currentQuery;
    }

    public DeclarationResolver getActualDeclarationResolver() {
        return this.getDeclarationResolverImp();
    }

    public JPQLQueryContext getCurrentContext() {
        return this.currentContext;
    }

    public Expression getCurrentQuery() {
        return this.currentContext.currentQuery;
    }

    public DeclarationResolver getDeclarationResolver() {
        return this.currentContext.getDeclarationResolverImp();
    }

    public DeclarationResolver getDeclarationResolver(Expression expression) {
        JPQLQueryContext context = this.contexts.get(expression = this.getQueryExpression(expression));
        if (context != null) {
            return context.getDeclarationResolverImp();
        }
        this.getDeclarationResolver(expression.getParent());
        this.newSubqueryContext(expression);
        return this.currentContext.getDeclarationResolverImp();
    }

    protected DeclarationResolver getDeclarationResolverImp() {
        if (this.declarationResolver == null) {
            this.declarationResolver = this.buildDeclarationResolver();
        }
        if (!this.traversed) {
            this.traversed = true;
            this.declarationResolver.populate(this.currentQuery);
        }
        return this.declarationResolver;
    }

    public List<DeclarationResolver.Declaration> getDeclarations() {
        return this.getDeclarationResolver().getDeclarations();
    }

    public IType getEnumType(String enumTypeName) {
        return this.getTypeRepository().getEnumType(enumTypeName);
    }

    public ExpressionRegistry getExpressionRegistry() {
        return this.jpqlGrammar.getExpressionRegistry();
    }

    public JPQLGrammar getGrammar() {
        return this.jpqlGrammar;
    }

    protected InputParameterVisitor getInputParameterVisitor() {
        if (this.inputParameterVisitor == null) {
            this.inputParameterVisitor = this.buildInputParameter();
        }
        return this.inputParameterVisitor;
    }

    public Collection<Join> getJoins(String variableName) {
        return this.getDeclarationResolver().getJoins(variableName);
    }

    public JPAVersion getJPAVersion() {
        return this.jpqlGrammar.getJPAVersion();
    }

    public JPQLExpression getJPQLExpression() {
        return this.jpqlExpression;
    }

    public String getJPQLQuery() {
        return this.query.getExpression();
    }

    protected LiteralVisitor getLiteralVisitor() {
        if (this.literalVisitor == null) {
            this.literalVisitor = this.buildLiteralVisitor();
        }
        return this.literalVisitor;
    }

    public IMapping getMapping(Expression expression) {
        return this.getResolver(expression).getMapping();
    }

    public IType getParameterType(InputParameter inputParameter) {
        ParameterTypeVisitor visitor = this.getParameterTypeVisitor();
        try {
            inputParameter.accept(visitor);
            IType iType = visitor.getType();
            return iType;
        }
        finally {
            visitor.dispose();
        }
    }

    protected ParameterTypeVisitor getParameterTypeVisitor() {
        if (this.parameterTypeVisitor == null) {
            this.parameterTypeVisitor = this.buildParameterTypeVisitor();
        }
        return this.parameterTypeVisitor;
    }

    public JPQLQueryContext getParent() {
        return this.parent;
    }

    public IManagedTypeProvider getProvider() {
        return this.query.getProvider();
    }

    public IQuery getQuery() {
        return this.query;
    }

    public Expression getQueryExpression(Expression expression) {
        QueryExpressionVisitor visitor = this.getQueryExpressionVisitor();
        try {
            expression.accept(visitor);
            Expression expression2 = visitor.expression;
            return expression2;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected QueryExpressionVisitor getQueryExpressionVisitor() {
        if (this.queryExpressionVisitor == null) {
            this.queryExpressionVisitor = this.buildQueryExpressionVisitor();
        }
        return this.queryExpressionVisitor;
    }

    public Resolver getResolver(Expression expression) {
        ResolverBuilder visitor = this.getResolverBuilder();
        try {
            expression.accept(visitor);
            Resolver resolver = visitor.resolver;
            return resolver;
        }
        finally {
            visitor.resolver = null;
        }
    }

    public Resolver getResolver(String variableName) {
        return this.getDeclarationResolver().getResolver(variableName);
    }

    protected ResolverBuilder getResolverBuilder() {
        if (this.resolverBuilder == null) {
            this.resolverBuilder = this.buildResolverBuilder();
        }
        return this.resolverBuilder;
    }

    public Set<String> getResultVariables() {
        return this.getDeclarationResolver().getResultVariables();
    }

    public IType getType(Class<?> type) {
        return this.getTypeRepository().getType(type);
    }

    public IType getType(Expression expression) {
        return this.getResolver(expression).getType();
    }

    public IType getType(String typeName) {
        return this.getTypeRepository().getType(typeName);
    }

    public ITypeDeclaration getTypeDeclaration(Expression expression) {
        return this.getResolver(expression).getTypeDeclaration();
    }

    public TypeHelper getTypeHelper() {
        return this.getTypeRepository().getTypeHelper();
    }

    public ITypeRepository getTypeRepository() {
        return this.getProvider().getTypeRepository();
    }

    public boolean hasJoins() {
        return this.getDeclarationResolver().hasJoins();
    }

    protected void initialize(JPQLGrammar jpqlGrammar) {
        this.jpqlGrammar = jpqlGrammar;
        this.currentContext = this;
        this.contexts = new HashMap<Expression, JPQLQueryContext>();
    }

    protected void initializeRoot() {
        if (this.jpqlExpression == null) {
            this.jpqlExpression = new JPQLExpression(this.query.getExpression(), this.jpqlGrammar, true);
        }
        this.currentQuery = this.jpqlExpression;
        this.contexts.put(this.currentQuery, this);
    }

    public boolean isCollectionIdentificationVariable(String variableName) {
        return this.getDeclarationResolver().isCollectionIdentificationVariable(variableName);
    }

    public boolean isRangeIdentificationVariable(String variableName) {
        return this.getDeclarationResolver().isRangeIdentificationVariable(variableName);
    }

    public boolean isResultVariable(String variable) {
        return this.getDeclarationResolverImp().isResultVariable(variable);
    }

    public String literal(Expression expression, LiteralType type) {
        LiteralVisitor visitor = this.getLiteralVisitor();
        try {
            visitor.setType(type);
            expression.accept(visitor);
            String string = visitor.literal;
            return string;
        }
        finally {
            visitor.literal = "";
        }
    }

    public void newSubqueryContext(Expression currentQuery) {
        JPQLQueryContext context = this.contexts.get(currentQuery);
        this.currentContext = context != null ? context : this.buildJPQLQueryContext(this.currentContext, currentQuery);
    }

    public void setJPQLExpression(JPQLExpression jpqlExpression) {
        this.jpqlExpression = jpqlExpression;
    }

    public void setQuery(IQuery query) {
        this.query = query;
        this.initializeRoot();
    }

    protected void store(JPQLQueryContext parent, Expression currentQuery) {
        this.parent = parent;
        this.currentQuery = currentQuery;
        this.query = parent.query;
        this.contexts = parent.contexts;
        this.jpqlExpression = parent.jpqlExpression;
        this.literalVisitor = parent.literalVisitor;
        this.resolverBuilder = parent.resolverBuilder;
        this.parameterTypeVisitor = parent.parameterTypeVisitor;
        this.queryExpressionVisitor = parent.queryExpressionVisitor;
        this.contexts.put(currentQuery, this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Current JPQL query=");
        sb.append(this.currentContext.currentQuery.toParsedText());
        return sb.toString();
    }

    protected class InputParameterVisitor
    extends AbstractTraverseChildrenVisitor {
        protected Collection<InputParameter> inputParameters;
        protected String parameterName;

        protected InputParameterVisitor() {
        }

        public void visit(InputParameter expression) {
            if (this.parameterName.equals(expression.getParameter())) {
                this.inputParameters.add(expression);
            }
        }

        public void visit(SimpleSelectStatement expression) {
            JPQLQueryContext.this.newSubqueryContext(expression);
            try {
                super.visit(expression);
            }
            finally {
                JPQLQueryContext.this.disposeSubqueryContext();
            }
        }
    }

    protected static class QueryExpressionVisitor
    extends AbstractTraverseParentVisitor {
        protected Expression expression;

        protected QueryExpressionVisitor() {
        }

        public void visit(JPQLExpression expression) {
            this.expression = expression;
        }

        public void visit(SimpleSelectStatement expression) {
            this.expression = expression;
        }
    }
}

