/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Singleton;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.Archive;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.metadata.Application;
import org.eclipse.persistence.jpa.rs.metadata.MetadataStore;
import org.eclipse.persistence.jpa.rs.util.InMemoryArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class PersistenceFactory {
    private Map<String, PersistenceContext> persistenceContexts = new HashMap<String, PersistenceContext>();
    private MetadataStore metadataStore;

    public PersistenceContext bootstrapPersistenceContext(String name, String persistenceXML, Map<String, ?> originalProperties, boolean replace) {
        ByteArrayInputStream stream = new ByteArrayInputStream(persistenceXML.getBytes());
        InMemoryArchive archive = new InMemoryArchive(stream);
        return this.bootstrapPersistenceContext(name, (Archive)archive, null, originalProperties, replace);
    }

    public PersistenceContext bootstrapPersistenceContext(String name, URL persistenceXMLURL, Map<String, ?> originalProperties, boolean replace) throws IOException {
        InMemoryArchive archive = new InMemoryArchive(persistenceXMLURL.openStream());
        return this.bootstrapPersistenceContext(name, (Archive)archive, persistenceXMLURL.toString(), originalProperties, replace);
    }

    public PersistenceContext bootstrapPersistenceContext(String name, InputStream persistenceXMLStream, Map<String, ?> originalProperties, boolean replace) {
        InMemoryArchive archive = new InMemoryArchive(persistenceXMLStream);
        return this.bootstrapPersistenceContext(name, (Archive)archive, null, originalProperties, replace);
    }

    public PersistenceContext bootstrapPersistenceContext(String name, Archive archive, String persistenceXMLLocation, Map<String, ?> originalProperties, boolean replace) {
        this.initialize();
        PersistenceContext persistenceContext = this.getPersistenceContext(name);
        if (persistenceContext == null || replace) {
            DynamicClassLoader dcl = new DynamicClassLoader(Thread.currentThread().getContextClassLoader());
            Map<String, Object> properties = PersistenceFactory.createProperties(dcl, originalProperties);
            properties.putAll(originalProperties);
            persistenceContext = new PersistenceContext(archive, properties, (ClassLoader)dcl);
            this.persistenceContexts.put(name, persistenceContext);
            if (persistenceXMLLocation != null) {
                this.storeApplicationMetadata(name, persistenceXMLLocation);
            }
        } else {
            System.out.println("PersistenceContext " + name + " already started.  Using existing.");
        }
        return persistenceContext;
    }

    public PersistenceContext bootstrapPersistenceContext(String name, EntityManagerFactory emf, URI baseURI, boolean replace) {
        this.initialize();
        PersistenceContext persistenceContext = null;
        if (!replace) {
            persistenceContext = this.getPersistenceContext(name);
        }
        if (persistenceContext == null) {
            persistenceContext = new PersistenceContext(name, (EntityManagerFactoryImpl)emf, baseURI);
            this.persistenceContexts.put(name, persistenceContext);
        }
        persistenceContext.setBaseURI(baseURI);
        return persistenceContext;
    }

    public void closePersistenceContext(String name) {
        PersistenceContext context = this.persistenceContexts.get(name);
        if (context != null) {
            context.getEmf().close();
            this.persistenceContexts.remove(name);
        }
    }

    public void close() {
        for (String key : this.persistenceContexts.keySet()) {
            this.persistenceContexts.get(key).stop();
        }
        if (this.metadataStore != null) {
            this.metadataStore.close();
        }
    }

    protected static Map<String, Object> createProperties(DynamicClassLoader dcl, Map<String, ?> originalProperties) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("eclipselink.classloader", dcl);
        properties.put("eclipselink.weaving", "static");
        for (Map.Entry<String, ?> entry : originalProperties.entrySet()) {
            if (!entry.getKey().startsWith("javax") && !entry.getKey().startsWith("eclipselink.log") && !entry.getKey().startsWith("eclipselink.target-server")) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceContext getPersistenceContext(String name) {
        PersistenceFactory persistenceFactory = this;
        synchronized (persistenceFactory) {
            this.initialize();
            return this.persistenceContexts.get(name);
        }
    }

    public Set<String> getPersistenceContextNames() {
        HashSet<String> contextNames = new HashSet<String>();
        contextNames.addAll(this.persistenceContexts.keySet());
        try {
            Set archives = PersistenceUnitProcessor.findPersistenceArchives();
            for (Archive archive : archives) {
                List infos = PersistenceUnitProcessor.processPersistenceArchive((Archive)archive, (ClassLoader)Thread.currentThread().getContextClassLoader());
                for (SEPersistenceUnitInfo info : infos) {
                    if (info.getPersistenceUnitName().equals("jpa-rs")) continue;
                    contextNames.add(info.getPersistenceUnitName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contextNames;
    }

    public MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    public void initialize() {
        this.initialize(new HashMap<String, Object>());
    }

    public void initialize(Map<String, Object> properties) {
        if (this.metadataStore != null && !this.metadataStore.isInitialized()) {
            List<Application> applications = this.metadataStore.retreiveMetadata();
            for (Application application : applications) {
                try {
                    URL persistenceXMLURL = new URL(application.getPersistenceXMLURL());
                    this.bootstrapPersistenceContext(application.getName(), persistenceXMLURL, properties, false);
                }
                catch (Exception e) {
                    System.out.println("Exception bootstrapping PersistenceFactory for application " + application.getName());
                    e.printStackTrace();
                }
            }
        }
    }

    public void setMetadataStore(MetadataStore metadataStore) {
        this.metadataStore = metadataStore;
    }

    public void storeApplicationMetadata(String applicationName, String persistenceXMLURL) {
        if (this.metadataStore != null) {
            this.metadataStore.persistMetadata(applicationName, persistenceXMLURL);
        } else {
            System.out.println("Unable to store metadata.  No MetadataStore has been configured.");
        }
    }
}

