/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.PersistenceFactory;
import org.eclipse.persistence.jpa.rs.metadata.DatabaseMetadataStore;
import org.eclipse.persistence.jpa.rs.metadata.model.Attribute;
import org.eclipse.persistence.jpa.rs.metadata.model.Descriptor;
import org.eclipse.persistence.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.jpa.rs.metadata.model.LinkTemplate;
import org.eclipse.persistence.jpa.rs.metadata.model.Parameter;
import org.eclipse.persistence.jpa.rs.metadata.model.PersistenceUnit;
import org.eclipse.persistence.jpa.rs.metadata.model.Query;
import org.eclipse.persistence.jpa.rs.metadata.model.SessionBeanCall;
import org.eclipse.persistence.jpa.rs.util.IdHelper;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
@Path(value="/")
public class Service {
    static final Logger logger = Logger.getLogger("AppService");
    private PersistenceFactory factory;

    public PersistenceFactory getPersistenceFactory() {
        return this.factory;
    }

    @EJB
    public void setPersistenceFactory(PersistenceFactory factory) {
        this.factory = factory;
    }

    @PUT
    @Path(value="/")
    @Consumes(value={"*/*"})
    public Response start(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @Context HttpHeaders hh, InputStream in) {
        this.factory.setMetadataStore(new DatabaseMetadataStore());
        List datasourceValues = hh.getRequestHeader("datasourceName");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (datasourceValues != null && datasourceValues.size() > 0) {
            properties.put("javax.persistence.nonJtaDataSource", datasourceValues.get(0));
        }
        this.factory.getMetadataStore().setProperties(properties);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @GET
    @Path(value="/")
    public Response getContexts(@Context HttpHeaders hh, @Context UriInfo uriInfo) throws JAXBException {
        Set<String> contexts = this.factory.getPersistenceContextNames();
        Iterator<String> contextIterator = contexts.iterator();
        ArrayList<Link> links = new ArrayList<Link>();
        String mediaType = StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()).toString();
        while (contextIterator.hasNext()) {
            String context = contextIterator.next();
            links.add(new Link(context, mediaType, "\"href\": \"" + uriInfo.getBaseUri() + context + "/metadata\""));
        }
        String result = null;
        result = this.marshallMetadata(links, mediaType);
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, hh.getAcceptableMediaTypes())).build();
    }

    @POST
    @Path(value="/")
    @Produces(value={"*/*"})
    public Response callSessionBean(@Context HttpHeaders hh, @Context UriInfo ui, InputStream is) throws JAXBException, ClassNotFoundException, NamingException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        SessionBeanCall call = null;
        InitialContext ctx = new InitialContext();
        call = this.unmarshallSessionBeanCall(is);
        String jndiName = call.getJndiName();
        Object ans = ctx.lookup(jndiName);
        if (ans == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PersistenceContext context = null;
        if (call.getContext() != null && (context = this.factory.getPersistenceContext(call.getContext())) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Class[] parameters = new Class[call.getParameters().size()];
        Object[] args = new Object[call.getParameters().size()];
        int i = 0;
        for (Parameter param : call.getParameters()) {
            System.out.println("Got paramter " + param.getValue());
            Class<?> parameterClass = null;
            Object parameterValue = null;
            if (context != null) {
                parameterClass = context.getClass(param.getTypeName());
            }
            if (parameterClass != null) {
                parameterValue = context.unmarshalEntity(param.getTypeName(), null, hh.getMediaType(), is);
            } else {
                parameterClass = Thread.currentThread().getContextClassLoader().loadClass(param.getTypeName());
                parameterValue = ConversionManager.getDefaultManager().convertObject((Object)param.getValue(), parameterClass);
            }
            parameters[i] = parameterClass;
            args[i] = parameterValue;
            ++i;
        }
        Method method = ans.getClass().getMethod(call.getMethodName(), parameters);
        Object returnValue = method.invoke(ans, args);
        return Response.ok((Object)new StreamingOutputMarshaller(null, returnValue, hh.getAcceptableMediaTypes())).build();
    }

    @PUT
    @Path(value="{context}")
    public Response bootstrap(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @Context HttpHeaders hh, @Context UriInfo uriInfo, InputStream in) throws IOException, MalformedURLException {
        String urlString = this.getSingleHeader("persistenceXmlURL", hh);
        PersistenceContext persistenceContext = null;
        boolean replace = false;
        List replaceValues = hh.getRequestHeader("replace");
        if (replaceValues != null && replaceValues.size() > 0) {
            replace = Boolean.getBoolean((String)replaceValues.get(0));
        }
        HashMap properties = new HashMap();
        if (urlString != null) {
            URL url = new URL(urlString);
            persistenceContext = this.factory.bootstrapPersistenceContext(persistenceUnit, url, properties, replace);
        } else {
            persistenceContext = this.factory.bootstrapPersistenceContext(persistenceUnit, in, properties, replace);
        }
        if (persistenceContext != null) {
            persistenceContext.setBaseURI(uriInfo.getBaseUri());
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    @Path(value="{context}/metadata")
    public Response getTypes(@PathParam(value="context") String persistenceUnit, @Context HttpHeaders hh, @Context UriInfo uriInfo) {
        PersistenceContext app = this.get(persistenceUnit, uriInfo.getBaseUri());
        if (app == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PersistenceUnit pu = new PersistenceUnit();
        pu.setPersistenceUnitName(persistenceUnit);
        Map descriptors = JpaHelper.getServerSession((EntityManagerFactory)app.getEmf()).getDescriptors();
        String mediaType = StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()).toString();
        Iterator contextIterator = descriptors.keySet().iterator();
        while (contextIterator.hasNext()) {
            ClassDescriptor descriptor = (ClassDescriptor)descriptors.get(contextIterator.next());
            pu.getTypes().add(new Link(descriptor.getAlias(), mediaType, uriInfo.getBaseUri() + persistenceUnit + "/metadata/entity/" + descriptor.getAlias()));
        }
        String result = null;
        try {
            result = this.marshallMetadata(pu, mediaType);
        }
        catch (JAXBException jAXBException) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        Response.ResponseBuilder rb = Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, hh.getAcceptableMediaTypes()));
        rb.header("Content-Type", (Object)"application/json");
        return rb.build();
    }

    @DELETE
    @Path(value="{context}")
    public Response removeContext(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @Context HttpHeaders hh, InputStream in) {
        this.factory.closePersistenceContext(persistenceUnit);
        return Response.ok().build();
    }

    @PUT
    @Path(value="{context}/subscribe/{name}")
    public Response subscribe(@PathParam(value="context") String persistenceUnit, @PathParam(value="name") String name, @Context UriInfo ui) {
        PersistenceContext app = this.get(persistenceUnit, ui.getBaseUri());
        if (app == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        app.subscribeToEventNotification(name);
        return Response.ok().build();
    }

    @GET
    @Path(value="{context}/metadata/entity/{descriptorAlias}")
    public Response getDescriptorMetadata(@PathParam(value="context") String persistenceUnit, @PathParam(value="descriptorAlias") String descriptorAlias, @Context HttpHeaders hh, @Context UriInfo uriInfo) {
        PersistenceContext app = this.get(persistenceUnit, uriInfo.getBaseUri());
        if (app == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ClassDescriptor descriptor = JpaHelper.getServerSession((EntityManagerFactory)app.getEmf()).getDescriptorForAlias(descriptorAlias);
        if (descriptor == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String mediaType = StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()).toString();
        Descriptor returnDescriptor = this.buildDescriptor(app, persistenceUnit, descriptor, uriInfo.getBaseUri().toString());
        String result = null;
        try {
            result = this.marshallMetadata(returnDescriptor, mediaType);
        }
        catch (JAXBException jAXBException) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, hh.getAcceptableMediaTypes())).build();
    }

    @GET
    @Path(value="{context}/metadata/query/")
    public Response getQueriesMetadata(@PathParam(value="context") String persistenceUnit, @Context HttpHeaders hh, @Context UriInfo uriInfo) {
        PersistenceContext app = this.get(persistenceUnit, uriInfo.getBaseUri());
        if (app == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        this.addQueries(queries, app, null);
        String mediaType = StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()).toString();
        String result = null;
        try {
            result = this.marshallMetadata(queries, mediaType);
        }
        catch (JAXBException jAXBException) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, hh.getAcceptableMediaTypes())).build();
    }

    @GET
    @Path(value="{context}/metadata/query/{queryName}")
    public Response getQueryMetadata(@PathParam(value="context") String persistenceUnit, @PathParam(value="queryName") String queryName, @Context HttpHeaders hh, @Context UriInfo uriInfo) {
        PersistenceContext app = this.get(persistenceUnit, uriInfo.getBaseUri());
        if (app == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ArrayList<Query> returnQueries = new ArrayList<Query>();
        Map queries = JpaHelper.getServerSession((EntityManagerFactory)app.getEmf()).getQueries();
        if (queries.get(queryName) != null) {
            for (DatabaseQuery query : (List)queries.get(queryName)) {
                returnQueries.add(this.getQuery(query, app));
            }
        }
        String mediaType = StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()).toString();
        String result = null;
        try {
            result = this.marshallMetadata(returnQueries, mediaType);
        }
        catch (JAXBException jAXBException) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, hh.getAcceptableMediaTypes())).build();
    }

    @GET
    @Path(value="{context}/entity/{type}/{key}")
    public Response find(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="key") String key, @Context HttpHeaders hh, @Context UriInfo ui) {
        PersistenceContext app = this.get(persistenceUnit, ui.getBaseUri());
        if (app == null || app.getClass(type) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Object id = IdHelper.buildId(app, type, key);
        Object entity = app.find(this.getTenantId(hh), type, id, Service.getHintMap(ui));
        if (entity == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes())).build();
    }

    @PUT
    @Path(value="{context}/entity/{type}")
    public Response create(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @Context HttpHeaders hh, @Context UriInfo uriInfo, InputStream in) throws JAXBException {
        PersistenceContext app = this.get(persistenceUnit, uriInfo.getBaseUri());
        ClassDescriptor descriptor = app.getDescriptor(type);
        if (app == null || descriptor == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Object entity = null;
        try {
            entity = app.unmarshalEntity(type, this.getTenantId(hh), StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()), in);
        }
        catch (JAXBException jAXBException) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        AbstractDirectMapping sequenceMapping = descriptor.getObjectBuilder().getSequenceMapping();
        if (sequenceMapping != null) {
            Object value = sequenceMapping.getAttributeAccessor().getAttributeValueFromObject(entity);
            if (descriptor.getObjectBuilder().isPrimaryKeyComponentInvalid(value, descriptor.getPrimaryKeyFields().indexOf(descriptor.getSequenceNumberField())) || descriptor.getSequence().shouldAlwaysOverrideExistingValue()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        for (DatabaseMapping mapping : descriptor.getObjectBuilder().getRelationshipMappings()) {
            Object value;
            if (!mapping.isForeignReferenceMapping() || !((ForeignReferenceMapping)mapping).isCascadePersist() || (value = mapping.getAttributeAccessor().getAttributeValueFromObject(entity)) == null) continue;
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        app.create(this.getTenantId(hh), entity);
        Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.CREATED);
        rb.entity((Object)new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes()));
        return rb.build();
    }

    @POST
    @Path(value="{context}/entity/{type}")
    public Response update(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @Context HttpHeaders hh, @Context UriInfo uriInfo, InputStream in) {
        PersistenceContext app = this.get(persistenceUnit, uriInfo.getBaseUri());
        if (app == null || app.getClass(type) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String tenantId = this.getTenantId(hh);
        MediaType contentType = StreamingOutputMarshaller.mediaType(hh.getRequestHeader("Content-Type"));
        Object entity = null;
        try {
            entity = app.unmarshalEntity(type, tenantId, contentType, in);
        }
        catch (JAXBException jAXBException) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        entity = app.merge(tenantId, entity);
        return Response.ok((Object)new StreamingOutputMarshaller(app, entity, hh.getAcceptableMediaTypes())).build();
    }

    @DELETE
    @Path(value="{context}/entity/{type}/{key}")
    public Response delete(@PathParam(value="context") String persistenceUnit, @PathParam(value="type") String type, @PathParam(value="key") String key, @Context HttpHeaders hh, @Context UriInfo ui) {
        PersistenceContext app = this.get(persistenceUnit, ui.getBaseUri());
        if (app == null || app.getClass(type) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String tenantId = this.getTenantId(hh);
        Object id = IdHelper.buildId(app, type, key);
        app.delete(tenantId, type, id);
        return Response.ok().build();
    }

    @GET
    @Path(value="{context}/query/{name}")
    public Response namedQuery(@PathParam(value="context") String persistenceUnit, @PathParam(value="name") String name, @Context HttpHeaders hh, @Context UriInfo ui) {
        PersistenceContext app = this.get(persistenceUnit, ui.getBaseUri());
        if (app == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Object result = app.query(name, Service.getParameterMap(ui), Service.getHintMap(ui), false, false);
        return Response.ok((Object)new StreamingOutputMarshaller(app, result, hh.getAcceptableMediaTypes())).build();
    }

    @POST
    @Path(value="{context}/query/{name}")
    @Produces(value={"application/octet-stream"})
    public Response namedQueryUpdate(@PathParam(value="context") String persistenceUnit, @PathParam(value="name") String name, @Context HttpHeaders hh, @Context UriInfo ui) {
        PersistenceContext app = this.get(persistenceUnit, ui.getBaseUri());
        if (app == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Object result = app.query(name, Service.getParameterMap(ui), Service.getHintMap(ui), false, true);
        return Response.ok((Object)new StreamingOutputMarshaller(app, (Object)result.toString(), hh.getAcceptableMediaTypes())).build();
    }

    @GET
    @Path(value="{context}/singleResultQuery/{name}")
    @Produces(value={"*/*"})
    public Response namedQuerySingleResult(@PathParam(value="context") String persistenceUnit, @PathParam(value="name") String name, @Context HttpHeaders hh, @Context UriInfo ui) {
        PersistenceContext app = this.get(persistenceUnit, ui.getBaseUri());
        if (app == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Object result = app.query(name, Service.getParameterMap(ui), Service.getHintMap(ui), true, false);
        return Response.ok((Object)new StreamingOutputMarshaller(app, result, hh.getAcceptableMediaTypes())).build();
    }

    protected Descriptor buildDescriptor(PersistenceContext app, String persistenceUnit, ClassDescriptor descriptor, String baseUri) {
        Descriptor returnDescriptor = new Descriptor();
        returnDescriptor.setName(descriptor.getAlias());
        returnDescriptor.setType(descriptor.getJavaClassName());
        returnDescriptor.getLinkTemplates().add(new LinkTemplate("find", "get", String.valueOf(baseUri) + persistenceUnit + "/entity/" + descriptor.getAlias() + "/{primaryKey}"));
        returnDescriptor.getLinkTemplates().add(new LinkTemplate("persist", "put", String.valueOf(baseUri) + persistenceUnit + "/entity/" + descriptor.getAlias()));
        returnDescriptor.getLinkTemplates().add(new LinkTemplate("update", "post", String.valueOf(baseUri) + persistenceUnit + "/entity/" + descriptor.getAlias()));
        returnDescriptor.getLinkTemplates().add(new LinkTemplate("delete", "delete", String.valueOf(baseUri) + persistenceUnit + "/entity/" + descriptor.getAlias() + "/{primaryKey}"));
        if (!descriptor.getMappings().isEmpty()) {
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                this.addMapping(returnDescriptor, mapping);
            }
        }
        this.addQueries(returnDescriptor.getQueries(), app, descriptor.getJavaClassName());
        return returnDescriptor;
    }

    protected void addMapping(Descriptor descriptor, DatabaseMapping mapping) {
        String target = null;
        if (mapping.isCollectionMapping()) {
            CollectionMapping collectionMapping = (CollectionMapping)mapping;
            String collectionType = collectionMapping.getContainerPolicy().getContainerClassName();
            if (collectionMapping.getContainerPolicy().isMapPolicy()) {
                String mapKeyType = ((MapContainerPolicy)collectionMapping.getContainerPolicy()).getKeyType().toString();
                target = String.valueOf(collectionType) + "<" + mapKeyType + ", " + collectionMapping.getReferenceClassName() + ">";
            } else {
                target = String.valueOf(collectionType) + "<" + collectionMapping.getReferenceClassName() + ">";
            }
        } else {
            target = mapping.isForeignReferenceMapping() ? ((ForeignReferenceMapping)mapping).getReferenceClass().getName() : mapping.getAttributeClassification().getName();
        }
        descriptor.getAttributes().add(new Attribute(mapping.getAttributeName(), target));
    }

    protected void addQueries(List<Query> queryList, PersistenceContext app, String javaClassName) {
        Map queries = JpaHelper.getServerSession((EntityManagerFactory)app.getEmf()).getQueries();
        ArrayList<DatabaseQuery> returnQueries = new ArrayList<DatabaseQuery>();
        for (String key : queries.keySet()) {
            List keyQueries = (List)queries.get(key);
            for (DatabaseQuery query : keyQueries) {
                if (javaClassName != null && (query.getReferenceClassName() == null || !query.getReferenceClassName().equals(javaClassName))) continue;
                returnQueries.add(query);
            }
        }
        Iterator queryIterator = returnQueries.iterator();
        while (queryIterator.hasNext()) {
            queryList.add(this.getQuery((DatabaseQuery)queryIterator.next(), app));
        }
    }

    protected Query getQuery(DatabaseQuery query, PersistenceContext app) {
        String method = query.isReadQuery() ? "get" : "post";
        String jpql = query.getJPQLString() == null ? "" : query.getJPQLString();
        StringBuffer parameterString = new StringBuffer();
        for (String argument : query.getArguments()) {
            parameterString.append(";");
            parameterString.append(String.valueOf(argument) + "={" + argument + "}");
        }
        Query returnQuery = new Query(query.getName(), jpql, new LinkTemplate("execute", method, app.getBaseURI() + app.getName() + "/query/" + query.getName() + parameterString));
        if (query.isReportQuery()) {
            query.checkPrepare((AbstractSession)JpaHelper.getServerSession((EntityManagerFactory)app.getEmf()), (AbstractRecord)new DatabaseRecord());
            for (ReportItem item : ((ReportQuery)query).getItems()) {
                if (item.getMapping() != null) {
                    if (item.getAttributeExpression() != null && item.getAttributeExpression().isMapEntryExpression()) {
                        if (((MapEntryExpression)item.getAttributeExpression()).shouldReturnMapEntry()) {
                            returnQuery.getReturnTypes().add(Map.Entry.class.getName());
                            continue;
                        }
                        returnQuery.getReturnTypes().add(((Class)((CollectionMapping)item.getMapping()).getContainerPolicy().getKeyType()).getName());
                        continue;
                    }
                    returnQuery.getReturnTypes().add(item.getMapping().getAttributeClassification().getName());
                    continue;
                }
                if (item.getResultType() != null) {
                    returnQuery.getReturnTypes().add(item.getResultType().getName());
                    continue;
                }
                if (item.getDescriptor() != null) {
                    returnQuery.getReturnTypes().add(item.getDescriptor().getJavaClass().getName());
                    continue;
                }
                if (item.getAttributeExpression() != null && item.getAttributeExpression().isConstantExpression()) {
                    returnQuery.getReturnTypes().add(((ConstantExpression)item.getAttributeExpression()).getValue().getClass().getName());
                    continue;
                }
                returnQuery.getReturnTypes().add(ClassConstants.OBJECT.getName());
            }
        } else {
            returnQuery.getReturnTypes().add(query.getReferenceClassName() == null ? "" : query.getReferenceClassName());
        }
        return returnQuery;
    }

    @PreDestroy
    public void close() {
        this.factory.close();
    }

    private PersistenceContext get(String persistenceUnit, URI defaultURI) {
        PersistenceContext app = this.getPersistenceFactory().getPersistenceContext(persistenceUnit);
        if (app == null) {
            try {
                DynamicClassLoader dcl = new DynamicClassLoader(Thread.currentThread().getContextClassLoader());
                HashMap<String, DynamicClassLoader> properties = new HashMap<String, DynamicClassLoader>();
                properties.put("eclipselink.classloader", dcl);
                EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)persistenceUnit, properties);
                if (factory != null) {
                    app = this.getPersistenceFactory().bootstrapPersistenceContext(persistenceUnit, factory, defaultURI, true);
                }
            }
            catch (Exception exception) {}
        } else if (app.getBaseURI() == null) {
            app.setBaseURI(defaultURI);
        }
        if (app == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return app;
    }

    private static Map<String, Object> getHintMap(UriInfo info) {
        HashMap<String, Object> hints = new HashMap<String, Object>();
        for (String key : info.getQueryParameters().keySet()) {
            hints.put(key, info.getQueryParameters().getFirst((Object)key));
        }
        return hints;
    }

    private static Map<String, Object> getParameterMap(UriInfo info) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        PathSegment pathSegment = (PathSegment)info.getPathSegments().get(info.getPathSegments().size() - 1);
        for (Map.Entry entry : pathSegment.getMatrixParameters().entrySet()) {
            parameters.put((String)entry.getKey(), ((List)entry.getValue()).get(0));
        }
        return parameters;
    }

    private String getTenantId(HttpHeaders hh) {
        List tenantIdValues = hh.getRequestHeader("tenant-id");
        if (tenantIdValues == null || tenantIdValues.isEmpty()) {
            return null;
        }
        if (tenantIdValues.size() != 1) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        return (String)tenantIdValues.get(0);
    }

    private String getSingleHeader(String parameterName, HttpHeaders hh) {
        List params = hh.getRequestHeader(parameterName);
        if (params == null || params.isEmpty()) {
            return null;
        }
        if (params.size() != 1) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        return (String)params.get(0);
    }

    protected String marshallMetadata(Object metadata, String mediaType) throws JAXBException {
        Class[] jaxbClasses = new Class[]{Link.class, Attribute.class, Descriptor.class, LinkTemplate.class, PersistenceUnit.class, Query.class};
        JAXBContext context = (JAXBContext)JAXBContextFactory.createContext((Class[])jaxbClasses, null);
        JAXBMarshaller marshaller = context.createMarshaller();
        marshaller.setProperty("eclipselink.json.include-root", (Object)Boolean.FALSE);
        marshaller.setProperty("eclipselink.media-type", (Object)mediaType);
        StringWriter writer = new StringWriter();
        marshaller.marshal(metadata, (Writer)writer);
        return writer.toString();
    }

    protected SessionBeanCall unmarshallSessionBeanCall(InputStream data) throws JAXBException {
        Class[] jaxbClasses = new Class[]{SessionBeanCall.class};
        JAXBContext context = (JAXBContext)JAXBContextFactory.createContext((Class[])jaxbClasses, null);
        JAXBUnmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)Boolean.FALSE);
        unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        StreamSource ss = new StreamSource(data);
        return (SessionBeanCall)unmarshaller.unmarshal((Source)ss, SessionBeanCall.class).getValue();
    }
}

