/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.jpa.CMP3Policy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.Server;

public class IdHelper {
    private static final String SEPARATOR_STRING = "+";

    public static Object buildId(PersistenceContext app, String entityName, String idString) {
        Server session = JpaHelper.getServerSession((EntityManagerFactory)app.getEmf());
        ClassDescriptor descriptor = app.getDescriptor(entityName);
        List pkMappings = descriptor.getObjectBuilder().getPrimaryKeyMappings();
        ArrayList<SortableKey> pkIndices = new ArrayList<SortableKey>();
        int index = 0;
        for (DatabaseMapping mapping : pkMappings) {
            pkIndices.add(new SortableKey(mapping, index));
            ++index;
        }
        Collections.sort(pkIndices);
        int[] elementIndex = new int[pkMappings.size()];
        Object[] keyElements = new Object[pkMappings.size()];
        StringTokenizer tokenizer = new StringTokenizer(idString, SEPARATOR_STRING);
        int tokens = tokenizer.countTokens();
        if (tokens != pkMappings.size()) {
            throw new RuntimeException("Failed, incorrect number of keys values");
        }
        index = 0;
        Iterator iterator = pkIndices.iterator();
        while (tokenizer.hasMoreTokens()) {
            Object idValue;
            SortableKey key = (SortableKey)iterator.next();
            keyElements[key.getIndex()] = idValue = session.getPlatform().getConversionManager().convertObject((Object)tokenizer.nextToken(), key.getMapping().getAttributeClassification());
            ++index;
        }
        if (descriptor.hasCMPPolicy()) {
            CMP3Policy policy = (CMP3Policy)descriptor.getCMPPolicy();
            return policy.createPrimaryKeyInstanceFromPrimaryKeyValues((AbstractSession)session, elementIndex, keyElements);
        }
        if (keyElements.length == 1) {
            return keyElements[0];
        }
        return keyElements;
    }

    public static String stringifyId(DynamicEntityImpl entity, PersistenceContext app) {
        ClassDescriptor descriptor = app.getDescriptor(entity.getType().getName());
        List pkMappings = descriptor.getObjectBuilder().getPrimaryKeyMappings();
        if (pkMappings.isEmpty()) {
            return "";
        }
        ArrayList<SortableKey> pkIndices = new ArrayList<SortableKey>();
        int index = 0;
        for (DatabaseMapping mapping : pkMappings) {
            pkIndices.add(new SortableKey(mapping, index));
            ++index;
        }
        Collections.sort(pkIndices);
        StringBuffer key = new StringBuffer();
        Iterator sortableKeys = pkIndices.iterator();
        while (sortableKeys.hasNext()) {
            key.append(entity.get(((SortableKey)sortableKeys.next()).getMapping().getAttributeName()).toString());
            if (!sortableKeys.hasNext()) continue;
            key.append(SEPARATOR_STRING);
        }
        return key.toString();
    }

    public static Object buildObjectShell(PersistenceContext context, String entityType, Object id) {
        ClassDescriptor descriptor = context.getDescriptor(entityType);
        List pkMappings = descriptor.getObjectBuilder().getPrimaryKeyMappings();
        DynamicEntityImpl entity = null;
        if (descriptor.hasCMPPolicy()) {
            CMP3Policy policy = (CMP3Policy)descriptor.getCMPPolicy();
            entity = (DynamicEntityImpl)policy.createBeanUsingKey(id, (AbstractSession)JpaHelper.getDatabaseSession((EntityManagerFactory)context.getEmf()));
        } else {
            entity = (DynamicEntityImpl)context.newEntity(entityType);
            if (pkMappings.size() == 1) {
                entity.set(((DatabaseMapping)pkMappings.get(0)).getAttributeName(), id);
            } else {
                ArrayList<SortableKey> pkIndices = new ArrayList<SortableKey>();
                int index = 0;
                for (DatabaseMapping mapping : pkMappings) {
                    pkIndices.add(new SortableKey(mapping, index));
                    ++index;
                }
                Collections.sort(pkIndices);
                Object[] keyElements = (Object[])id;
                for (SortableKey key : pkIndices) {
                    entity.set(key.getMapping().getAttributeName(), keyElements[key.getIndex()]);
                }
            }
        }
        entity._persistence_setId(id);
        entity._persistence_setSession((Session)JpaHelper.getDatabaseSession((EntityManagerFactory)context.getEmf()));
        return entity;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortableKey
    implements Comparable<SortableKey> {
        private DatabaseMapping mapping;
        private int index;

        public SortableKey(DatabaseMapping mapping, int index) {
            this.mapping = mapping;
            this.index = index;
        }

        @Override
        public int compareTo(SortableKey o) {
            return this.mapping.getAttributeName().compareTo(o.getMapping().getAttributeName());
        }

        public DatabaseMapping getMapping() {
            return this.mapping;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

