/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedSetValueInField;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class InstanceVariableAttributeAccessor
extends AttributeAccessor {
    protected transient Field attributeField;

    public Class getAttributeClass() {
        if (this.getAttributeField() == null) {
            return null;
        }
        return this.getAttributeType();
    }

    public Field getAttributeField() {
        return this.attributeField;
    }

    public Class getAttributeType() {
        return this.attributeField.getType();
    }

    public Object getAttributeValueFromObject(Object anObject) throws DescriptorException {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedGetValueFromField(this.attributeField, anObject));
                }
                catch (PrivilegedActionException exception) {
                    throw DescriptorException.illegalAccesstWhileGettingValueThruInstanceVaraibleAccessor(this.getAttributeName(), anObject.getClass().getName(), exception.getException());
                }
            }
            return this.attributeField.get(anObject);
        }
        catch (IllegalArgumentException exception) {
            throw DescriptorException.illegalArgumentWhileGettingValueThruInstanceVariableAccessor(this.getAttributeName(), this.getAttributeType().getName(), anObject.getClass().getName(), exception);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccesstWhileGettingValueThruInstanceVaraibleAccessor(this.getAttributeName(), anObject.getClass().getName(), exception);
        }
        catch (NullPointerException exception) {
            String className = null;
            if (anObject != null) {
                className = anObject.getClass().getName();
            }
            throw DescriptorException.nullPointerWhileGettingValueThruInstanceVariableAccessor(this.getAttributeName(), className, exception);
        }
    }

    public void initializeAttributes(Class theJavaClass) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
        try {
            this.setAttributeField(Helper.getField(theJavaClass, this.getAttributeName()));
        }
        catch (NoSuchFieldException exception) {
            throw DescriptorException.noSuchFieldWhileInitializingAttributesInInstanceVariableAccessor(this.getAttributeName(), theJavaClass.getName(), exception);
        }
        catch (SecurityException exception) {
            throw DescriptorException.securityWhileInitializingAttributesInInstanceVariableAccessor(this.getAttributeName(), theJavaClass.getName(), exception);
        }
    }

    public boolean isInitialized() {
        return this.attributeField != null;
    }

    public boolean isInstanceVariableAttributeAccessor() {
        return true;
    }

    protected void setAttributeField(Field field) {
        this.attributeField = field;
    }

    public void setAttributeValueInObject(Object anObject, Object value) throws DescriptorException {
        block30: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        AccessController.doPrivileged(new PrivilegedSetValueInField(this.attributeField, anObject, value));
                        break block30;
                    }
                    catch (PrivilegedActionException exception) {
                        throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), value, exception.getException());
                    }
                }
                this.attributeField.set(anObject, value);
            }
            catch (IllegalArgumentException exception) {
                try {
                    if (value == null) {
                        Class fieldClass = this.getAttributeClass();
                        if (Helper.isPrimitiveWrapper(fieldClass)) {
                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                try {
                                    AccessController.doPrivileged(new PrivilegedSetValueInField(this.attributeField, anObject, ConversionManager.getDefaultManager().convertObject(0, fieldClass)));
                                }
                                catch (PrivilegedActionException exc) {
                                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), value, exc.getException());
                                }
                            } else {
                                PrivilegedAccessHelper.setValueInField(this.attributeField, anObject, ConversionManager.getDefaultManager().convertObject(0, fieldClass));
                            }
                        }
                        return;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), value, exception);
                }
                try {
                    if (value instanceof String) {
                        Object newValue = ConversionManager.getDefaultManager().convertObject(value, this.getAttributeClass());
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                AccessController.doPrivileged(new PrivilegedSetValueInField(this.attributeField, anObject, newValue));
                            }
                            catch (PrivilegedActionException privilegedActionException) {}
                        } else {
                            PrivilegedAccessHelper.setValueInField(this.attributeField, anObject, newValue);
                        }
                        return;
                    }
                }
                catch (Exception exception2) {}
                throw DescriptorException.illegalArgumentWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), this.getAttributeType().getName(), value, exception);
            }
            catch (IllegalAccessException exception) {
                if (value == null) {
                    return;
                }
                throw DescriptorException.illegalAccessWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), anObject.getClass().getName(), value, exception);
            }
            catch (NullPointerException exception) {
                try {
                    if (anObject != null) {
                        Class fieldClass = this.getAttributeClass();
                        if (Helper.isPrimitiveWrapper(fieldClass) && value == null) {
                            if (!Helper.isPrimitiveWrapper(fieldClass)) break block30;
                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                try {
                                    AccessController.doPrivileged(new PrivilegedSetValueInField(this.attributeField, anObject, ConversionManager.getDefaultManager().convertObject(0, fieldClass)));
                                }
                                catch (PrivilegedActionException exc) {
                                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), value, exc.getException());
                                }
                            }
                            PrivilegedAccessHelper.setValueInField(this.attributeField, anObject, ConversionManager.getDefaultManager().convertObject(0, fieldClass));
                        }
                        throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), value, exception);
                    }
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), value, exception);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), value, exception);
                }
            }
        }
    }
}

