/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.WeakObjectWrapper;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLObjectBuilder
extends ObjectBuilder {
    private Boolean isXMLDescriptor;
    private boolean xsiTypeIndicatorField;

    public XMLObjectBuilder(ClassDescriptor descriptor) {
        super(descriptor);
    }

    public AbstractRecord buildRow(Object object, AbstractSession session, DatabaseField xmlField, XMLRecord parentRecord) {
        if (this.isXmlDescriptor() && ((XMLDescriptor)this.getDescriptor()).shouldPreserveDocument()) {
            CacheKey cacheKey;
            Object pk = this.extractPrimaryKeyFromObject(object, session);
            if (pk == null || pk instanceof CacheId && ((CacheId)pk).getPrimaryKey().length == 0) {
                pk = new CacheId(new Object[]{new WeakObjectWrapper(object)});
            }
            if ((cacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(pk, this.getDescriptor().getJavaClass(), this.getDescriptor(), false)) != null && cacheKey.getRecord() != null) {
                XMLRecord nestedRecord = (XMLRecord)cacheKey.getRecord();
                nestedRecord.setMarshaller(parentRecord.getMarshaller());
                nestedRecord.setLeafElementType(parentRecord.getLeafElementType());
                parentRecord.setLeafElementType((XPathQName)null);
                return this.buildIntoNestedRow(nestedRecord, object, session);
            }
        }
        Element newNode = XPathEngine.getInstance().createUnownedElement(parentRecord.getDOM(), (XMLField)xmlField);
        DOMRecord nestedRecord = new DOMRecord(newNode);
        nestedRecord.setNamespaceResolver(parentRecord.getNamespaceResolver());
        nestedRecord.setMarshaller(parentRecord.getMarshaller());
        nestedRecord.setLeafElementType(parentRecord.getLeafElementType());
        parentRecord.setLeafElementType((XPathQName)null);
        return this.buildIntoNestedRow(nestedRecord, object, session);
    }

    public AbstractRecord createRecord(AbstractSession session) {
        return this.createRecord(this.getDescriptor().getTableName(), session);
    }

    public AbstractRecord createRecord(int size, AbstractSession session) {
        return this.createRecord(this.getDescriptor().getTableName(), session);
    }

    public AbstractRecord createRecord(String rootName, AbstractSession session) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        DOMRecord xmlRec = new DOMRecord(rootName, namespaceResolver);
        xmlRec.setSession(session);
        return xmlRec;
    }

    public AbstractRecord createRecord(String rootName, String rootUri, AbstractSession session) {
        DOMRecord xmlRec = new DOMRecord(rootName, rootUri);
        xmlRec.setSession(session);
        return xmlRec;
    }

    public AbstractRecord createRecord(String rootName, Node parent, AbstractSession session) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        DOMRecord xmlRec = new DOMRecord(rootName, namespaceResolver, parent);
        xmlRec.setSession(session);
        return xmlRec;
    }

    public AbstractRecord createRecordFor(Object attributeValue, XMLField xmlField, XMLRecord parentRecord, XMLMapping mapping) {
        DocumentPreservationPolicy policy = parentRecord.getDocPresPolicy();
        Element newNode = null;
        if (policy != null) {
            newNode = (Element)policy.getNodeForObject(attributeValue);
        }
        if (newNode == null) {
            newNode = XPathEngine.getInstance().createUnownedElement(parentRecord.getDOM(), xmlField);
            if (xmlField.isSelfField()) {
                policy.addObjectToCache(attributeValue, newNode, mapping);
            } else {
                policy.addObjectToCache(attributeValue, newNode);
            }
        }
        DOMRecord nestedRecord = new DOMRecord(newNode);
        nestedRecord.setMarshaller(parentRecord.getMarshaller());
        nestedRecord.setLeafElementType(parentRecord.getLeafElementType());
        parentRecord.setLeafElementType((XPathQName)null);
        nestedRecord.setDocPresPolicy(policy);
        nestedRecord.setXOPPackage(parentRecord.isXOPPackage());
        return nestedRecord;
    }

    public AbstractRecord createRecordFor(Object object, DocumentPreservationPolicy docPresPolicy) {
        Element cachedNode = null;
        DOMRecord record = null;
        if (docPresPolicy != null) {
            cachedNode = (Element)docPresPolicy.getNodeForObject(object);
        }
        if (cachedNode == null) {
            record = new DOMRecord(this.getDescriptor().getTableName(), this.getNamespaceResolver());
            docPresPolicy.addObjectToCache(object, ((XMLRecord)record).getDOM());
        } else {
            record = new DOMRecord(cachedNode);
        }
        record.setDocPresPolicy(docPresPolicy);
        return record;
    }

    public AbstractRecord createRecordFor(Object object, DocumentPreservationPolicy docPresPolicy, String rootName, String rootUri) {
        Element cachedNode = null;
        DOMRecord record = null;
        if (docPresPolicy != null) {
            cachedNode = (Element)docPresPolicy.getNodeForObject(object);
        }
        if (cachedNode == null) {
            record = new DOMRecord(rootName, rootUri);
            docPresPolicy.addObjectToCache(object, ((XMLRecord)record).getDOM());
        } else {
            record = new DOMRecord(cachedNode);
        }
        record.setDocPresPolicy(docPresPolicy);
        return record;
    }

    protected AbstractRecord createRecordForPKExtraction(int size, AbstractSession session) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        DOMRecord xmlRec = new DOMRecord(this.getDescriptor().getTableName(), namespaceResolver);
        xmlRec.setSession(session);
        return xmlRec;
    }

    public Object buildObject(ObjectBuildingQuery query, AbstractRecord databaseRow, JoinedAttributeManager joinManager) throws DatabaseException, QueryException {
        DocumentPreservationPolicy docPresPolicy;
        XMLRecord row = (XMLRecord)databaseRow;
        row.setSession(query.getSession());
        XMLUnmarshaller unmarshaller = row.getUnmarshaller();
        Object parent = row.getOwningObject();
        Object pk = this.extractPrimaryKeyFromRow(databaseRow, query.getSession());
        if (!this.isXmlDescriptor() && !this.getDescriptor().isDescriptorTypeAggregate()) {
            return super.buildObject(query, databaseRow, joinManager);
        }
        query.getSession().startOperationProfile("Timer:ObjectBuilding", query, Integer.MAX_VALUE);
        ClassDescriptor concreteDescriptor = this.getDescriptor();
        Object domainObject = null;
        if (concreteDescriptor.hasInheritance() && parent == null) {
            QName leafElementType;
            Class classValue = concreteDescriptor.getInheritancePolicy().classFromRow(databaseRow, query.getSession());
            if (classValue == null && this.isXmlDescriptor() && (leafElementType = ((XMLDescriptor)concreteDescriptor).getDefaultRootElementType()) != null) {
                XPathQName xpathQName = new XPathQName(leafElementType, row.isNamespaceAware());
                Object indicator = concreteDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(xpathQName);
                if (indicator != null) {
                    classValue = (Class)indicator;
                }
            }
            if (classValue != null) {
                concreteDescriptor = query.getSession().getDescriptor(classValue);
                if (concreteDescriptor == null && query.hasPartialAttributeExpressions()) {
                    concreteDescriptor = this.getDescriptor();
                }
                if (concreteDescriptor == null) {
                    throw QueryException.noDescriptorForClassFromInheritancePolicy(query, classValue);
                }
            } else if (Modifier.isAbstract(concreteDescriptor.getJavaClass().getModifiers())) {
                throw DescriptorException.missingClassIndicatorField(databaseRow, concreteDescriptor.getInheritancePolicy().getDescriptor());
            }
        }
        domainObject = concreteDescriptor.getObjectBuilder().buildNewInstance();
        row.setCurrentObject(domainObject);
        if (unmarshaller != null && unmarshaller.getUnmarshalListener() != null) {
            unmarshaller.getUnmarshalListener().beforeUnmarshal(domainObject, parent);
        }
        concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(domainObject, null, databaseRow, query, joinManager, false, query.getSession());
        if (this.isXmlDescriptor() && ((XMLDescriptor)concreteDescriptor).getPrimaryKeyFieldNames().size() > 0) {
            if (pk == null || ((CacheId)pk).getPrimaryKey().length == 0) {
                pk = new CacheId(new Object[]{new WeakObjectWrapper(domainObject)});
            }
            CacheKey key = query.getSession().getIdentityMapAccessorInstance().acquireDeferredLock(pk, concreteDescriptor.getJavaClass(), concreteDescriptor);
            if (((XMLDescriptor)concreteDescriptor).shouldPreserveDocument()) {
                key.setRecord(databaseRow);
            }
            key.setObject(domainObject);
            key.releaseDeferredLock();
        }
        if ((docPresPolicy = ((DOMRecord)row).getDocPresPolicy()) != null) {
            ((DOMRecord)row).getDocPresPolicy().addObjectToCache(domainObject, ((DOMRecord)row).getDOM());
        }
        query.getSession().endOperationProfile("Timer:ObjectBuilding", query, Integer.MAX_VALUE);
        if (unmarshaller != null && unmarshaller.getUnmarshalListener() != null) {
            unmarshaller.getUnmarshalListener().afterUnmarshal(domainObject, parent);
        }
        return domainObject;
    }

    public AbstractRecord buildRow(AbstractRecord databaseRow, Object object, AbstractSession session) {
        return this.buildRow(databaseRow, object, session, false);
    }

    public AbstractRecord buildRow(AbstractRecord databaseRow, Object object, AbstractSession session, boolean wasXMLRoot) {
        XMLRecord row = (XMLRecord)databaseRow;
        row.setSession(session);
        XMLMarshaller marshaller = row.getMarshaller();
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().beforeMarshal(object);
        }
        this.writeOutMappings(row, object, session);
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(row);
        }
        this.addNamespaceDeclarations(row.getDocument());
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().afterMarshal(object);
        }
        return row;
    }

    public void writeOutMappings(XMLRecord row, Object object, AbstractSession session) {
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        int index = 0;
        while (index < mappings.size()) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            mapping.writeFromObjectIntoRow(object, row, session, DatabaseMapping.WriteType.UNDEFINED);
            ++index;
        }
    }

    public void addNamespaceDeclarations(Document document) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        if (namespaceResolver == null) {
            return;
        }
        Element docElement = document.getDocumentElement();
        if (namespaceResolver.getDefaultNamespaceURI() != null) {
            docElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceResolver.getDefaultNamespaceURI());
        }
        Enumeration prefixes = namespaceResolver.getPrefixes();
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            String namespace = namespaceResolver.resolveNamespacePrefix(prefix);
            docElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
        }
    }

    public void buildAttributesIntoObject(Object domainObject, CacheKey cacheKey, AbstractRecord databaseRow, ObjectBuildingQuery query, JoinedAttributeManager joinManager, boolean forRefresh, AbstractSession targetSession) throws DatabaseException {
        ((XMLRecord)databaseRow).setSession(query.getSession().getExecutionSession(query));
        super.buildAttributesIntoObject(domainObject, cacheKey, databaseRow, query, joinManager, forRefresh, targetSession);
    }

    public AbstractRecord extractPrimaryKeyRowFromExpression(Expression expression, AbstractRecord translationRow, AbstractSession session) {
        AbstractRecord primaryKeyRow = this.createRecord(this.getPrimaryKeyMappings().size(), session);
        expression.getBuilder().setSession(session.getRootSession(null));
        boolean isValid = expression.extractPrimaryKeyValues(true, this.getDescriptor(), primaryKeyRow, translationRow);
        if (!isValid) {
            return null;
        }
        if (primaryKeyRow.size() != this.getDescriptor().getPrimaryKeyFields().size()) {
            return null;
        }
        return primaryKeyRow;
    }

    public Object extractPrimaryKeyFromExpression(boolean requiresExactMatch, Expression expression, AbstractRecord translationRow, AbstractSession session) {
        AbstractRecord primaryKeyRow = this.createRecord(this.getPrimaryKeyMappings().size(), session);
        expression.getBuilder().setSession(session.getRootSession(null));
        boolean isValid = expression.extractPrimaryKeyValues(requiresExactMatch, this.getDescriptor(), primaryKeyRow, translationRow);
        if (requiresExactMatch && !isValid) {
            return null;
        }
        if (primaryKeyRow.size() != this.getDescriptor().getPrimaryKeyFields().size()) {
            return null;
        }
        return this.extractPrimaryKeyFromRow(primaryKeyRow, session);
    }

    public Object extractPrimaryKeyFromObject(Object domainObject, AbstractSession session) {
        if (this.getDescriptor().hasInheritance() && domainObject.getClass() != this.getDescriptor().getJavaClass() && !domainObject.getClass().getSuperclass().equals(this.getDescriptor().getJavaClass())) {
            return session.getDescriptor(domainObject.getClass()).getObjectBuilder().extractPrimaryKeyFromObject(domainObject, session);
        }
        List<DatabaseField> descriptorPrimaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        if (descriptorPrimaryKeyFields == null || descriptorPrimaryKeyFields.size() == 0) {
            return null;
        }
        return super.extractPrimaryKeyFromObject(domainObject, session);
    }

    public AbstractRecord buildIntoNestedRow(AbstractRecord row, Object object, AbstractSession session) {
        return this.buildIntoNestedRow(row, null, object, session, null, null, false);
    }

    public AbstractRecord buildIntoNestedRow(AbstractRecord row, Object object, AbstractSession session, XMLDescriptor refDesc, XMLField xmlField) {
        return this.buildIntoNestedRow(row, null, object, session, refDesc, xmlField, false);
    }

    public AbstractRecord buildIntoNestedRow(AbstractRecord row, Object originalObject, Object object, AbstractSession session, XMLDescriptor refDesc, XMLField xmlField, boolean wasXMLRoot) {
        XMLRecord record = (XMLRecord)row;
        record.setSession(session);
        XMLMarshaller marshaller = record.getMarshaller();
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().beforeMarshal(object);
        }
        List extraNamespaces = null;
        if (this.isXmlDescriptor()) {
            XMLDescriptor xmlDescriptor = (XMLDescriptor)this.getDescriptor();
            extraNamespaces = this.addExtraNamespacesToNamespaceResolver(xmlDescriptor, record, session, false, false);
            this.writeExtraNamespaces(extraNamespaces, record);
            this.addXsiTypeAndClassIndicatorIfRequired(record, xmlDescriptor, refDesc, xmlField, originalObject, object, wasXMLRoot, false);
        }
        this.writeOutMappings(record, object, session);
        if (this.isXmlDescriptor()) {
            XMLDescriptor cfr_ignored_0 = (XMLDescriptor)this.getDescriptor();
            this.removeExtraNamespacesFromNamespaceResolver(record, extraNamespaces, session);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(row);
        }
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().afterMarshal(object);
        }
        return row;
    }

    protected void writeXsiTypeAttribute(XMLDescriptor xmlDescriptor, XMLRecord row, QName typeValueQName, boolean addToNamespaceResolver) {
        if (typeValueQName == null) {
            return;
        }
        String typeValue = typeValueQName.getLocalPart();
        String uri = typeValueQName.getNamespaceURI();
        if (row.isNamespaceAware() && uri != null && !uri.equals("") && !uri.equals(row.getNamespaceResolver().getDefaultNamespaceURI())) {
            String prefix = row.getNamespaceResolver().resolveNamespaceURI(uri);
            if (prefix != null && !prefix.equals("")) {
                typeValue = String.valueOf(prefix) + row.getNamespaceSeparator() + typeValue;
            } else if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
                prefix = row.getNamespaceResolver().generatePrefix("xsd");
                typeValue = String.valueOf(prefix) + row.getNamespaceSeparator() + typeValue;
                this.writeNamespace(row, prefix, uri, addToNamespaceResolver);
            } else if (typeValueQName.getPrefix() != null && !typeValueQName.getPrefix().equals("")) {
                typeValue = String.valueOf(typeValueQName.getPrefix()) + row.getNamespaceSeparator() + typeValue;
                this.writeNamespace(row, typeValueQName.getPrefix(), uri, addToNamespaceResolver);
            }
        }
        this.writeXsiTypeAttribute(xmlDescriptor, row, typeValue, addToNamespaceResolver);
    }

    protected void writeXsiTypeAttribute(XMLDescriptor xmlDescriptor, XMLRecord row, String typeValue, boolean addToNamespaceResolver) {
        if (xmlDescriptor == null) {
            this.writeXsiTypeAttribute(row, typeValue, addToNamespaceResolver);
            return;
        }
        XMLField xmlField = null;
        if (row.isNamespaceAware()) {
            String xsiPrefix = null;
            boolean generated = false;
            xsiPrefix = row.getNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
            if (xsiPrefix == null) {
                xsiPrefix = xmlDescriptor.getNonNullNamespaceResolver().generatePrefix("xsi");
                generated = true;
                this.writeNamespace(row, xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance", addToNamespaceResolver);
            }
            xmlField = (XMLField)xmlDescriptor.buildField(XMLConstants.ATTRIBUTE + xsiPrefix + ':' + "type");
            if (generated) {
                xmlField.getLastXPathFragment().setGeneratedPrefix(true);
            }
        } else {
            xmlField = (XMLField)xmlDescriptor.buildField(XMLConstants.ATTRIBUTE + "type");
        }
        xmlField.getLastXPathFragment().setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        row.add(xmlField, typeValue);
    }

    protected void writeXsiTypeAttribute(XMLRecord row, String typeValue, boolean addToNamespaceResolver) {
        XMLField xmlField = null;
        if (row.isNamespaceAware()) {
            String xsiPrefix = null;
            boolean generated = false;
            xsiPrefix = row.getNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
            if (xsiPrefix == null) {
                xsiPrefix = "xsi";
                generated = true;
                this.writeNamespace(row, xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance", addToNamespaceResolver);
            }
            xmlField = new XMLField(XMLConstants.ATTRIBUTE + xsiPrefix + ':' + "type");
            if (generated) {
                xmlField.getLastXPathFragment().setGeneratedPrefix(true);
            }
        } else {
            xmlField = new XMLField(XMLConstants.ATTRIBUTE + "type");
        }
        xmlField.getLastXPathFragment().setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        row.add(xmlField, typeValue);
    }

    protected XMLField writeNamespace(XMLRecord nestedRecord, String prefix, String url, boolean addToNamespaceResolver) {
        String existingPrefix = nestedRecord.getNamespaceResolver().resolveNamespaceURI(url);
        if (existingPrefix == null || existingPrefix != null && !existingPrefix.equals("") && !existingPrefix.equals(prefix)) {
            XMLField xmlField = new XMLField("@xmlns:" + prefix);
            xmlField.setNamespaceResolver(nestedRecord.getNamespaceResolver());
            xmlField.getXPathFragment().setNamespaceURI("http://www.w3.org/2000/xmlns/");
            nestedRecord.add(xmlField, url);
            if (addToNamespaceResolver) {
                nestedRecord.getNamespaceResolver().put(prefix, url);
            }
            return xmlField;
        }
        return null;
    }

    public NamespaceResolver getNamespaceResolver() {
        NamespaceResolver namespaceResolver = null;
        if (this.isXmlDescriptor()) {
            namespaceResolver = ((XMLDescriptor)this.getDescriptor()).getNamespaceResolver();
        } else if (this.getDescriptor() instanceof EISDescriptor) {
            namespaceResolver = ((EISDescriptor)this.getDescriptor()).getNamespaceResolver();
        }
        return namespaceResolver;
    }

    protected boolean isXmlDescriptor() {
        if (this.isXMLDescriptor == null) {
            this.isXMLDescriptor = this.getDescriptor() instanceof XMLDescriptor;
        }
        return this.isXMLDescriptor;
    }

    public void setDescriptor(ClassDescriptor aDescriptor) {
        super.setDescriptor(aDescriptor);
        this.isXMLDescriptor = null;
    }

    protected List addExtraNamespacesToNamespaceResolver(XMLDescriptor desc, XMLRecord marshalRecord, AbstractSession session) {
        return this.addExtraNamespacesToNamespaceResolver(desc, marshalRecord, session, true, false);
    }

    protected List addExtraNamespacesToNamespaceResolver(XMLDescriptor desc, XMLRecord marshalRecord, AbstractSession session, boolean allowOverride, boolean ignoreEqualResolvers) {
        if (((XMLLogin)session.getDatasourceLogin()).hasEqualNamespaceResolvers() && !ignoreEqualResolvers) {
            return null;
        }
        NamespaceResolver descriptorNamespaceResolver = desc.getNamespaceResolver();
        if (descriptorNamespaceResolver == null || !descriptorNamespaceResolver.hasPrefixesToNamespaces()) {
            return null;
        }
        Map<String, String> prefixesToNamespaces = descriptorNamespaceResolver.getPrefixesToNamespaces();
        if (prefixesToNamespaces.size() == 0) {
            return null;
        }
        ArrayList<Namespace> returnList = new ArrayList<Namespace>(prefixesToNamespaces.size());
        NamespaceResolver marshalRecordNamespaceResolver = marshalRecord.getNamespaceResolver();
        for (Map.Entry<String, String> entry : prefixesToNamespaces.entrySet()) {
            String prefix = marshalRecordNamespaceResolver.resolveNamespaceURI(entry.getValue());
            if (prefix == null || prefix.length() == 0) {
                String newPrefix;
                prefix = entry.getKey();
                if (marshalRecord.hasCustomNamespaceMapper() && (newPrefix = marshalRecord.getMarshaller().getNamespacePrefixMapper().getPreferredPrefix(entry.getValue(), prefix, true)) != null && newPrefix.length() != 0) {
                    prefix = newPrefix;
                }
                String uri = marshalRecordNamespaceResolver.resolveNamespacePrefix(prefix);
                if (!marshalRecord.hasCustomNamespaceMapper() && !allowOverride && uri != null && uri.length() != 0) continue;
                marshalRecordNamespaceResolver.put(entry.getKey(), entry.getValue());
                returnList.add(new Namespace(prefix, entry.getValue()));
                continue;
            }
            if (!allowOverride || prefix.equals(entry.getKey()) || marshalRecord.hasCustomNamespaceMapper()) continue;
            marshalRecordNamespaceResolver.put(entry.getKey(), entry.getValue());
            returnList.add(new Namespace(entry.getKey(), entry.getValue()));
        }
        return returnList;
    }

    public void writeExtraNamespaces(List extraNamespaces, XMLRecord xmlRecord) {
        if (extraNamespaces == null) {
            return;
        }
        if (xmlRecord.getDOM().getNodeType() != 1) {
            return;
        }
        int i = 0;
        while (i < extraNamespaces.size()) {
            Namespace next = (Namespace)extraNamespaces.get(i);
            ((Element)xmlRecord.getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + next.getPrefix(), next.getNamespaceURI());
            ++i;
        }
    }

    public void removeExtraNamespacesFromNamespaceResolver(XMLRecord marshalRecord, List extraNamespaces, AbstractSession session) {
        if (extraNamespaces == null) {
            return;
        }
        int i = 0;
        while (i < extraNamespaces.size()) {
            Namespace nextExtraNamespace = (Namespace)extraNamespaces.get(i);
            String uri = marshalRecord.getNamespaceResolver().resolveNamespacePrefix(nextExtraNamespace.getPrefix());
            if (uri != null && uri.equals(nextExtraNamespace.getNamespaceURI())) {
                marshalRecord.getNamespaceResolver().removeNamespace(nextExtraNamespace.getPrefix());
            }
            ++i;
        }
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        XMLField indicatorField;
        DatabaseMapping sequenceMapping;
        this.mappingsByField.clear();
        if (this.readOnlyMappingsByField != null) {
            this.readOnlyMappingsByField.clear();
        }
        if (this.mappingsByAttribute != null) {
            this.mappingsByAttribute.clear();
        }
        this.cloningMappings.clear();
        if (this.eagerMappings != null) {
            this.eagerMappings.clear();
        }
        if (this.relationshipMappings != null) {
            this.relationshipMappings.clear();
        }
        Enumeration<DatabaseMapping> mappings = this.descriptor.getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            if (!mapping.isWriteOnly() && this.mappingsByAttribute != null) {
                this.getMappingsByAttribute().put(mapping.getAttributeName(), mapping);
            }
            if (mapping.isCloningRequired()) {
                this.getCloningMappings().add(mapping);
            }
            if (mapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)mapping).usesIndirection() && !mapping.isLazy()) {
                this.getEagerMappings().add(mapping);
            }
            if (!mapping.isDirectToFieldMapping() && this.relationshipMappings != null) {
                this.relationshipMappings.add(mapping);
            }
            for (DatabaseField field : mapping.getFields()) {
                if (mapping.isReadOnly()) {
                    if (this.readOnlyMappingsByField == null) continue;
                    List<DatabaseMapping> readOnlyMappings = this.getReadOnlyMappingsByField().get(field);
                    if (readOnlyMappings == null) {
                        readOnlyMappings = new ArrayList<DatabaseMapping>();
                        this.getReadOnlyMappingsByField().put(field, readOnlyMappings);
                    }
                    readOnlyMappings.add(mapping);
                    continue;
                }
                if (mapping.isAggregateObjectMapping()) {
                    ObjectBuilder aggregateObjectBuilder = ((AggregateObjectMapping)mapping).getReferenceDescriptor().getObjectBuilder();
                    DatabaseMapping aggregatedFieldMapping = aggregateObjectBuilder.getMappingForField(field);
                    if (aggregatedFieldMapping == null) {
                        List<DatabaseMapping> readOnlyMappings = this.getReadOnlyMappingsByField().get(field);
                        if (readOnlyMappings == null) {
                            readOnlyMappings = new ArrayList<DatabaseMapping>();
                            this.getReadOnlyMappingsByField().put(field, readOnlyMappings);
                        }
                        readOnlyMappings.add(mapping);
                        continue;
                    }
                    this.getMappingsByField().put(field, mapping);
                    continue;
                }
                if (this.getMappingsByField().containsKey(field)) continue;
                this.getMappingsByField().put(field, mapping);
            }
        }
        this.isSimple = this.relationshipMappings == null || this.relationshipMappings.isEmpty();
        this.initializePrimaryKey(session);
        this.initializeJoinedAttributes();
        if (this.descriptor.usesSequenceNumbers() && (sequenceMapping = this.getMappingForField(this.descriptor.getSequenceNumberField())) != null && sequenceMapping.isDirectToFieldMapping()) {
            this.setSequenceMapping((AbstractDirectMapping)sequenceMapping);
        }
        if (this.descriptor.hasInheritance() && (indicatorField = (XMLField)this.descriptor.getInheritancePolicy().getClassIndicatorField()) != null && indicatorField.getLastXPathFragment().getNamespaceURI() != null && indicatorField.getLastXPathFragment().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance") && indicatorField.getLastXPathFragment().getLocalName().equals("type")) {
            this.xsiTypeIndicatorField = true;
        }
    }

    public boolean isXMLObjectBuilder() {
        return true;
    }

    public boolean addXsiTypeAndClassIndicatorIfRequired(XMLRecord record, XMLDescriptor xmlDescriptor, XMLDescriptor referenceDescriptor, XMLField xmlField, Object originalObject, Object obj, boolean wasXMLRoot, boolean addToNamespaceResolver) {
        if (wasXMLRoot) {
            XMLSchemaReference xmlRef = xmlDescriptor.getSchemaReference();
            if (this.descriptor != null) {
                XMLRoot xr = (XMLRoot)originalObject;
                if (xmlDescriptor.getSchemaReference() == null) {
                    return false;
                }
                XPathQName qName = new XPathQName(xr.getNamespaceURI(), xr.getLocalName(), record.isNamespaceAware());
                XMLDescriptor xdesc = record.getMarshaller().getXMLContext().getDescriptor(qName);
                if (xdesc != null) {
                    boolean writeTypeAttribute;
                    boolean bl = writeTypeAttribute = xdesc.getJavaClass() != this.descriptor.getJavaClass();
                    if (writeTypeAttribute && xmlRef != null) {
                        QName typeValueQName = this.getTypeValueToWriteAsQName(record, xdesc, xmlRef, addToNamespaceResolver);
                        this.writeXsiTypeAttribute(xmlDescriptor, record, typeValueQName, addToNamespaceResolver);
                        return true;
                    }
                    return false;
                }
                if (xr.getDeclaredType() != null && xr.getDeclaredType() == xr.getObject().getClass()) {
                    return false;
                }
                String xmlRootLocalName = xr.getLocalName();
                String xmlRootUri = xr.getNamespaceURI();
                boolean writeTypeAttribute = true;
                int i = 0;
                while (i < this.descriptor.getTableNames().size()) {
                    if (!writeTypeAttribute) {
                        return false;
                    }
                    String defaultRootQualifiedName = (String)xmlDescriptor.getTableNames().get(i);
                    if (defaultRootQualifiedName != null) {
                        String defaultRootLocalName = null;
                        String defaultRootUri = null;
                        int colonIndex = defaultRootQualifiedName.indexOf(58);
                        if (colonIndex > 0) {
                            String defaultRootPrefix = defaultRootQualifiedName.substring(0, colonIndex);
                            defaultRootLocalName = defaultRootQualifiedName.substring(colonIndex + 1);
                            if (xmlDescriptor.getNamespaceResolver() != null) {
                                defaultRootUri = xmlDescriptor.getNamespaceResolver().resolveNamespacePrefix(defaultRootPrefix);
                            }
                        } else {
                            defaultRootLocalName = defaultRootQualifiedName;
                        }
                        if (xmlRootLocalName != null && (defaultRootLocalName == null && xmlRootLocalName == null || defaultRootLocalName.equals(xmlRootLocalName)) && (defaultRootUri == null && xmlRootUri == null || xmlRootUri != null && defaultRootUri != null && defaultRootUri.equals(xmlRootUri))) {
                            return false;
                        }
                    } else if (xmlRootLocalName == null) {
                        return false;
                    }
                    ++i;
                }
                if (writeTypeAttribute && xmlRef != null) {
                    QName typeValueQName = this.getTypeValueToWriteAsQName(record, xmlDescriptor, xmlRef, addToNamespaceResolver);
                    this.writeXsiTypeAttribute(xmlDescriptor, record, typeValueQName, addToNamespaceResolver);
                    return true;
                }
            }
            return false;
        }
        return this.addXsiTypeAndClassIndicatorIfRequired(record, xmlDescriptor, referenceDescriptor, xmlField, addToNamespaceResolver);
    }

    public boolean addXsiTypeAndClassIndicatorIfRequired(XMLRecord record, XMLDescriptor xmlDescriptor, XMLDescriptor referenceDescriptor, XMLField xmlField, boolean addToNamespaceResolver) {
        XMLField indicatorField;
        if (this.descriptor.hasInheritance() && !this.xsiTypeIndicatorField) {
            xmlDescriptor.getInheritancePolicy().addClassIndicatorFieldToRow(record);
        }
        QName leafType = null;
        if (xmlField != null) {
            leafType = xmlField.getLeafElementType();
            XMLSchemaReference xmlRef = xmlDescriptor.getSchemaReference();
            if (xmlRef != null) {
                QName ctxQName;
                if (leafType == null && xmlRef.getType() == 3) {
                    return false;
                }
                if (leafType == null && referenceDescriptor == null) {
                    QName typeValueQName = this.getTypeValueToWriteAsQName(record, xmlDescriptor, xmlRef, addToNamespaceResolver);
                    this.writeXsiTypeAttribute(xmlDescriptor, record, typeValueQName, addToNamespaceResolver);
                    return true;
                }
                if ((xmlRef.getType() == 1 || xmlRef.getType() == 2) && xmlRef.getSchemaContext() != null && xmlRef.isGlobalDefinition() && leafType != null && !(ctxQName = xmlRef.getSchemaContextAsQName(xmlDescriptor.getNamespaceResolver())).equals(leafType)) {
                    QName typeValueQName = this.getTypeValueToWriteAsQName(record, xmlDescriptor, xmlRef, addToNamespaceResolver);
                    this.writeXsiTypeAttribute(xmlDescriptor, record, typeValueQName, addToNamespaceResolver);
                    return true;
                }
            }
        }
        if (referenceDescriptor != null && referenceDescriptor == xmlDescriptor) {
            return false;
        }
        if (xmlDescriptor.hasInheritance() && !xmlDescriptor.getInheritancePolicy().isRootParentDescriptor() && (indicatorField = (XMLField)xmlDescriptor.getInheritancePolicy().getClassIndicatorField()) != null && this.xsiTypeIndicatorField) {
            Object classIndicatorValueObject = xmlDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(xmlDescriptor.getJavaClass());
            QName classIndicatorQName = null;
            if (classIndicatorValueObject instanceof QName) {
                classIndicatorQName = (QName)classIndicatorValueObject;
            } else {
                String classIndicatorValue = (String)xmlDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(xmlDescriptor.getJavaClass());
                int nsindex = classIndicatorValue.indexOf(58);
                String localName = null;
                String prefix = null;
                if (nsindex != -1) {
                    localName = classIndicatorValue.substring(nsindex + 1);
                    prefix = classIndicatorValue.substring(0, nsindex);
                } else {
                    localName = classIndicatorValue;
                }
                String namespaceURI = xmlDescriptor.getNonNullNamespaceResolver().resolveNamespacePrefix(prefix);
                classIndicatorQName = new QName(namespaceURI, localName);
            }
            if (leafType == null || !classIndicatorQName.equals(leafType)) {
                if (xmlDescriptor.getInheritancePolicy().hasClassExtractor()) {
                    xmlDescriptor.getInheritancePolicy().addClassIndicatorFieldToRow(record);
                } else {
                    this.writeXsiTypeAttribute(xmlDescriptor, record, classIndicatorQName, addToNamespaceResolver);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private QName getTypeValueToWriteAsQName(XMLRecord record, XMLDescriptor descriptorToWrite, XMLSchemaReference xmlRef, boolean addToNamespaceResolver) {
        QName contextAsQName = xmlRef.getSchemaContextAsQName();
        if (contextAsQName == null) {
            contextAsQName = xmlRef.getSchemaContextAsQName(record.getNamespaceResolver());
        }
        if (contextAsQName != null) {
            String uri = contextAsQName.getNamespaceURI();
            String localPart = contextAsQName.getLocalPart();
            String prefix = record.getNamespaceResolver().resolveNamespaceURI(uri);
            if (prefix == null) {
                String defaultUri = record.getNamespaceResolver().getDefaultNamespaceURI();
                if (defaultUri != null && defaultUri.equals(uri)) {
                    return new QName(localPart);
                }
                if ("".equals(uri)) {
                    return new QName(localPart);
                }
                prefix = record.getNamespaceResolver().generatePrefix();
                return new QName(uri, localPart, prefix);
            }
            return new QName(uri, localPart, prefix);
        }
        return null;
    }
}

