/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.JPQLCallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.JPAQueryBuilder;

public class JPQLCall
implements Serializable,
Call {
    protected DatabaseQuery query;
    protected String jpqlString;
    protected boolean isParsed;

    public JPQLCall() {
    }

    public JPQLCall(String jpqlString) {
        this();
        this.jpqlString = jpqlString;
    }

    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery query) {
        return new JPQLCallQueryMechanism(query, this);
    }

    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery query, DatabaseQueryMechanism mechanism) {
        return this.buildNewQueryMechanism(query);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getCallString() {
        return this.getEjbqlString();
    }

    public String getEjbqlString() {
        return this.jpqlString;
    }

    public String getJPQLString() {
        return this.jpqlString;
    }

    private boolean getIsParsed() {
        return this.isParsed;
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public String getLogString(Accessor accessor) {
        return this.getSQLString();
    }

    public String getSQLString() {
        return null;
    }

    public boolean isJPQLCall() {
        return true;
    }

    public boolean isFinished() {
        return true;
    }

    public boolean isParsed() {
        return this.getIsParsed();
    }

    public void populateQuery(AbstractSession session) {
        if (!this.isParsed()) {
            JPAQueryBuilder queryBuilder = session.getQueryBuilder();
            queryBuilder.populateQuery(this.getEjbqlString(), this.getQuery(), session);
            this.setIsParsed(true);
        }
    }

    public PreparedStatement prepareStatement(DatabaseAccessor accessor, AbstractRecord translationRow, AbstractSession session) throws SQLException {
        return null;
    }

    public void setEjbqlString(String jpqlString) {
        this.jpqlString = jpqlString;
    }

    public void setJPQLString(String jpqlString) {
        this.jpqlString = jpqlString;
    }

    public void setIsParsed(boolean newIsParsed) {
        this.isParsed = newIsParsed;
    }

    public void setQuery(DatabaseQuery query) {
        this.query = query;
    }

    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
    }

    public boolean isNothingReturned() {
        return false;
    }

    public boolean isOneRowReturned() {
        return false;
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        if (this.getJPQLString() == null) {
            return name;
        }
        return String.valueOf(name) + "(" + this.getJPQLString() + ")";
    }
}

