/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.expressions.ClassTypeExpression;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.NonSynchronizedSubVector;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractColumnMapping;
import org.eclipse.persistence.queries.ConstructorReportItem;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportQueryResult
implements Serializable,
Map {
    protected List<String> names;
    protected List<Object> results;
    protected Object primaryKey;
    protected StringBuffer key;

    public ReportQueryResult(List<Object> results, Object primaryKeyValues) {
        this.results = results;
        this.primaryKey = primaryKeyValues;
    }

    public ReportQueryResult(ReportQuery query, AbstractRecord row, Vector toManyResults) {
        this.names = query.getNames();
        this.buildResult(query, row, toManyResults);
    }

    protected void buildResult(ReportQuery query, AbstractRecord row, Vector toManyData) {
        if (query.shouldDistinctBeUsed() && query.shouldFilterDuplicates()) {
            this.key = new StringBuffer();
        }
        List<ReportItem> items = query.getItems();
        int itemSize = items.size();
        ArrayList<Object> results = new ArrayList<Object>(itemSize);
        if (query.shouldRetrievePrimaryKeys()) {
            this.setId(query.getDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(row, query.getSession()));
        }
        int index = 0;
        while (index < itemSize) {
            Object value;
            ReportItem item = items.get(index);
            if (item.isConstructorItem()) {
                ConstructorReportItem constructorItem = (ConstructorReportItem)item;
                Class[] constructorArgTypes = constructorItem.getConstructorArgTypes();
                int numberOfArguments = constructorItem.getReportItems().size();
                Object[] constructorArgs = new Object[numberOfArguments];
                int argumentIndex = 0;
                while (argumentIndex < numberOfArguments) {
                    ReportItem argumentItem = (ReportItem)constructorItem.getReportItems().get(argumentIndex);
                    Object result = this.processItem(query, row, toManyData, argumentItem);
                    constructorArgs[argumentIndex] = ConversionManager.getDefaultManager().convertObject(result, constructorArgTypes[argumentIndex]);
                    ++argumentIndex;
                }
                try {
                    Constructor constructor = constructorItem.getConstructor();
                    Object returnValue = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            returnValue = AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, constructorArgs));
                        }
                        catch (PrivilegedActionException exception) {
                            throw QueryException.exceptionWhileUsingConstructorExpression(exception.getException(), query);
                        }
                    } else {
                        returnValue = PrivilegedAccessHelper.invokeConstructor(constructor, constructorArgs);
                    }
                    results.add(returnValue);
                }
                catch (IllegalAccessException exc) {
                    throw QueryException.exceptionWhileUsingConstructorExpression(exc, query);
                }
                catch (InvocationTargetException exc) {
                    throw QueryException.exceptionWhileUsingConstructorExpression(exc, query);
                }
                catch (InstantiationException exc) {
                    throw QueryException.exceptionWhileUsingConstructorExpression(exc, query);
                }
            } else if (item.getAttributeExpression() != null && item.getAttributeExpression().isClassTypeExpression()) {
                value = this.processItem(query, row, toManyData, item);
                ClassDescriptor descriptor = ((ClassTypeExpression)item.getAttributeExpression()).getContainingDescriptor(query);
                value = descriptor != null && descriptor.hasInheritance() ? descriptor.getInheritancePolicy().classFromValue(value, query.getSession()) : query.getSession().getDatasourcePlatform().convertObject(value, Class.class);
                results.add(value);
            } else {
                value = this.processItem(query, row, toManyData, item);
                results.add(value);
            }
            ++index;
        }
        this.setResults(results);
    }

    protected Object processItem(ReportQuery query, AbstractRecord row, Vector toManyData, ReportItem item) {
        JoinedAttributeManager joinManager = null;
        if (item.hasJoining() && (joinManager = item.getJoinedAttributeManager()).isToManyJoin() && joinManager.getDataResults_() == null) {
            joinManager.setDataResults(new ArrayList(toManyData), query.getSession());
        }
        Object value = null;
        DatabaseMapping mapping = item.getMapping();
        int rowSize = row.size();
        int itemIndex = item.getResultIndex();
        ClassDescriptor descriptor = item.getDescriptor();
        if (!item.isPlaceHolder()) {
            if (descriptor == null && mapping != null) {
                descriptor = mapping.getReferenceDescriptor();
            }
            if (mapping != null && mapping.isAbstractColumnMapping()) {
                if (itemIndex >= rowSize) {
                    throw QueryException.reportQueryResultSizeMismatch(itemIndex + 1, rowSize);
                }
                value = row instanceof DatabaseRecord ? (Object)row.getValues().get(itemIndex) : row.get(mapping.getField());
                value = ((AbstractColumnMapping)mapping).getObjectValue(value, query.getSession());
                if (this.key != null) {
                    this.key.append(value);
                    this.key.append("_");
                }
            } else if (descriptor != null) {
                if (itemIndex + descriptor.getAllFields().size() > rowSize) {
                    throw QueryException.reportQueryResultSizeMismatch(itemIndex + descriptor.getAllFields().size(), rowSize);
                }
                AbstractRecord subRow = row;
                if (itemIndex > 0) {
                    NonSynchronizedSubVector trimedFields = new NonSynchronizedSubVector(row.getFields(), itemIndex, rowSize);
                    NonSynchronizedSubVector trimedValues = new NonSynchronizedSubVector(row.getValues(), itemIndex, rowSize);
                    subRow = new DatabaseRecord(trimedFields, trimedValues);
                }
                value = mapping != null && mapping.isAggregateObjectMapping() ? ((AggregateObjectMapping)mapping).buildAggregateFromRow(subRow, null, null, joinManager, query, false, query.getSession(), true) : descriptor.getObjectBuilder().buildObject(query, subRow, joinManager);
                if (item.getAttributeExpression().isMapEntryExpression() && mapping.isCollectionMapping()) {
                    Object rowKey = null;
                    rowKey = mapping.getContainerPolicy().isMapPolicy() && !mapping.getContainerPolicy().isMappedKeyMapPolicy() ? ((MapContainerPolicy)mapping.getContainerPolicy()).keyFrom(value, query.getSession()) : mapping.getContainerPolicy().buildKey(subRow, query, null, query.getSession(), true);
                    value = ((MapEntryExpression)item.getAttributeExpression()).shouldReturnMapEntry() ? new Association(rowKey, value) : rowKey;
                }
                if (this.key != null) {
                    Object primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromRow(subRow, query.getSession());
                    if (primaryKey != null) {
                        this.key.append(primaryKey);
                    }
                    this.key.append("_");
                }
            } else {
                value = row.getValues().get(itemIndex);
                if (this.key != null) {
                    this.key.append(value);
                }
            }
        }
        return value;
    }

    @Override
    public void clear() {
        this.names = new ArrayList<String>();
        this.results = new ArrayList<Object>();
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getNames().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getResults().contains(value);
    }

    public Enumeration elements() {
        return new Vector<Object>(this.getResults()).elements();
    }

    public Set entrySet() {
        return new EntrySet();
    }

    @Override
    public boolean equals(Object anObject) {
        if (anObject instanceof ReportQueryResult) {
            return this.equals((ReportQueryResult)anObject);
        }
        return false;
    }

    public boolean equals(ReportQueryResult result) {
        if (this == result) {
            return true;
        }
        if (!this.getResults().equals(result.getResults())) {
            return false;
        }
        if (this.getId() != null) {
            if (result.getId() == null) {
                return false;
            }
            return this.getId().equals(this.getId());
        }
        return true;
    }

    public Object get(Object name) {
        if (name instanceof String) {
            return this.get((String)name);
        }
        return null;
    }

    public Object get(String name) {
        int index = this.getNames().indexOf(name);
        if (index == -1) {
            return null;
        }
        return this.getResults().get(index);
    }

    public Object getByIndex(int index) {
        return this.getResults().get(index);
    }

    public String getResultKey() {
        if (this.key != null) {
            return this.key.toString();
        }
        return null;
    }

    public List<String> getNames() {
        return this.names;
    }

    public Object getId() {
        return this.primaryKey;
    }

    @Deprecated
    public Vector<Object> getPrimaryKeyValues() {
        if (this.primaryKey instanceof CacheId) {
            return new Vector<Object>(Arrays.asList(((CacheId)this.primaryKey).getPrimaryKey()));
        }
        Vector<Object> primaryKey = new Vector<Object>(1);
        primaryKey.add(this.primaryKey);
        return primaryKey;
    }

    public List<Object> getResults() {
        return this.results;
    }

    @Override
    public boolean isEmpty() {
        return this.getNames().isEmpty();
    }

    public Enumeration keys() {
        return new Vector<String>(this.getNames()).elements();
    }

    public Set keySet() {
        return new KeySet();
    }

    public Object put(Object name, Object value) {
        int index = this.getNames().indexOf(name);
        if (index == -1) {
            this.getNames().add((String)name);
            this.getResults().add(value);
            return null;
        }
        Object oldValue = this.getResults().get(index);
        this.getResults().set(index, value);
        return oldValue;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object readObject(Class javaClass, Session session) {
        if (this.getId() == null) {
            throw QueryException.reportQueryResultWithoutPKs(this);
        }
        ReadObjectQuery query = new ReadObjectQuery(javaClass);
        query.setSelectionId(this.getId());
        return session.executeQuery(query);
    }

    public Object remove(Object name) {
        int index = this.getNames().indexOf(name);
        if (index >= 0) {
            this.getNames().remove(index);
            Object value = this.getResults().get(index);
            this.getResults().remove(index);
            return value;
        }
        return null;
    }

    protected void setNames(List<String> names) {
        this.names = names;
    }

    protected void setId(Object primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setResults(List<Object> results) {
        this.results = results;
    }

    @Override
    public int size() {
        return this.getNames().size();
    }

    public Object[] toArray() {
        List<Object> list = this.getResults();
        return list == null ? null : list.toArray();
    }

    public List toList() {
        return this.getResults();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("ReportQueryResult(");
        int index = 0;
        while (index < this.getResults().size()) {
            Object resultObj = this.getResults().get(index);
            writer.write(String.valueOf(resultObj));
            writer.write(" <" + (resultObj == null ? "null" : resultObj.getClass().getName()) + ">");
            if (index < this.getResults().size() - 1) {
                writer.write(", ");
            }
            ++index;
        }
        writer.write(")");
        return writer.toString();
    }

    public Collection values() {
        return this.getResults();
    }

    protected class EntryIterator
    implements Iterator {
        int index = 0;

        EntryIterator() {
        }

        public boolean hasNext() {
            return this.index < ReportQueryResult.this.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return new RecordEntry(ReportQueryResult.this.getNames().get(this.index - 1), ReportQueryResult.this.getResults().get(this.index - 1));
        }

        public void remove() {
            if (this.index >= ReportQueryResult.this.size()) {
                throw new IllegalStateException();
            }
            ReportQueryResult.this.remove(ReportQueryResult.this.getNames().get(this.index));
        }
    }

    protected class EntrySet
    extends AbstractSet {
        protected EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public int size() {
            return ReportQueryResult.this.size();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            return ReportQueryResult.this.containsKey(((Map.Entry)object).getKey());
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            ReportQueryResult.this.remove(((Map.Entry)object).getKey());
            return true;
        }

        public void clear() {
            ReportQueryResult.this.clear();
        }
    }

    protected class KeyIterator
    extends EntryIterator {
        protected KeyIterator() {
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return ReportQueryResult.this.getNames().get(this.index - 1);
        }
    }

    protected class KeySet
    extends EntrySet {
        protected KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public boolean contains(Object object) {
            return ReportQueryResult.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return ReportQueryResult.this.remove(object) != null;
        }
    }

    protected static class RecordEntry
    implements Map.Entry {
        Object key;
        Object value;

        public RecordEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.compare(this.key, entry.getKey()) && this.compare(this.value, entry.getValue());
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private boolean compare(Object object1, Object object2) {
            return object1 == null ? object2 == null : object1.equals(object2);
        }
    }
}

