/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sequencing;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sequencing.QuerySequence;

public class NativeSequence
extends QuerySequence {
    protected boolean shouldUseIdentityIfPlatformSupports = true;

    public NativeSequence() {
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(boolean shouldUseIdentityIfPlatformSupports) {
        this.setShouldSkipUpdate(true);
        this.setShouldUseIdentityIfPlatformSupports(shouldUseIdentityIfPlatformSupports);
    }

    public NativeSequence(String name) {
        super(name);
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(String name, boolean shouldUseIdentityIfPlatformSupports) {
        super(name);
        this.setShouldSkipUpdate(true);
        this.setShouldUseIdentityIfPlatformSupports(shouldUseIdentityIfPlatformSupports);
    }

    public NativeSequence(String name, int size) {
        super(name, size);
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(String name, int size, boolean shouldUseIdentityIfPlatformSupports) {
        super(name, size);
        this.setShouldSkipUpdate(true);
        this.setShouldUseIdentityIfPlatformSupports(shouldUseIdentityIfPlatformSupports);
    }

    public NativeSequence(String name, int size, int initialValue) {
        super(name, size, initialValue);
        this.setShouldSkipUpdate(true);
    }

    public NativeSequence(String name, int size, int initialValue, boolean shouldUseIdentityIfPlatformSupports) {
        super(name, size, initialValue);
        this.setShouldSkipUpdate(true);
        this.setShouldUseIdentityIfPlatformSupports(shouldUseIdentityIfPlatformSupports);
    }

    public boolean isNative() {
        return true;
    }

    public void setShouldUseIdentityIfPlatformSupports(boolean shouldUseIdentityIfPlatformSupports) {
        this.shouldUseIdentityIfPlatformSupports = shouldUseIdentityIfPlatformSupports;
    }

    public boolean shouldUseIdentityIfPlatformSupports() {
        return this.shouldUseIdentityIfPlatformSupports;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NativeSequence) {
            return NativeSequence.equalNameAndSize(this, (NativeSequence)obj);
        }
        return false;
    }

    protected ValueReadQuery buildSelectQuery() {
        if (this.shouldAcquireValueAfterInsert()) {
            return ((DatasourcePlatform)this.getDatasourcePlatform()).buildSelectQueryForIdentity();
        }
        return ((DatasourcePlatform)this.getDatasourcePlatform()).buildSelectQueryForSequenceObject();
    }

    protected ValueReadQuery buildSelectQuery(String seqName, Integer size) {
        if (this.shouldAcquireValueAfterInsert()) {
            return ((DatabasePlatform)this.getDatasourcePlatform()).buildSelectQueryForIdentity(this.getQualified(seqName), size);
        }
        return ((DatasourcePlatform)this.getDatasourcePlatform()).buildSelectQueryForSequenceObject(this.getQualified(seqName), size);
    }

    public void onConnect() {
        DatasourcePlatform platform = (DatasourcePlatform)this.getDatasourcePlatform();
        if (!platform.supportsNativeSequenceNumbers() && this.getSelectQuery() == null) {
            throw ValidationException.platformDoesNotSupportSequence(this.getName(), Helper.getShortClassName(this.getDatasourcePlatform()), Helper.getShortClassName(this));
        }
        if (platform.supportsIdentity() && this.shouldUseIdentityIfPlatformSupports()) {
            this.setShouldAcquireValueAfterInsert(true);
        } else if (platform.supportsSequenceObjects() && !this.shouldUseIdentityIfPlatformSupports()) {
            this.setShouldAcquireValueAfterInsert(false);
        } else if (platform.supportsNativeSequenceNumbers()) {
            this.setShouldAcquireValueAfterInsert(platform.supportsIdentity());
        }
        this.setShouldUseTransaction(platform.shouldNativeSequenceUseTransaction());
        super.onConnect();
    }

    public void onDisconnect() {
        this.setShouldAcquireValueAfterInsert(false);
        this.setShouldUseTransaction(false);
        super.onDisconnect();
    }

    public ValueReadQuery buildSelectQueryForIdentity(String seqName, Integer size) {
        return null;
    }
}

