/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.structures;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.mappings.structures.StructureMapping;

public class StructureAccessor
extends MappingAccessor {
    private ColumnMetadata m_column;
    private DatabaseField m_field;
    private MetadataClass m_referenceClass;
    private MetadataClass m_targetClass;
    private String m_targetClassName;

    public StructureAccessor() {
        super("<structure>");
    }

    public StructureAccessor(MetadataAnnotation embedded, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(embedded, accessibleObject, classAccessor);
        this.m_column = new ColumnMetadata(this.getAnnotation("javax.persistence.Column"), this);
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof StructureAccessor) {
            StructureAccessor accessor = (StructureAccessor)objectToCompare;
            return this.valuesMatch(this.m_column, accessor.getColumn());
        }
        return false;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        if (this.m_column == null) {
            this.m_column = new ColumnMetadata(this);
        } else {
            this.initXMLObject(this.m_column, accessibleObject);
        }
    }

    public void process() {
        StructureMapping mapping = new StructureMapping();
        this.setMapping((DatabaseMapping)mapping);
        this.m_field = new ObjectRelationalDatabaseField(this.getDatabaseField(this.getDescriptor().getPrimaryTable(), "metadata_default_column"));
        mapping.setField(this.m_field);
        mapping.setIsReadOnly(this.m_field.isReadOnly());
        mapping.setReferenceClassName(this.getReferenceClassName());
        mapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods((DatabaseMapping)mapping);
        this.processReturnInsertAndUpdate();
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    public void setColumn(ColumnMetadata column) {
        this.m_column = column;
    }

    public boolean isEmbedded() {
        return true;
    }

    public MetadataClass getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetClass();
            if (this.m_referenceClass == null) {
                this.m_referenceClass = super.getReferenceClass();
            }
        }
        return this.m_referenceClass;
    }

    protected MetadataClass getTargetClass() {
        return this.m_targetClass;
    }

    protected String getTargetClassName() {
        return this.m_targetClassName;
    }

    public void setTargetClassName(String targetClassName) {
        this.m_targetClassName = targetClassName;
    }
}

