/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContextFactory;
import org.eclipse.persistence.jaxb.metadata.XMLMetadataSource;
import org.eclipse.persistence.jpa.Archive;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.jpa.rs.eventlistener.ChangeListener;
import org.eclipse.persistence.jpa.rs.eventlistener.DatabaseEventListenerFactory;
import org.eclipse.persistence.jpa.rs.eventlistener.DescriptorBasedDatabaseEventListener;
import org.eclipse.persistence.jpa.rs.util.DynamicXMLMetadataSource;
import org.eclipse.persistence.jpa.rs.util.JTATransactionWrapper;
import org.eclipse.persistence.jpa.rs.util.LinkAdapter;
import org.eclipse.persistence.jpa.rs.util.ResourceLocalTransactionWrapper;
import org.eclipse.persistence.jpa.rs.util.TransactionWrapper;
import org.eclipse.persistence.platform.database.events.DatabaseEventListener;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContext {
    public static DatabaseEventListenerFactory EVENT_LISTENER_FACTORY = null;
    public static final String CHANGE_NOTIFICATION_LISTENER = "jpars.change-notification-listener";
    private String name = null;
    private EntityManagerFactory emf;
    private JAXBContext context = null;
    private URI baseURI = null;
    private DescriptorBasedDatabaseEventListener databaseEventListener = null;
    private TransactionWrapper transaction = null;

    public static void setEventListenerFactory(DatabaseEventListenerFactory eventListenerFactory) {
        EVENT_LISTENER_FACTORY = eventListenerFactory;
    }

    public PersistenceContext(Archive archive, Map<String, Object> properties, ClassLoader classLoader) {
        List persistenceUnits = PersistenceUnitProcessor.getPersistenceUnits((Archive)archive, (ClassLoader)classLoader);
        SEPersistenceUnitInfo persistenceUnitInfo = (SEPersistenceUnitInfo)persistenceUnits.get(0);
        this.name = persistenceUnitInfo.getPersistenceUnitName();
        EntityManagerFactoryImpl emf = this.createEntityManagerFactory((PersistenceUnitInfo)persistenceUnitInfo, properties);
        this.emf = emf;
        this.transaction = JpaHelper.getServerSession((EntityManagerFactory)emf).hasExternalTransactionController() ? new JTATransactionWrapper() : new ResourceLocalTransactionWrapper();
        try {
            JAXBContext jaxbContext;
            this.context = jaxbContext = this.createDynamicJAXBContext(persistenceUnitInfo.getPersistenceUnitName(), (Server)emf.getServerSession());
        }
        catch (Exception e) {
            emf.close();
            throw new RuntimeException("JAXB Creation Exception", e);
        }
    }

    public PersistenceContext(String emfName, EntityManagerFactoryImpl emf, URI defaultURI) {
        this.emf = emf;
        this.name = emfName;
        this.transaction = JpaHelper.getServerSession((EntityManagerFactory)emf).hasExternalTransactionController() ? new JTATransactionWrapper() : new ResourceLocalTransactionWrapper();
        try {
            JAXBContext jaxbContext = null;
            this.context = jaxbContext = this.createDynamicJAXBContext(emfName, (Server)emf.getServerSession());
        }
        catch (Exception e) {
            throw new RuntimeException("JAXB Creation Exception", e);
        }
        this.setBaseURI(defaultURI);
    }

    protected void addDynamicXMLMetadataSources(List<Object> metadataSources, String persistenceUnitName, Server session) {
        HashSet<String> packages = new HashSet<String>();
        for (Class descriptorClass : session.getDescriptors().keySet()) {
            String packageName = "";
            if (descriptorClass.getName().lastIndexOf(46) > 0) {
                packageName = descriptorClass.getName().substring(0, descriptorClass.getName().lastIndexOf(46));
            }
            if (packages.contains(packageName)) continue;
            packages.add(packageName);
        }
        for (String packageName : packages) {
            metadataSources.add(new DynamicXMLMetadataSource(persistenceUnitName, session, packageName));
        }
    }

    public void addListener(ChangeListener listener) {
        DescriptorBasedDatabaseEventListener changeListener = (DescriptorBasedDatabaseEventListener)JpaHelper.getDatabaseSession((EntityManagerFactory)this.getEmf()).getProperty(CHANGE_NOTIFICATION_LISTENER);
        if (changeListener == null) {
            throw new RuntimeException("Change Listener not registered properly");
        }
        changeListener.addChangeListener(listener);
    }

    public void create(String tenantId, Object entity) {
        EntityManager em = this.getEmf().createEntityManager();
        try {
            this.transaction.beginTransaction(em);
            em.persist(entity);
            this.transaction.commitTransaction(em);
        }
        finally {
            em.close();
        }
    }

    protected JAXBContext createDynamicJAXBContext(String persistenceUnitName, Server session) throws JAXBException, IOException {
        JAXBContext jaxbContext = (JAXBContext)session.getProperty(JAXBContext.class.getName());
        if (jaxbContext != null) {
            return jaxbContext;
        }
        Map<String, Object> properties = this.createJAXBProperties(persistenceUnitName, session);
        ClassLoader cl = session.getPlatform().getConversionManager().getLoader();
        jaxbContext = DynamicJAXBContextFactory.createContextFromOXM((ClassLoader)cl, properties);
        session.setProperty(JAXBContext.class.getName(), (Object)jaxbContext);
        return jaxbContext;
    }

    protected EntityManagerFactoryImpl createEntityManagerFactory(PersistenceUnitInfo info, Map<String, ?> properties) {
        PersistenceProvider provider = new PersistenceProvider();
        EntityManagerFactory emf = provider.createContainerEntityManagerFactory(info, properties);
        return (EntityManagerFactoryImpl)emf;
    }

    protected EntityManager createEntityManager(String tenantId) {
        return this.getEmf().createEntityManager();
    }

    protected Map<String, Object> createJAXBProperties(String persistenceUnitName, Server session) throws IOException {
        String oxmLocation = (String)this.emf.getProperties().get("eclipselink.jpa-rs.oxm");
        HashMap<String, Object> properties = new HashMap<String, Object>(1);
        ArrayList<Object> metadataLocations = new ArrayList<Object>();
        this.addDynamicXMLMetadataSources(metadataLocations, persistenceUnitName, session);
        if (oxmLocation != null) {
            metadataLocations.add(new XMLMetadataSource(new URL(oxmLocation).openStream()));
        }
        properties.put("eclipselink-oxm-xml", metadataLocations);
        return properties;
    }

    public void delete(String tenantId, String type, Object id) {
        EntityManager em = this.getEmf().createEntityManager();
        try {
            this.transaction.beginTransaction(em);
            Object entity = em.find(this.getClass(type), id);
            if (entity != null) {
                em.remove(entity);
            }
            this.transaction.commitTransaction(em);
        }
        finally {
            em.close();
        }
    }

    public Object find(String entityName, Object id) {
        return this.find(null, entityName, id);
    }

    public Object find(String tenantId, String entityName, Object id) {
        return this.find(tenantId, entityName, id, null);
    }

    public Object find(String tenantId, String entityName, Object id, Map<String, Object> properties) {
        EntityManager em = this.getEmf().createEntityManager();
        try {
            Object object = em.find(this.getClass(entityName), id, properties);
            return object;
        }
        finally {
            em.close();
        }
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public Class<?> getClass(String entityName) {
        ClassDescriptor descriptor = this.getDescriptor(entityName);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getJavaClass();
    }

    public ClassDescriptor getDescriptor(String entityName) {
        Server session = JpaHelper.getServerSession((EntityManagerFactory)this.getEmf());
        ClassDescriptor descriptor = session.getDescriptorForAlias(entityName);
        if (descriptor == null) {
            for (Object ajaxBSession : this.getJAXBContext().getXMLContext().getSessions()) {
                descriptor = ((Session)ajaxBSession).getClassDescriptorForAlias(entityName);
                if (descriptor != null) break;
            }
        }
        return descriptor;
    }

    public ClassDescriptor getDescriptorForClass(Class clazz) {
        Server session = JpaHelper.getServerSession((EntityManagerFactory)this.getEmf());
        ClassDescriptor descriptor = session.getDescriptor(clazz);
        if (descriptor == null) {
            for (Object ajaxBSession : this.getJAXBContext().getXMLContext().getSessions()) {
                descriptor = ((Session)ajaxBSession).getClassDescriptor(clazz);
                if (descriptor != null) break;
            }
        }
        return descriptor;
    }

    public EntityManagerFactory getEmf() {
        return this.emf;
    }

    public JAXBContext getJAXBContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public Object merge(String tenantId, Object entity) {
        EntityManager em = this.getEmf().createEntityManager();
        ArrayList<Object> mergedEntity = null;
        try {
            this.transaction.beginTransaction(em);
            if (entity instanceof List) {
                ArrayList<Object> mergeList = new ArrayList<Object>();
                for (Object o : (List)entity) {
                    mergeList.add(em.merge(o));
                }
                mergedEntity = mergeList;
            } else {
                mergedEntity = em.merge(entity);
            }
            this.transaction.commitTransaction(em);
            ArrayList<Object> arrayList = mergedEntity;
            return arrayList;
        }
        finally {
            em.close();
        }
    }

    public DynamicEntity newEntity(String type) {
        return this.newEntity(null, type);
    }

    public DynamicEntity newEntity(String tenantId, String type) {
        JPADynamicHelper helper = new JPADynamicHelper(this.getEmf());
        DynamicEntity entity = null;
        try {
            entity = helper.newDynamicEntity(type);
        }
        catch (IllegalArgumentException e) {
            DynamicType jaxbType;
            ClassDescriptor descriptor = this.getDescriptor(type);
            if (descriptor != null && (jaxbType = (DynamicType)descriptor.getProperty("ENTITY_TYPE")) != null) {
                return jaxbType.newDynamicEntity();
            }
            throw e;
        }
        return entity;
    }

    public Object query(String name, Map<?, ?> parameters) {
        return this.query(name, parameters, null, false, false);
    }

    public Object query(String name, Map<?, ?> parameters, Map<String, ?> hints, boolean returnSingleResult, boolean executeUpdate) {
        EntityManager em = this.getEmf().createEntityManager();
        try {
            Query query = em.createNamedQuery(name);
            DatabaseQuery dbQuery = ((EJBQueryImpl)query).getDatabaseQuery();
            if (parameters != null) {
                for (String key : parameters.keySet()) {
                    Class parameterClass = null;
                    int index = dbQuery.getArguments().indexOf(key);
                    if (index >= 0) {
                        parameterClass = (Class)dbQuery.getArgumentTypes().get(index);
                    }
                    Object parameter = parameters.get(key);
                    if (parameterClass != null) {
                        parameter = ConversionManager.getDefaultManager().convertObject(parameter, parameterClass);
                    }
                    query.setParameter(key, parameter);
                }
            }
            if (hints != null) {
                for (String key : hints.keySet()) {
                    query.setHint(key, hints.get(key));
                }
            }
            if (executeUpdate) {
                this.transaction.beginTransaction(em);
                Integer result = query.executeUpdate();
                this.transaction.commitTransaction(em);
                Integer n = result;
                return n;
            }
            if (returnSingleResult) {
                Object object = query.getSingleResult();
                return object;
            }
            List list = query.getResultList();
            return list;
        }
        finally {
            em.close();
        }
    }

    public void remove(ChangeListener listener) {
        DescriptorBasedDatabaseEventListener changeListener = (DescriptorBasedDatabaseEventListener)JpaHelper.getDatabaseSession((EntityManagerFactory)this.getEmf()).getProperty(CHANGE_NOTIFICATION_LISTENER);
        if (changeListener != null) {
            changeListener.removeChangeListener(listener);
        }
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    protected void stop() {
        this.emf.close();
        this.emf = null;
        this.context = null;
    }

    public DatabaseEventListener subscribeToEventNotification(String descriptorAlias) {
        ServerSession session = (ServerSession)JpaHelper.getServerSession((EntityManagerFactory)this.emf);
        ClassDescriptor descriptor = session.getDescriptorForAlias(descriptorAlias);
        if (descriptor == null) {
            throw new RuntimeException("Could not find " + descriptorAlias + " for subscription");
        }
        return this.subscribeToEventNotification(this.emf, descriptor);
    }

    public DatabaseEventListener subscribeToEventNotification(EntityManagerFactory emf, ClassDescriptor descriptor) {
        ServerSession session = (ServerSession)JpaHelper.getServerSession((EntityManagerFactory)emf);
        if (this.databaseEventListener == null) {
            if (EVENT_LISTENER_FACTORY != null) {
                this.databaseEventListener = EVENT_LISTENER_FACTORY.createDatabaseEventListener();
                session.setDatabaseEventListener((DatabaseEventListener)this.databaseEventListener);
                session.setProperty(CHANGE_NOTIFICATION_LISTENER, (Object)this.databaseEventListener);
            } else {
                throw new RuntimeException("Could not subscribe to change notification for " + descriptor.getAlias());
            }
        }
        this.databaseEventListener.initialize(descriptor, (AbstractSession)session);
        this.databaseEventListener.register((Session)session, descriptor);
        return this.databaseEventListener;
    }

    public String toString() {
        return "Application(" + this.getName() + ")::" + System.identityHashCode(this);
    }

    public Object unmarshalEntity(String type, String tenantId, MediaType acceptedMedia, InputStream in) throws JAXBException {
        JAXBUnmarshaller unmarshaller = this.getJAXBContext().createUnmarshaller();
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)Boolean.FALSE);
        unmarshaller.setProperty("eclipselink.media-type", (Object)acceptedMedia.toString());
        unmarshaller.setAdapter((XmlAdapter)new LinkAdapter(this.getBaseURI().toString(), this));
        JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(in), this.getClass(type));
        return element.getValue();
    }

    public void marshallEntity(Object object, MediaType mediaType, OutputStream output) throws JAXBException {
        JAXBMarshaller marshaller = this.getJAXBContext().createMarshaller();
        marshaller.setProperty("eclipselink.media-type", (Object)mediaType.toString());
        marshaller.setProperty("eclipselink.json.include-root", (Object)false);
        marshaller.setAdapter((XmlAdapter)new LinkAdapter(this.getBaseURI().toString(), this));
        marshaller.setListener(new Marshaller.Listener(){

            public void beforeMarshal(Object source) {
                if (source instanceof DynamicEntity) {
                    DynamicEntityImpl sourceImpl = (DynamicEntityImpl)source;
                    PropertyChangeListener listener = sourceImpl._persistence_getPropertyChangeListener();
                    sourceImpl._persistence_setPropertyChangeListener(null);
                    ((DynamicEntity)source).set("self", source);
                    sourceImpl._persistence_setPropertyChangeListener(listener);
                }
            }
        });
        if (mediaType == MediaType.APPLICATION_XML_TYPE && object instanceof List) {
            marshaller.setProperty("jaxb.fragment", (Object)true);
            XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
            XMLStreamWriter writer = null;
            try {
                writer = outputFactory.createXMLStreamWriter(output);
                writer.writeStartDocument();
                writer.writeStartElement("List");
                for (Object o : (List)object) {
                    marshaller.marshal(o, writer);
                }
                writer.writeEndDocument();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        } else {
            marshaller.marshal(object, output);
        }
    }
}

