/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.metadata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.eclipse.persistence.jpa.rs.metadata.Application;
import org.eclipse.persistence.jpa.rs.metadata.MetadataStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseMetadataStore
implements MetadataStore {
    protected EntityManagerFactory factory = null;
    Map<String, Object> properties = null;

    public EntityManagerFactory getEntityManagerFactory() {
        if (this.factory == null) {
            HashMap<String, Object> bootstrapProperties = new HashMap<String, Object>();
            if (this.properties != null) {
                bootstrapProperties.putAll(this.properties);
            }
            if (bootstrapProperties.get("javax.persistence.nonJtaDataSource") == null && bootstrapProperties.get("javax.persistence.jdbc.url") == null) {
                bootstrapProperties.put("javax.persistence.nonJtaDataSource", "jdbc/jpa-rs");
            }
            bootstrapProperties.put("eclipselink.ddl-generation", "create-tables");
            this.factory = Persistence.createEntityManagerFactory((String)"jpa-rs", bootstrapProperties);
        }
        return this.factory;
    }

    @Override
    public void persistMetadata(String name, String url) {
        Application application = new Application(name, url);
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        em.getTransaction().begin();
        if (em.find(Application.class, (Object)application.getName()) != null) {
            em.merge((Object)application);
        } else {
            em.persist((Object)application);
        }
        em.getTransaction().commit();
    }

    @Override
    public List<Application> retreiveMetadata() {
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        return em.createQuery("select a from Application a").getResultList();
    }

    @Override
    public void clearMetadata() {
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        em.getTransaction().begin();
        em.createQuery("delete from Application a").executeUpdate();
        em.getTransaction().commit();
    }

    @Override
    public void close() {
        if (this.isInitialized()) {
            this.getEntityManagerFactory().close();
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public boolean isInitialized() {
        return this.factory != null;
    }
}

