/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.DeclarationResolver;
import org.eclipse.persistence.jpa.jpql.DefaultContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.Resolver;
import org.eclipse.persistence.jpa.jpql.StateFieldResolver;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractConditionalClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractDoubleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractFromClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTraverseChildrenVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTraverseParentVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTripleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.AggregateFunction;
import org.eclipse.persistence.jpa.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.EncapsulatedIdentificationVariableExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionRegistry;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.FunctionExpression;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.IdentifierRole;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.jpql.parser.LogicalExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.QueryPosition;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.jpql.parser.WhenClause;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.eclipse.persistence.jpa.jpql.spi.IEmbeddable;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IMappedSuperclass;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;
import org.eclipse.persistence.jpa.jpql.spi.JPAVersion;
import org.eclipse.persistence.jpa.jpql.util.filter.AndFilter;
import org.eclipse.persistence.jpa.jpql.util.filter.Filter;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContentAssistVisitor
extends AnonymousExpressionVisitor {
    private CollectionExpressionVisitor collectionExpressionVisitor;
    protected final JPQLQueryContext context;
    protected Stack<Integer> corrections;
    protected Map<Class<?>, Object> helpers;
    protected Stack<Expression> lockedExpressions;
    private NullExpressionVisitor nullExpressionVisitor;
    protected Stack<Integer> positionInCollections;
    protected DefaultContentAssistProposals proposals;
    protected QueryPosition queryPosition;
    protected Stack<Integer> virtualSpaces;
    protected String word;
    protected WordParser wordParser;
    protected static final int SPACE_LENGTH = 1;

    protected AbstractContentAssistVisitor(JPQLQueryContext context) {
        Assert.isNotNull(context, "The JPQLQueryContext cannot be null");
        this.context = context;
        this.initialize();
    }

    protected void addAggregate(String identifier) {
        if (this.isAggregate(identifier)) {
            this.addIdentifier(identifier);
        }
    }

    protected void addAllAggregates(JPQLQueryBNF queryBNF) {
        for (String identifier : queryBNF.getIdentifiers()) {
            this.addAggregate(identifier);
        }
    }

    protected void addAllAggregates(String queryBNFId) {
        this.addAllAggregates(this.getQueryBNF(queryBNFId));
    }

    protected void addAllClauses(JPQLQueryBNF queryBNF) {
        for (String identifier : queryBNF.getIdentifiers()) {
            this.addClause(identifier);
        }
    }

    protected void addAllClauses(String queryBNF) {
        this.addAllClauses(this.getQueryBNF(queryBNF));
    }

    protected void addAllCompounds(JPQLQueryBNF queryBNF) {
        for (String identifier : queryBNF.getIdentifiers()) {
            this.addCompound(identifier);
        }
    }

    protected void addAllCompounds(String queryBNFId) {
        this.addAllCompounds(this.getQueryBNF(queryBNFId));
    }

    protected void addAllExpressionFactoryIdentifiers(ExpressionFactory expressionFactory) {
        String[] stringArray = expressionFactory.identifiers();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String identifier = stringArray[n2];
            this.proposals.addIdentifier(identifier);
            ++n2;
        }
    }

    protected void addAllExpressionFactoryIdentifiers(String expressionFactoryId) {
        this.addAllExpressionFactoryIdentifiers(this.getExpressionRegistry().getExpressionFactory(expressionFactoryId));
    }

    protected void addAllFunctions(JPQLQueryBNF queryBNF) {
        this.addAllFunctions(queryBNF, this.queryPosition.getPosition());
    }

    protected void addAllFunctions(JPQLQueryBNF queryBNF, int position) {
        for (String identifier : queryBNF.getIdentifiers()) {
            this.addFunction(identifier, position);
        }
    }

    protected void addAllFunctions(String queryBNFId) {
        this.addAllFunctions(this.getQueryBNF(queryBNFId), this.queryPosition.getPosition());
    }

    protected void addAllFunctions(String queryBNFId, int position) {
        this.addAllFunctions(this.getQueryBNF(queryBNFId), position);
    }

    protected void addAllIdentificationVariables() {
        this.addIdentificationVariables(IdentificationVariableType.ALL, null);
    }

    protected void addAllIdentifiers(JPQLQueryBNF queryBNF) {
        for (String identifier : queryBNF.getIdentifiers()) {
            this.addIdentifier(identifier);
        }
    }

    protected void addAllIdentifiers(String queryBNFId) {
        this.addAllIdentifiers(this.getQueryBNF(queryBNFId));
    }

    protected void addAllResultVariables() {
        this.addIdentificationVariables(IdentificationVariableType.RESULT_VARIABLE, null);
    }

    protected void addClause(String identifier) {
        if (this.isClause(identifier)) {
            this.addIdentifier(identifier);
        }
    }

    protected void addCompound(String identifier) {
        if (this.isCompoundFunction(identifier)) {
            this.addIdentifier(identifier, this.queryPosition.getPosition());
        }
    }

    protected void addEntities() {
        for (IEntity entity : this.entities()) {
            if (!this.isValidProposal(entity.getName(), this.word)) continue;
            this.proposals.addAbstractSchemaType(entity);
        }
    }

    protected void addEntities(IType type) {
        for (IEntity entity : this.entities()) {
            if (!this.isValidProposal(entity.getName(), this.word) || !type.isAssignableTo(entity.getType())) continue;
            this.proposals.addAbstractSchemaType(entity);
        }
    }

    protected void addFunction(String identifier, int position) {
        if (this.isFunction(identifier)) {
            this.addIdentifier(identifier, position);
        }
    }

    protected void addIdentificationVariable(String identificationVariable) {
        if (ExpressionTools.stringIsNotEmpty(identificationVariable) && this.isValidProposal(identificationVariable, this.word)) {
            this.proposals.addIdentificationVariable(identificationVariable);
        }
    }

    protected void addIdentificationVariables(IdentificationVariableType type, Expression expression) {
        block23: {
            block24: {
                if (type != IdentificationVariableType.RESULT_VARIABLE) break block24;
                for (String resultVariable : this.context.getResultVariables()) {
                    this.addIdentificationVariable(resultVariable);
                }
                break block23;
            }
            if (type == IdentificationVariableType.NONE) break block23;
            boolean stop = false;
            block7: for (DeclarationResolver.Declaration declaration : this.context.getDeclarations()) {
                if (!stop) {
                    block0 : switch (type) {
                        case ALL: {
                            if (declaration.rangeDeclaration) {
                                this.addRangeIdentificationVariable(declaration.getVariableName());
                            } else {
                                this.addIdentificationVariable(declaration.getVariableName());
                            }
                            for (String joinIdentificationVariable : declaration.getJoinIdentificationVariables()) {
                                this.addIdentificationVariable(joinIdentificationVariable);
                            }
                            continue block7;
                        }
                        case COLLECTION: {
                            if (declaration.rangeDeclaration) break;
                            this.addIdentificationVariable(declaration.getVariableName());
                            for (String joinIdentificationVariable : declaration.getJoinIdentificationVariables()) {
                                this.addIdentificationVariable(joinIdentificationVariable);
                            }
                            continue block7;
                        }
                        case LEFT: {
                            boolean shouldStop = declaration.declarationExpression.isAncestor(expression);
                            if (shouldStop && !declaration.getJoins().contains(expression)) {
                                stop = true;
                                break;
                            }
                            if (declaration.rangeDeclaration) {
                                this.addRangeIdentificationVariable(declaration.getVariableName());
                            } else if (!shouldStop) {
                                this.addIdentificationVariable(declaration.getVariableName());
                            }
                            for (Map.Entry<Join, String> join : declaration.getJoinEntries()) {
                                if (join.getKey().isAncestor(expression)) {
                                    stop = true;
                                    break block0;
                                }
                                this.addIdentificationVariable(join.getValue());
                            }
                            continue block7;
                        }
                        case LEFT_COLLECTION: {
                            boolean shouldStop = declaration.declarationExpression.isAncestor(expression);
                            if (shouldStop && declaration.getJoins().contains(expression)) {
                                stop = true;
                                break;
                            }
                            if (!shouldStop && !declaration.rangeDeclaration) {
                                this.addIdentificationVariable(declaration.getVariableName());
                                break;
                            }
                            for (Map.Entry<Join, String> join : declaration.getJoinEntries()) {
                                if (join.getKey().isAncestor(expression)) {
                                    stop = true;
                                    break block0;
                                }
                                this.addIdentificationVariable(join.getValue());
                            }
                            continue block7;
                        }
                    }
                    continue;
                }
                break;
            }
        }
    }

    protected void addIdentifier(String identifier) {
        this.addIdentifier(identifier, this.word);
    }

    protected void addIdentifier(String identifier, int position) {
        boolean found = this.addIdentifier(identifier, position -= this.word.length(), "IS NOT ", 2);
        if (!found && !(found = this.addIdentifier(identifier, position, "NOT ", 3))) {
            this.addIdentifier(identifier);
        }
    }

    protected boolean addIdentifier(String identifier, int position, String partialEnding, int endIndex) {
        int index = partialEnding.length();
        while (index > endIndex) {
            String partial = partialEnding.substring(0, index);
            if (this.wordParser.endsWith(position, partial)) {
                this.addIdentifier(identifier, String.valueOf(partial) + this.word);
                return true;
            }
            --index;
        }
        return false;
    }

    protected void addIdentifier(String identifier, String word) {
        if (this.isValidProposal(identifier, word) && this.isValidVersion(identifier)) {
            this.proposals.addIdentifier(identifier);
        }
    }

    protected void addJoinIdentifiers() {
        this.proposals.addIdentifier("INNER JOIN");
        this.proposals.addIdentifier("INNER JOIN FETCH");
        this.proposals.addIdentifier("JOIN");
        this.proposals.addIdentifier("JOIN FETCH");
        this.proposals.addIdentifier("LEFT JOIN");
        this.proposals.addIdentifier("LEFT JOIN FETCH");
        this.proposals.addIdentifier("LEFT OUTER JOIN");
        this.proposals.addIdentifier("LEFT OUTER JOIN FETCH");
    }

    protected void addLeftIdentificationVariables(Expression expression) {
        this.addIdentificationVariables(IdentificationVariableType.LEFT, expression);
    }

    protected void addRangeIdentificationVariable(String identificationVariable) {
        if (ExpressionTools.stringIsNotEmpty(identificationVariable) && this.isValidProposal(identificationVariable, this.word)) {
            Resolver resolver = this.context.getResolver(identificationVariable);
            IEntity entity = this.getEntity(resolver.getType());
            if (entity != null) {
                this.proposals.addRangeIdentificationVariable(identificationVariable, entity);
            } else {
                this.proposals.addIdentificationVariable(identificationVariable);
            }
        }
    }

    protected void addScalarExpressionProposals() {
        this.addAllIdentificationVariables();
        this.addEntities();
        this.addAllFunctions("scalar_expression");
    }

    protected void addSelectExpressionProposals(AbstractSelectClause expression, int length) {
        int position = this.getPosition(expression) - this.corrections.peek();
        CollectionExpression collectionExpression = this.getCollectionExpression(expression.getSelectExpression());
        if (collectionExpression != null) {
            int index = 0;
            int count = collectionExpression.childrenSize();
            while (index < count) {
                Expression child = collectionExpression.getChild(index);
                if (position == length) {
                    this.addAllIdentificationVariables();
                    this.addAllFunctions(expression.selectItemBNF());
                    break;
                }
                boolean withinChild = this.addSelectExpressionProposals(child, expression.selectItemBNF(), length, index, index + 1 == count);
                if (withinChild) break;
                length += this.length(child);
                if (!collectionExpression.hasComma(index)) break;
                if (position == ++length) {
                    this.addAllIdentificationVariables();
                    this.addAllFunctions(expression.selectItemBNF());
                    break;
                }
                if (collectionExpression.hasSpace(index)) {
                    ++length;
                }
                ++index;
            }
        } else {
            this.addSelectExpressionProposals(expression.getSelectExpression(), expression.selectItemBNF(), length, 0, true);
        }
    }

    protected boolean addSelectExpressionProposals(Expression expression, String queryBNFId, int length, int index, boolean last) {
        int position = this.getPosition(expression) - this.corrections.peek();
        if (position > 0) {
            if (position == 0) {
                if (index == 0) {
                    this.addIdentifier("DISTINCT");
                }
                this.addAllIdentificationVariables();
                this.addAllFunctions(queryBNFId);
            } else {
                int childLength = this.length(expression);
                if ((position == length + childLength + this.virtualSpaces.peek() || position == childLength) && this.isSelectExpressionComplete(expression)) {
                    if (!this.isResultVariable(expression)) {
                        if (this.virtualSpaces.peek() > 0 || position == childLength) {
                            this.proposals.addIdentifier("AS");
                        }
                        this.addAllAggregates(queryBNFId);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected AcceptableTypeVisitor buildAcceptableTypeVisitor() {
        return new AcceptableTypeVisitor();
    }

    protected AppendableExpressionVisitor buildAppendableExpressionVisitor() {
        return new AppendableExpressionVisitor();
    }

    protected CollectionExpressionVisitor buildCollectionExpressionVisitor() {
        return new CollectionExpressionVisitor();
    }

    protected CollectionMappingFilter buildCollectionMappingFilter() {
        return new CollectionMappingFilter();
    }

    protected CompoundExpressionHelper buildCompoundExpressionHelper() {
        return new CompoundExpressionHelper();
    }

    protected ConditionalExpressionCompletenessVisitor buildConditionalExpressionCompletenessVisitor() {
        return new ConditionalExpressionCompletenessVisitor();
    }

    protected ConstrutorCollectionHelper buildConstrutorCollectionHelper() {
        return new ConstrutorCollectionHelper();
    }

    protected DefaultMappingCollector buildDefaultMappingCollector() {
        return new DefaultMappingCollector();
    }

    protected DeleteClauseHelper buildDeleteClauseHelper() {
        return new DeleteClauseHelper();
    }

    protected DoubleEncapsulatedCollectionHelper buildDoubleEncapsulatedCollectionHelper() {
        return new DoubleEncapsulatedCollectionHelper();
    }

    protected FilteringMappingCollector buildFilteringMappingCollector(AbstractPathExpression expression, Resolver resolver, Filter<IMapping> filter, String pattern) {
        return new FilteringMappingCollector(resolver, this.buildMappingFilter(expression, filter), pattern);
    }

    protected FromClauseCollectionHelper buildFromClauseCollectionHelper() {
        return new FromClauseCollectionHelper();
    }

    protected FromClauseHelper buildFromClauseHelper() {
        return new FromClauseHelper();
    }

    protected FromClauseSelectStatementHelper buildFromClauseSelectStatementHelper() {
        return new FromClauseSelectStatementHelper();
    }

    protected GroupByClauseCollectionHelper buildGroupByClauseCollectionHelper() {
        return new GroupByClauseCollectionHelper();
    }

    protected GroupByClauseSelectStatementHelper buildGroupByClauseSelectStatementHelper() {
        return new GroupByClauseSelectStatementHelper();
    }

    protected HavingClauseHelper buildHavingClauseHelper() {
        return new HavingClauseHelper();
    }

    protected HavingClauseSelectStatementHelper buildHavingClauseSelectStatementHelper() {
        return new HavingClauseSelectStatementHelper();
    }

    protected IncompleteCollectionExpressionVisitor buildIncompleteCollectionExpressionVisitor() {
        return new IncompleteCollectionExpressionVisitor();
    }

    protected JoinCollectionHelper buildJoinCollectionHelper() {
        return new JoinCollectionHelper();
    }

    protected MappingCollector buildMappingCollector(AbstractPathExpression expression, Resolver resolver, Filter<IMapping> filter) {
        return this.buildFilteringMappingCollector(expression, resolver, filter, "");
    }

    protected Filter<IMapping> buildMappingFilter(AbstractPathExpression expression, Filter<IMapping> filter) {
        IType type = this.getAcceptableType(expression.getParent());
        if (type == null) {
            return filter;
        }
        return new AndFilter<IMapping>(new MappingTypeFilter(type), filter);
    }

    protected Filter<IMapping> buildMappingFilter(Expression expression) {
        MappingFilterBuilder visitor = this.getMappingFilterBuilder();
        try {
            expression.accept(visitor);
            Filter<IMapping> filter = visitor.filter;
            return filter;
        }
        finally {
            visitor.filter = null;
        }
    }

    protected MappingFilterBuilder buildMappingFilterBuilder() {
        return new MappingFilterBuilder();
    }

    protected NullExpressionVisitor buildNullExpressionVisitor() {
        return new NullExpressionVisitor();
    }

    protected OrderByClauseCollectionHelper buildOrderByClauseCollectionHelper() {
        return new OrderByClauseCollectionHelper();
    }

    protected OrderByClauseSelectStatementHelper buildOrderByClauseSelectStatementHelper() {
        return new OrderByClauseSelectStatementHelper();
    }

    protected PropertyMappingFilter buildPropertyMappingFilter() {
        return new PropertyMappingFilter();
    }

    public ContentAssistProposals buildProposals(int position) {
        JPQLExpression jpqlExpression = this.getJPQLExpression();
        QueryPosition queryPosition = jpqlExpression.buildPosition(this.getQueryExpression(), position);
        this.prepare(queryPosition);
        jpqlExpression.accept(this);
        return this.proposals;
    }

    protected RangeVariableDeclarationVisitor buildRangeVariableDeclarationVisitor() {
        return new RangeVariableDeclarationVisitor();
    }

    protected ResultVariableVisitor buildResultVariableVisitor() {
        return new ResultVariableVisitor();
    }

    protected SelectClauseCompletenessVisitor buildSelectClauseCompleteness() {
        return new SelectClauseCompletenessVisitor();
    }

    protected SelectClauseSelectStatementHelper buildSelectClauseSelectStatementHelper() {
        return new SelectClauseSelectStatementHelper();
    }

    protected SimpleFromClauseSelectStatementHelper buildSimpleFromClauseSelectStatementHelper() {
        return new SimpleFromClauseSelectStatementHelper();
    }

    protected SimpleGroupByClauseSelectStatementHelper buildSimpleGroupByClauseSelectStatementHelper() {
        return new SimpleGroupByClauseSelectStatementHelper();
    }

    protected SimpleHavingClauseSelectStatementHelper buildSimpleHavingClauseSelectStatementHelper() {
        return new SimpleHavingClauseSelectStatementHelper();
    }

    protected SimpleSelectClauseSelectStatementHelper buildSimpleSelectClauseSelectStatementHelper() {
        return new SimpleSelectClauseSelectStatementHelper();
    }

    protected SimpleWhereClauseSelectStatementHelper buildSimpleWhereClauseSelectStatementHelper() {
        return new SimpleWhereClauseSelectStatementHelper();
    }

    protected SubqueryVisitor buildSubqueryVisitor() {
        return new SubqueryVisitor();
    }

    protected TrailingCompletenessVisitor buildTrailingCompleteness() {
        return new TrailingCompletenessVisitor();
    }

    protected TripleEncapsulatedCollectionHelper buildTripleEncapsulatedCollectionHelper() {
        return new TripleEncapsulatedCollectionHelper();
    }

    protected UpdateItemCollectionHelper buildUpdateItemCollectionHelper() {
        return new UpdateItemCollectionHelper();
    }

    protected VisitParentVisitor buildVisitParentVisitor() {
        return new VisitParentVisitor();
    }

    protected WhereClauseHelper buildWhereClauseHelper() {
        return new WhereClauseHelper();
    }

    protected WhereClauseSelectStatementHelper buildWhereClauseSelectStatementHelper() {
        return new WhereClauseSelectStatementHelper();
    }

    protected SelectStatementHelper<AbstractSelectStatement, Expression> cast(SelectStatementHelper<? extends AbstractSelectStatement, ? extends Expression> helper) {
        return helper;
    }

    public void dispose() {
        this.word = null;
        this.proposals = null;
        this.wordParser = null;
        this.queryPosition = null;
    }

    protected IterableIterator<IEntity> entities() {
        return this.getProvider().entities();
    }

    protected int findExpressionPosition(CollectionExpression expression) {
        int position;
        Expression leafExpression = this.queryPosition.getExpression();
        if (leafExpression != expression) {
            int index = 0;
            int count = expression.childrenSize();
            while (index < count) {
                Expression child = expression.getChild(index);
                if (child.isAncestor(leafExpression)) {
                    return index;
                }
                ++index;
            }
        }
        if ((position = this.getPosition(expression)) > -1) {
            int index = 0;
            int count = expression.childrenSize();
            while (index < count) {
                Expression child = expression.getChild(index);
                String text = child.toActualText();
                if (position <= text.length()) {
                    return index;
                }
                position -= text.length();
                if (expression.hasComma(index)) {
                    --position;
                }
                if (expression.hasSpace(index)) {
                    --position;
                }
                ++index;
            }
        }
        if (position == 0 && (expression.endsWithComma() || expression.endsWithSpace())) {
            return expression.childrenSize();
        }
        return -1;
    }

    protected RangeVariableDeclaration findRangeVariableDeclaration(UpdateClause expression) {
        RangeVariableDeclarationVisitor visitor = this.getRangeVariableDeclarationVisitor();
        try {
            expression.getRangeVariableDeclaration().accept(visitor);
            RangeVariableDeclaration rangeVariableDeclaration = visitor.expression;
            return rangeVariableDeclaration;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected IType getAcceptableType(Expression expression) {
        AcceptableTypeVisitor visitor = this.getExpressionTypeVisitor();
        try {
            expression.accept(visitor);
            IType iType = visitor.type;
            return iType;
        }
        finally {
            visitor.type = null;
        }
    }

    protected AppendableExpressionVisitor getAppendableExpressionVisitor() {
        AppendableExpressionVisitor helper = this.getHelper(AppendableExpressionVisitor.class);
        if (helper == null) {
            helper = this.buildAppendableExpressionVisitor();
            this.registerHelper(AppendableExpressionVisitor.class, helper);
        }
        return helper;
    }

    protected CollectionExpression getCollectionExpression(Expression expression) {
        CollectionExpressionVisitor visitor = this.getCollectionExpressionVisitor();
        try {
            expression.accept(visitor);
            CollectionExpression collectionExpression = visitor.expression;
            return collectionExpression;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected CollectionExpressionVisitor getCollectionExpressionVisitor() {
        if (this.collectionExpressionVisitor == null) {
            this.collectionExpressionVisitor = this.buildCollectionExpressionVisitor();
        }
        return this.collectionExpressionVisitor;
    }

    protected CompletenessVisitor getCompletenessVisitor() {
        TrailingCompletenessVisitor helper = (TrailingCompletenessVisitor)this.helpers.get(TrailingCompletenessVisitor.class);
        if (helper == null) {
            helper = this.buildTrailingCompleteness();
            this.helpers.put(TrailingCompletenessVisitor.class, helper);
        }
        return helper;
    }

    protected CompoundExpressionHelper getCompoundExpressionHelper() {
        CompoundExpressionHelper helper = this.getHelper(CompoundExpressionHelper.class);
        if (helper == null) {
            helper = this.buildCompoundExpressionHelper();
            this.registerHelper(CompoundExpressionHelper.class, helper);
        }
        return helper;
    }

    protected CompletenessVisitor getConditionalExpressionCompletenessVisitor() {
        ConditionalExpressionCompletenessVisitor helper = this.getHelper(ConditionalExpressionCompletenessVisitor.class);
        if (helper == null) {
            helper = this.buildConditionalExpressionCompletenessVisitor();
            this.registerHelper(ConditionalExpressionCompletenessVisitor.class, helper);
        }
        return helper;
    }

    protected ConstrutorCollectionHelper getConstructorCollectionHelper() {
        ConstrutorCollectionHelper helper = this.getHelper(ConstrutorCollectionHelper.class);
        if (helper == null) {
            helper = this.buildConstrutorCollectionHelper();
            this.registerHelper(ConstrutorCollectionHelper.class, helper);
        }
        return helper;
    }

    protected final Stack<Integer> getCorrections() {
        return this.corrections;
    }

    protected MappingCollector getDefaultMappingCollector() {
        DefaultMappingCollector helper = this.getHelper(DefaultMappingCollector.class);
        if (helper == null) {
            helper = this.buildDefaultMappingCollector();
            this.registerHelper(DefaultMappingCollector.class, helper);
        }
        return helper;
    }

    protected ClauseHelper<DeleteClause> getDeleteClauseHelper() {
        DeleteClauseHelper helper = this.getHelper(DeleteClauseHelper.class);
        if (helper == null) {
            helper = this.buildDeleteClauseHelper();
            this.registerHelper(DeleteClauseHelper.class, helper);
        }
        return helper;
    }

    protected DoubleEncapsulatedCollectionHelper getDoubleEncapsulatedCollectionHelper() {
        DoubleEncapsulatedCollectionHelper helper = this.getHelper(DoubleEncapsulatedCollectionHelper.class);
        if (helper == null) {
            helper = this.buildDoubleEncapsulatedCollectionHelper();
            this.registerHelper(DoubleEncapsulatedCollectionHelper.class, helper);
        }
        return helper;
    }

    protected IEmbeddable getEmbeddable(IType type) {
        return this.getProvider().getEmbeddable(type);
    }

    protected IEntity getEntity(IType type) {
        return this.getProvider().getEntity(type);
    }

    protected IEntity getEntityNamed(String entityName) {
        return this.getProvider().getEntityNamed(entityName);
    }

    protected ExpressionRegistry getExpressionRegistry() {
        return this.getQueryContext().getExpressionRegistry();
    }

    protected AcceptableTypeVisitor getExpressionTypeVisitor() {
        AcceptableTypeVisitor helper = this.getHelper(AcceptableTypeVisitor.class);
        if (helper == null) {
            helper = this.buildAcceptableTypeVisitor();
            this.registerHelper(AcceptableTypeVisitor.class, helper);
        }
        return helper;
    }

    protected FromClauseCollectionHelper getFromClauseCollectionHelper() {
        FromClauseCollectionHelper helper = this.getHelper(FromClauseCollectionHelper.class);
        if (helper == null) {
            helper = this.buildFromClauseCollectionHelper();
            this.registerHelper(FromClauseCollectionHelper.class, helper);
        }
        return helper;
    }

    protected ClauseHelper<AbstractFromClause> getFromClauseHelper() {
        FromClauseHelper helper = this.getHelper(FromClauseHelper.class);
        if (helper == null) {
            helper = this.buildFromClauseHelper();
            this.registerHelper(FromClauseHelper.class, helper);
        }
        return helper;
    }

    protected FromClauseSelectStatementHelper getFromClauseSelectStatementHelper() {
        FromClauseSelectStatementHelper helper = this.getHelper(FromClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildFromClauseSelectStatementHelper();
            this.registerHelper(FromClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    protected JPQLGrammar getGrammar() {
        return this.getQueryContext().getGrammar();
    }

    protected GroupByClauseCollectionHelper getGroupByClauseCollectionHelper() {
        GroupByClauseCollectionHelper helper = this.getHelper(GroupByClauseCollectionHelper.class);
        if (helper == null) {
            helper = this.buildGroupByClauseCollectionHelper();
            this.registerHelper(GroupByClauseCollectionHelper.class, helper);
        }
        return helper;
    }

    protected GroupByClauseSelectStatementHelper getGroupByClauseSelectStatementHelper() {
        GroupByClauseSelectStatementHelper helper = this.getHelper(GroupByClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildGroupByClauseSelectStatementHelper();
            this.registerHelper(GroupByClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    protected ClauseHelper<HavingClause> getHavingClauseHelper() {
        HavingClauseHelper helper = this.getHelper(HavingClauseHelper.class);
        if (helper == null) {
            helper = this.buildHavingClauseHelper();
            this.registerHelper(HavingClauseHelper.class, helper);
        }
        return helper;
    }

    protected HavingClauseSelectStatementHelper getHavingClauseSelectStatementHelper() {
        HavingClauseSelectStatementHelper helper = this.getHelper(HavingClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildHavingClauseSelectStatementHelper();
            this.registerHelper(HavingClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    protected final <T> T getHelper(Class<T> helperClass) {
        return (T)this.helpers.get(helperClass);
    }

    protected IdentifierRole getIdentifierRole(String identifier) {
        return this.getExpressionRegistry().getIdentifierRole(identifier);
    }

    protected JPAVersion getIdentifierVersion(String identifier) {
        return this.getExpressionRegistry().getIdentifierVersion(identifier);
    }

    protected CompletenessVisitor getIncompleteCollectionExpressionVisitor() {
        IncompleteCollectionExpressionVisitor helper = this.getHelper(IncompleteCollectionExpressionVisitor.class);
        if (helper == null) {
            helper = this.buildIncompleteCollectionExpressionVisitor();
            this.registerHelper(IncompleteCollectionExpressionVisitor.class, helper);
        }
        return helper;
    }

    protected JoinCollectionHelper getJoinCollectionHelper() {
        JoinCollectionHelper helper = this.getHelper(JoinCollectionHelper.class);
        if (helper == null) {
            helper = this.buildJoinCollectionHelper();
            this.registerHelper(JoinCollectionHelper.class, helper);
        }
        return helper;
    }

    protected JPAVersion getJPAVersion() {
        return this.getQueryContext().getJPAVersion();
    }

    protected JPQLExpression getJPQLExpression() {
        return this.context.getJPQLExpression();
    }

    protected IManagedType getManagedType(IType type) {
        return this.getProvider().getManagedType(type);
    }

    protected IMappedSuperclass getMappedSuperclass(IType type) {
        return this.getProvider().getMappedSuperclass(type);
    }

    protected IMapping getMapping(Expression expression) {
        return this.context.getMapping(expression);
    }

    protected Filter<IMapping> getMappingCollectionFilter() {
        CollectionMappingFilter helper = this.getHelper(CollectionMappingFilter.class);
        if (helper == null) {
            helper = this.buildCollectionMappingFilter();
            this.registerHelper(CollectionMappingFilter.class, helper);
        }
        return helper;
    }

    protected MappingFilterBuilder getMappingFilterBuilder() {
        MappingFilterBuilder helper = (MappingFilterBuilder)this.helpers.get(MappingFilterBuilder.class);
        if (helper == null) {
            helper = this.buildMappingFilterBuilder();
            this.helpers.put(MappingFilterBuilder.class, helper);
        }
        return helper;
    }

    protected Filter<IMapping> getMappingPropertyFilter() {
        PropertyMappingFilter helper = (PropertyMappingFilter)this.helpers.get(PropertyMappingFilter.class);
        if (helper == null) {
            helper = this.buildPropertyMappingFilter();
            this.helpers.put(PropertyMappingFilter.class, helper);
        }
        return helper;
    }

    protected NullExpressionVisitor getNullExpressionVisitor() {
        if (this.nullExpressionVisitor == null) {
            this.nullExpressionVisitor = this.buildNullExpressionVisitor();
        }
        return this.nullExpressionVisitor;
    }

    protected OrderByClauseCollectionHelper getOrderByClauseCollectionHelper() {
        OrderByClauseCollectionHelper helper = this.getHelper(OrderByClauseCollectionHelper.class);
        if (helper == null) {
            helper = this.buildOrderByClauseCollectionHelper();
            this.registerHelper(OrderByClauseCollectionHelper.class, helper);
        }
        return helper;
    }

    protected OrderByClauseSelectStatementHelper getOrderByClauseSelectStatementHelper() {
        OrderByClauseSelectStatementHelper helper = this.getHelper(OrderByClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildOrderByClauseSelectStatementHelper();
            this.registerHelper(OrderByClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    protected int getPosition(Expression expression) {
        return this.queryPosition.getPosition(expression);
    }

    public DefaultContentAssistProposals getProposals() {
        return this.proposals;
    }

    protected IManagedTypeProvider getProvider() {
        return this.getQuery().getProvider();
    }

    protected IQuery getQuery() {
        return this.context.getQuery();
    }

    protected JPQLQueryBNF getQueryBNF(String queryBNFId) {
        return this.getExpressionRegistry().getQueryBNF(queryBNFId);
    }

    protected JPQLQueryContext getQueryContext() {
        return this.context;
    }

    protected String getQueryExpression() {
        return this.getQuery().getExpression();
    }

    protected RangeVariableDeclarationVisitor getRangeVariableDeclarationVisitor() {
        RangeVariableDeclarationVisitor helper = this.getHelper(RangeVariableDeclarationVisitor.class);
        if (helper == null) {
            helper = this.buildRangeVariableDeclarationVisitor();
            this.registerHelper(RangeVariableDeclarationVisitor.class, helper);
        }
        return helper;
    }

    protected Resolver getResolver(Expression expression) {
        return this.context.getResolver(expression);
    }

    protected ResultVariableVisitor getResultVariableVisitor() {
        ResultVariableVisitor helper = this.getHelper(ResultVariableVisitor.class);
        if (helper == null) {
            helper = this.buildResultVariableVisitor();
            this.registerHelper(ResultVariableVisitor.class, helper);
        }
        return helper;
    }

    protected CompletenessVisitor getSelectClauseCompletenessVisitor() {
        SelectClauseCompletenessVisitor helper = (SelectClauseCompletenessVisitor)this.helpers.get(SelectClauseCompletenessVisitor.class);
        if (helper == null) {
            helper = this.buildSelectClauseCompleteness();
            this.helpers.put(SelectClauseCompletenessVisitor.class, helper);
        }
        return helper;
    }

    protected SelectClauseSelectStatementHelper getSelectClauseSelectStatementHelper() {
        SelectClauseSelectStatementHelper helper = this.getHelper(SelectClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildSelectClauseSelectStatementHelper();
            this.registerHelper(SelectClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    protected SimpleFromClauseSelectStatementHelper getSimpleFromClauseSelectStatementHelper() {
        SimpleFromClauseSelectStatementHelper helper = this.getHelper(SimpleFromClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildSimpleFromClauseSelectStatementHelper();
            this.registerHelper(SimpleFromClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    protected SimpleGroupByClauseSelectStatementHelper getSimpleGroupByClauseSelectStatementHelper() {
        SimpleGroupByClauseSelectStatementHelper helper = this.getHelper(SimpleGroupByClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildSimpleGroupByClauseSelectStatementHelper();
            this.registerHelper(SimpleGroupByClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    protected SimpleHavingClauseSelectStatementHelper getSimpleHavingClauseSelectStatementHelper() {
        SimpleHavingClauseSelectStatementHelper helper = this.getHelper(SimpleHavingClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildSimpleHavingClauseSelectStatementHelper();
            this.registerHelper(SimpleHavingClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    protected SimpleSelectClauseSelectStatementHelper getSimpleSelectClauseSelectStatementHelper() {
        SimpleSelectClauseSelectStatementHelper helper = this.getHelper(SimpleSelectClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildSimpleSelectClauseSelectStatementHelper();
            this.registerHelper(SimpleSelectClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    protected SimpleWhereClauseSelectStatementHelper getSimpleWhereClauseSelectStatementHelper() {
        SimpleWhereClauseSelectStatementHelper helper = this.getHelper(SimpleWhereClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildSimpleWhereClauseSelectStatementHelper();
            this.registerHelper(SimpleWhereClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    protected SubqueryVisitor getSubqueryVisitor() {
        SubqueryVisitor helper = this.getHelper(SubqueryVisitor.class);
        if (helper == null) {
            helper = this.buildSubqueryVisitor();
            this.registerHelper(SubqueryVisitor.class, helper);
        }
        return helper;
    }

    protected TripleEncapsulatedCollectionHelper getTripleEncapsulatedCollectionHelper() {
        TripleEncapsulatedCollectionHelper helper = this.getHelper(TripleEncapsulatedCollectionHelper.class);
        if (helper == null) {
            helper = this.buildTripleEncapsulatedCollectionHelper();
            this.registerHelper(TripleEncapsulatedCollectionHelper.class, helper);
        }
        return helper;
    }

    protected IType getType(Class<?> type) {
        return this.getTypeRepository().getType(type);
    }

    protected IType getType(Expression expression) {
        return this.context.getType(expression);
    }

    protected IType getType(String typeName) {
        return this.getTypeRepository().getType(typeName);
    }

    protected ITypeDeclaration getTypeDeclaration(Expression expression) {
        return this.context.getTypeDeclaration(expression);
    }

    protected TypeHelper getTypeHelper() {
        return this.getTypeRepository().getTypeHelper();
    }

    protected ITypeRepository getTypeRepository() {
        return this.getProvider().getTypeRepository();
    }

    protected UpdateItemCollectionHelper getUpdateItemCollectionHelper() {
        UpdateItemCollectionHelper helper = this.getHelper(UpdateItemCollectionHelper.class);
        if (helper == null) {
            helper = this.buildUpdateItemCollectionHelper();
            this.registerHelper(UpdateItemCollectionHelper.class, helper);
        }
        return helper;
    }

    protected void initialize() {
        this.helpers = new HashMap();
        this.lockedExpressions = new Stack();
        this.virtualSpaces = new Stack();
        this.virtualSpaces.add(0);
        this.positionInCollections = new Stack();
        this.positionInCollections.add(-1);
        this.corrections = new Stack();
        this.corrections.add(0);
    }

    protected boolean isAggregate(String identifier) {
        return this.getIdentifierRole(identifier) == IdentifierRole.AGGREGATE;
    }

    protected boolean isAppendable(Expression expression) {
        AppendableExpressionVisitor visitor = this.getAppendableExpressionVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.appendable;
            return bl;
        }
        finally {
            visitor.appendable = false;
        }
    }

    protected boolean isAppendableToCollection(Expression expression) {
        CompletenessVisitor visitor = this.getIncompleteCollectionExpressionVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.complete;
            return bl;
        }
        finally {
            visitor.complete = false;
        }
    }

    protected boolean isClause(String identifier) {
        return this.getIdentifierRole(identifier) == IdentifierRole.CLAUSE;
    }

    protected boolean isComplete(Expression expression) {
        CompletenessVisitor visitor = this.getCompletenessVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.complete;
            return bl;
        }
        finally {
            visitor.complete = false;
        }
    }

    protected boolean isCompoundable(Expression expression) {
        CompoundExpressionHelper visitor = this.getCompoundExpressionHelper();
        try {
            expression.accept(visitor);
            boolean bl = visitor.isCompoundable();
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected boolean isCompoundFunction(String identifier) {
        if (identifier == "IS" || identifier == "OF") {
            return false;
        }
        return this.getIdentifierRole(identifier) == IdentifierRole.COMPOUND_FUNCTION;
    }

    protected boolean isConditionalExpressionComplete(Expression expression) {
        CompletenessVisitor visitor = this.getConditionalExpressionCompletenessVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.complete;
            return bl;
        }
        finally {
            visitor.complete = false;
        }
    }

    protected boolean isFunction(String identifier) {
        return this.getIdentifierRole(identifier) == IdentifierRole.FUNCTION;
    }

    protected boolean isGroupByComplete(Expression expression) {
        CompletenessVisitor visitor = this.getCompletenessVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.complete;
            return bl;
        }
        finally {
            visitor.complete = false;
        }
    }

    protected boolean isInSubquery(Expression expression) {
        SubqueryVisitor visitor = this.getSubqueryVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.expression != null;
            return bl;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected abstract boolean isJoinFetchIdentifiable();

    protected boolean isLocked(Expression expression) {
        return !this.lockedExpressions.empty() && this.lockedExpressions.peek() == expression;
    }

    protected boolean isNull(Expression expression) {
        NullExpressionVisitor visitor = this.getNullExpressionVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.expression != null;
            return bl;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected boolean isPositionWithin(int position, int offset, String word) {
        return position >= offset && position - offset <= word.length();
    }

    protected boolean isPositionWithin(int position, String word) {
        return this.isPositionWithin(position, 0, word);
    }

    protected boolean isPreviousClauseComplete(AbstractSelectStatement expression, SelectStatementHelper<AbstractSelectStatement, Expression> helper) {
        if ((helper = this.cast(helper.getPreviousHelper())) == null || !helper.hasClause(expression)) {
            return false;
        }
        Expression clause = helper.getClause(expression);
        Expression clauseExpression = helper.getClauseExpression(clause);
        return helper.isClauseExpressionComplete(clauseExpression);
    }

    protected boolean isResultVariable(Expression expression) {
        ResultVariableVisitor visitor = this.getResultVariableVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.expression != null;
            return bl;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected boolean isSelectExpressionComplete(Expression expression) {
        CompletenessVisitor visitor = this.getSelectClauseCompletenessVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.complete;
            return bl;
        }
        finally {
            visitor.complete = false;
        }
    }

    protected boolean isValidProposal(String proposal, String word) {
        if (word.length() == 0) {
            return true;
        }
        char character = word.charAt(0);
        if (character == '+' || character == '-' || character == '*' || character == '/') {
            return true;
        }
        if (word.length() > proposal.length()) {
            return false;
        }
        int index = 0;
        int length = word.length();
        while (index < length) {
            char upperCase2;
            char character1 = proposal.charAt(index);
            char character2 = word.charAt(index);
            char upperCase1 = Character.toUpperCase(character1);
            if (upperCase1 != (upperCase2 = Character.toUpperCase(character2))) {
                return false;
            }
            if (Character.toLowerCase(upperCase1) != Character.toLowerCase(upperCase2)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    protected boolean isValidVersion(String identifier) {
        JPAVersion identifierVersion = this.getIdentifierVersion(identifier);
        return this.getJPAVersion().isNewerThanOrEqual(identifierVersion);
    }

    protected int length(Expression expression) {
        return expression.getLength();
    }

    public void prepare(QueryPosition queryPosition) {
        this.queryPosition = queryPosition;
        this.proposals = new DefaultContentAssistProposals(this.getGrammar());
        this.wordParser = new WordParser(this.context.getJPQLExpression().toActualText());
        this.wordParser.setPosition(queryPosition.getPosition());
        this.word = this.wordParser.partialWord();
    }

    protected final <T> void registerHelper(Class<T> helperClass, T helper) {
        this.helpers.put(helperClass, helper);
    }

    @Override
    public void visit(AbsExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(AbstractSchemaName expression) {
        this.corrections.add(this.getPosition(expression));
        super.visit(expression);
        this.corrections.pop();
        this.addEntities();
    }

    @Override
    public void visit(AdditionExpression expression) {
        super.visit(expression);
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(AllOrAnyExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.NONE, "ALL", "ANY", "SOME");
    }

    @Override
    public void visit(AndExpression expression) {
        super.visit(expression);
        this.visitLogicalExpression(expression, "AND");
    }

    @Override
    public void visit(ArithmeticFactor expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        if (position == 1) {
            this.addAllIdentificationVariables();
            this.addAllFunctions(expression.getQueryBNF());
        }
    }

    @Override
    public void visit(AvgFunction expression) {
        super.visit(expression);
        this.visitAggregateFunction(expression);
    }

    @Override
    public void visit(BadExpression expression) {
        this.corrections.add(this.getPosition(expression));
        super.visit(expression);
        this.corrections.pop();
    }

    @Override
    public void visit(BetweenExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasExpression()) {
            length += this.length(expression.getExpression()) + 1;
        }
        if (expression.hasNot() && this.isPositionWithin(position, length, "NOT BETWEEN") || !expression.hasNot() && this.isPositionWithin(position, length, "BETWEEN")) {
            this.proposals.addIdentifier("BETWEEN");
            this.proposals.addIdentifier("NOT BETWEEN");
        } else if (expression.hasSpaceAfterBetween()) {
            if (position == (length += expression.getIdentifier().length() + 1)) {
                this.addAllIdentificationVariables();
                this.addAllFunctions("internal_between_expression");
            }
            if (expression.hasLowerBoundExpression()) {
                int lowerBoundLength = this.length(expression.getLowerBoundExpression());
                if (!expression.hasAnd() && position > length && position < length + lowerBoundLength && this.isAppendableToCollection(expression.getLowerBoundExpression())) {
                    this.addIdentifier("AND");
                }
                length += lowerBoundLength;
                if (expression.hasSpaceAfterLowerBound()) {
                    if (position == ++length) {
                        this.proposals.addIdentifier("AND");
                    } else if (expression.hasAnd() && this.isPositionWithin(position, length, "AND")) {
                        this.proposals.addIdentifier("AND");
                    } else if (expression.hasSpaceAfterAnd()) {
                        if (position == (length += "AND".length() + 1)) {
                            this.addAllIdentificationVariables();
                            this.addAllFunctions("internal_between_expression");
                        }
                    } else if (!expression.hasAnd() && expression.hasUpperBoundExpression() && position == (length += this.length(expression.getUpperBoundExpression()))) {
                        this.addIdentifier("AND");
                    }
                }
            }
        }
    }

    @Override
    public void visit(CaseExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "CASE")) {
            if (this.isValidVersion("CASE")) {
                this.proposals.addIdentifier("CASE");
            }
        } else if (expression.hasSpaceAfterCase()) {
            int length = "CASE".length() + 1;
            if (position == length) {
                this.addAllIdentificationVariables();
                this.addAllFunctions("case_operand");
                this.proposals.addIdentifier("WHEN");
            }
            if (expression.hasCaseOperand() && expression.hasSpaceAfterCaseOperand() && position == (length += this.length(expression.getCaseOperand()) + 1)) {
                this.proposals.addIdentifier("WHEN");
            }
            if (expression.hasWhenClauses() && expression.hasSpaceAfterWhenClauses()) {
                if (this.isPositionWithin(position, length += this.length(expression.getWhenClauses()) + 1, "ELSE")) {
                    this.proposals.addIdentifier("ELSE");
                }
                if (expression.hasElse() && expression.hasSpaceAfterElse()) {
                    if (position == (length += "ELSE".length() + 1)) {
                        this.addAllIdentificationVariables();
                        this.addAllFunctions("case_operand");
                    }
                    if (expression.hasElseExpression() && expression.hasSpaceAfterElseExpression() && this.isPositionWithin(position, length += this.length(expression.getElseExpression()) + 1, "END")) {
                        this.proposals.addIdentifier("END");
                    }
                }
            }
        }
    }

    @Override
    public void visit(CoalesceExpression expression) {
        super.visit(expression);
        this.visitEncapsulatedExpression(expression, "COALESCE", expression.encapsulatedExpressionBNF());
    }

    @Override
    public void visit(CollectionExpression expression) {
        this.positionInCollections.add(this.findExpressionPosition(expression));
        super.visit(expression);
        this.positionInCollections.pop();
    }

    @Override
    public void visit(CollectionMemberDeclaration expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "IN")) {
            this.proposals.addIdentifier("IN");
        }
        if (this.isInSubquery(expression) && expression.hasSpaceAfterIn()) {
            int length = "IN".length() + 1;
            if (position == length) {
                this.addLeftIdentificationVariables(expression);
            }
        } else if (expression.hasLeftParenthesis()) {
            int length = "IN".length() + 1;
            if (position == length) {
                this.addLeftIdentificationVariables(expression);
                this.addAllFunctions("collection_valued_path_expression");
            }
            if (expression.hasRightParenthesis()) {
                if (position == (length += this.length(expression.getCollectionValuedPathExpression()) + 1) && !expression.hasSpaceAfterRightParenthesis()) {
                    this.proposals.addIdentifier("AS");
                }
                if (expression.hasSpaceAfterRightParenthesis()) {
                    ++length;
                }
                if (this.isPositionWithin(position, length, "AS")) {
                    this.proposals.addIdentifier("AS");
                }
            }
        }
    }

    @Override
    public void visit(CollectionMemberExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        String identifier = expression.getIdentifier();
        int length = 0;
        if (expression.hasEntityExpression()) {
            length = this.length(expression.getEntityExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, identifier)) {
            this.proposals.addIdentifier("NOT MEMBER");
            this.proposals.addIdentifier("NOT MEMBER OF");
            this.proposals.addIdentifier("MEMBER");
            this.proposals.addIdentifier("MEMBER OF");
        } else if ((expression.hasOf() && expression.hasSpaceAfterOf() || !expression.hasOf() && expression.hasSpaceAfterMember()) && position == (length += identifier.length() + 1)) {
            if (!expression.hasOf()) {
                this.addIdentifier("OF");
            }
            this.addAllIdentificationVariables();
        }
    }

    @Override
    public void visit(CollectionValuedPathExpression expression) {
        this.visitPathExpression(expression);
    }

    @Override
    public void visit(ComparisonExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasLeftExpression()) {
            length += this.length(expression.getLeftExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, expression.getComparisonOperator())) {
            this.addAllExpressionFactoryIdentifiers("comparison");
        }
        length += expression.getComparisonOperator().length();
        if (expression.hasSpaceAfterIdentifier()) {
            ++length;
        }
        if (position == length) {
            this.addAllIdentificationVariables();
            this.addAllFunctions(expression.rightExpressionBNF());
            this.addAllClauses(expression.rightExpressionBNF());
        }
    }

    @Override
    public void visit(ConcatExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(ConstructorExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "NEW")) {
            this.proposals.addIdentifier("NEW");
        } else if (expression.hasSpaceAfterNew()) {
            int length = "NEW".length() + 1;
            if (expression.hasLeftParenthesis()) {
                String className = expression.getClassName();
                if (position == (length += className.length() + 1)) {
                    this.addAllIdentificationVariables();
                    this.addAllFunctions("constructor_item");
                } else {
                    this.visitCollectionExpression(expression, "NEW", this.getConstructorCollectionHelper());
                }
            }
        }
    }

    @Override
    public void visit(CountFunction expression) {
        super.visit(expression);
        this.visitAggregateFunction(expression);
    }

    @Override
    public void visit(DateTime expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "CURRENT_DATE") || this.isPositionWithin(position, "CURRENT_TIME") || this.isPositionWithin(position, "CURRENT_TIMESTAMP")) {
            this.proposals.addIdentifier("CURRENT_DATE");
            this.proposals.addIdentifier("CURRENT_TIME");
            this.proposals.addIdentifier("CURRENT_TIMESTAMP");
        }
    }

    @Override
    public void visit(DeleteClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitClause(expression, "DELETE FROM", expression.hasSpaceAfterFrom(), this.getDeleteClauseHelper());
        }
    }

    @Override
    public void visit(DeleteStatement expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitDeleteStatement(expression);
        }
    }

    @Override
    public void visit(DivisionExpression expression) {
        super.visit(expression);
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(EmptyCollectionComparisonExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasExpression()) {
            length = this.length(expression.getExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, expression.getIdentifier())) {
            this.proposals.addIdentifier("IS EMPTY");
            this.proposals.addIdentifier("IS NOT EMPTY");
        }
    }

    @Override
    public void visit(EntityTypeLiteral expression) {
        this.corrections.add(this.getPosition(expression));
        super.visit(expression);
        this.corrections.pop();
        this.addEntities();
    }

    @Override
    public void visit(EntryExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.COLLECTION);
    }

    @Override
    public void visit(ExistsExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.NONE, "EXISTS", "NOT EXISTS");
    }

    @Override
    protected void visit(Expression expression) {
        expression.getParent().accept(this);
    }

    @Override
    public void visit(FromClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, "FROM", this.getFromClauseCollectionHelper());
        }
    }

    @Override
    public void visit(FunctionExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(GroupByClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, "GROUP BY", this.getGroupByClauseCollectionHelper());
        }
    }

    @Override
    public void visit(HavingClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitClause(expression, "HAVING", expression.hasSpaceAfterIdentifier(), this.getHavingClauseHelper());
            this.visitCompoundableExpression(expression);
        }
    }

    @Override
    public void visit(IdentificationVariable expression) {
        this.corrections.add(this.getPosition(expression));
        super.visit(expression);
        this.corrections.pop();
    }

    @Override
    public void visit(IdentificationVariableDeclaration expression) {
        super.visit(expression);
        if (expression.hasSpace()) {
            int length;
            int position = this.getPosition(expression) - this.corrections.peek();
            if (position == (length = this.length(expression.getRangeVariableDeclaration()) + 1)) {
                this.addJoinIdentifiers();
            } else {
                this.visitCollectionExpression(expression, "", this.getJoinCollectionHelper());
            }
        }
    }

    @Override
    public void visit(IndexExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(InExpression expression) {
        expression.accept(this.visitParentVisitor());
        int position = this.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasExpression()) {
            length += this.length(expression.getExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, expression.getIdentifier())) {
            this.proposals.addIdentifier("IN");
            this.proposals.addIdentifier("NOT IN");
        } else if (expression.hasLeftParenthesis() && position == (length += expression.getIdentifier().length() + 1)) {
            this.addAllFunctions("in_expression_item");
            this.proposals.addIdentifier("SELECT");
        }
    }

    @Override
    public void visit(InputParameter expression) {
        super.visit(expression);
    }

    @Override
    public void visit(Join expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        String identifier = expression.getIdentifier();
        boolean joinFetch = expression.hasFetch();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier("JOIN");
            this.proposals.addIdentifier("INNER JOIN");
            this.proposals.addIdentifier("LEFT JOIN");
            this.proposals.addIdentifier("LEFT OUTER JOIN");
            if (this.isJoinFetchIdentifiable() || !expression.hasAs() && !expression.hasIdentificationVariable()) {
                this.proposals.addIdentifier("JOIN FETCH");
                this.proposals.addIdentifier("INNER JOIN FETCH");
                this.proposals.addIdentifier("LEFT JOIN FETCH");
                this.proposals.addIdentifier("LEFT OUTER JOIN FETCH");
            }
        } else if (expression.hasSpaceAfterJoin()) {
            int length = identifier.length() + 1;
            if (position == length) {
                if (identifier == "LEFT") {
                    this.addIdentifier("LEFT JOIN");
                    this.addIdentifier("LEFT OUTER JOIN");
                    if (this.isJoinFetchIdentifiable() || !expression.hasAs() && !expression.hasIdentificationVariable()) {
                        this.addIdentifier("LEFT JOIN FETCH");
                        this.addIdentifier("LEFT OUTER JOIN FETCH");
                    }
                } else if (identifier == "INNER") {
                    this.addIdentifier("INNER JOIN");
                    if (this.isJoinFetchIdentifiable() || !expression.hasAs() && !expression.hasIdentificationVariable()) {
                        this.addIdentifier("INNER JOIN FETCH");
                    }
                } else if (identifier.equals("LEFT_OUTER")) {
                    this.addIdentifier("LEFT OUTER JOIN");
                    if (this.isJoinFetchIdentifiable() || !expression.hasAs() && !expression.hasIdentificationVariable()) {
                        this.addIdentifier("LEFT OUTER JOIN FETCH");
                    }
                } else {
                    this.addLeftIdentificationVariables(expression);
                }
            }
            if (expression.hasJoinAssociationPath() && expression.hasSpaceAfterJoinAssociation() && (!joinFetch || joinFetch && this.isJoinFetchIdentifiable()) && this.isPositionWithin(position, length += this.length(expression.getJoinAssociationPath()) + 1, "AS")) {
                this.addIdentifier("AS");
            }
        }
    }

    @Override
    public void visit(JPQLExpression expression) {
        if (!this.isLocked(expression)) {
            int length;
            int position = this.getPosition(expression);
            boolean hasQueryStatement = expression.hasQueryStatement();
            int n = length = hasQueryStatement ? this.length(expression.getQueryStatement()) : 0;
            if (position == 0) {
                this.addIdentifier("SELECT");
                this.addIdentifier("UPDATE");
                this.addIdentifier("DELETE FROM");
            } else if (position > length) {
                String text = expression.getUnknownEndingStatement().toActualText();
                this.addIdentifier("SELECT", text);
                this.addIdentifier("DELETE FROM", text);
                this.addIdentifier("UPDATE", text);
                if (hasQueryStatement) {
                    this.lockedExpressions.add(expression);
                    this.corrections.add(-length - 1);
                    expression.getQueryStatement().accept(this);
                    this.corrections.pop();
                    this.lockedExpressions.pop();
                }
            }
        }
    }

    @Override
    public void visit(KeyExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.LEFT_COLLECTION);
    }

    @Override
    public void visit(KeywordExpression expression) {
        this.corrections.add(this.getPosition(expression));
        super.visit(expression);
        this.corrections.pop();
        int position = this.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "TRUE") || this.isPositionWithin(position, "FALSE") || this.isPositionWithin(position, "NULL")) {
            this.proposals.addIdentifier("TRUE");
            this.proposals.addIdentifier("FALSE");
            this.proposals.addIdentifier("NULL");
        }
    }

    @Override
    public void visit(LengthExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(LikeExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasStringExpression()) {
            length += this.length(expression.getStringExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, expression.getIdentifier())) {
            this.proposals.addIdentifier("LIKE");
            this.proposals.addIdentifier("NOT LIKE");
        } else if (expression.hasSpaceAfterLike()) {
            length += expression.getIdentifier().length() + 1;
            if (expression.hasPatternValue() && expression.hasSpaceAfterPatternValue() && this.isPositionWithin(position, length += this.length(expression.getPatternValue()) + 1, "ESCAPE")) {
                this.proposals.addIdentifier("ESCAPE");
            }
        }
    }

    @Override
    public void visit(LocateExpression expression) {
        super.visit(expression);
        this.visitCollectionExpression(expression, "LOCATE", this.getTripleEncapsulatedCollectionHelper());
    }

    @Override
    public void visit(LowerExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(MaxFunction expression) {
        super.visit(expression);
        this.visitAggregateFunction(expression);
    }

    @Override
    public void visit(MinFunction expression) {
        super.visit(expression);
        this.visitAggregateFunction(expression);
    }

    @Override
    public void visit(ModExpression expression) {
        super.visit(expression);
        this.visitCollectionExpression(expression, "MOD", this.getDoubleEncapsulatedCollectionHelper());
    }

    @Override
    public void visit(MultiplicationExpression expression) {
        super.visit(expression);
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(NotExpression expression) {
        int length;
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "NOT")) {
            this.proposals.addIdentifier("NOT");
            if (!expression.hasExpression()) {
                int currentPosition = this.queryPosition.getPosition();
                this.addIdentifier("NOT BETWEEN", currentPosition);
                this.addIdentifier("NOT EXISTS", currentPosition);
                this.addIdentifier("NOT IN", currentPosition);
                this.addIdentifier("NOT LIKE", currentPosition);
                this.addIdentifier("NOT MEMBER", currentPosition);
                this.addIdentifier("NOT MEMBER OF", currentPosition);
                this.addIdentifier("IS NOT EMPTY", currentPosition);
                this.addIdentifier("IS NOT NULL", currentPosition);
            }
        } else if (expression.hasSpaceAfterNot() && position == (length = "NOT".length() + 1)) {
            boolean canAddCompoundIdentifiers;
            boolean bl = canAddCompoundIdentifiers = !expression.hasExpression();
            if (!canAddCompoundIdentifiers) {
                String variableName = this.context.literal(expression.getExpression(), LiteralType.IDENTIFICATION_VARIABLE);
                canAddCompoundIdentifiers = ExpressionTools.stringIsNotEmpty(variableName);
            }
            if (canAddCompoundIdentifiers) {
                int currentPosition = this.queryPosition.getPosition();
                this.addIdentifier("NOT BETWEEN", currentPosition);
                this.addIdentifier("NOT EXISTS", currentPosition);
                this.addIdentifier("NOT IN", currentPosition);
                this.addIdentifier("NOT LIKE", currentPosition);
                this.addIdentifier("NOT MEMBER", currentPosition);
                this.addIdentifier("NOT MEMBER OF", currentPosition);
                this.addIdentifier("IS NOT EMPTY", currentPosition);
                this.addIdentifier("IS NOT NULL", currentPosition);
            }
        }
    }

    @Override
    public void visit(NullComparisonExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasExpression()) {
            length += this.length(expression.getExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, expression.getIdentifier())) {
            this.proposals.addIdentifier("IS NULL");
            this.proposals.addIdentifier("IS NOT NULL");
        }
    }

    @Override
    public void visit(NullExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(NullIfExpression expression) {
        super.visit(expression);
        this.visitCollectionExpression(expression, "NULLIF", this.getDoubleEncapsulatedCollectionHelper());
    }

    @Override
    public void visit(NumericLiteral expression) {
        super.visit(expression);
    }

    @Override
    public void visit(ObjectExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(OrderByClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitCollectionExpression(expression, "ORDER BY", this.getOrderByClauseCollectionHelper());
        }
    }

    @Override
    public void visit(OrderByItem expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        if (expression.hasExpression()) {
            int length = this.length(expression.getExpression());
            if (expression.hasSpaceAfterExpression()) {
                if (position == ++length) {
                    this.proposals.addIdentifier("ASC");
                    this.proposals.addIdentifier("DESC");
                } else {
                    OrderByItem.Ordering ordering = expression.getOrdering();
                    if (ordering != OrderByItem.Ordering.DEFAULT && this.isPositionWithin(position, length, ordering.name())) {
                        this.proposals.addIdentifier("ASC");
                        this.proposals.addIdentifier("DESC");
                    }
                }
            }
        }
    }

    @Override
    public void visit(OrExpression expression) {
        super.visit(expression);
        this.visitLogicalExpression(expression, "OR");
    }

    @Override
    public void visit(RangeVariableDeclaration expression) {
        int length;
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        if (expression.hasRootObject() && expression.hasSpaceAfterRootObject() && this.isPositionWithin(position, length = this.length(expression.getRootObject()) + 1, "AS")) {
            this.addIdentifier("AS");
        }
    }

    @Override
    public void visit(ResultVariable expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasSelectExpression()) {
            length += this.length(expression.getSelectExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, "AS")) {
            this.addIdentifier("AS");
        }
    }

    @Override
    public void visit(SelectClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitSelectClause(expression);
        }
    }

    @Override
    public void visit(SelectStatement expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitSelectStatement(expression, this.getSelectClauseSelectStatementHelper());
        }
    }

    @Override
    public void visit(SimpleFromClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitClause(expression, "FROM", expression.hasSpaceAfterFrom(), this.getFromClauseHelper());
        }
    }

    @Override
    public void visit(SimpleSelectClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitSelectClause(expression);
        }
    }

    @Override
    public void visit(SimpleSelectStatement expression) {
        if (!this.isLocked(expression)) {
            this.visitSelectStatement(expression, this.getSimpleSelectClauseSelectStatementHelper());
        }
    }

    @Override
    public void visit(SizeExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(SqrtExpression expression) {
        expression.accept(this.visitParentVisitor());
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(StateFieldPathExpression expression) {
        this.visitPathExpression(expression);
    }

    @Override
    public void visit(StringLiteral expression) {
        super.visit(expression);
    }

    @Override
    public void visit(SubExpression expression) {
        this.corrections.add(this.getPosition(expression));
        super.visit(expression);
        this.corrections.pop();
    }

    @Override
    public void visit(SubstringExpression expression) {
        super.visit(expression);
        this.visitCollectionExpression(expression, "SUBSTRING", this.getTripleEncapsulatedCollectionHelper());
    }

    @Override
    public void visit(SubtractionExpression expression) {
        super.visit(expression);
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(SumFunction expression) {
        super.visit(expression);
        this.visitAggregateFunction(expression);
    }

    @Override
    public void visit(TreatExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.getCorrections().peek();
        if (this.isPositionWithin(position, "TREAT")) {
            if (this.isValidVersion("TREAT")) {
                this.proposals.addIdentifier("TREAT");
            }
        } else if (expression.hasLeftParenthesis()) {
            Expression collectionValuedPathExpression;
            int length = "TREAT".length() + 1;
            if (position == length) {
                this.addLeftIdentificationVariables(expression);
            }
            if (expression.hasCollectionValuedPathExpression() && expression.hasSpaceAfterCollectionValuedPathExpression() && this.isPositionWithin(position, length += this.length(collectionValuedPathExpression = expression.getCollectionValuedPathExpression()) + 1, "AS")) {
                this.getProposals().addIdentifier("AS");
                if (!expression.hasEntityType()) {
                    IType type = this.getType(collectionValuedPathExpression);
                    if (type.isResolvable()) {
                        this.addEntities(type);
                    } else {
                        this.addEntities();
                    }
                }
            }
            if (expression.hasAs() && expression.hasSpaceAfterAs() && position == (length += "AS".length() + 1)) {
                IType type = this.getType(expression.getCollectionValuedPathExpression());
                if (type.isResolvable()) {
                    this.addEntities(type);
                } else {
                    this.addEntities();
                }
            }
        }
    }

    @Override
    public void visit(TrimExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (this.isPositionWithin(position, "TRIM")) {
            this.proposals.addIdentifier("TRIM");
        } else if (expression.hasLeftParenthesis()) {
            if (position == (length += "TRIM".length() + 1)) {
                this.addIdentifier("BOTH");
                this.addIdentifier("LEADING");
                this.addIdentifier("TRAILING");
                if (!expression.hasTrimCharacter() && !expression.hasFrom()) {
                    this.addAllIdentificationVariables();
                    this.addAllFunctions("string_primary");
                }
            }
            if (expression.hasSpecification()) {
                String specification = expression.getSpecification().name();
                if (this.isPositionWithin(position, length, specification)) {
                    this.addIdentifier("BOTH");
                    this.addIdentifier("LEADING");
                    this.addIdentifier("TRAILING");
                    if (!expression.hasTrimCharacter() && !expression.hasFrom()) {
                        this.addAllIdentificationVariables();
                        this.addAllFunctions("string_primary");
                    }
                }
                length += specification.length();
            }
            if (expression.hasSpaceAfterSpecification()) {
                ++length;
            }
            if (expression.hasTrimCharacter()) {
                length += this.length(expression.getTrimCharacter());
            }
            if (expression.hasSpaceAfterTrimCharacter()) {
                ++length;
            }
            if (position == length) {
                this.addIdentifier("FROM");
                if (!expression.hasFrom()) {
                    this.addAllIdentificationVariables();
                    this.addAllFunctions("string_primary");
                }
            }
            if (expression.hasFrom()) {
                if (this.isPositionWithin(position, length, "FROM")) {
                    this.addIdentifier("FROM");
                }
                length += "FROM".length();
            }
            if (expression.hasSpaceAfterFrom()) {
                ++length;
            }
            if (position == length) {
                this.addAllIdentificationVariables();
                this.addAllFunctions("string_primary");
            }
            if (expression.hasExpression() && position == (length += this.length(expression.getExpression())) + this.virtualSpaces.peek() && !expression.hasTrimCharacter() && !expression.hasFrom()) {
                this.addIdentifier("FROM");
            }
        }
    }

    @Override
    public void visit(TypeExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(UnknownExpression expression) {
        this.corrections.add(this.getPosition(expression));
        super.visit(expression);
        this.corrections.pop();
    }

    @Override
    public void visit(UpdateClause expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "UPDATE")) {
            this.proposals.addIdentifier("UPDATE");
        } else if (expression.hasSpaceAfterUpdate()) {
            RangeVariableDeclaration rangeVariableDeclaration;
            int length = "UPDATE".length() + 1;
            if (position == length) {
                this.addEntities();
            } else if (expression.hasRangeVariableDeclaration() && (rangeVariableDeclaration = this.findRangeVariableDeclaration(expression)) != null && rangeVariableDeclaration.hasRootObject() && rangeVariableDeclaration.hasSpaceAfterRootObject()) {
                if (!expression.hasSet() && !rangeVariableDeclaration.hasAs() && this.isPositionWithin(position, length += this.length(rangeVariableDeclaration.getRootObject()) + 1, "SET")) {
                    this.addIdentifier("SET");
                } else {
                    if (rangeVariableDeclaration.hasAs()) {
                        length += 2;
                    }
                    if (rangeVariableDeclaration.hasSpaceAfterAs()) {
                        ++length;
                    }
                    if (rangeVariableDeclaration.hasIdentificationVariable()) {
                        length += this.length(rangeVariableDeclaration.getIdentificationVariable());
                    }
                    if (expression.hasSpaceAfterRangeVariableDeclaration()) {
                        ++length;
                    }
                    if ((rangeVariableDeclaration.hasAs() && rangeVariableDeclaration.hasIdentificationVariable() || !rangeVariableDeclaration.hasAs() && rangeVariableDeclaration.hasIdentificationVariable()) && this.isPositionWithin(position, length, "SET")) {
                        this.addIdentifier("SET");
                    } else if (expression.hasSet() && expression.hasSpaceAfterSet()) {
                        if (position == (length += "SET".length() + 1)) {
                            this.addAllIdentificationVariables();
                        } else {
                            this.visitCollectionExpression(expression, "", this.getUpdateItemCollectionHelper());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void visit(UpdateItem expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (position == length) {
            this.addAllIdentificationVariables();
        } else if (expression.hasStateFieldPathExpression() && expression.hasSpaceAfterStateFieldPathExpression()) {
            if (position == (length += this.length(expression.getStateFieldPathExpression()) + 1)) {
                this.proposals.addIdentifier("=");
            } else if (expression.hasEqualSign()) {
                if (position == ++length) {
                    this.proposals.addIdentifier("=");
                    this.addAllIdentificationVariables();
                    this.addAllFunctions("new_value");
                } else if (expression.hasSpaceAfterEqualSign() && position == ++length) {
                    this.addAllIdentificationVariables();
                    this.addAllFunctions("new_value");
                }
            }
        }
    }

    @Override
    public void visit(UpdateStatement expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitUpdateStatement(expression);
        }
    }

    @Override
    public void visit(UpperExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.ALL);
    }

    @Override
    public void visit(ValueExpression expression) {
        super.visit(expression);
        this.visitSingleEncapsulatedExpression(expression, IdentificationVariableType.LEFT_COLLECTION);
    }

    @Override
    public void visit(WhenClause expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "WHEN")) {
            this.proposals.addIdentifier("WHEN");
        } else if (expression.hasSpaceAfterWhen()) {
            int length = "WHEN".length() + 1;
            if (position == length) {
                this.addAllIdentificationVariables();
                this.addAllFunctions("internal_when_clause*");
            } else {
                length += this.length(expression.getWhenExpression());
                if (expression.hasSpaceAfterWhenExpression()) {
                    if (position == ++length) {
                        this.proposals.addIdentifier("THEN");
                    } else if (expression.hasThen()) {
                        if (this.isPositionWithin(position, length, "THEN")) {
                            this.proposals.addIdentifier("THEN");
                        } else {
                            length += "THEN".length();
                            if (expression.hasSpaceAfterThen() && position == ++length) {
                                this.addScalarExpressionProposals();
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void visit(WhereClause expression) {
        if (!this.isLocked(expression)) {
            super.visit(expression);
            this.visitClause(expression, "WHERE", expression.hasSpaceAfterIdentifier(), this.whereClauseHelper());
            this.visitCompoundableExpression(expression);
        }
    }

    protected void visitAggregateFunction(AggregateFunction expression) {
        String identifier;
        int position = this.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, identifier = expression.getIdentifier())) {
            this.proposals.addIdentifier(identifier);
        } else if (expression.hasLeftParenthesis()) {
            int length = identifier.length() + 1;
            boolean hasDistinct = expression.hasDistinct();
            if (hasDistinct && this.isPositionWithin(position, length, "DISTINCT")) {
                this.addIdentifier("DISTINCT");
            } else {
                if (hasDistinct && expression.hasSpaceAfterDistinct()) {
                    length += "DISTINCT".length() + 1;
                }
                if (position == length) {
                    if (!hasDistinct) {
                        this.addIdentifier("DISTINCT");
                    }
                    this.addAllIdentificationVariables();
                    this.addAllFunctions(expression.encapsulatedExpressionBNF());
                }
            }
        }
    }

    protected void visitArithmeticExpression(ArithmeticExpression expression) {
        int position = this.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasLeftExpression()) {
            length += this.length(expression.getLeftExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, "+")) {
            this.addAllAggregates(expression.getQueryBNF());
        } else if (expression.hasSpaceAfterIdentifier() && position == (length += 2) && this.positionInCollections.peek() == -1) {
            this.addAllIdentificationVariables();
            this.addAllFunctions(expression.rightExpressionBNF(), position);
        }
    }

    protected <T extends AbstractExpression> void visitClause(T expression, String identifier, boolean hasSpaceAfterIdentifier, ClauseHelper<T> helper) {
        this.lockedExpressions.add(expression);
        int position = this.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier(identifier);
        } else if (hasSpaceAfterIdentifier) {
            int length = identifier.length() + 1;
            if (position == length) {
                helper.addProposals(expression);
            } else {
                Expression clauseExpression = helper.getClauseExpression(expression);
                int clauseExpressionLength = this.length(clauseExpression);
                if (position == length + clauseExpressionLength + this.virtualSpaces.peek()) {
                    this.virtualSpaces.add(1);
                    this.corrections.add(-clauseExpressionLength - 2);
                    clauseExpression.accept(this);
                    if (this.isComplete(clauseExpression)) {
                        helper.addAtTheEndOfExpression(expression);
                    }
                    this.virtualSpaces.pop();
                    this.corrections.pop();
                }
            }
        }
        this.lockedExpressions.pop();
    }

    protected <T extends Expression> void visitCollectionExpression(T expression, String identifier, CollectionExpressionHelper<T> helper) {
        int position = this.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier(identifier);
        } else if (helper.hasDelimiterAfterIdentifier(expression)) {
            int length = identifier.length() + 1;
            if (position == (length += helper.preExpressionLength(expression))) {
                helper.addProposals(expression, 0);
            } else {
                CollectionExpression collectionExpression = helper.buildCollectionExpression(expression);
                boolean hasComma = false;
                int count = Math.min(collectionExpression.childrenSize(), helper.maxCollectionSize(expression));
                int index = 0;
                while (index < count) {
                    Expression child = collectionExpression.getChild(index);
                    int childLength = 0;
                    if (position == length) {
                        helper.addProposals(expression, index);
                        break;
                    }
                    childLength = this.length(child);
                    if (position == length + childLength + this.virtualSpaces.peek() && this.isComplete(child)) {
                        helper.addAtTheEndOfChild(expression, child, index);
                        break;
                    }
                    length += childLength;
                    hasComma = collectionExpression.hasComma(index);
                    if (hasComma && position == ++length) {
                        helper.addProposals(expression, index + 1);
                        break;
                    }
                    if (collectionExpression.hasSpace(index)) {
                        ++length;
                    }
                    if (position < length) break;
                    ++index;
                }
            }
        }
    }

    protected void visitCompoundableExpression(AbstractConditionalClause expression) {
        if (expression.hasConditionalExpression()) {
            int position = this.getPosition(expression);
            int length = expression.getIdentifier().length() + 1;
            CompoundExpressionHelper helper = this.getCompoundExpressionHelper();
            try {
                expression.getConditionalExpression().accept(helper);
                this.visitCompoundableExpression(helper, position, length);
            }
            finally {
                helper.dispose();
            }
        }
    }

    protected void visitCompoundableExpression(CompoundExpressionHelper helper, int position, int length) {
        if (position == (length += helper.length())) {
            if (helper.isCompoundable()) {
                this.addAllCompounds("conditional_expression");
            }
        } else if (helper.hasIdentifier()) {
            length += helper.identifierLength();
            if (helper.hasNext()) {
                helper.next();
                this.visitCompoundableExpression(helper, position, length);
            }
        }
    }

    protected void visitDeleteStatement(DeleteStatement expression) {
        this.lockedExpressions.add(expression);
        int position = this.getPosition(expression);
        DeleteClause deleteClause = expression.getDeleteClause();
        int length = this.length(deleteClause);
        if (position == length && this.isAppendable(deleteClause)) {
            this.addIdentifier("WHERE");
        } else if (position == length + 1 && expression.hasSpaceAfterDeleteClause()) {
            this.virtualSpaces.add(1);
            this.corrections.add(-length - 2);
            deleteClause.accept(this);
            this.corrections.pop();
            this.virtualSpaces.pop();
        }
        if (position == length && !expression.hasSpaceAfterDeleteClause()) {
            return;
        }
        if (expression.hasSpaceAfterDeleteClause()) {
            ++length;
        }
        if (position == length && !deleteClause.hasRangeVariableDeclaration()) {
            return;
        }
        if (position == length && expression.hasSpaceAfterDeleteClause() && this.isComplete(deleteClause.getRangeVariableDeclaration())) {
            this.addIdentifier("WHERE");
        }
        if (expression.hasWhereClause()) {
            int whereClauseLength;
            AbstractConditionalClause whereClause = (AbstractConditionalClause)expression.getWhereClause();
            if (position > length && position == (length += (whereClauseLength = this.length(whereClause))) + 1) {
                this.virtualSpaces.add(1);
                this.corrections.add(-whereClauseLength - 2);
                whereClause.accept(this);
                this.corrections.pop();
                this.virtualSpaces.pop();
            }
        }
    }

    protected void visitEncapsulatedExpression(AbstractEncapsulatedExpression expression, String identifier, String jpqlQueryBNF) {
        int length;
        int position = this.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier(identifier);
        } else if (expression.hasLeftParenthesis() && position == (length = identifier.length() + 1)) {
            this.addAllIdentificationVariables();
            this.addAllFunctions(jpqlQueryBNF);
        }
    }

    protected void visitLogicalExpression(LogicalExpression expression, String identifier) {
        int position = this.getPosition(expression) - this.corrections.peek();
        int length = 0;
        if (expression.hasLeftExpression()) {
            length += this.length(expression.getLeftExpression()) + 1;
        }
        if (this.isPositionWithin(position, length, expression.getIdentifier())) {
            this.proposals.addIdentifier(identifier);
        } else if (expression.hasSpaceAfterIdentifier() && position == (length += identifier.length() + 1)) {
            this.addAllIdentificationVariables();
            this.addAllFunctions(expression.rightExpressionBNF());
        }
    }

    protected VisitParentVisitor visitParentVisitor() {
        VisitParentVisitor helper = this.getHelper(VisitParentVisitor.class);
        if (helper == null) {
            helper = this.buildVisitParentVisitor();
            this.registerHelper(VisitParentVisitor.class, helper);
        }
        return helper;
    }

    protected void visitPathExpression(AbstractPathExpression expression) {
        int position = this.getPosition(expression);
        String text = expression.toActualText();
        int dotIndex = text.indexOf(46);
        if (position > -1) {
            if (dotIndex > -1 && position > dotIndex) {
                this.visitPathExpression(expression, this.buildMappingFilter(expression));
            } else {
                String variableName = this.context.literal(expression.getIdentificationVariable(), LiteralType.IDENTIFICATION_VARIABLE);
                if (ExpressionTools.stringIsNotEmpty(variableName)) {
                    this.corrections.add(this.getPosition(expression));
                    this.visit(expression);
                    this.corrections.pop();
                }
            }
        }
    }

    protected void visitPathExpression(AbstractPathExpression expression, Filter<IMapping> helper) {
        MappingCollector mappingCollector = this.getDefaultMappingCollector();
        int position = this.queryPosition.getPosition(expression);
        boolean mappingCollectorCreated = false;
        Resolver resolver = null;
        int length = 0;
        int index = 0;
        int count = expression.pathSize();
        while (index < count) {
            Resolver childResolver;
            String path = expression.getPath(index);
            if (position <= length + path.length()) {
                if (length == position) {
                    path = "";
                } else if (position - length > -1) {
                    path = path.substring(0, position - length);
                }
                if (resolver == null) break;
                mappingCollector = this.buildFilteringMappingCollector(expression, resolver, helper, path);
                mappingCollectorCreated = true;
                break;
            }
            if (resolver == null) {
                resolver = this.context.getResolver(expression.getIdentificationVariable());
            } else if ((index + 1 < count || expression.endsWithDot()) && (childResolver = resolver.getChild(path)) == null) {
                childResolver = new StateFieldResolver(resolver, path);
                resolver.addChild(path, childResolver);
                resolver = childResolver;
            }
            length += path.length() + 1;
            ++index;
        }
        if (!mappingCollectorCreated && resolver != null) {
            mappingCollector = this.buildMappingCollector(expression, resolver, helper);
        }
        this.proposals.addMappings(mappingCollector.buildProposals());
    }

    protected void visitSelectClause(AbstractSelectClause expression) {
        int position = this.getPosition(expression) - this.corrections.peek();
        if (this.isPositionWithin(position, "SELECT")) {
            this.proposals.addIdentifier("SELECT");
        } else if (expression.hasSpaceAfterSelect()) {
            int length = "SELECT".length() + 1;
            if (expression.hasDistinct() && this.isPositionWithin(position, length, "DISTINCT")) {
                this.proposals.addIdentifier("DISTINCT");
            } else {
                if (expression.hasDistinct()) {
                    length += "DISTINCT".length();
                    if (expression.hasSpaceAfterDistinct()) {
                        ++length;
                    }
                }
                if (position == length) {
                    if (!expression.hasDistinct()) {
                        this.addIdentifier("DISTINCT");
                    }
                    this.addAllIdentificationVariables();
                    this.addAllFunctions(expression.selectItemBNF());
                } else {
                    int selectExpressionLength = this.length(expression.getSelectExpression());
                    if (position <= length + selectExpressionLength + this.virtualSpaces.peek()) {
                        this.addSelectExpressionProposals(expression, length);
                    }
                }
            }
        }
    }

    protected SelectStatementHelper<? extends AbstractSelectStatement, ? extends Expression> visitSelectStatement(AbstractSelectStatement expression, int position, int[] length, SelectStatementHelper<AbstractSelectStatement, Expression> helper) {
        if (position == length[0]) {
            if (helper.hasSpaceBeforeClause(expression) && this.isPreviousClauseComplete(expression, helper)) {
                helper.addClauseProposal();
            }
            return null;
        }
        if (helper.hasClause(expression)) {
            Expression clause = helper.getClause(expression);
            if (position > length[0]) {
                int clauseLength = this.length(clause);
                length[0] = length[0] + clauseLength;
                boolean hasSpaceAfterIdentifier = helper.hasSpaceAfterClause(expression);
                Expression clauseExpression = helper.getClauseExpression(clause);
                if (position == length[0]) {
                    helper.appendNextClauseProposals(expression, clause, position, false);
                } else if (position == length[0] + 1 && hasSpaceAfterIdentifier) {
                    this.virtualSpaces.add(1);
                    this.corrections.add(-clauseLength - 2);
                    clause.accept(this);
                    this.corrections.pop();
                    this.virtualSpaces.pop();
                    if (helper.isClauseExpressionComplete(clauseExpression)) {
                        helper.appendNextClauseProposals(expression, clause, position, true);
                    }
                }
                if (position < length[0] || position == length[0] && !hasSpaceAfterIdentifier) {
                    return null;
                }
                if (hasSpaceAfterIdentifier) {
                    length[0] = length[0] + 1;
                }
                if (position < length[0] || position == length[0] && !helper.hasClauseExpression(clause)) {
                    return null;
                }
                if (position == length[0]) {
                    if (hasSpaceAfterIdentifier && helper.isClauseExpressionComplete(clauseExpression)) {
                        helper.appendNextClauseProposals(expression, clause, position, true);
                    }
                    return null;
                }
            }
        }
        return helper.getNextHelper();
    }

    protected void visitSelectStatement(AbstractSelectStatement expression, SelectStatementHelper<? extends AbstractSelectStatement, ? extends Expression> helper) {
        this.lockedExpressions.add(expression);
        try {
            int position = this.getPosition(expression);
            int[] length = new int[1];
            while (helper != null) {
                helper = this.visitSelectStatement(expression, position, length, this.cast(helper));
            }
        }
        finally {
            this.lockedExpressions.pop();
        }
    }

    protected void visitSingleEncapsulatedExpression(AbstractSingleEncapsulatedExpression expression, IdentificationVariableType identificationVariableType) {
        this.visitSingleEncapsulatedExpression(expression, identificationVariableType, expression.getIdentifier());
    }

    protected void visitSingleEncapsulatedExpression(AbstractSingleEncapsulatedExpression expression, IdentificationVariableType identificationVariableType, String ... expressionIdentifiers) {
        int position = this.getPosition(expression) - this.corrections.peek();
        String actualIdentifier = expression.getIdentifier();
        boolean added = false;
        String[] stringArray = expressionIdentifiers;
        int n = expressionIdentifiers.length;
        int n2 = 0;
        while (n2 < n) {
            String identifier = stringArray[n2];
            if (this.isPositionWithin(position, actualIdentifier)) {
                this.proposals.addIdentifier(identifier);
            } else if (expression.hasLeftParenthesis()) {
                int length = identifier.length() + 1;
                if (!added && position == length) {
                    added = true;
                    this.addIdentificationVariables(identificationVariableType, expression);
                    String queryBNF = expression.encapsulatedExpressionBNF();
                    this.addAllFunctions(queryBNF);
                    this.addAllClauses(queryBNF);
                }
            }
            ++n2;
        }
    }

    protected void visitUpdateStatement(UpdateStatement expression) {
        this.lockedExpressions.add(expression);
        int position = this.getPosition(expression);
        UpdateClause updateClause = expression.getUpdateClause();
        int length = this.length(updateClause);
        if (position == length + 1 && expression.hasSpaceAfterUpdateClause()) {
            this.virtualSpaces.add(1);
            this.corrections.add(-length - 2);
            updateClause.accept(this);
            this.corrections.pop();
            this.virtualSpaces.pop();
        }
        if (position == length && !expression.hasSpaceAfterUpdateClause()) {
            return;
        }
        if (expression.hasSpaceAfterUpdateClause()) {
            ++length;
        }
        if (position == length && !updateClause.hasRangeVariableDeclaration()) {
            return;
        }
        if (position == length) {
            if (expression.hasSpaceAfterUpdateClause() && this.isComplete(updateClause.getUpdateItems())) {
                this.addIdentifier("WHERE");
            }
            return;
        }
        if (expression.hasWhereClause()) {
            int whereClauseLength;
            AbstractConditionalClause whereClause = (AbstractConditionalClause)expression.getWhereClause();
            if (position > length && position == (length += (whereClauseLength = this.length(whereClause))) + 1) {
                this.virtualSpaces.add(1);
                this.corrections.add(-whereClauseLength - 2);
                whereClause.accept(this);
                this.corrections.pop();
                this.virtualSpaces.pop();
            }
        }
    }

    protected ClauseHelper<WhereClause> whereClauseHelper() {
        WhereClauseHelper helper = this.getHelper(WhereClauseHelper.class);
        if (helper == null) {
            helper = this.buildWhereClauseHelper();
            this.registerHelper(WhereClauseHelper.class, helper);
        }
        return helper;
    }

    protected WhereClauseSelectStatementHelper whereClauseSelectStatementHelper() {
        WhereClauseSelectStatementHelper helper = this.getHelper(WhereClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildWhereClauseSelectStatementHelper();
            this.registerHelper(WhereClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractFromClauseSelectStatementHelper<T extends AbstractSelectStatement>
    implements SelectStatementHelper<T, AbstractFromClause> {
        protected AbstractFromClauseSelectStatementHelper() {
        }

        protected boolean addAppendableToCollection(T expression, int position) {
            if (AbstractContentAssistVisitor.this.wordParser.endsWith(position, "GROUP") || AbstractContentAssistVisitor.this.wordParser.endsWith(position, "GROUP B")) {
                if (!((AbstractSelectStatement)expression).hasWhereClause()) {
                    AbstractContentAssistVisitor.this.proposals.addIdentifier("GROUP BY");
                }
                return true;
            }
            if (AbstractContentAssistVisitor.this.wordParser.endsWith(position, "ORDER") || AbstractContentAssistVisitor.this.wordParser.endsWith(position, "ORDER B")) {
                if (!((AbstractSelectStatement)expression).hasWhereClause() && !((AbstractSelectStatement)expression).hasHavingClause()) {
                    AbstractContentAssistVisitor.this.proposals.addIdentifier("ORDER BY");
                }
                return true;
            }
            return false;
        }

        protected abstract void addClauseIdentifierProposals(T var1);

        @Override
        public void addClauseProposal() {
            AbstractContentAssistVisitor.this.addIdentifier("FROM");
        }

        @Override
        public final void appendNextClauseProposals(T expression, AbstractFromClause clause, int position, boolean complete) {
            boolean skip;
            if (complete || AbstractContentAssistVisitor.this.isAppendable(clause)) {
                this.addClauseIdentifierProposals(expression);
            } else if (AbstractContentAssistVisitor.this.isAppendableToCollection(clause) && !(skip = this.addAppendableToCollection(expression, position))) {
                this.addClauseIdentifierProposals(expression);
            }
        }

        @Override
        public AbstractFromClause getClause(T expression) {
            return (AbstractFromClause)((AbstractSelectStatement)expression).getFromClause();
        }

        @Override
        public Expression getClauseExpression(AbstractFromClause clause) {
            return clause.getDeclaration();
        }

        @Override
        public boolean hasClause(AbstractSelectStatement expression) {
            return expression.hasFromClause();
        }

        @Override
        public boolean hasClauseExpression(AbstractFromClause clause) {
            return clause.hasDeclaration();
        }

        @Override
        public boolean hasSpaceAfterClause(T expression) {
            return ((AbstractSelectStatement)expression).hasSpaceAfterFrom();
        }

        @Override
        public boolean hasSpaceBeforeClause(T expression) {
            return ((AbstractSelectStatement)expression).hasSpaceAfterSelect();
        }

        @Override
        public boolean isClauseExpressionComplete(Expression expression) {
            return AbstractContentAssistVisitor.this.isComplete(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractGroupByClauseSelectStatementHelper<T extends AbstractSelectStatement>
    implements SelectStatementHelper<T, GroupByClause> {
        protected AbstractGroupByClauseSelectStatementHelper() {
        }

        @Override
        public void addClauseProposal() {
            AbstractContentAssistVisitor.this.addIdentifier("GROUP BY");
        }

        @Override
        public GroupByClause getClause(AbstractSelectStatement expression) {
            return (GroupByClause)expression.getGroupByClause();
        }

        @Override
        public Expression getClauseExpression(GroupByClause clause) {
            return clause.getGroupByItems();
        }

        @Override
        public boolean hasClause(AbstractSelectStatement expression) {
            return expression.hasGroupByClause();
        }

        @Override
        public boolean hasClauseExpression(GroupByClause clause) {
            return clause.hasGroupByItems();
        }

        @Override
        public boolean hasSpaceAfterClause(AbstractSelectStatement expression) {
            return expression.hasSpaceAfterGroupBy();
        }

        @Override
        public boolean hasSpaceBeforeClause(AbstractSelectStatement expression) {
            return expression.hasSpaceAfterWhere();
        }

        @Override
        public boolean isClauseExpressionComplete(Expression expression) {
            return AbstractContentAssistVisitor.this.isGroupByComplete(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractHavingClauseSelectStatementHelper<T extends AbstractSelectStatement>
    implements SelectStatementHelper<T, HavingClause> {
        protected AbstractHavingClauseSelectStatementHelper() {
        }

        @Override
        public void addClauseProposal() {
            AbstractContentAssistVisitor.this.addIdentifier("HAVING");
        }

        @Override
        public HavingClause getClause(AbstractSelectStatement expression) {
            return (HavingClause)expression.getHavingClause();
        }

        @Override
        public Expression getClauseExpression(HavingClause clause) {
            return clause.getConditionalExpression();
        }

        @Override
        public boolean hasClause(AbstractSelectStatement expression) {
            return expression.hasHavingClause();
        }

        @Override
        public boolean hasClauseExpression(HavingClause clause) {
            return clause.hasConditionalExpression();
        }

        @Override
        public boolean hasSpaceBeforeClause(AbstractSelectStatement expression) {
            return expression.hasSpaceAfterGroupBy();
        }

        @Override
        public boolean isClauseExpressionComplete(Expression expression) {
            return AbstractContentAssistVisitor.this.isConditionalExpressionComplete(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractSelectClauseSelectStatementHelper
    implements SelectStatementHelper<AbstractSelectStatement, AbstractSelectClause> {
        protected AbstractSelectClauseSelectStatementHelper() {
        }

        @Override
        public void addClauseProposal() {
            AbstractContentAssistVisitor.this.addIdentifier("SELECT");
        }

        @Override
        public void appendNextClauseProposals(AbstractSelectStatement expression, AbstractSelectClause clause, int position, boolean complete) {
            if (complete || AbstractContentAssistVisitor.this.isAppendable(clause)) {
                AbstractContentAssistVisitor.this.addIdentifier("FROM");
            }
        }

        @Override
        public AbstractSelectClause getClause(AbstractSelectStatement expression) {
            return expression.getSelectClause();
        }

        @Override
        public Expression getClauseExpression(AbstractSelectClause clause) {
            return clause.getSelectExpression();
        }

        @Override
        public SelectStatementHelper<AbstractSelectStatement, Expression> getPreviousHelper() {
            return null;
        }

        @Override
        public boolean hasClause(AbstractSelectStatement expression) {
            return true;
        }

        @Override
        public boolean hasClauseExpression(AbstractSelectClause clause) {
            return clause.hasSelectExpression();
        }

        @Override
        public boolean hasSpaceAfterClause(AbstractSelectStatement expression) {
            return expression.hasSpaceAfterSelect();
        }

        @Override
        public boolean hasSpaceBeforeClause(AbstractSelectStatement expression) {
            return false;
        }

        @Override
        public boolean isClauseExpressionComplete(Expression expression) {
            return AbstractContentAssistVisitor.this.isSelectExpressionComplete(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractWhereClauseSelectStatementHelper<T extends AbstractSelectStatement>
    implements SelectStatementHelper<T, WhereClause> {
        protected AbstractWhereClauseSelectStatementHelper() {
        }

        @Override
        public void addClauseProposal() {
            AbstractContentAssistVisitor.this.addIdentifier("WHERE");
        }

        @Override
        public WhereClause getClause(AbstractSelectStatement expression) {
            return (WhereClause)expression.getWhereClause();
        }

        @Override
        public Expression getClauseExpression(WhereClause clause) {
            return clause.getConditionalExpression();
        }

        @Override
        public boolean hasClause(AbstractSelectStatement expression) {
            return expression.hasWhereClause();
        }

        @Override
        public boolean hasClauseExpression(WhereClause clause) {
            return clause.hasConditionalExpression();
        }

        @Override
        public boolean hasSpaceAfterClause(AbstractSelectStatement expression) {
            return expression.hasSpaceAfterWhere();
        }

        @Override
        public boolean hasSpaceBeforeClause(AbstractSelectStatement expression) {
            return expression.hasSpaceAfterFrom();
        }

        @Override
        public boolean isClauseExpressionComplete(Expression expression) {
            return AbstractContentAssistVisitor.this.isConditionalExpressionComplete(expression);
        }
    }

    protected class AcceptableTypeVisitor
    extends AbstractExpressionVisitor {
        IType type;

        protected AcceptableTypeVisitor() {
        }

        public void visit(AbsExpression expression) {
            this.type = AbstractContentAssistVisitor.this.getType(Number.class);
        }

        public void visit(ArithmeticFactor expression) {
            this.type = AbstractContentAssistVisitor.this.getType(Number.class);
        }

        public void visit(AvgFunction expression) {
            this.type = AbstractContentAssistVisitor.this.getType(Number.class);
        }

        public void visit(CollectionExpression expression) {
            expression.getParent().accept(this);
        }

        public void visit(ConcatExpression expression) {
            this.type = AbstractContentAssistVisitor.this.getType(CharSequence.class);
        }

        public void visit(LengthExpression expression) {
            this.type = AbstractContentAssistVisitor.this.getType(CharSequence.class);
        }

        public void visit(LocateExpression expression) {
            this.type = AbstractContentAssistVisitor.this.getType(CharSequence.class);
        }

        public void visit(LowerExpression expression) {
            this.type = AbstractContentAssistVisitor.this.getType(CharSequence.class);
        }

        public void visit(ModExpression expression) {
            this.type = AbstractContentAssistVisitor.this.getType(Number.class);
        }

        public void visit(SqrtExpression expression) {
            this.type = AbstractContentAssistVisitor.this.getType(Number.class);
        }

        public void visit(SubExpression expression) {
            expression.getParent().accept(this);
        }

        public void visit(SubstringExpression expression) {
            this.type = AbstractContentAssistVisitor.this.getType(CharSequence.class);
        }

        public void visit(SumFunction expression) {
            this.type = AbstractContentAssistVisitor.this.getType(Number.class);
        }

        public void visit(TrimExpression expression) {
            this.type = AbstractContentAssistVisitor.this.getType(CharSequence.class);
        }

        public void visit(UpperExpression expression) {
            this.type = AbstractContentAssistVisitor.this.getType(CharSequence.class);
        }
    }

    protected class AppendableExpressionVisitor
    extends AbstractTraverseChildrenVisitor {
        boolean appendable;
        int positionInCollection = -1;

        AppendableExpressionVisitor() {
        }

        public void visit(AdditionExpression expression) {
            super.visit(expression);
        }

        public void visit(AndExpression expression) {
            super.visit(expression);
        }

        public void visit(CollectionExpression expression) {
            this.positionInCollection = expression.childrenSize() - 1;
            expression.getChild(this.positionInCollection).accept(this);
            this.positionInCollection = -1;
        }

        public void visit(DivisionExpression expression) {
            super.visit(expression);
        }

        public void visit(IdentificationVariable expression) {
            this.appendable = this.positionInCollection > -1;
        }

        public void visit(IdentificationVariableDeclaration expression) {
            if (expression.hasJoins()) {
                expression.getJoins().accept(this);
            } else {
                expression.getRangeVariableDeclaration().accept(this);
            }
        }

        public void visit(MultiplicationExpression expression) {
            super.visit(expression);
        }

        public void visit(OrExpression expression) {
            super.visit(expression);
        }

        public void visit(RangeVariableDeclaration expression) {
            this.appendable = !expression.hasSpaceAfterRootObject() && !expression.hasAs() && !expression.hasIdentificationVariable();
        }

        public void visit(ResultVariable expression) {
            this.appendable = !expression.hasAs() && !expression.hasSpaceAfterAs() && expression.hasResultVariable();
        }

        public void visit(SubtractionExpression expression) {
            super.visit(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface ClauseHelper<T extends Expression> {
        public void addAtTheEndOfExpression(T var1);

        public void addProposals(T var1);

        public Expression getClauseExpression(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface CollectionExpressionHelper<T extends Expression> {
        public void addAtTheEndOfChild(T var1, Expression var2, int var3);

        public void addProposals(T var1, int var2);

        public CollectionExpression buildCollectionExpression(T var1);

        public boolean hasDelimiterAfterIdentifier(T var1);

        public int maxCollectionSize(T var1);

        public int preExpressionLength(T var1);

        public JPQLQueryBNF queryBNF(T var1, int var2);
    }

    protected static class CollectionExpressionVisitor
    extends AbstractExpressionVisitor {
        protected CollectionExpression expression;

        protected CollectionExpressionVisitor() {
        }

        public void visit(CollectionExpression expression) {
            this.expression = expression;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CollectionMappingFilter
    implements Filter<IMapping> {
        protected CollectionMappingFilter() {
        }

        @Override
        public boolean accept(IMapping value) {
            return value.isRelationship();
        }
    }

    protected abstract class CompletenessVisitor
    extends AbstractExpressionVisitor {
        protected boolean complete;

        protected CompletenessVisitor() {
        }

        public void visit(CollectionExpression expression) {
            int lastIndex = expression.childrenSize() - 1;
            AbstractExpression child = (AbstractExpression)expression.getChild(lastIndex);
            child.accept(this);
        }
    }

    protected class CompoundExpressionHelper
    extends AnonymousExpressionVisitor {
        protected Expression leftExpression;
        protected LogicalExpression logicalExpression;
        protected Expression rightExpression;

        protected CompoundExpressionHelper() {
        }

        void dispose() {
            this.leftExpression = null;
            this.rightExpression = null;
            this.logicalExpression = null;
        }

        boolean hasIdentifier() {
            return this.logicalExpression != null;
        }

        boolean hasNext() {
            return this.rightExpression != null;
        }

        int identifierLength() {
            if (this.logicalExpression != null) {
                int length = this.logicalExpression.getIdentifier().length();
                length += this.logicalExpression.hasLeftExpression() ? 1 : 0;
                return length += this.logicalExpression.hasSpaceAfterIdentifier() ? 1 : 0;
            }
            return 0;
        }

        boolean isCompoundable() {
            return AbstractContentAssistVisitor.this.isComplete(this.leftExpression);
        }

        int length() {
            if (this.leftExpression != null) {
                return AbstractContentAssistVisitor.this.length(this.leftExpression);
            }
            return 0;
        }

        void next() {
            this.rightExpression.accept(this);
        }

        public void visit(AndExpression expression) {
            this.visitLogicalExpression(expression);
        }

        public void visit(Expression expression) {
            this.leftExpression = expression;
            this.rightExpression = null;
        }

        public void visit(OrExpression expression) {
            this.visitLogicalExpression(expression);
        }

        protected void visitLogicalExpression(LogicalExpression expression) {
            this.logicalExpression = expression;
            this.leftExpression = expression.hasLeftExpression() ? expression.getLeftExpression() : null;
            this.rightExpression = expression.hasRightExpression() ? expression.getRightExpression() : null;
        }
    }

    protected class ConditionalExpressionCompletenessVisitor
    extends CompletenessVisitor {
        protected ConditionalExpressionCompletenessVisitor() {
        }

        public void visit(AndExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                this.complete = AbstractContentAssistVisitor.this.isComplete(expression.getRightExpression());
            }
        }

        public void visit(BetweenExpression expression) {
            this.complete = expression.hasUpperBoundExpression();
            if (this.complete) {
                this.complete = AbstractContentAssistVisitor.this.isComplete(expression.getUpperBoundExpression());
            }
        }

        public void visit(CollectionMemberExpression expression) {
            this.complete = expression.hasCollectionValuedPathExpression();
            if (this.complete) {
                this.complete = AbstractContentAssistVisitor.this.isComplete(expression.getCollectionValuedPathExpression());
            }
        }

        public void visit(ComparisonExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                this.complete = AbstractContentAssistVisitor.this.isComplete(expression.getRightExpression());
            }
        }

        public void visit(EmptyCollectionComparisonExpression expression) {
            this.complete = true;
        }

        public void visit(ExistsExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(InExpression expression) {
            this.complete = expression.hasInItems();
            if (this.complete) {
                this.complete = AbstractContentAssistVisitor.this.isComplete(expression.getInItems());
            }
        }

        public void visit(LikeExpression expression) {
            this.complete = AbstractContentAssistVisitor.this.isComplete(expression);
        }

        public void visit(NullComparisonExpression expression) {
            this.complete = true;
        }

        public void visit(OrExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                this.complete = AbstractContentAssistVisitor.this.isComplete(expression.getRightExpression());
            }
        }

        public void visit(SubExpression expression) {
            if (!this.complete) {
                this.complete = expression.hasRightParenthesis();
                if (this.complete) {
                    expression.getExpression().accept(this);
                }
            } else {
                this.complete = expression.hasRightParenthesis();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConstrutorCollectionHelper
    implements CollectionExpressionHelper<ConstructorExpression> {
        protected ConstrutorCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(ConstructorExpression expression, Expression child, int index) {
            AbstractContentAssistVisitor.this.addAllAggregates("constructor_item");
        }

        @Override
        public void addProposals(ConstructorExpression expression, int index) {
            AbstractContentAssistVisitor.this.addIdentificationVariables(IdentificationVariableType.ALL, expression);
            AbstractContentAssistVisitor.this.addAllFunctions("constructor_item");
        }

        @Override
        public CollectionExpression buildCollectionExpression(ConstructorExpression expression) {
            CollectionExpression collectionExpression = AbstractContentAssistVisitor.this.getCollectionExpression(expression.getConstructorItems());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(ConstructorExpression expression) {
            return expression.hasLeftParenthesis();
        }

        @Override
        public int maxCollectionSize(ConstructorExpression expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(ConstructorExpression expression) {
            if (expression.hasSpaceAfterNew()) {
                return expression.getClassName().length() + 1;
            }
            return expression.getClassName().length();
        }

        @Override
        public JPQLQueryBNF queryBNF(ConstructorExpression expression, int index) {
            return AbstractContentAssistVisitor.this.getQueryBNF("constructor_item");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultMappingCollector
    implements MappingCollector {
        protected DefaultMappingCollector() {
        }

        @Override
        public Collection<IMapping> buildProposals() {
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DeleteClauseHelper
    implements ClauseHelper<DeleteClause> {
        protected DeleteClauseHelper() {
        }

        @Override
        public void addAtTheEndOfExpression(DeleteClause expression) {
        }

        @Override
        public void addProposals(DeleteClause expression) {
            AbstractContentAssistVisitor.this.addEntities();
        }

        @Override
        public Expression getClauseExpression(DeleteClause expression) {
            return expression.getRangeVariableDeclaration();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DoubleEncapsulatedCollectionHelper
    implements CollectionExpressionHelper<AbstractDoubleEncapsulatedExpression> {
        protected DoubleEncapsulatedCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(AbstractDoubleEncapsulatedExpression expression, Expression child, int index) {
            if (this.queryBNF(expression, index).handleAggregate()) {
                AbstractContentAssistVisitor.this.addAllAggregates(this.queryBNF(expression, index));
            }
        }

        @Override
        public void addProposals(AbstractDoubleEncapsulatedExpression expression, int index) {
            AbstractContentAssistVisitor.this.addAllIdentificationVariables();
            AbstractContentAssistVisitor.this.addAllFunctions(this.queryBNF(expression, index));
        }

        @Override
        public CollectionExpression buildCollectionExpression(AbstractDoubleEncapsulatedExpression expression) {
            return expression.buildCollectionExpression();
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(AbstractDoubleEncapsulatedExpression expression) {
            return expression.hasLeftParenthesis();
        }

        @Override
        public int maxCollectionSize(AbstractDoubleEncapsulatedExpression expression) {
            return 2;
        }

        @Override
        public int preExpressionLength(AbstractDoubleEncapsulatedExpression expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(AbstractDoubleEncapsulatedExpression expression, int index) {
            return AbstractContentAssistVisitor.this.getQueryBNF(expression.parameterExpressionBNF(index));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FilteringMappingCollector
    implements MappingCollector {
        protected final Filter<IMapping> filter;
        protected final Resolver resolver;
        protected final String suffix;

        FilteringMappingCollector(Resolver resolver, Filter<IMapping> filter, String suffix) {
            this.filter = filter;
            this.suffix = suffix;
            this.resolver = resolver;
        }

        protected void addFilteredMappings(IManagedType managedType, List<IMapping> mappings) {
            Filter<IMapping> filter = this.buildFilter(this.suffix);
            for (IMapping mapping : managedType.mappings()) {
                if (!filter.accept(mapping)) continue;
                mappings.add(mapping);
            }
        }

        protected Filter<IMapping> buildFilter(String suffix) {
            if (suffix.length() == 0) {
                return this.filter;
            }
            return new AndFilter<IMapping>(this.filter, this.buildMappingNameFilter(suffix));
        }

        protected Filter<IMapping> buildMappingNameFilter(final String suffix) {
            return new Filter<IMapping>(){

                @Override
                public boolean accept(IMapping mapping) {
                    return mapping.getName().startsWith(suffix);
                }
            };
        }

        @Override
        public Collection<IMapping> buildProposals() {
            IManagedType managedType = this.resolver.getManagedType();
            if (managedType == null) {
                return Collections.emptyList();
            }
            ArrayList<IMapping> mappings = new ArrayList<IMapping>();
            this.addFilteredMappings(managedType, mappings);
            return mappings;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FromClauseCollectionHelper
    implements CollectionExpressionHelper<AbstractFromClause> {
        protected FromClauseCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(AbstractFromClause expression, Expression child, int index) {
            AbstractContentAssistVisitor.this.addJoinIdentifiers();
        }

        @Override
        public void addProposals(AbstractFromClause expression, int index) {
            AbstractContentAssistVisitor.this.addEntities();
            if (index > 0) {
                AbstractContentAssistVisitor.this.addIdentifier("IN");
            }
        }

        @Override
        public CollectionExpression buildCollectionExpression(AbstractFromClause expression) {
            CollectionExpression collectionExpression = AbstractContentAssistVisitor.this.getCollectionExpression(expression.getDeclaration());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(AbstractFromClause expression) {
            return expression.hasSpaceAfterFrom();
        }

        @Override
        public int maxCollectionSize(AbstractFromClause expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(AbstractFromClause expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(AbstractFromClause expression, int index) {
            return AbstractContentAssistVisitor.this.getQueryBNF(expression.declarationBNF());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FromClauseHelper
    implements ClauseHelper<AbstractFromClause> {
        protected FromClauseHelper() {
        }

        @Override
        public void addAtTheEndOfExpression(AbstractFromClause expression) {
        }

        @Override
        public void addProposals(AbstractFromClause expression) {
            AbstractContentAssistVisitor.this.addEntities();
            if (AbstractContentAssistVisitor.this.positionInCollections.peek() > 0) {
                AbstractContentAssistVisitor.this.addAllIdentifiers("internal_from_clause");
            }
        }

        @Override
        public Expression getClauseExpression(AbstractFromClause expression) {
            return expression.getDeclaration();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FromClauseSelectStatementHelper
    extends AbstractFromClauseSelectStatementHelper<SelectStatement> {
        protected FromClauseSelectStatementHelper() {
        }

        @Override
        protected boolean addAppendableToCollection(SelectStatement expression, int position) {
            boolean skip = super.addAppendableToCollection(expression, position);
            if (!skip && (AbstractContentAssistVisitor.this.wordParser.endsWith(position, "ORDER") || AbstractContentAssistVisitor.this.wordParser.endsWith(position, "ORDER B"))) {
                if (!expression.hasWhereClause() && !expression.hasHavingClause()) {
                    AbstractContentAssistVisitor.this.proposals.addIdentifier("ORDER BY");
                }
                return true;
            }
            return false;
        }

        @Override
        protected void addClauseIdentifierProposals(SelectStatement expression) {
            AbstractContentAssistVisitor.this.addIdentifier("WHERE");
            if (!expression.hasWhereClause()) {
                AbstractContentAssistVisitor.this.addIdentifier("GROUP BY");
                if (!expression.hasGroupByClause()) {
                    AbstractContentAssistVisitor.this.addIdentifier("HAVING");
                    if (!expression.hasHavingClause()) {
                        AbstractContentAssistVisitor.this.addIdentifier("ORDER BY");
                    }
                }
            }
        }

        public WhereClauseSelectStatementHelper getNextHelper() {
            return AbstractContentAssistVisitor.this.whereClauseSelectStatementHelper();
        }

        public SelectClauseSelectStatementHelper getPreviousHelper() {
            return AbstractContentAssistVisitor.this.getSelectClauseSelectStatementHelper();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GroupByClauseCollectionHelper
    implements CollectionExpressionHelper<GroupByClause> {
        protected GroupByClauseCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(GroupByClause expression, Expression child, int index) {
        }

        @Override
        public void addProposals(GroupByClause expression, int index) {
            AbstractContentAssistVisitor.this.addAllIdentificationVariables();
        }

        @Override
        public CollectionExpression buildCollectionExpression(GroupByClause expression) {
            CollectionExpression collectionExpression = AbstractContentAssistVisitor.this.getCollectionExpression(expression.getGroupByItems());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(GroupByClause expression) {
            return expression.hasSpaceAfterGroupBy();
        }

        @Override
        public int maxCollectionSize(GroupByClause expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(GroupByClause expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(GroupByClause expression, int index) {
            return AbstractContentAssistVisitor.this.getQueryBNF("groupby_item");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GroupByClauseSelectStatementHelper
    extends AbstractGroupByClauseSelectStatementHelper<SelectStatement> {
        protected GroupByClauseSelectStatementHelper() {
        }

        @Override
        public void appendNextClauseProposals(SelectStatement expression, GroupByClause clause, int position, boolean complete) {
            if (complete || AbstractContentAssistVisitor.this.isAppendable(clause)) {
                AbstractContentAssistVisitor.this.addIdentifier("HAVING");
                if (!expression.hasHavingClause()) {
                    AbstractContentAssistVisitor.this.addIdentifier("ORDER BY");
                }
            }
        }

        public HavingClauseSelectStatementHelper getNextHelper() {
            return AbstractContentAssistVisitor.this.getHavingClauseSelectStatementHelper();
        }

        public WhereClauseSelectStatementHelper getPreviousHelper() {
            return AbstractContentAssistVisitor.this.whereClauseSelectStatementHelper();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HavingClauseHelper
    implements ClauseHelper<HavingClause> {
        protected HavingClauseHelper() {
        }

        @Override
        public void addAtTheEndOfExpression(HavingClause expression) {
            AbstractContentAssistVisitor.this.addAllAggregates("conditional_expression");
        }

        @Override
        public void addProposals(HavingClause expression) {
            AbstractContentAssistVisitor.this.addAllIdentificationVariables();
            AbstractContentAssistVisitor.this.addAllFunctions("conditional_expression");
        }

        @Override
        public Expression getClauseExpression(HavingClause expression) {
            return expression.getConditionalExpression();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HavingClauseSelectStatementHelper
    extends AbstractHavingClauseSelectStatementHelper<SelectStatement> {
        protected HavingClauseSelectStatementHelper() {
        }

        @Override
        public void appendNextClauseProposals(SelectStatement expression, HavingClause clause, int position, boolean complete) {
            if (complete || AbstractContentAssistVisitor.this.isAppendable(clause)) {
                AbstractContentAssistVisitor.this.addIdentifier("ORDER BY");
            }
        }

        public OrderByClauseSelectStatementHelper getNextHelper() {
            return AbstractContentAssistVisitor.this.getOrderByClauseSelectStatementHelper();
        }

        public GroupByClauseSelectStatementHelper getPreviousHelper() {
            return AbstractContentAssistVisitor.this.getGroupByClauseSelectStatementHelper();
        }

        @Override
        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return expression.hasSpaceBeforeOrderBy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum IdentificationVariableType {
        ALL,
        COLLECTION,
        LEFT,
        LEFT_COLLECTION,
        NONE,
        RESULT_VARIABLE;

    }

    protected class IncompleteCollectionExpressionVisitor
    extends CompletenessVisitor {
        protected boolean insideCollection;

        protected IncompleteCollectionExpressionVisitor() {
        }

        public void visit(CollectionExpression expression) {
            int lastIndex = expression.childrenSize() - 1;
            this.insideCollection = true;
            if (!expression.hasComma(lastIndex - 1)) {
                expression.getChild(lastIndex).accept(this);
            }
            this.insideCollection = false;
        }

        public void visit(FromClause expression) {
            expression.getDeclaration().accept(this);
        }

        public void visit(GroupByClause expression) {
            expression.getGroupByItems().accept(this);
        }

        public void visit(HavingClause expression) {
            expression.getConditionalExpression().accept(this);
        }

        public void visit(IdentificationVariable expression) {
            this.complete = true;
        }

        public void visit(IdentificationVariableDeclaration expression) {
            if (this.insideCollection && !expression.hasJoins()) {
                expression.getRangeVariableDeclaration().accept(this);
            }
        }

        public void visit(RangeVariableDeclaration expression) {
            if (this.insideCollection) {
                boolean bl = this.complete = !expression.hasAs() && !expression.hasIdentificationVariable();
                if (!this.complete) {
                    this.complete = expression.toParsedText().equalsIgnoreCase("GROUP B") || expression.toParsedText().equalsIgnoreCase("ORDER B");
                }
            }
        }

        public void visit(WhereClause expression) {
            expression.getConditionalExpression().accept(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JoinCollectionHelper
    implements CollectionExpressionHelper<IdentificationVariableDeclaration> {
        protected JoinCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(IdentificationVariableDeclaration expression, Expression child, int index) {
        }

        @Override
        public void addProposals(IdentificationVariableDeclaration expression, int index) {
            AbstractContentAssistVisitor.this.addJoinIdentifiers();
        }

        @Override
        public CollectionExpression buildCollectionExpression(IdentificationVariableDeclaration expression) {
            CollectionExpression collectionExpression = AbstractContentAssistVisitor.this.getCollectionExpression(expression.getJoins());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(IdentificationVariableDeclaration expression) {
            return expression.hasSpace();
        }

        @Override
        public int maxCollectionSize(IdentificationVariableDeclaration expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(IdentificationVariableDeclaration expression) {
            return AbstractContentAssistVisitor.this.length(expression.getRangeVariableDeclaration());
        }

        @Override
        public JPQLQueryBNF queryBNF(IdentificationVariableDeclaration expression, int index) {
            return AbstractContentAssistVisitor.this.getQueryBNF("join*");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface MappingCollector {
        public Collection<IMapping> buildProposals();
    }

    protected class MappingFilterBuilder
    extends AbstractTraverseParentVisitor {
        protected Filter<IMapping> filter;

        protected MappingFilterBuilder() {
        }

        public void visit(CollectionMemberDeclaration expression) {
            this.filter = AbstractContentAssistVisitor.this.getMappingCollectionFilter();
        }

        public void visit(CollectionValuedPathExpression expression) {
            this.filter = AbstractContentAssistVisitor.this.getMappingCollectionFilter();
        }

        public void visit(Join expression) {
            this.filter = AbstractContentAssistVisitor.this.getMappingCollectionFilter();
        }

        public void visit(JPQLExpression expression) {
            this.filter = AbstractContentAssistVisitor.this.getMappingPropertyFilter();
        }

        public void visit(SizeExpression expression) {
            this.filter = AbstractContentAssistVisitor.this.getMappingCollectionFilter();
        }

        public void visit(TreatExpression expression) {
            this.filter = AbstractContentAssistVisitor.this.getMappingCollectionFilter();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MappingTypeFilter
    implements Filter<IMapping> {
        protected final IType type;

        MappingTypeFilter(IType type) {
            this.type = type;
        }

        @Override
        public boolean accept(IMapping value) {
            if (value.isRelationship() && !value.isCollection()) {
                return true;
            }
            IType mappingType = value.getType();
            mappingType = AbstractContentAssistVisitor.this.getTypeHelper().convertPrimitive(mappingType);
            return mappingType.isAssignableTo(this.type);
        }
    }

    protected static class NullExpressionVisitor
    extends AbstractExpressionVisitor {
        protected NullExpression expression;

        protected NullExpressionVisitor() {
        }

        public void visit(NullExpression expression) {
            this.expression = expression;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OrderByClauseCollectionHelper
    implements CollectionExpressionHelper<OrderByClause> {
        protected OrderByClauseCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(OrderByClause expression, Expression child, int index) {
            OrderByItem item = (OrderByItem)child;
            if (item.getOrdering() == OrderByItem.Ordering.DEFAULT) {
                AbstractContentAssistVisitor.this.addIdentifier("ASC");
                AbstractContentAssistVisitor.this.addIdentifier("DESC");
            }
        }

        @Override
        public void addProposals(OrderByClause expression, int index) {
            AbstractContentAssistVisitor.this.addAllIdentificationVariables();
            AbstractContentAssistVisitor.this.addAllResultVariables();
        }

        @Override
        public CollectionExpression buildCollectionExpression(OrderByClause expression) {
            CollectionExpression collectionExpression = AbstractContentAssistVisitor.this.getCollectionExpression(expression.getOrderByItems());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(OrderByClause expression) {
            return expression.hasSpaceAfterOrderBy();
        }

        @Override
        public int maxCollectionSize(OrderByClause expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(OrderByClause expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(OrderByClause expression, int index) {
            return AbstractContentAssistVisitor.this.getQueryBNF("orderby_item");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OrderByClauseSelectStatementHelper
    implements SelectStatementHelper<SelectStatement, OrderByClause> {
        protected OrderByClauseSelectStatementHelper() {
        }

        @Override
        public void addClauseProposal() {
            AbstractContentAssistVisitor.this.addIdentifier("ORDER BY");
        }

        @Override
        public void appendNextClauseProposals(SelectStatement expression, OrderByClause clause, int position, boolean complete) {
        }

        @Override
        public OrderByClause getClause(SelectStatement expression) {
            return (OrderByClause)expression.getOrderByClause();
        }

        @Override
        public Expression getClauseExpression(OrderByClause clause) {
            return clause.getOrderByItems();
        }

        @Override
        public SelectStatementHelper<? extends AbstractSelectStatement, ? extends Expression> getNextHelper() {
            return null;
        }

        public HavingClauseSelectStatementHelper getPreviousHelper() {
            return AbstractContentAssistVisitor.this.getHavingClauseSelectStatementHelper();
        }

        @Override
        public boolean hasClause(SelectStatement expression) {
            return expression.hasOrderByClause();
        }

        @Override
        public boolean hasClauseExpression(OrderByClause clause) {
            return clause.hasOrderByItems();
        }

        @Override
        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return false;
        }

        @Override
        public boolean hasSpaceBeforeClause(SelectStatement expression) {
            return expression.hasSpaceBeforeOrderBy();
        }

        @Override
        public boolean isClauseExpressionComplete(Expression expression) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PropertyMappingFilter
    implements Filter<IMapping> {
        protected PropertyMappingFilter() {
        }

        @Override
        public boolean accept(IMapping value) {
            return !value.isTransient() && !value.isCollection();
        }
    }

    protected class RangeVariableDeclarationVisitor
    extends AbstractExpressionVisitor {
        RangeVariableDeclaration expression;

        protected RangeVariableDeclarationVisitor() {
        }

        public void visit(RangeVariableDeclaration expression) {
            this.expression = expression;
        }
    }

    protected class ResultVariableVisitor
    extends AbstractExpressionVisitor {
        protected ResultVariable expression;

        protected ResultVariableVisitor() {
        }

        public void visit(ResultVariable expression) {
            this.expression = expression;
        }
    }

    protected class SelectClauseCompletenessVisitor
    extends CompletenessVisitor {
        protected SelectClauseCompletenessVisitor() {
        }

        public void visit(AbsExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(AdditionExpression expression) {
            this.visitArithmeticExpression(expression);
        }

        public void visit(AvgFunction expression) {
            this.visitAggregateFunction(expression);
        }

        public void visit(CaseExpression expression) {
            this.complete = expression.hasEnd();
        }

        public void visit(CoalesceExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(CollectionExpression expression) {
            int lastIndex;
            AbstractExpression child;
            if (expression.endsWithComma()) {
                this.complete = true;
            }
            if (AbstractContentAssistVisitor.this.isNull(child = (AbstractExpression)expression.getChild(lastIndex = expression.childrenSize() - 1))) {
                this.complete = false;
            } else {
                int length = expression.toActualText(AbstractContentAssistVisitor.this.positionInCollections.peek()).length();
                if (AbstractContentAssistVisitor.this.corrections.peek() == length) {
                    int index = Math.max(0, AbstractContentAssistVisitor.this.positionInCollections.peek() - 1);
                    this.complete = expression.hasComma(index);
                } else {
                    child.accept(this);
                }
            }
        }

        public void visit(ConcatExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(ConstructorExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(CountFunction expression) {
            this.visitAggregateFunction(expression);
        }

        public void visit(DateTime expression) {
            this.complete = expression.isJDBCDate() ? expression.toActualText().endsWith("}") : true;
        }

        public void visit(DivisionExpression expression) {
            this.visitArithmeticExpression(expression);
        }

        public void visit(EntryExpression expression) {
            this.visitEncapsulatedIdentificationVariableExpression(expression);
        }

        public void visit(IdentificationVariable expression) {
            this.complete = true;
        }

        public void visit(IndexExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(KeyExpression expression) {
            this.visitEncapsulatedIdentificationVariableExpression(expression);
        }

        public void visit(KeywordExpression expression) {
            this.complete = true;
        }

        public void visit(LengthExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(LocateExpression expression) {
            this.visitAbstractTripleEncapsulatedExpression(expression);
        }

        public void visit(LowerExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(MaxFunction expression) {
            this.visitAggregateFunction(expression);
        }

        public void visit(MinFunction expression) {
            this.visitAggregateFunction(expression);
        }

        public void visit(ModExpression expression) {
            this.visitAbstractDoubleEncapsulatedExpression(expression);
        }

        public void visit(MultiplicationExpression expression) {
            this.visitArithmeticExpression(expression);
        }

        public void visit(NullExpression expression) {
            this.complete = true;
        }

        public void visit(NullIfExpression expression) {
            this.visitAbstractDoubleEncapsulatedExpression(expression);
        }

        public void visit(ObjectExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(ResultVariable expression) {
            this.complete = expression.hasResultVariable();
        }

        public void visit(SelectClause expression) {
            int position = AbstractContentAssistVisitor.this.getPosition(expression);
            if (position == "SELECT".length() + 1) {
                this.complete = true;
            } else {
                expression.getSelectExpression().accept(this);
            }
        }

        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        public void visit(SizeExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(SqrtExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(StateFieldPathExpression expression) {
            this.complete = true;
        }

        public void visit(SubstringExpression expression) {
            this.visitAbstractTripleEncapsulatedExpression(expression);
        }

        public void visit(SubtractionExpression expression) {
            this.visitArithmeticExpression(expression);
        }

        public void visit(SumFunction expression) {
            this.visitAggregateFunction(expression);
        }

        public void visit(TrimExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(TypeExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(UpperExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(ValueExpression expression) {
            this.visitEncapsulatedIdentificationVariableExpression(expression);
        }

        protected void visitAbstractDoubleEncapsulatedExpression(AbstractDoubleEncapsulatedExpression expression) {
            this.visitAbstractEncapsulatedExpression(expression);
        }

        protected void visitAbstractEncapsulatedExpression(AbstractEncapsulatedExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        protected void visitAbstractSingleEncapsulatedExpression(AbstractSingleEncapsulatedExpression expression) {
            this.visitAbstractEncapsulatedExpression(expression);
        }

        protected void visitAbstractTripleEncapsulatedExpression(AbstractTripleEncapsulatedExpression expression) {
            this.visitAbstractEncapsulatedExpression(expression);
        }

        protected void visitAggregateFunction(AggregateFunction expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        protected void visitArithmeticExpression(ArithmeticExpression expression) {
            expression.getRightExpression().accept(this);
        }

        protected void visitEncapsulatedIdentificationVariableExpression(EncapsulatedIdentificationVariableExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }
    }

    protected class SelectClauseSelectStatementHelper
    extends AbstractSelectClauseSelectStatementHelper {
        protected SelectClauseSelectStatementHelper() {
        }

        public FromClauseSelectStatementHelper getNextHelper() {
            return AbstractContentAssistVisitor.this.getFromClauseSelectStatementHelper();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface SelectStatementHelper<T extends AbstractSelectStatement, C extends Expression> {
        public void addClauseProposal();

        public void appendNextClauseProposals(T var1, C var2, int var3, boolean var4);

        public C getClause(T var1);

        public Expression getClauseExpression(C var1);

        public SelectStatementHelper<? extends AbstractSelectStatement, ? extends Expression> getNextHelper();

        public SelectStatementHelper<? extends AbstractSelectStatement, ? extends Expression> getPreviousHelper();

        public boolean hasClause(T var1);

        public boolean hasClauseExpression(C var1);

        public boolean hasSpaceAfterClause(T var1);

        public boolean hasSpaceBeforeClause(T var1);

        public boolean isClauseExpressionComplete(Expression var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimpleFromClauseSelectStatementHelper
    extends AbstractFromClauseSelectStatementHelper<SimpleSelectStatement> {
        protected SimpleFromClauseSelectStatementHelper() {
        }

        @Override
        protected boolean addAppendableToCollection(SimpleSelectStatement expression, int position) {
            if (AbstractContentAssistVisitor.this.wordParser.endsWith(position, "GROUP") || AbstractContentAssistVisitor.this.wordParser.endsWith(position, "GROUP B")) {
                if (!expression.hasWhereClause()) {
                    AbstractContentAssistVisitor.this.proposals.addIdentifier("GROUP BY");
                }
                return true;
            }
            return false;
        }

        @Override
        protected void addClauseIdentifierProposals(SimpleSelectStatement expression) {
            AbstractContentAssistVisitor.this.addIdentifier("WHERE");
            if (!expression.hasWhereClause()) {
                AbstractContentAssistVisitor.this.addIdentifier("GROUP BY");
                if (!expression.hasGroupByClause()) {
                    AbstractContentAssistVisitor.this.addIdentifier("HAVING");
                }
            }
        }

        public SimpleWhereClauseSelectStatementHelper getNextHelper() {
            return AbstractContentAssistVisitor.this.getSimpleWhereClauseSelectStatementHelper();
        }

        public SimpleSelectClauseSelectStatementHelper getPreviousHelper() {
            return AbstractContentAssistVisitor.this.getSimpleSelectClauseSelectStatementHelper();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimpleGroupByClauseSelectStatementHelper
    extends AbstractGroupByClauseSelectStatementHelper<SimpleSelectStatement> {
        protected SimpleGroupByClauseSelectStatementHelper() {
        }

        @Override
        public void appendNextClauseProposals(SimpleSelectStatement expression, GroupByClause clause, int position, boolean complete) {
            if (complete || AbstractContentAssistVisitor.this.isAppendable(clause)) {
                AbstractContentAssistVisitor.this.addIdentifier("HAVING");
            }
        }

        public SimpleHavingClauseSelectStatementHelper getNextHelper() {
            return AbstractContentAssistVisitor.this.getSimpleHavingClauseSelectStatementHelper();
        }

        public SimpleWhereClauseSelectStatementHelper getPreviousHelper() {
            return AbstractContentAssistVisitor.this.getSimpleWhereClauseSelectStatementHelper();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimpleHavingClauseSelectStatementHelper
    extends AbstractHavingClauseSelectStatementHelper<SimpleSelectStatement> {
        protected SimpleHavingClauseSelectStatementHelper() {
        }

        @Override
        public void appendNextClauseProposals(SimpleSelectStatement expression, HavingClause clause, int position, boolean complete) {
        }

        @Override
        public SelectStatementHelper<AbstractSelectStatement, Expression> getNextHelper() {
            return null;
        }

        public SimpleGroupByClauseSelectStatementHelper getPreviousHelper() {
            return AbstractContentAssistVisitor.this.getSimpleGroupByClauseSelectStatementHelper();
        }

        @Override
        public boolean hasSpaceAfterClause(SimpleSelectStatement expression) {
            return false;
        }
    }

    protected class SimpleSelectClauseSelectStatementHelper
    extends AbstractSelectClauseSelectStatementHelper {
        protected SimpleSelectClauseSelectStatementHelper() {
        }

        public SimpleFromClauseSelectStatementHelper getNextHelper() {
            return AbstractContentAssistVisitor.this.getSimpleFromClauseSelectStatementHelper();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SimpleWhereClauseSelectStatementHelper
    extends AbstractWhereClauseSelectStatementHelper<SimpleSelectStatement> {
        protected SimpleWhereClauseSelectStatementHelper() {
        }

        @Override
        public void appendNextClauseProposals(SimpleSelectStatement expression, WhereClause clause, int position, boolean complete) {
            if (complete || AbstractContentAssistVisitor.this.isAppendable(clause)) {
                AbstractContentAssistVisitor.this.addIdentifier("GROUP BY");
                if (!expression.hasGroupByClause()) {
                    AbstractContentAssistVisitor.this.addIdentifier("HAVING");
                }
            }
        }

        public SimpleGroupByClauseSelectStatementHelper getNextHelper() {
            return AbstractContentAssistVisitor.this.getSimpleGroupByClauseSelectStatementHelper();
        }

        public SimpleFromClauseSelectStatementHelper getPreviousHelper() {
            return AbstractContentAssistVisitor.this.getSimpleFromClauseSelectStatementHelper();
        }
    }

    protected class SubqueryVisitor
    extends AbstractTraverseParentVisitor {
        SimpleSelectStatement expression;

        protected SubqueryVisitor() {
        }

        public void visit(SimpleSelectStatement expression) {
            this.expression = expression;
        }
    }

    protected class TrailingCompletenessVisitor
    extends CompletenessVisitor {
        protected TrailingCompletenessVisitor() {
        }

        public void visit(AbsExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(AbstractSchemaName expression) {
            this.complete = true;
        }

        public void visit(AdditionExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                expression.getRightExpression().accept(this);
            }
        }

        public void visit(AllOrAnyExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(AndExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                expression.getRightExpression().accept(this);
            }
        }

        public void visit(ArithmeticFactor expression) {
            this.complete = expression.hasExpression();
            if (this.complete) {
                expression.getExpression().accept(this);
            }
        }

        public void visit(AvgFunction expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(BetweenExpression expression) {
            boolean bl = this.complete = expression.hasAnd() && expression.hasUpperBoundExpression();
            if (this.complete) {
                expression.getUpperBoundExpression().accept(this);
            }
        }

        public void visit(CaseExpression expression) {
            this.complete = expression.hasEnd();
        }

        public void visit(CoalesceExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(CollectionMemberDeclaration expression) {
            this.complete = expression.hasIdentificationVariable();
        }

        public void visit(CollectionMemberExpression expression) {
            this.complete = expression.hasCollectionValuedPathExpression();
            if (this.complete) {
                expression.getCollectionValuedPathExpression().accept(this);
            }
        }

        public void visit(CollectionValuedPathExpression expression) {
            this.complete = !expression.endsWithDot();
        }

        public void visit(ComparisonExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                expression.getRightExpression().accept(this);
            }
        }

        public void visit(ConcatExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(ConstructorExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(CountFunction expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(DateTime expression) {
            this.complete = expression.isJDBCDate() ? expression.toActualText().endsWith("}") : true;
        }

        public void visit(DivisionExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                expression.getRightExpression().accept(this);
            }
        }

        public void visit(EmptyCollectionComparisonExpression expression) {
            this.complete = true;
        }

        public void visit(EntityTypeLiteral expression) {
            this.complete = true;
        }

        public void visit(EntryExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(ExistsExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(IdentificationVariable expression) {
            this.complete = true;
        }

        public void visit(IdentificationVariableDeclaration expression) {
            if (expression.hasJoins()) {
                expression.getJoins().accept(this);
            } else {
                expression.getRangeVariableDeclaration().accept(this);
            }
        }

        public void visit(IndexExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(InExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(InputParameter expression) {
            this.complete = true;
        }

        public void visit(Join expression) {
            this.complete = expression.hasFetch() ? (expression.hasAs() ? expression.hasIdentificationVariable() : expression.hasJoinAssociationPath()) : expression.hasIdentificationVariable();
        }

        public void visit(KeyExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(KeywordExpression expression) {
            this.complete = true;
        }

        public void visit(LengthExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(LikeExpression expression) {
            this.complete = expression.hasEscape() ? expression.hasEscapeCharacter() : expression.hasPatternValue();
        }

        public void visit(LocateExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(LowerExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(MaxFunction expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(MinFunction expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(ModExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(MultiplicationExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                expression.getRightExpression().accept(this);
            }
        }

        public void visit(NotExpression expression) {
            this.complete = expression.hasExpression();
        }

        public void visit(NullComparisonExpression expression) {
            this.complete = true;
        }

        public void visit(NullIfExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(NumericLiteral expression) {
            this.complete = true;
        }

        public void visit(ObjectExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(OrderByItem expression) {
            this.complete = true;
        }

        public void visit(OrExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                expression.getRightExpression().accept(this);
            }
        }

        public void visit(RangeVariableDeclaration expression) {
            this.complete = expression.hasIdentificationVariable();
        }

        public void visit(ResultVariable expression) {
            this.complete = expression.hasResultVariable();
        }

        public void visit(SizeExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(SqrtExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(StateFieldPathExpression expression) {
            this.complete = true;
        }

        public void visit(StringLiteral expression) {
            this.complete = expression.hasCloseQuote();
        }

        public void visit(SubExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(SubstringExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(SubtractionExpression expression) {
            this.complete = expression.hasRightExpression();
            if (this.complete) {
                expression.getRightExpression().accept(this);
            }
        }

        public void visit(SumFunction expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(TreatExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(TrimExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(TypeExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(UpdateItem expression) {
            this.complete = expression.hasNewValue();
            if (this.complete) {
                expression.getNewValue().accept(this);
            }
        }

        public void visit(UpperExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(ValueExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(WhenClause expression) {
            this.complete = expression.hasThenExpression();
            if (this.complete) {
                expression.getThenExpression().accept(this);
            }
        }

        public void visit(WhereClause expression) {
            this.complete = expression.hasConditionalExpression();
            if (this.complete) {
                expression.getConditionalExpression().accept(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TripleEncapsulatedCollectionHelper
    implements CollectionExpressionHelper<AbstractTripleEncapsulatedExpression> {
        protected TripleEncapsulatedCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(AbstractTripleEncapsulatedExpression expression, Expression child, int index) {
            if (this.queryBNF(expression, index).handleAggregate()) {
                AbstractContentAssistVisitor.this.addAllAggregates(this.queryBNF(expression, index));
            }
        }

        @Override
        public void addProposals(AbstractTripleEncapsulatedExpression expression, int index) {
            AbstractContentAssistVisitor.this.addAllIdentificationVariables();
            AbstractContentAssistVisitor.this.addAllFunctions(this.queryBNF(expression, index));
        }

        @Override
        public CollectionExpression buildCollectionExpression(AbstractTripleEncapsulatedExpression expression) {
            return expression.buildCollectionExpression();
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(AbstractTripleEncapsulatedExpression expression) {
            return expression.hasLeftParenthesis();
        }

        @Override
        public int maxCollectionSize(AbstractTripleEncapsulatedExpression expression) {
            return 3;
        }

        @Override
        public int preExpressionLength(AbstractTripleEncapsulatedExpression expression) {
            return 0;
        }

        @Override
        public JPQLQueryBNF queryBNF(AbstractTripleEncapsulatedExpression expression, int index) {
            return AbstractContentAssistVisitor.this.getQueryBNF(expression.parameterExpressionBNF(index));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UpdateItemCollectionHelper
    implements CollectionExpressionHelper<UpdateClause> {
        protected UpdateItemCollectionHelper() {
        }

        @Override
        public void addAtTheEndOfChild(UpdateClause expression, Expression child, int index) {
            AbstractContentAssistVisitor.this.addAllAggregates("new_value");
        }

        @Override
        public void addProposals(UpdateClause expression, int index) {
            AbstractContentAssistVisitor.this.addAllIdentificationVariables();
        }

        @Override
        public CollectionExpression buildCollectionExpression(UpdateClause expression) {
            CollectionExpression collectionExpression = AbstractContentAssistVisitor.this.getCollectionExpression(expression.getUpdateItems());
            if (collectionExpression == null) {
                collectionExpression = expression.buildCollectionExpression();
            }
            return collectionExpression;
        }

        @Override
        public boolean hasDelimiterAfterIdentifier(UpdateClause expression) {
            return true;
        }

        @Override
        public int maxCollectionSize(UpdateClause expression) {
            return Integer.MAX_VALUE;
        }

        @Override
        public int preExpressionLength(UpdateClause expression) {
            return "UPDATE".length() + 1 + AbstractContentAssistVisitor.this.length(expression.getRangeVariableDeclaration()) + 1 + "SET".length();
        }

        @Override
        public JPQLQueryBNF queryBNF(UpdateClause expression, int index) {
            return AbstractContentAssistVisitor.this.getQueryBNF("new_value");
        }
    }

    protected class VisitParentVisitor
    extends AnonymousExpressionVisitor {
        protected VisitParentVisitor() {
        }

        protected void visit(Expression expression) {
            expression.getParent().accept(AbstractContentAssistVisitor.this);
        }

        public void visit(InExpression expression) {
            int position = AbstractContentAssistVisitor.this.getPosition(expression) - AbstractContentAssistVisitor.this.corrections.peek();
            int length = 0;
            if (expression.hasExpression()) {
                length += AbstractContentAssistVisitor.this.length(expression.getExpression()) + 1;
            }
            if (AbstractContentAssistVisitor.this.isPositionWithin(position, length, expression.getIdentifier())) {
                boolean hasOnlyIdentifier;
                boolean bl = hasOnlyIdentifier = !expression.hasExpression() && !expression.hasInItems();
                if (hasOnlyIdentifier) {
                    AbstractContentAssistVisitor.this.corrections.add(AbstractContentAssistVisitor.this.getPosition(expression));
                }
                super.visit(expression);
                if (hasOnlyIdentifier) {
                    AbstractContentAssistVisitor.this.corrections.pop();
                }
            } else {
                super.visit(expression);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WhereClauseHelper
    implements ClauseHelper<WhereClause> {
        protected WhereClauseHelper() {
        }

        @Override
        public void addAtTheEndOfExpression(WhereClause expression) {
            AbstractContentAssistVisitor.this.addAllAggregates("conditional_expression");
            if (AbstractContentAssistVisitor.this.isCompoundable(expression.getConditionalExpression())) {
                AbstractContentAssistVisitor.this.addAllCompounds("conditional_expression");
            }
        }

        @Override
        public void addProposals(WhereClause expression) {
            AbstractContentAssistVisitor.this.addAllIdentificationVariables();
            AbstractContentAssistVisitor.this.addAllFunctions("conditional_expression");
        }

        @Override
        public Expression getClauseExpression(WhereClause expression) {
            return expression.getConditionalExpression();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WhereClauseSelectStatementHelper
    extends AbstractWhereClauseSelectStatementHelper<SelectStatement> {
        protected WhereClauseSelectStatementHelper() {
        }

        @Override
        public void appendNextClauseProposals(SelectStatement expression, WhereClause clause, int position, boolean complete) {
            if (complete || AbstractContentAssistVisitor.this.isAppendable(clause)) {
                AbstractContentAssistVisitor.this.addIdentifier("GROUP BY");
                if (!expression.hasGroupByClause()) {
                    AbstractContentAssistVisitor.this.addIdentifier("HAVING");
                    if (!expression.hasHavingClause()) {
                        AbstractContentAssistVisitor.this.addIdentifier("ORDER BY");
                    }
                }
            }
        }

        public GroupByClauseSelectStatementHelper getNextHelper() {
            return AbstractContentAssistVisitor.this.getGroupByClauseSelectStatementHelper();
        }

        public FromClauseSelectStatementHelper getPreviousHelper() {
            return AbstractContentAssistVisitor.this.getFromClauseSelectStatementHelper();
        }
    }
}

