/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.AbstractContentAssistVisitor;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.CastExpression;
import org.eclipse.persistence.jpa.jpql.parser.DatabaseType;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExtractExpression;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.RegexpExpression;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.TableExpression;
import org.eclipse.persistence.jpa.jpql.parser.TableVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.UnionClause;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;

public class EclipseLinkContentAssistVisitor
extends AbstractContentAssistVisitor
implements EclipseLinkExpressionVisitor {
    public EclipseLinkContentAssistVisitor(JPQLQueryContext queryContext) {
        super(queryContext);
    }

    protected UnionClauseSelectStatementHelper buildUnionClauseSelectStatementHelper() {
        return new UnionClauseSelectStatementHelper();
    }

    protected UnionClauseSelectStatementHelper getUnionClauseSelectStatementHelper() {
        UnionClauseSelectStatementHelper helper = this.getHelper(UnionClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildUnionClauseSelectStatementHelper();
            this.registerHelper(UnionClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    protected boolean isJoinFetchIdentifiable() {
        return this.getGrammar().getProviderVersion() == "2.4";
    }

    public void visit(CastExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        String identifier = expression.getIdentifier();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier(identifier);
        } else if (expression.hasLeftParenthesis()) {
            Expression scalarExpression;
            int length = identifier.length() + 1;
            if (position == length) {
                this.addAllIdentificationVariables();
                this.addAllFunctions(expression.encapsulatedExpressionBNF());
            } else if (expression.hasExpression() && this.isComplete(scalarExpression = expression.getExpression())) {
                length += this.length(scalarExpression);
                if (expression.hasSpaceAfterExpression()) {
                    if (position == ++length) {
                        this.addAllAggregates(expression.encapsulatedExpressionBNF());
                        this.proposals.addIdentifier("AS");
                    } else if (this.isPositionWithin(position, length, "AS")) {
                        this.proposals.addIdentifier("AS");
                    }
                }
            }
        }
    }

    public void visit(DatabaseType expression) {
    }

    public void visit(ExtractExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        String identifier = expression.getIdentifier();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier(identifier);
        } else if (expression.hasLeftParenthesis()) {
            int length = identifier.length() + 1;
            if (expression.hasDatePart()) {
                String datePart = expression.getDatePart();
                this.isPositionWithin(position, length, datePart);
                length += datePart.length();
                if (expression.hasSpaceAfterDatePart() && position == ++length) {
                    this.addIdentifier("FROM");
                    if (!expression.hasExpression() || !expression.hasFrom()) {
                        this.addAllIdentificationVariables();
                        this.addAllFunctions(expression.encapsulatedExpressionBNF());
                    }
                }
            }
            if (expression.hasFrom()) {
                if (this.isPositionWithin(position, length, "FROM")) {
                    this.proposals.addIdentifier("FROM");
                    if (!expression.hasExpression()) {
                        this.addAllIdentificationVariables();
                        this.addAllFunctions(expression.encapsulatedExpressionBNF());
                    }
                }
                length += 4;
                if (expression.hasSpaceAfterFrom()) {
                    ++length;
                }
                if (position == length) {
                    this.addAllIdentificationVariables();
                    this.addAllFunctions(expression.encapsulatedExpressionBNF());
                }
            }
        }
    }

    public void visit(OrderByItem expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        if (expression.hasExpression()) {
            int length = this.length(expression.getExpression());
            if (expression.hasSpaceAfterExpression()) {
                if (position == ++length) {
                    if (expression.getOrdering() == OrderByItem.Ordering.DEFAULT) {
                        this.proposals.addIdentifier("NULLS FIRST");
                        this.proposals.addIdentifier("NULLS LAST");
                    }
                } else if (position > (length += expression.getActualOrdering().length()) && expression.hasSpaceAfterOrdering()) {
                    if (position == ++length) {
                        this.proposals.addIdentifier("NULLS FIRST");
                        this.proposals.addIdentifier("NULLS LAST");
                    } else {
                        String nullOrdering = expression.getActualNullOrdering();
                        if (this.isPositionWithin(position, length, nullOrdering)) {
                            this.proposals.addIdentifier("NULLS FIRST");
                            this.proposals.addIdentifier("NULLS LAST");
                        }
                    }
                }
            }
        }
    }

    public void visit(RegexpExpression expression) {
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        int length = 0;
        if (expression.hasStringExpression()) {
            length += this.length(expression.getStringExpression());
            if (expression.hasSpaceAfterStringExpression()) {
                ++length;
            }
        }
        if (this.isPositionWithin(position, length, "REGEXP")) {
            this.proposals.addIdentifier("REGEXP");
        } else {
            length += 6;
            if (expression.hasSpaceAfterIdentifier()) {
                ++length;
                this.addAllIdentificationVariables();
                this.addAllFunctions("pattern_value");
            }
        }
    }

    public void visit(TableExpression expression) {
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        if (this.isPositionWithin(position, "TABLE")) {
            this.proposals.addIdentifier("TABLE");
        }
    }

    public void visit(TableVariableDeclaration expression) {
        this.getPosition(expression);
        ((Integer)this.corrections.peek()).intValue();
    }

    public void visit(UnionClause expression) {
        String identifier;
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        if (this.isPositionWithin(position, identifier = expression.getIdentifier())) {
            this.proposals.addIdentifier("EXCEPT");
            this.proposals.addIdentifier("INTERSECT");
            this.proposals.addIdentifier("UNION");
        } else if (expression.hasSpaceAfterIdentifier()) {
            int length = identifier.length() + 1;
            if (position == length) {
                this.proposals.addIdentifier("ALL");
                if (!expression.hasAll()) {
                    this.proposals.addIdentifier("SELECT");
                }
            } else if (this.isPositionWithin(position, length, "ALL")) {
                this.proposals.addIdentifier("ALL");
            } else {
                position += 3;
                if (expression.hasSpaceAfterAll() && ++position == length) {
                    this.proposals.addIdentifier("SELECT");
                }
            }
        }
    }

    protected class FromClauseSelectStatementHelper
    extends AbstractContentAssistVisitor.FromClauseSelectStatementHelper {
        protected FromClauseSelectStatementHelper() {
        }

        protected void addClauseIdentifierProposals(SelectStatement expression) {
            super.addClauseIdentifierProposals(expression);
            if (!(expression.hasWhereClause() || expression.hasGroupByClause() || expression.hasHavingClause() || expression.hasOrderByClause())) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
                EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
            }
        }
    }

    protected class GroupByClauseSelectStatementHelper
    extends AbstractContentAssistVisitor.GroupByClauseSelectStatementHelper {
        protected GroupByClauseSelectStatementHelper() {
        }

        public void appendNextClauseProposals(SelectStatement expression, GroupByClause clause, int position, boolean complete) {
            super.appendNextClauseProposals(expression, clause, position, complete);
            if (!(!complete && !EclipseLinkContentAssistVisitor.this.isAppendable(clause) || expression.hasGroupByClause() || expression.hasHavingClause() || expression.hasOrderByClause())) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
            }
        }
    }

    protected class HavingClauseSelectStatementHelper
    extends AbstractContentAssistVisitor.HavingClauseSelectStatementHelper {
        protected HavingClauseSelectStatementHelper() {
        }

        public void appendNextClauseProposals(SelectStatement expression, HavingClause clause, int position, boolean complete) {
            super.appendNextClauseProposals(expression, clause, position, complete);
            if ((complete || EclipseLinkContentAssistVisitor.this.isAppendable(clause)) && !expression.hasOrderByClause()) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
            }
        }
    }

    protected class OrderByClauseSelectStatementHelper
    extends AbstractContentAssistVisitor.OrderByClauseSelectStatementHelper {
        protected OrderByClauseSelectStatementHelper() {
        }

        public void appendNextClauseProposals(SelectStatement expression, OrderByClause clause, int position, boolean complete) {
            super.appendNextClauseProposals(expression, clause, position, complete);
            if ((complete || EclipseLinkContentAssistVisitor.this.isAppendable(clause)) && !expression.hasOrderByClause()) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
            }
        }

        public UnionClauseSelectStatementHelper getNextHelper() {
            return EclipseLinkContentAssistVisitor.this.getUnionClauseSelectStatementHelper();
        }

        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return expression.hasSpaceBeforeUnion();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UnionClauseSelectStatementHelper
    implements AbstractContentAssistVisitor.SelectStatementHelper<SelectStatement, UnionClause> {
        protected UnionClauseSelectStatementHelper() {
        }

        @Override
        public void addClauseProposal() {
            EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
        }

        @Override
        public void appendNextClauseProposals(SelectStatement expression, UnionClause clause, int position, boolean complete) {
            EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
        }

        @Override
        public UnionClause getClause(SelectStatement expression) {
            return (UnionClause)expression.getUnionClauses();
        }

        @Override
        public Expression getClauseExpression(UnionClause clause) {
            return clause.getQuery();
        }

        @Override
        public AbstractContentAssistVisitor.SelectStatementHelper<? extends AbstractSelectStatement, ? extends Expression> getNextHelper() {
            return null;
        }

        public AbstractContentAssistVisitor.OrderByClauseSelectStatementHelper getPreviousHelper() {
            return EclipseLinkContentAssistVisitor.this.getOrderByClauseSelectStatementHelper();
        }

        @Override
        public boolean hasClause(SelectStatement expression) {
            return expression.hasUnionClauses();
        }

        @Override
        public boolean hasClauseExpression(UnionClause clause) {
            return clause.hasQuery();
        }

        @Override
        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return false;
        }

        @Override
        public boolean hasSpaceBeforeClause(SelectStatement expression) {
            return expression.hasSpaceBeforeUnion();
        }

        @Override
        public boolean isClauseExpressionComplete(Expression expression) {
            return false;
        }
    }

    protected class WhereClauseSelectStatementHelper
    extends AbstractContentAssistVisitor.WhereClauseSelectStatementHelper {
        protected WhereClauseSelectStatementHelper() {
        }

        public void appendNextClauseProposals(SelectStatement expression, WhereClause clause, int position, boolean complete) {
            super.appendNextClauseProposals(expression, clause, position, complete);
            if (!(!complete && !EclipseLinkContentAssistVisitor.this.isAppendable(clause) || expression.hasGroupByClause() || expression.hasHavingClause() || expression.hasOrderByClause())) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
            }
        }
    }
}

