/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.complexaggregate;

import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.CoachVitals;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.HockeyCoach;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.HockeyPlayer;
import org.eclipse.persistence.testing.models.jpa.complexaggregate.PersonalVitals;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class MapKeyColumnMergeTest
extends EntityContainerTestBase {
    protected Object playerId;
    protected Object player2Id;
    protected Object coachId;

    public MapKeyColumnMergeTest() {
        this.setDescription("Tests using a read-only aggregate as a map key.");
    }

    @Override
    public void setup() {
        super.setup();
        ((EntityManagerImpl)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        HockeyPlayer player = new HockeyPlayer();
        player.setFirstName("Guy");
        player.setLastName("Flower");
        HockeyPlayer player2 = new HockeyPlayer();
        player2.setFirstName("Power");
        player2.setLastName("Flower");
        HockeyCoach coach = new HockeyCoach();
        coach.setFirstName("Scott");
        coach.setLastName("Arrowman");
        CoachVitals cVitals = new CoachVitals();
        PersonalVitals pVitals = new PersonalVitals();
        pVitals.setAge(45);
        pVitals.setHeight(3.3);
        pVitals.setWeight(333.0);
        cVitals.setPersonalVitals(pVitals);
        coach.setVitals(cVitals);
        this.beginTransaction();
        this.getEntityManager().persist((Object)player);
        this.getEntityManager().persist((Object)player2);
        this.getEntityManager().persist((Object)coach);
        this.playerId = player.getPlayerId();
        this.player2Id = player2.getPlayerId();
        this.coachId = coach.getId();
        coach.addFavouritePlayer(player);
        this.commitTransaction();
        this.getEntityManager().close();
        this.beginTransaction();
        coach.addFavouritePlayer(player2);
        this.getEntityManager().merge((Object)coach);
        this.commitTransaction();
    }

    @Override
    public void reset() {
        HockeyPlayer player = (HockeyPlayer)this.getEntityManager().find(HockeyPlayer.class, this.playerId);
        HockeyPlayer player2 = (HockeyPlayer)this.getEntityManager().find(HockeyPlayer.class, this.player2Id);
        HockeyCoach coach = (HockeyCoach)this.getEntityManager().find(HockeyCoach.class, this.coachId);
        this.beginTransaction();
        if (player != null) {
            this.getEntityManager().remove((Object)player);
        }
        if (player2 != null) {
            this.getEntityManager().remove((Object)player2);
        }
        if (coach != null) {
            this.getEntityManager().remove((Object)coach);
        }
        this.commitTransaction();
    }
}

