/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.ddlgeneration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.tests.jpa.ddlgeneration.DDLGenerationJUnitTestSuite;
import org.eclipse.persistence.tools.schemaframework.DefaultTableGenerator;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class DDLGenerationExtendTablesJUnitTestSuite
extends DDLGenerationJUnitTestSuite {
    public DDLGenerationExtendTablesJUnitTestSuite() {
    }

    public DDLGenerationExtendTablesJUnitTestSuite(String name) {
        super(name);
        this.setPuName(DDL_PU);
    }

    @Override
    public void testSetup() {
        EntityManager em = DDLGenerationExtendTablesJUnitTestSuite.createEntityManager((String)DDL_PU);
        DatabaseSessionImpl session = DDLGenerationExtendTablesJUnitTestSuite.getDatabaseSession((String)DDL_PU);
        TableCreator defaultTableCreator = new DefaultTableGenerator(session.getProject(), true).generateDefaultTableCreator();
        defaultTableCreator.dropTables((DatabaseSession)session);
        DatabaseException exception = null;
        try {
            em.createQuery("Select c from Course c").getResultList();
        }
        catch (DatabaseException caught) {
            exception = caught;
        }
        DDLGenerationExtendTablesJUnitTestSuite.assertNotNull((String)"setup failed because a query on a drop table did not throw an exception.", (Object)((Object)exception));
        EmptyTableCreator tbCreator = new EmptyTableCreator();
        tbCreator.createTables((DatabaseSession)session);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.ddl-generation", "create-or-extend-tables");
        properties.put("eclipselink.ddl-generation.output-mode", "database");
        properties.put("eclipselink.deploy-on-startup", "true");
        this.beginTransaction(em);
        JpaHelper.getEntityManagerFactory((EntityManager)em).refreshMetadata(properties);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        DDLGenerationExtendTablesJUnitTestSuite.clearCache((String)DDL_PU);
    }

    public static Test suite() {
        if (System.getProperty("server.platform") != null) {
            DDL_PU = "MulitPU-1";
        }
        TestSuite suite = new TestSuite();
        suite.setName("DDLCreateAndAlterTablesTestSuite");
        suite.addTest((Test)new DDLGenerationExtendTablesJUnitTestSuite("testSetup"));
        ArrayList<String> tests = new ArrayList<String>();
        tests.add("testDDLPkConstraintErrorIncludingRelationTableColumnName");
        tests.add("testOptionalPrimaryKeyJoinColumnRelationship");
        tests.add("testPrimaryKeyJoinColumns");
        tests.add("testDDLEmbeddableMapKey");
        tests.add("testDDLAttributeOverrides");
        tests.add("testDDLAttributeOverridesOnElementCollection");
        tests.add("testDDLUniqueKeysAsJoinColumns");
        tests.add("testDDLUniqueConstraintsByAnnotations");
        tests.add("testDDLUniqueConstraintsByXML");
        tests.add("testDDLSubclassEmbeddedIdPkColumnsInJoinedStrategy");
        tests.add("testBug241308");
        tests.add("testDDLUnidirectionalOneToMany");
        tests.add("testCascadeMergeOnManagedEntityWithOrderedList");
        tests.add("testDirectCollectionMapping");
        tests.add("testAggregateCollectionMapping");
        tests.add("testOneToManyMapping");
        tests.add("testUnidirectionalOneToManyMapping");
        tests.add("testManyToManyMapping");
        tests.add("testManyToManyWithMultipleJoinColumns");
        tests.add("testEmbeddedManyToMany");
        tests.add("testEmbeddedOneToOne");
        tests.add("testAssociationOverrideToEmbeddedManyToMany");
        tests.add("testDeleteObjectWithEmbeddedManyToMany");
        tests.add("testLAZYLOBWithEmbeddedId");
        tests.add("testElementMapOnEmbedded");
        if (!JUnitTestCase.isJPA10()) {
            tests.add("testCreateMafiaFamily707");
            tests.add("testCreateMafiaFamily007");
            tests.add("testValidateMafiaFamily707");
            tests.add("testValidateMafiaFamily007");
        }
        tests.add("testSimpleSelectFoo");
        Collections.sort(tests);
        for (String test : tests) {
            suite.addTest((Test)new DDLGenerationExtendTablesJUnitTestSuite(test));
        }
        return suite;
    }

    public class EmptyTableCreator
    extends TableCreator {
        public EmptyTableCreator() {
            TableDefinition tabledefinition = new TableDefinition();
            tabledefinition.setName("Countries");
            FieldDefinition field = new FieldDefinition();
            field.setName("iso_code");
            field.setType(String.class);
            field.setSize(50);
            field.setShouldAllowNull(false);
            field.setIsPrimaryKey(true);
            field.setUnique(false);
            field.setIsIdentity(true);
            tabledefinition.addField(field);
            this.addTableDefinition(tabledefinition);
            tabledefinition = new TableDefinition();
            tabledefinition.setName("DDL_EMP");
            field = new FieldDefinition();
            field.setName("ID");
            field.setType(Integer.class);
            field.setShouldAllowNull(false);
            field.setIsPrimaryKey(true);
            field.setUnique(false);
            field.setIsIdentity(true);
            tabledefinition.addField(field);
            this.addTableDefinition(tabledefinition);
            tabledefinition = new TableDefinition();
            tabledefinition.setName("TMP_COURSE");
            field = new FieldDefinition();
            field.setName("ID");
            field.setType(Long.class);
            field.setShouldAllowNull(false);
            field.setIsPrimaryKey(true);
            field.setUnique(false);
            field.setIsIdentity(true);
            tabledefinition.addField(field);
            this.addTableDefinition(tabledefinition);
            tabledefinition = new TableDefinition();
            tabledefinition.setName("Foos");
            field = new FieldDefinition();
            field.setName("contact_id");
            field.setType(Integer.class);
            field.setShouldAllowNull(false);
            field.setIsPrimaryKey(true);
            field.setUnique(false);
            field.setIsIdentity(true);
            tabledefinition.addField(field);
            field = new FieldDefinition();
            field.setName("ordinal_nbr");
            field.setType(Integer.class);
            field.setShouldAllowNull(false);
            field.setIsPrimaryKey(true);
            field.setUnique(false);
            field.setIsIdentity(true);
            tabledefinition.addField(field);
            this.addTableDefinition(tabledefinition);
            tabledefinition = new TableDefinition();
            tabledefinition.setName("DDL_CKENTA");
            field = new FieldDefinition();
            field.setName("SEQ");
            field.setType(Integer.class);
            field.setShouldAllowNull(false);
            field.setIsPrimaryKey(true);
            field.setUnique(false);
            field.setIsIdentity(true);
            tabledefinition.addField(field);
            field = new FieldDefinition();
            field.setName("F_NAME");
            field.setType(String.class);
            field.setSize(64);
            field.setShouldAllowNull(false);
            field.setIsPrimaryKey(true);
            field.setUnique(false);
            field.setIsIdentity(true);
            tabledefinition.addField(field);
            field = new FieldDefinition();
            field.setName("L_NAME");
            field.setType(String.class);
            field.setSize(64);
            field.setShouldAllowNull(false);
            field.setIsPrimaryKey(true);
            field.setUnique(false);
            field.setIsIdentity(true);
            tabledefinition.addField(field);
            this.addTableDefinition(tabledefinition);
        }
    }
}

