/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.relationships;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.copying.CloneCopyPolicy;
import org.eclipse.persistence.descriptors.copying.CopyPolicy;
import org.eclipse.persistence.descriptors.copying.InstantiationCopyPolicy;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.Auditor;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.CEO;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.Customer;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.Distributor;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.Item;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.Lego;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.Manufacturer;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.Mattel;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.MegaBrands;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.Namco;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.Order;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.OrderCard;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.OrderLabel;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.RelationshipsTableManager;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.TestInstantiationCopyPolicy;
import org.eclipse.persistence.testing.tests.jpa.TestingProperties;

public class EntityMappingsRelationshipsJUnitTestCase
extends JUnitTestCase {
    private static Integer customerId;
    private static Integer itemId;
    private static Integer extendedItemId;
    private static Integer orderId;
    private String m_persistenceUnit;

    public EntityMappingsRelationshipsJUnitTestCase() {
    }

    public EntityMappingsRelationshipsJUnitTestCase(String name) {
        super(name);
    }

    public EntityMappingsRelationshipsJUnitTestCase(String name, String persistenceUnit) {
        super(name);
        this.m_persistenceUnit = persistenceUnit;
    }

    public static Test suite() {
        String ormTesting = TestingProperties.getProperty("orm.testing", "jpa");
        String persistenceUnit = ormTesting.equals("jpa") ? "default" : "extended-relationships";
        TestSuite suite = new TestSuite("Relationships Model - " + persistenceUnit);
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testSetup", persistenceUnit));
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testCreateCustomer", persistenceUnit));
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testCreateItem", persistenceUnit));
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testCreateOrder", persistenceUnit));
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testReadCustomer", persistenceUnit));
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testReadItem", persistenceUnit));
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testReadOrder", persistenceUnit));
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testNamedQueryOnCustomer", persistenceUnit));
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testNamedQueryOnItem", persistenceUnit));
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testNamedQueryOnOrder", persistenceUnit));
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testUpdateCustomer", persistenceUnit));
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testUpdateItem", persistenceUnit));
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testUpdateOrder", persistenceUnit));
        if (persistenceUnit.equals("extended-relationships")) {
            suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testExcludeDefaultMappings", persistenceUnit));
            suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testCreateExtendedItem", persistenceUnit));
            suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testModifyExtendedItem", persistenceUnit));
            suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testVerifyExtendedItem", persistenceUnit));
            suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testCopyPolicy", persistenceUnit));
            suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testCloneCopyPolicy", persistenceUnit));
            suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testInstantiationCopyPolicy", persistenceUnit));
            suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testNamedNativeQueryFromMappedSuperclass", persistenceUnit));
        } else {
            suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testOne2OneRelationTables", persistenceUnit));
        }
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testDeleteOrder", persistenceUnit));
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testDeleteCustomer", persistenceUnit));
        suite.addTest((Test)new EntityMappingsRelationshipsJUnitTestCase("testDeleteItem", persistenceUnit));
        return suite;
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        new RelationshipsTableManager().replaceTables((DatabaseSession)session);
        EntityMappingsRelationshipsJUnitTestCase.clearCache((String)this.m_persistenceUnit);
    }

    public void testCreateCustomer() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Customer customer = new Customer();
            customer.setName("Joe Black");
            customer.setCity("Austin");
            em.persist((Object)customer);
            customerId = customer.getCustomerId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testCreateItem() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Item item = new Item();
            item.setName("Widget");
            item.setDescription("This is a Widget");
            item.setImage(new byte[1024]);
            em.persist((Object)item);
            itemId = item.getItemId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testCreateOrder() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Order order = new Order();
            order.setShippingAddress("50 O'Connor St.");
            Customer customer = (Customer)em.find(Customer.class, (Object)customerId);
            order.setCustomer(customer);
            order.setQuantity(1);
            Item item = (Item)em.find(Item.class, (Object)itemId);
            order.setItem(item);
            em.persist((Object)order);
            orderId = order.getOrderId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testDeleteCustomer() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Customer c = (Customer)em.find(Customer.class, (Object)customerId);
            em.refresh((Object)c);
            em.remove((Object)c);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Error deleting Customer", (em.find(Customer.class, (Object)customerId) == null ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testDeleteItem() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            em.remove(em.find(Item.class, (Object)itemId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Error deleting Item", (em.find(Item.class, (Object)itemId) == null ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testDeleteOrder() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            em.remove(em.find(Order.class, (Object)orderId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Error deleting Order", (em.find(Order.class, (Object)orderId) == null ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testNamedNativeQueryFromMappedSuperclass() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        Object customer = em.createNamedQuery("findAllSQLXMLCustomers").getSingleResult();
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Error executing named native query 'findAllSQLXMLCustomers'", (customer != null ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testNamedQueryOnCustomer() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        Customer customer = (Customer)em.createNamedQuery("findAllXMLCustomers").getSingleResult();
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Error executing named query 'findAllXMLCustomers'", (customer != null ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testNamedQueryOnOrder() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        Query query = em.createNamedQuery("findAllXMLOrdersByItem");
        query.setParameter("id", (Object)itemId);
        Order order = (Order)query.getSingleResult();
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Error executing named query 'findAllXMLOrdersByItem'", (order != null ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testNamedQueryOnItem() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        Query query = em.createNamedQuery("findAllXMLItemsByName");
        query.setParameter("1", (Object)"Widget");
        Item item = (Item)query.getSingleResult();
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Error executing named query 'findAllXMLItemsByName'", (item != null ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testReadCustomer() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        Customer customer = (Customer)em.find(Customer.class, (Object)customerId);
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Error reading Customer", (boolean)customer.getCustomerId().equals(customerId));
        this.closeEntityManager(em);
    }

    public void testReadItem() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        Item item = (Item)em.find(Item.class, (Object)itemId);
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Error reading Item", (boolean)item.getItemId().equals(itemId));
        this.closeEntityManager(em);
    }

    public void testReadOrder() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        Order order = (Order)em.find(Order.class, (Object)orderId);
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Error reading Order", (boolean)order.getOrderId().equals(orderId));
        this.closeEntityManager(em);
    }

    public void testUpdateCustomer() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Customer customer = (Customer)em.find(Customer.class, (Object)customerId);
            customer.setCity("Dallas");
            em.merge((Object)customer);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsRelationshipsJUnitTestCase.clearCache((String)this.m_persistenceUnit);
        Customer newCustomer = (Customer)em.find(Customer.class, (Object)customerId);
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Error updating Customer", (boolean)newCustomer.getCity().equals("Dallas"));
        this.closeEntityManager(em);
    }

    public void testUpdateItem() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Item item = (Item)em.find(Item.class, (Object)itemId);
            item.setDescription("A Widget");
            item.setImage(new byte[1280]);
            em.merge((Object)item);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsRelationshipsJUnitTestCase.clearCache((String)this.m_persistenceUnit);
        Item newItem = (Item)em.find(Item.class, (Object)itemId);
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Error updating Item description", (boolean)newItem.getDescription().equals("A Widget"));
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Error updating Item image", (newItem.getImage().length == 1280 ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testUpdateOrder() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Customer customer = (Customer)em.find(Customer.class, (Object)customerId);
            Order order = (Order)customer.getOrders().iterator().next();
            order.setQuantity(100);
            em.merge((Object)customer);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsRelationshipsJUnitTestCase.clearCache((String)this.m_persistenceUnit);
        Customer newCustomer = (Customer)em.find(Customer.class, (Object)customerId);
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Error updating Customer", (((Order)newCustomer.getOrders().iterator().next()).getQuantity() == 100 ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testExcludeDefaultMappings() {
        ClassDescriptor descriptor = EntityMappingsRelationshipsJUnitTestCase.getServerSession((String)this.m_persistenceUnit).getDescriptor(Mattel.class);
        EntityMappingsRelationshipsJUnitTestCase.assertNull((String)"The 'ignoredBasic' attribute from the clas Mattel was mapped despite an exclude-default-mappings setting of true.", (Object)descriptor.getMappingForAttributeName("ignoredBasic"));
        EntityMappingsRelationshipsJUnitTestCase.assertNull((String)"The 'ignoredOneToOne' attribute from the clas Mattel was mapped despite an exclude-default-mappings setting of true.", (Object)descriptor.getMappingForAttributeName("ignoredOneToOne"));
        EntityMappingsRelationshipsJUnitTestCase.assertNull((String)"The 'ignoredVariableOneToOne' attribute from the clas Mattel was mapped despite an exclude-default-mappings setting of true.", (Object)descriptor.getMappingForAttributeName("ignoredVariableOneToOne"));
        EntityMappingsRelationshipsJUnitTestCase.assertNull((String)"The 'ignoredOneToMany' attribute from the clas Mattel was mapped despite an exclude-default-mappings setting of true.", (Object)descriptor.getMappingForAttributeName("ignoredOneToMany"));
    }

    public void testCreateExtendedItem() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Item item = new Item();
            item.setName("Synergizer2000");
            item.setDescription("Every kid must have one ... ");
            Mattel mattel = new Mattel();
            mattel.setName("Mattel Inc.");
            CEO mattelCEO = new CEO();
            mattelCEO.setName("Mr. Mattel");
            mattel.setCeo(mattelCEO);
            em.persist((Object)mattel);
            item.setManufacturer((Manufacturer)mattel);
            Namco namco = new Namco();
            namco.setName("Namco Games");
            CEO namcoCEO = new CEO();
            namcoCEO.setName("Mr. Namco");
            namco.setCeo(namcoCEO);
            item.setDistributor((Distributor)namco);
            em.persist((Object)item);
            extendedItemId = item.getItemId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testModifyExtendedItem() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Item item = (Item)em.find(Item.class, (Object)extendedItemId);
            item.setName("Willy Waller");
            item.setDescription("For adults only!");
            EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"The manufacturer was not persisted", (item.getManufacturer() != null ? 1 : 0) != 0);
            EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"The manufacturer of the item was incorrect", (boolean)item.getManufacturer().getName().equals("Mattel Inc."));
            Lego lego = new Lego();
            lego.setName("The LEGO Group");
            em.persist((Object)lego);
            item.setManufacturer((Manufacturer)lego);
            EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"The distributor was not persisted", (item.getDistributor() != null ? 1 : 0) != 0);
            EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"The distributor of the item was incorrect", (boolean)item.getDistributor().getName().equals("Namco Games"));
            MegaBrands megaBrands = new MegaBrands();
            megaBrands.setName("MegaBrands Inc.");
            em.persist((Object)megaBrands);
            item.setDistributor((Distributor)megaBrands);
            em.merge((Object)item);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testVerifyExtendedItem() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        Item item = (Item)em.find(Item.class, (Object)extendedItemId);
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"The manufacturer was not persisted", (item.getManufacturer() != null ? 1 : 0) != 0);
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)("The manufacturer of the item was incorrect [" + item.getManufacturer().getName() + "]"), (boolean)item.getManufacturer().getName().equals("The LEGO Group"));
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"The distributor was not persisted", (item.getDistributor() != null ? 1 : 0) != 0);
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)("The distributor of the item was incorrect [" + item.getDistributor().getName() + "]"), (boolean)item.getDistributor().getName().equals("MegaBrands Inc."));
        this.closeEntityManager(em);
    }

    public void testInstantiationCopyPolicy() {
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"The InstantiationCopyPolicy was not properly set.", (boolean)(EntityMappingsRelationshipsJUnitTestCase.getServerSession((String)this.m_persistenceUnit).getDescriptor(Item.class).getCopyPolicy() instanceof InstantiationCopyPolicy));
    }

    public void testCopyPolicy() {
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"The CopyPolicy was not properly set.", (boolean)(EntityMappingsRelationshipsJUnitTestCase.getServerSession((String)this.m_persistenceUnit).getDescriptor(Order.class).getCopyPolicy() instanceof TestInstantiationCopyPolicy));
    }

    public void testCloneCopyPolicy() {
        CopyPolicy copyPolicy = EntityMappingsRelationshipsJUnitTestCase.getServerSession((String)this.m_persistenceUnit).getDescriptor(Namco.class).getCopyPolicy();
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"The CloneCopyPolicy was not properly set.", (boolean)(copyPolicy instanceof CloneCopyPolicy));
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"The method on CloneCopyPolicy was not properly set.", (boolean)((CloneCopyPolicy)copyPolicy).getMethodName().equals("cloneNamco"));
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"The workingCopyMethod on CloneCopyPolicy was not properly set.", (boolean)((CloneCopyPolicy)copyPolicy).getWorkingCopyMethodName().equals("cloneWorkingCopyNamco"));
    }

    public void testOne2OneRelationTables() {
        EntityManager em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        Order order1 = new Order();
        Order order2 = new Order();
        Auditor auditor = new Auditor();
        try {
            OrderCard order1Card = new OrderCard();
            OrderLabel order1Label = new OrderLabel();
            order1Label.setDescription("I describe order 1");
            order1.setOrderLabel(order1Label);
            order1.setOrderCard(order1Card);
            em.persist((Object)order1);
            OrderCard order2Card = new OrderCard();
            OrderLabel order2Label = new OrderLabel();
            order2Label.setDescription("I describe order 2");
            order2.setOrderLabel(order2Label);
            order2.setOrderCard(order2Card);
            em.persist((Object)order2);
            auditor.setName("Guillaume");
            auditor.addOrder(order1);
            auditor.addOrder(order2);
            em.persist((Object)auditor);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
        EntityMappingsRelationshipsJUnitTestCase.clearCache((String)this.m_persistenceUnit);
        em = EntityMappingsRelationshipsJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        Auditor refreshedAuditor = (Auditor)em.find(Auditor.class, (Object)auditor.getId());
        Order refreshedOrder1 = (Order)em.find(Order.class, (Object)order1.getOrderId());
        Order refreshedOrder2 = (Order)em.find(Order.class, (Object)order2.getOrderId());
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Auditor read back did not match the original", (boolean)EntityMappingsRelationshipsJUnitTestCase.getServerSession((String)this.m_persistenceUnit).compareObjects((Object)auditor, (Object)refreshedAuditor));
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Order1 read back did not match the original", (boolean)EntityMappingsRelationshipsJUnitTestCase.getServerSession((String)this.m_persistenceUnit).compareObjects((Object)order1, (Object)refreshedOrder1));
        EntityMappingsRelationshipsJUnitTestCase.assertTrue((String)"Order2 read back did not match the original", (boolean)EntityMappingsRelationshipsJUnitTestCase.getServerSession((String)this.m_persistenceUnit).compareObjects((Object)order2, (Object)refreshedOrder2));
        this.closeEntityManager(em);
    }
}

