/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm;

import java.util.Iterator;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.optimisticlocking.ListHolder;
import org.eclipse.persistence.testing.models.optimisticlocking.ListItem;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.ConfigurableCacheSyncDistributedTest;

public class NewObjectWithOptimisticLockingTest
extends ConfigurableCacheSyncDistributedTest {
    protected ListHolder holder = null;

    public NewObjectWithOptimisticLockingTest() {
        this.cacheSyncConfigValues.put(ListHolder.class, new Integer(1));
        this.cacheSyncConfigValues.put(ListItem.class, new Integer(1));
    }

    @Override
    public void setup() {
        super.setup();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        ListHolder holder = new ListHolder();
        holder = (ListHolder)uow.registerObject((Object)holder);
        ListItem item = new ListItem();
        item.setDescription("test");
        item = (ListItem)uow.registerObject((Object)item);
        holder.getItems().add(item);
        item.setHolder(holder);
        uow.commit();
    }

    public void test() {
        DistributedServer server = (DistributedServer)DistributedServersModel.getDistributedServers().get(0);
        UnitOfWork uow = server.getDistributedSession().acquireUnitOfWork();
        this.holder = (ListHolder)uow.readObject(ListHolder.class);
        ListItem item = new ListItem();
        item.setDescription("test2");
        item = (ListItem)uow.registerObject((Object)item);
        this.holder.getItems().add(item);
        uow.commit();
    }

    public void verify() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.holder = (ListHolder)this.getSession().readObject(ListHolder.class);
        if (this.holder.getItems().size() != 2) {
            throw new TestErrorException("Incorrect number of items");
        }
        boolean found = false;
        for (ListItem item : this.holder.getItems()) {
            if (item.getDescription() == null || !item.getDescription().equals("test2")) continue;
            found = true;
        }
        if (!found) {
            throw new TestErrorException("A new object was not complete propogated.");
        }
    }

    @Override
    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holder = (ListHolder)uow.readObject(ListHolder.class);
        Iterator<ListItem> i = this.holder.getItems().iterator();
        while (i.hasNext()) {
            uow.deleteObject((Object)i.next());
        }
        uow.deleteObject((Object)this.holder);
        uow.commit();
        super.reset();
    }
}

