/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.eis.cobol;

import java.util.Enumeration;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.eis.cobol.CobolRow;
import org.eclipse.persistence.internal.eis.cobol.FieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.RecordMetaData;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.tests.eis.cobol.CobolTest;
import org.eclipse.persistence.testing.tests.eis.cobol.CobolTestModel;

public class BasicReadWriteTest
extends CobolTest {
    CobolRow resultRow;
    CobolRow row;
    byte[] recordData = new byte[420];

    public String description() {
        return "This test will take a database row, write its contents to a byte array and then read the contents back into another database row, then compare the results to assure the two rows are equal";
    }

    protected void test() {
        FieldMetaData field;
        DatabaseField databaseField;
        RecordMetaData recordMetaData = CobolTestModel.getConversionRecord();
        this.row = CobolTestModel.getConversionRow();
        Enumeration fieldEnum = this.row.getFields().elements();
        this.resultRow = new CobolRow();
        while (fieldEnum.hasMoreElements()) {
            databaseField = (DatabaseField)fieldEnum.nextElement();
            field = recordMetaData.getFieldNamed(databaseField.getName());
            field.writeOnArray(this.row, this.recordData);
        }
        fieldEnum = this.row.getFields().elements();
        while (fieldEnum.hasMoreElements()) {
            databaseField = (DatabaseField)fieldEnum.nextElement();
            field = recordMetaData.getFieldNamed(databaseField.getName());
            field.writeOnRow(this.resultRow, this.recordData);
        }
    }

    protected void verify() throws TestException {
        if (!CobolTestModel.compareCobolRows(this.row, this.resultRow)) {
            TestErrorException exception = new TestErrorException("The rows do not match.");
            this.setTestException((EclipseLinkException)exception);
        }
    }
}

