/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.eis.cobol;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.internal.eis.cobol.CobolRow;
import org.eclipse.persistence.internal.eis.cobol.CompositeFieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.CompositeObject;
import org.eclipse.persistence.internal.eis.cobol.ElementaryFieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.FieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.RecordMetaData;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.tests.eis.cobol.CobolTestBaseSuite;

public class CobolTestModel
extends TestModel {
    public CobolTestModel() {
        this.addTest((Test)new CobolTestBaseSuite());
    }

    public static CobolRow getConversionRow() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>();
        Vector<Object> values = new Vector<Object>();
        fields.addElement(new DatabaseField("emp-ssn"));
        values.addElement("123456789");
        fields.addElement(new DatabaseField("emp-salary"));
        values.addElement("25000.25");
        fields.addElement(new DatabaseField("emp-num-depend"));
        values.addElement("2");
        fields.addElement(new DatabaseField("emp-num-vacation"));
        values.addElement("-245");
        fields.addElement(new DatabaseField("emp-name"));
        Vector<CobolRow> name = new Vector<CobolRow>();
        Vector<DatabaseField> nameFields = new Vector<DatabaseField>();
        Vector<String> nameValues = new Vector<String>();
        nameFields.addElement(new DatabaseField("emp-name-first"));
        nameValues.addElement("John");
        nameFields.addElement(new DatabaseField("emp-name-last"));
        nameValues.addElement("Doe");
        name.addElement(new CobolRow(nameFields, nameValues));
        values.addElement(name);
        fields.addElement(new DatabaseField("emp-dependents"));
        Vector<CobolRow> dependents = new Vector<CobolRow>();
        Vector<DatabaseField> wifeFields = new Vector<DatabaseField>();
        Vector<String> wifeValues = new Vector<String>();
        wifeFields.addElement(new DatabaseField("emp-dependents-name"));
        wifeValues.addElement("Jane Doe");
        wifeFields.addElement(new DatabaseField("emp-dependents-ssn"));
        wifeValues.addElement("987654321");
        dependents.addElement(new CobolRow(wifeFields, wifeValues));
        Vector<DatabaseField> sonFields = new Vector<DatabaseField>();
        Vector<String> sonValues = new Vector<String>();
        sonFields.addElement(new DatabaseField("emp-dependents-name"));
        sonValues.addElement("John Doe Jr.");
        sonFields.addElement(new DatabaseField("emp-dependents-ssn"));
        sonValues.addElement("835873949");
        dependents.addElement(new CobolRow(sonFields, sonValues));
        values.addElement(dependents);
        fields.addElement(new DatabaseField("emp-tasks"));
        Vector<String> tasks = new Vector<String>();
        tasks.addElement("1001");
        tasks.addElement("1002");
        tasks.addElement("1003");
        tasks.addElement("1004");
        values.addElement(tasks);
        return new CobolRow(fields, values);
    }

    public static RecordMetaData getConversionRecord() {
        RecordMetaData record = new RecordMetaData("emp-record");
        ElementaryFieldMetaData ssn = new ElementaryFieldMetaData("emp-ssn", record);
        ssn.setSize(5);
        ssn.setOffset(0);
        ssn.setType(7);
        record.addField((FieldMetaData)ssn);
        ElementaryFieldMetaData salary = new ElementaryFieldMetaData("emp-salary", record);
        salary.setSize(7);
        salary.setOffset(5);
        salary.setType(2);
        salary.setDecimalPosition(6);
        record.addField((FieldMetaData)salary);
        ElementaryFieldMetaData numDepend = new ElementaryFieldMetaData("emp-num-depend", record);
        numDepend.setSize(1);
        numDepend.setOffset(12);
        numDepend.setType(5);
        record.addField((FieldMetaData)numDepend);
        ElementaryFieldMetaData vacationDays = new ElementaryFieldMetaData("emp-num-vacation", record);
        vacationDays.setSize(2);
        vacationDays.setOffset(13);
        vacationDays.setType(5);
        vacationDays.setIsSigned(true);
        record.addField((FieldMetaData)vacationDays);
        CompositeFieldMetaData name = new CompositeFieldMetaData("emp-name", record);
        name.setOffset(15);
        ElementaryFieldMetaData lastName = new ElementaryFieldMetaData("emp-name-first", record);
        lastName.setSize(15);
        lastName.setOffset(15);
        lastName.setType(2);
        name.addField((FieldMetaData)lastName);
        ElementaryFieldMetaData firstName = new ElementaryFieldMetaData("emp-name-last", record);
        firstName.setSize(15);
        firstName.setOffset(30);
        firstName.setType(2);
        name.addField((FieldMetaData)firstName);
        record.addField((FieldMetaData)name);
        ElementaryFieldMetaData tasks = new ElementaryFieldMetaData("emp-tasks", record);
        tasks.setSize(4);
        tasks.setOffset(45);
        tasks.setType(2);
        tasks.setArraySize(4);
        record.addField((FieldMetaData)tasks);
        ElementaryFieldMetaData department = new ElementaryFieldMetaData("emp-depart", record);
        department.setSize(15);
        department.setOffset(45);
        department.setType(2);
        department.setFieldRedefined((FieldMetaData)tasks);
        department.setIsFieldRedefine(true);
        record.addField((FieldMetaData)department);
        CompositeFieldMetaData dependents = new CompositeFieldMetaData("emp-dependents", record);
        dependents.setOffset(61);
        dependents.setArraySize(10);
        dependents.setDependentFieldName("emp-num-depend");
        ElementaryFieldMetaData fullName = new ElementaryFieldMetaData("emp-dependents-name", record);
        fullName.setSize(30);
        fullName.setOffset(61);
        fullName.setType(2);
        dependents.addField((FieldMetaData)fullName);
        ElementaryFieldMetaData number = new ElementaryFieldMetaData("emp-dependents-ssn", record);
        number.setSize(9);
        number.setOffset(91);
        number.setType(2);
        dependents.addField((FieldMetaData)number);
        record.addField((FieldMetaData)dependents);
        return record;
    }

    public static String getSimpleCopyBookString() {
        return "01  emp-record." + Helper.cr() + "04  emp-ssn                   pic 9(12) comp-3." + Helper.cr() + "04  emp-name." + Helper.cr() + "06  emp-name-last       pic x(15)." + Helper.cr() + "06  emp-name-first      pic x(15)." + Helper.cr() + "06  emp-name-mi         pic x." + Helper.cr() + "04  emp-addr." + Helper.cr() + "06  emp-addr-street." + Helper.cr() + "08\temp-addr-street-no\tpic 9(5)." + Helper.cr() + "08\temp-addr-street-name\tpic x(15)." + Helper.cr() + "06  emp-addr-st         pic x(2)." + Helper.cr() + "06  emp-addr-zip        pic x(9).";
    }

    public static String getDeepNestedCopyBookString() {
        return "01 everything-record." + Helper.cr() + "03 everything-universe." + Helper.cr() + "05 universe-galaxycluster." + Helper.cr() + "07 galaxycluster-galaxy." + Helper.cr() + "09 galaxy-solarsystem." + Helper.cr() + "11 solarsystem-planet." + Helper.cr() + "13 planet-continent." + Helper.cr() + "15 continent-country." + Helper.cr() + "17 country-region." + Helper.cr() + "19 region-state." + Helper.cr() + "21 state-county." + Helper.cr() + "23 county-city." + Helper.cr() + "25 city-neighborhood." + Helper.cr() + "27 neighborhood-block." + Helper.cr() + "29 block-house." + Helper.cr() + "31 house-person." + Helper.cr() + "33 person-organ." + Helper.cr() + "35 organ-tissue." + Helper.cr() + "37 tissue-cell." + Helper.cr() + "39 cell-molecule." + Helper.cr() + "41 molecule-atom." + Helper.cr() + "43 atom-nucleus." + Helper.cr() + "45 nucleus-nuetron." + Helper.cr() + "47 nuetron-quark." + Helper.cr() + "49 quark-infinity.";
    }

    public static String getMultipleRecordString() {
        return Helper.cr() + Helper.cr() + Helper.cr() + Helper.cr() + Helper.cr() + "     *sldkfjaweitwoieawoeirgfa;e" + Helper.cr() + "     sherdfgkjhdsfglkjsdhfguheriuh" + Helper.cr() + Helper.cr() + "01 emp-time." + Helper.cr() + "05 time-hour\t\t\tpic 99." + Helper.cr() + "05 time-minute\t\t\tpic xx." + Helper.cr() + "05 time-second\t\t\tpic xx." + Helper.cr() + Helper.cr() + "*********************" + "**************************" + Helper.cr() + Helper.cr() + Helper.cr() + "01 MEMBER-TABLE." + Helper.cr() + Helper.cr() + "05 CLUB-NAME PIC X(20)." + Helper.cr() + Helper.cr() + "05 NUM-MEMBERS PIC 9(5)." + Helper.cr() + Helper.cr() + "05 MEMBERS." + Helper.cr() + Helper.cr() + "10  MEM-NAME    PIC X(20)." + Helper.cr() + Helper.cr() + "10  MEM-NUM     PIC 9(15)." + Helper.cr() + Helper.cr() + Helper.cr() + Helper.cr() + "PROCEDURE DIVISION." + Helper.cr() + CobolTestModel.getSimpleCopyBookString();
    }

    public static String getOccursDependsCopyBookString() {
        return "01 club-record." + Helper.cr() + "05 club-enrollment pic 9(5)." + Helper.cr() + "05 club-members " + Helper.cr() + "occurs 1 to 50 times" + Helper.cr() + " depending on club-enrollment." + Helper.cr() + "10 member-name pic x(20)." + Helper.cr() + "10 member-number pic x(5).";
    }

    public static String getRedefinesCopyBookString() {
        return "01  emp-record." + Helper.cr() + "04  emp-ssn                   pic 9(12) comp-3." + Helper.cr() + "04  emp-ssn-int redefines emp-ssn    pic 9(12) comp." + Helper.cr() + "04  emp-addr." + Helper.cr() + "06  emp-addr-street." + Helper.cr() + "08\temp-addr-street-no\tpic 9(5)." + Helper.cr() + "08\temp-addr-street-name\tpic x(5)." + Helper.cr() + "06  emp-addr-rr redefines  emp-addr-street." + Helper.cr() + "08   \temp-addr-rr-no\t\tpic 9(15)." + Helper.cr() + "08\temp-addr-rr-box\t\tpic 9(5)." + Helper.cr() + "06  emp-addr-zip        pic x(9).";
    }

    public static String getComplexPicStatementCopyBookString() {
        return "01 emp-record." + Helper.cr() + "04 emp-salary      pic S9(5)V99 sign leading seperate." + Helper.cr() + "04 emp-ex         pic Z(5).ZZ." + Helper.cr() + "04 emp-ex2        pic -9(4).99." + Helper.cr() + "04 emp-ex3     pic +ZZ99.99." + Helper.cr() + "04 emp-ex4      pic ----9.99-." + Helper.cr() + "04 emp-ex5       pic S9(5).99.";
    }

    public static String getFillerCopyBookString() {
        return "01 emp-record." + Helper.cr() + "04     pic x(5)." + Helper.cr() + "04." + Helper.cr() + "07     pic xx." + Helper.cr() + "07    pic xx.";
    }

    public static RecordMetaData getFillerRecord() {
        RecordMetaData record = new RecordMetaData("emp-record");
        ElementaryFieldMetaData fill1 = new ElementaryFieldMetaData("filler", record);
        fill1.setType(2);
        fill1.setSize(5);
        fill1.setOffset(0);
        record.addField((FieldMetaData)fill1);
        CompositeFieldMetaData fillComp = new CompositeFieldMetaData("filler", record);
        record.addField((FieldMetaData)fillComp);
        ElementaryFieldMetaData fill2 = new ElementaryFieldMetaData("filler", record);
        fill2.setType(2);
        fill2.setSize(2);
        fill2.setOffset(5);
        fillComp.addField((FieldMetaData)fill2);
        ElementaryFieldMetaData fill3 = new ElementaryFieldMetaData("filler", record);
        fill3.setType(2);
        fill3.setSize(2);
        fill3.setOffset(7);
        fillComp.addField((FieldMetaData)fill3);
        return record;
    }

    public static RecordMetaData getComplexPicStatementRecord() {
        RecordMetaData record = new RecordMetaData("emp-record");
        ElementaryFieldMetaData salary = new ElementaryFieldMetaData("emp-salary", record);
        salary.setType(2);
        salary.setSize(8);
        salary.setOffset(0);
        salary.setDecimalPosition(5);
        salary.setIsSigned(true);
        record.addField((FieldMetaData)salary);
        ElementaryFieldMetaData ex = new ElementaryFieldMetaData("emp-ex", record);
        ex.setType(2);
        ex.setSize(8);
        ex.setOffset(8);
        record.addField((FieldMetaData)ex);
        ElementaryFieldMetaData ex2 = new ElementaryFieldMetaData("emp-ex2", record);
        ex2.setType(2);
        ex2.setSize(8);
        ex2.setOffset(16);
        record.addField((FieldMetaData)ex2);
        ElementaryFieldMetaData ex3 = new ElementaryFieldMetaData("emp-ex3", record);
        ex3.setType(2);
        ex3.setSize(8);
        ex3.setOffset(24);
        record.addField((FieldMetaData)ex3);
        ElementaryFieldMetaData ex4 = new ElementaryFieldMetaData("emp-ex4", record);
        ex4.setType(2);
        ex4.setSize(9);
        ex4.setOffset(32);
        record.addField((FieldMetaData)ex4);
        ElementaryFieldMetaData ex5 = new ElementaryFieldMetaData("emp-ex5", record);
        ex5.setType(2);
        ex5.setSize(8);
        ex5.setOffset(41);
        ex5.setIsSigned(true);
        record.addField((FieldMetaData)ex5);
        return record;
    }

    public static RecordMetaData getRedefinesRecord() {
        RecordMetaData record = new RecordMetaData("emp-record");
        ElementaryFieldMetaData ssn = new ElementaryFieldMetaData("emp-ssn", record);
        ssn.setType(7);
        ssn.setSize(7);
        ssn.setOffset(0);
        record.addField((FieldMetaData)ssn);
        ElementaryFieldMetaData ssnInt = new ElementaryFieldMetaData("emp-ssn-int", record);
        ssnInt.setType(5);
        ssnInt.setSize(5);
        ssnInt.setOffset(0);
        ssnInt.setIsFieldRedefine(true);
        ssnInt.setFieldRedefined((FieldMetaData)ssn);
        record.addField((FieldMetaData)ssnInt);
        CompositeFieldMetaData address = new CompositeFieldMetaData("emp-addr", record);
        CompositeFieldMetaData street = new CompositeFieldMetaData("emp-addr-street", record);
        ElementaryFieldMetaData streetNumber = new ElementaryFieldMetaData("emp-addr-street-no", record);
        streetNumber.setType(2);
        streetNumber.setSize(5);
        streetNumber.setOffset(7);
        street.addField((FieldMetaData)streetNumber);
        ElementaryFieldMetaData streetName = new ElementaryFieldMetaData("emp-addr-street-name", record);
        streetName.setType(2);
        streetName.setSize(5);
        streetName.setOffset(12);
        street.addField((FieldMetaData)streetName);
        address.addField((FieldMetaData)street);
        CompositeFieldMetaData ruralRoute = new CompositeFieldMetaData("emp-addr-rr", record);
        ruralRoute.setIsFieldRedefine(true);
        ruralRoute.setFieldRedefined((FieldMetaData)street);
        ElementaryFieldMetaData ruralRouteNum = new ElementaryFieldMetaData("emp-addr-rr-no", record);
        ruralRouteNum.setType(2);
        ruralRouteNum.setSize(15);
        ruralRouteNum.setOffset(7);
        ruralRoute.addField((FieldMetaData)ruralRouteNum);
        ElementaryFieldMetaData ruralRouteBox = new ElementaryFieldMetaData("emp-addr-rr-box", record);
        ruralRouteBox.setType(2);
        ruralRouteBox.setSize(5);
        ruralRouteBox.setOffset(22);
        ruralRoute.addField((FieldMetaData)ruralRouteBox);
        address.addField((FieldMetaData)ruralRoute);
        ElementaryFieldMetaData zip = new ElementaryFieldMetaData("emp-addr-zip", record);
        zip.setType(2);
        zip.setSize(9);
        zip.setOffset(27);
        address.addField((FieldMetaData)zip);
        record.addField((FieldMetaData)address);
        return record;
    }

    public static RecordMetaData getOccursDependsRecord() {
        RecordMetaData record = new RecordMetaData("club-record");
        ElementaryFieldMetaData enrollment = new ElementaryFieldMetaData("club-enrollment", record);
        enrollment.setType(2);
        enrollment.setSize(5);
        enrollment.setOffset(0);
        record.addField((FieldMetaData)enrollment);
        CompositeFieldMetaData members = new CompositeFieldMetaData("club-members", record);
        members.setArraySize(49);
        members.setDependentFieldName("club-enrollment");
        ElementaryFieldMetaData memName = new ElementaryFieldMetaData("member-name", record);
        memName.setType(2);
        memName.setSize(20);
        memName.setOffset(5);
        members.addField((FieldMetaData)memName);
        ElementaryFieldMetaData memNum = new ElementaryFieldMetaData("member-number", record);
        memNum.setType(2);
        memNum.setSize(5);
        memNum.setOffset(25);
        members.addField((FieldMetaData)memNum);
        record.addField((FieldMetaData)members);
        return record;
    }

    public static Vector getMultipleRecords() {
        Vector<RecordMetaData> records = new Vector<RecordMetaData>(2);
        RecordMetaData record = new RecordMetaData("emp-time");
        ElementaryFieldMetaData hour = new ElementaryFieldMetaData("time-hour", record);
        hour.setType(2);
        hour.setSize(2);
        hour.setOffset(0);
        record.addField((FieldMetaData)hour);
        ElementaryFieldMetaData min = new ElementaryFieldMetaData("time-minute", record);
        min.setType(2);
        min.setSize(2);
        min.setOffset(2);
        record.addField((FieldMetaData)min);
        ElementaryFieldMetaData sec = new ElementaryFieldMetaData("time-second", record);
        sec.setType(2);
        sec.setSize(2);
        sec.setOffset(4);
        record.addField((FieldMetaData)sec);
        records.addElement(record);
        RecordMetaData record2 = new RecordMetaData("MEMBER-TABLE");
        ElementaryFieldMetaData name = new ElementaryFieldMetaData("CLUB-NAME", record2);
        name.setType(2);
        name.setSize(20);
        name.setOffset(0);
        record2.addField((FieldMetaData)name);
        ElementaryFieldMetaData number = new ElementaryFieldMetaData("NUM-MEMBERS", record2);
        number.setType(2);
        number.setSize(5);
        number.setOffset(20);
        record2.addField((FieldMetaData)number);
        CompositeFieldMetaData member = new CompositeFieldMetaData("MEMBERS", record2);
        ElementaryFieldMetaData memName = new ElementaryFieldMetaData("MEM-NAME", record2);
        memName.setType(2);
        memName.setSize(20);
        memName.setOffset(25);
        member.addField((FieldMetaData)memName);
        ElementaryFieldMetaData memNum = new ElementaryFieldMetaData("MEM-NUM", record2);
        memNum.setType(2);
        memNum.setSize(15);
        memNum.setOffset(45);
        member.addField((FieldMetaData)memNum);
        record2.addField((FieldMetaData)member);
        records.addElement(record2);
        return records;
    }

    public static RecordMetaData getDeepNestedRecord() {
        RecordMetaData everything = new RecordMetaData("everything-record");
        CompositeFieldMetaData universe = new CompositeFieldMetaData("everything-universe", everything);
        everything.addField((FieldMetaData)universe);
        CompositeFieldMetaData galaxyCluster = new CompositeFieldMetaData("universe-galaxycluster", everything);
        universe.addField((FieldMetaData)galaxyCluster);
        CompositeFieldMetaData galaxy = new CompositeFieldMetaData("galaxycluster-galaxy", everything);
        galaxyCluster.addField((FieldMetaData)galaxy);
        CompositeFieldMetaData solarSystem = new CompositeFieldMetaData("galaxy-solarsystem", everything);
        galaxy.addField((FieldMetaData)solarSystem);
        CompositeFieldMetaData planet = new CompositeFieldMetaData("solarsystem-planet", everything);
        solarSystem.addField((FieldMetaData)planet);
        CompositeFieldMetaData continent = new CompositeFieldMetaData("planet-continent", everything);
        planet.addField((FieldMetaData)continent);
        CompositeFieldMetaData country = new CompositeFieldMetaData("continent-country", everything);
        continent.addField((FieldMetaData)country);
        CompositeFieldMetaData region = new CompositeFieldMetaData("country-region", everything);
        country.addField((FieldMetaData)region);
        CompositeFieldMetaData state = new CompositeFieldMetaData("region-state", everything);
        region.addField((FieldMetaData)state);
        CompositeFieldMetaData county = new CompositeFieldMetaData("state-county", everything);
        state.addField((FieldMetaData)county);
        CompositeFieldMetaData city = new CompositeFieldMetaData("county-city", everything);
        county.addField((FieldMetaData)city);
        CompositeFieldMetaData neighborhood = new CompositeFieldMetaData("city-neighborhood", everything);
        city.addField((FieldMetaData)neighborhood);
        CompositeFieldMetaData block = new CompositeFieldMetaData("neighborhood-block", everything);
        neighborhood.addField((FieldMetaData)block);
        CompositeFieldMetaData house = new CompositeFieldMetaData("block-house", everything);
        block.addField((FieldMetaData)house);
        CompositeFieldMetaData person = new CompositeFieldMetaData("house-person", everything);
        house.addField((FieldMetaData)person);
        CompositeFieldMetaData organ = new CompositeFieldMetaData("person-organ", everything);
        person.addField((FieldMetaData)organ);
        CompositeFieldMetaData tissue = new CompositeFieldMetaData("organ-tissue", everything);
        organ.addField((FieldMetaData)tissue);
        CompositeFieldMetaData cell = new CompositeFieldMetaData("tissue-cell", everything);
        tissue.addField((FieldMetaData)cell);
        CompositeFieldMetaData molecule = new CompositeFieldMetaData("cell-molecule", everything);
        cell.addField((FieldMetaData)molecule);
        CompositeFieldMetaData atom = new CompositeFieldMetaData("molecule-atom", everything);
        molecule.addField((FieldMetaData)atom);
        CompositeFieldMetaData nucleus = new CompositeFieldMetaData("atom-nucleus", everything);
        atom.addField((FieldMetaData)nucleus);
        CompositeFieldMetaData nuetron = new CompositeFieldMetaData("nucleus-nuetron", everything);
        nucleus.addField((FieldMetaData)nuetron);
        CompositeFieldMetaData quark = new CompositeFieldMetaData("nuetron-quark", everything);
        nuetron.addField((FieldMetaData)quark);
        CompositeFieldMetaData infinity = new CompositeFieldMetaData("quark-infinity", everything);
        quark.addField((FieldMetaData)infinity);
        return everything;
    }

    public static RecordMetaData getSimpleRecord() {
        RecordMetaData record = new RecordMetaData("emp-record");
        ElementaryFieldMetaData ssn = new ElementaryFieldMetaData("emp-ssn", record);
        ssn.setSize(7);
        ssn.setOffset(0);
        ssn.setType(7);
        record.addField((FieldMetaData)ssn);
        CompositeFieldMetaData name = new CompositeFieldMetaData("emp-name", record);
        ElementaryFieldMetaData lastName = new ElementaryFieldMetaData("emp-name-last", record);
        lastName.setSize(15);
        lastName.setOffset(7);
        lastName.setType(2);
        name.addField((FieldMetaData)lastName);
        ElementaryFieldMetaData firstName = new ElementaryFieldMetaData("emp-name-first", record);
        firstName.setSize(15);
        firstName.setOffset(22);
        firstName.setType(2);
        name.addField((FieldMetaData)firstName);
        ElementaryFieldMetaData middleInit = new ElementaryFieldMetaData("emp-name-mi", record);
        middleInit.setSize(1);
        middleInit.setOffset(37);
        middleInit.setType(2);
        name.addField((FieldMetaData)middleInit);
        record.addField((FieldMetaData)name);
        CompositeFieldMetaData address = new CompositeFieldMetaData("emp-addr", record);
        CompositeFieldMetaData street = new CompositeFieldMetaData("emp-addr-street", record);
        ElementaryFieldMetaData number = new ElementaryFieldMetaData("emp-addr-street-no", record);
        number.setSize(5);
        number.setOffset(38);
        number.setType(2);
        street.addField((FieldMetaData)number);
        ElementaryFieldMetaData streetName = new ElementaryFieldMetaData("emp-addr-street-name", record);
        streetName.setSize(15);
        streetName.setOffset(43);
        streetName.setType(2);
        street.addField((FieldMetaData)streetName);
        address.addField((FieldMetaData)street);
        ElementaryFieldMetaData state = new ElementaryFieldMetaData("emp-addr-st", record);
        state.setSize(2);
        state.setOffset(58);
        state.setType(2);
        address.addField((FieldMetaData)state);
        ElementaryFieldMetaData zip = new ElementaryFieldMetaData("emp-addr-zip", record);
        zip.setSize(9);
        zip.setOffset(60);
        zip.setType(2);
        address.addField((FieldMetaData)zip);
        record.addField((FieldMetaData)address);
        return record;
    }

    public static boolean compareCobolRows(CobolRow row1, CobolRow row2) {
        if (row1 == row2) {
            return true;
        }
        if (row1 == null || row2 == null) {
            return false;
        }
        if (row1.size() != row2.size()) {
            return false;
        }
        Enumeration fieldsEnum = row1.getFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            DatabaseField field = (DatabaseField)fieldsEnum.nextElement();
            DatabaseField fieldMatch = row2.getField(field);
            if (fieldMatch == null) {
                return false;
            }
            if (CobolTestModel.compareValues(row1.get(field), row2.get(fieldMatch))) continue;
            return false;
        }
        return true;
    }

    private static boolean compareValues(Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        if (value1 instanceof List && CobolTestModel.compareListFieldValues((List)value1, (List)value2)) {
            return true;
        }
        if (value1.getClass() != value2.getClass()) {
            return false;
        }
        if (value1 instanceof String) {
            return value1.equals(value2);
        }
        return false;
    }

    private static boolean compareListFieldValues(List value1, List value2) {
        Iterator elementIter1 = value1.iterator();
        Iterator elementIter2 = value2.iterator();
        while (elementIter1.hasNext()) {
            Object value = elementIter1.next();
            if (!(value instanceof CobolRow ? !CobolTestModel.compareCobolRows((CobolRow)value, (CobolRow)elementIter2.next()) : !value.equals(elementIter2.next()))) continue;
            return false;
        }
        return true;
    }

    public static boolean compareCompositeObjects(CompositeObject object1, CompositeObject object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        if (!object1.getName().equals(object2.getName())) {
            return false;
        }
        if (object1.getFields().size() != object2.getFields().size()) {
            return false;
        }
        Enumeration fieldsEnum = object1.getFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            FieldMetaData field = (FieldMetaData)fieldsEnum.nextElement();
            FieldMetaData fieldMatch = object2.getFieldNamed(field.getName());
            if (fieldMatch == null) {
                return false;
            }
            if (CobolTestModel.compareFields(field, fieldMatch)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareFields(FieldMetaData field1, FieldMetaData field2) {
        if (field1 == field2) {
            return true;
        }
        if (field1 == null || field2 == null) {
            return false;
        }
        if (field1.getArraySize() != field2.getArraySize() || !field1.getDependentFieldName().equals(field2.getDependentFieldName())) {
            return false;
        }
        if (field1.isComposite() && field2.isComposite()) {
            if (!CobolTestModel.compareCompositeObjects((CompositeObject)field1, (CompositeObject)field2)) {
                return false;
            }
        } else {
            if (field1.isComposite() || field2.isComposite()) {
                return false;
            }
            if (!CobolTestModel.compareElementaryFields((ElementaryFieldMetaData)field1, (ElementaryFieldMetaData)field2)) {
                return false;
            }
        }
        return true;
    }

    public static boolean compareElementaryFields(ElementaryFieldMetaData field1, ElementaryFieldMetaData field2) {
        if (field1.isFieldRedefine() && field2.isFieldRedefine() ? !CobolTestModel.compareFields(field1.getFieldRedefined(), field2.getFieldRedefined()) : field1.isFieldRedefine() || field2.isFieldRedefine()) {
            return false;
        }
        return field1.getSize() == field2.getSize() && field1.getOffset() == field2.getOffset() && field1.getType() == field2.getType() && field1.getDecimalPosition() == field2.getDecimalPosition() && field1.isSigned() == field2.isSigned();
    }
}

