/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.eis.cobol;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.eis.cobol.CompositeFieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.CopyBookParser;
import org.eclipse.persistence.internal.eis.cobol.ElementaryFieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.FieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.RecordMetaData;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.tests.eis.cobol.CobolTest;
import org.eclipse.persistence.testing.tests.eis.cobol.CobolTestModel;

public class FillerNameTest
extends CobolTest {
    Vector records;

    public String description() {
        return "This test will parse a record which contains a record with no name and assure it replaces it with filler";
    }

    protected void test() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(CobolTestModel.getFillerCopyBookString().getBytes());
        CopyBookParser parser = new CopyBookParser();
        try {
            this.records = parser.parse((InputStream)inputStream);
        }
        catch (Exception exception) {
            TestErrorException testException = new TestErrorException(exception.getMessage());
            this.setTestException((EclipseLinkException)testException);
        }
    }

    protected void verify() throws TestException {
        RecordMetaData record = (RecordMetaData)this.records.firstElement();
        if (!this.compareFillerRecords(record, CobolTestModel.getFillerRecord())) {
            TestErrorException exception = new TestErrorException("The records do not match.");
            this.setTestException((EclipseLinkException)exception);
        }
    }

    private boolean compareFillerRecords(RecordMetaData record1, RecordMetaData record2) {
        Vector record1Fields = record1.getFields();
        Vector record2Fields = record2.getFields();
        if (!CobolTestModel.compareElementaryFields((ElementaryFieldMetaData)record1Fields.firstElement(), (ElementaryFieldMetaData)record2Fields.firstElement())) {
            return false;
        }
        if (!((FieldMetaData)record2Fields.elementAt(1)).getName().equalsIgnoreCase("filler")) {
            return false;
        }
        Vector fillerCompFields1 = ((CompositeFieldMetaData)record1Fields.elementAt(1)).getFields();
        Vector fillerCompFields2 = ((CompositeFieldMetaData)record2Fields.elementAt(1)).getFields();
        if (!CobolTestModel.compareElementaryFields((ElementaryFieldMetaData)fillerCompFields1.firstElement(), (ElementaryFieldMetaData)fillerCompFields2.firstElement())) {
            return false;
        }
        return CobolTestModel.compareElementaryFields((ElementaryFieldMetaData)fillerCompFields1.elementAt(1), (ElementaryFieldMetaData)fillerCompFields2.elementAt(1));
    }
}

