/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.eis.cobol;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.eis.cobol.CompositeObject;
import org.eclipse.persistence.internal.eis.cobol.CopyBookParser;
import org.eclipse.persistence.internal.eis.cobol.RecordMetaData;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.eis.cobol.CobolTest;
import org.eclipse.persistence.testing.tests.eis.cobol.CobolTestModel;

public class MultipleRecordParseTest
extends CobolTest {
    Vector records;

    public String description() {
        return "This test will parse a stream containing multiple records and extraneous information.";
    }

    protected void test() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(CobolTestModel.getMultipleRecordString().getBytes());
        CopyBookParser parser = new CopyBookParser();
        try {
            this.records = parser.parse((InputStream)inputStream);
        }
        catch (Exception exception) {
            TestErrorException testException = new TestErrorException(exception.getMessage());
            this.setTestException((EclipseLinkException)testException);
        }
    }

    protected void verify() {
        TestErrorException exception;
        Enumeration recordsEnum = this.records.elements();
        Enumeration recordsEnum2 = CobolTestModel.getMultipleRecords().elements();
        if (this.records.size() > 2) {
            exception = new TestErrorException("returned too many records.");
            this.setTestException((EclipseLinkException)exception);
        }
        while (recordsEnum.hasMoreElements()) {
            if (CobolTestModel.compareCompositeObjects((CompositeObject)((RecordMetaData)recordsEnum.nextElement()), (CompositeObject)((RecordMetaData)recordsEnum2.nextElement()))) continue;
            exception = new TestErrorException("The records do not match.");
            this.setTestException((EclipseLinkException)exception);
        }
    }
}

