/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.eis.xmlfile;

import java.io.File;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.RecordFactory;
import org.eclipse.persistence.eis.EISDOMRecord;
import org.eclipse.persistence.internal.eis.adapters.xmlfile.XMLFileInteractionSpec;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.eis.xmlfile.DirectConnectTest;

public class DirectInteractionTest
extends DirectConnectTest {
    public Connection connection;
    public RecordFactory recordFactory;

    public DirectInteractionTest() {
        this.setName("DirectInteractionTest");
        this.setDescription("Testing interaction XML data");
    }

    @Override
    public void test() throws Exception {
        this.connection = this.connect();
        this.recordFactory = this.connectionFactory.getRecordFactory();
        this.insertInteraction();
        this.updateInteraction();
        this.queryInteraction();
        this.deleteInteraction();
        this.connection.close();
    }

    protected void insertInteraction() throws Exception {
        Interaction interaction = this.connection.createInteraction();
        XMLFileInteractionSpec spec = new XMLFileInteractionSpec();
        spec.setInteractionType(0);
        spec.setFileName("xml-file-insert-test.xml");
        String data1 = "<order id='1234' orderedby='Bob'></order>";
        EISDOMRecord input = (EISDOMRecord)this.recordFactory.createMappedRecord("input");
        input.transformFromXML(data1);
        interaction.execute((InteractionSpec)spec, (Record)input);
        interaction.close();
    }

    protected void queryInteraction() throws Exception {
        Interaction interaction = this.connection.createInteraction();
        XMLFileInteractionSpec spec = new XMLFileInteractionSpec();
        spec.setInteractionType(1);
        spec.setFileName("xml-file-insert-test.xml");
        Record output = interaction.execute((InteractionSpec)spec, null);
        this.getSession().logMessage("output: " + output);
        interaction.close();
    }

    protected void updateInteraction() throws Exception {
        Interaction interaction = this.connection.createInteraction();
        XMLFileInteractionSpec spec = new XMLFileInteractionSpec();
        spec.setInteractionType(2);
        spec.setFileName("xml-file-insert-test.xml");
        String data1 = "<order id='1234' orderedby='Joe'></order>";
        EISDOMRecord input = (EISDOMRecord)this.recordFactory.createMappedRecord("input");
        input.transformFromXML(data1);
        interaction.execute((InteractionSpec)spec, (Record)input);
        interaction.close();
    }

    protected void deleteInteraction() throws Exception {
        Interaction interaction = this.connection.createInteraction();
        XMLFileInteractionSpec spec = new XMLFileInteractionSpec();
        spec.setInteractionType(3);
        spec.setFileName("xml-file-insert-test.xml");
        Record output = interaction.execute((InteractionSpec)spec, null);
        interaction.close();
        if (new File("xml-file-insert-test.xml").exists()) {
            throw new TestErrorException("delete did not remove the file.");
        }
    }
}

