/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.eis.xmlfile;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.tests.eis.xmlfile.EmployeeSystem;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class EmployeeBasicTestModel
extends TestModel {
    public EmployeeBasicTestModel() {
        this.setDescription("This model tests reading/writing/deleting JCA XFA using the employee demo.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new EmployeeSystem());
    }

    public void addTests() {
        this.addTest((Test)EmployeeBasicTestModel.getReadObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getInsertObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getReadAllTestSuite());
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the employee demo.");
        EmployeePopulator system = new EmployeePopulator();
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample3()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample4()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample5()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample3()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample3()));
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the employee demo.");
        suite.addTest((Test)new ReadAllTest(Employee.class, 12));
        suite.addTest((Test)new ReadAllTest(Project.class, 15));
        suite.addTest((Test)new ReadAllTest(LargeProject.class, 5));
        suite.addTest((Test)new ReadAllTest(SmallProject.class, 10));
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }
}

