/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.eis.xmlfile;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Vector;
import javax.resource.cci.InteractionSpec;
import org.eclipse.persistence.eis.interactions.XMLInteraction;
import org.eclipse.persistence.internal.eis.adapters.xmlfile.XMLFileInteractionSpec;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.order.Address;
import org.eclipse.persistence.testing.models.order.LineItem;
import org.eclipse.persistence.testing.models.order.Order;

public class ReadWriteTest
extends AutoVerifyTestCase {
    public ReadWriteTest() {
        this.setName("ReadWriteTest");
        this.setDescription("Testing reading and writing the order model.");
    }

    public void setup() {
        XMLInteraction deleteCall = new XMLInteraction();
        deleteCall.setFunctionName("delete-file");
        XMLFileInteractionSpec spec = new XMLFileInteractionSpec();
        spec.setInteractionType(3);
        spec.setFileName("order.xml");
        deleteCall.setInteractionSpec((InteractionSpec)spec);
        this.getSession().executeNonSelectingCall((Call)deleteCall);
    }

    public void test() throws Exception {
        DatabaseSession session = (DatabaseSession)this.getSession();
        Address address = new Address();
        address.addressee = "Bob Jones";
        address.street = "123 lane";
        address.city = "Ottawa";
        address.state = "Ont";
        address.country = "Canada";
        address.zipCode = "K2C4A4";
        ArrayList<LineItem> lineItems = new ArrayList<LineItem>();
        LineItem line = new LineItem();
        line.lineNumber = 1L;
        line.itemName = "Wheels";
        line.itemPrice = new BigDecimal("35.99");
        line.quantity = 50L;
        lineItems.add(line);
        line = new LineItem();
        line.lineNumber = 2L;
        line.itemName = "Axles";
        line.itemPrice = new BigDecimal("135.99");
        line.quantity = 25L;
        lineItems.add(line);
        Order order = new Order();
        order.id = 123L;
        order.orderedBy = "Tom Jones";
        order.address = address;
        order.lineItems = lineItems;
        session.insertObject((Object)order);
        session.getIdentityMapAccessor().initializeIdentityMaps();
        order = (Order)session.readObject((Object)order);
        session.logMessage(String.valueOf(order));
        if (order == null || order.id != 123L) {
            throw new TestErrorException("order not read back properly");
        }
        Vector orders = session.readAllObjects(Order.class);
        session.logMessage(String.valueOf(orders));
        if (orders.size() != 1) {
            throw new TestErrorException("should be 1 orders");
        }
        session.deleteObject((Object)order);
        orders = session.readAllObjects(Order.class);
        session.logMessage(String.valueOf(orders));
        if (orders.size() != 0) {
            throw new TestErrorException("should be 0 orders");
        }
        session.insertObject((Object)order);
        order = new Order();
        order.id = 456L;
        order.orderedBy = "Bob Baggins";
        session.insertObject((Object)order);
        orders = session.readAllObjects(Order.class);
        session.logMessage(String.valueOf(orders));
        if (orders.size() != 2) {
            throw new TestErrorException("should be 2 orders");
        }
        order.orderedBy = "Frodo Baggins";
        order.lineItems = new ArrayList();
        line = new LineItem();
        line.lineNumber = 1L;
        line.itemName = "Wheels";
        line.itemPrice = new BigDecimal("35.99");
        line.quantity = 50L;
        order.lineItems.add(line);
        session.updateObject((Object)order);
        session.getIdentityMapAccessor().initializeIdentityMaps();
        order = (Order)session.readObject((Object)order);
        session.logMessage(String.valueOf(order));
        if (order == null || order.lineItems.size() != 1 || !order.orderedBy.equals("Frodo Baggins")) {
            throw new TestErrorException("order orderedBy should be 'Frodo Baggins' and should have 1 line item:" + order);
        }
    }
}

