/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.eis.xmlfile;

import java.math.BigDecimal;
import java.util.ArrayList;
import javax.resource.cci.InteractionSpec;
import org.eclipse.persistence.eis.interactions.XMLInteraction;
import org.eclipse.persistence.internal.eis.adapters.xmlfile.XMLFileInteractionSpec;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.order.Address;
import org.eclipse.persistence.testing.models.order.LineItem;
import org.eclipse.persistence.testing.models.order.Order;

public class UnitOfWorkTest
extends TestCase {
    public UnitOfWorkTest() {
        this.setName("UnitOfWorkTest");
        this.setDescription("Testing unit of work with the XML file adapter.");
    }

    public void setup() {
        XMLInteraction deleteCall = new XMLInteraction();
        deleteCall.setFunctionName("delete-file");
        XMLFileInteractionSpec spec = new XMLFileInteractionSpec();
        spec.setInteractionType(3);
        spec.setFileName("order.xml");
        deleteCall.setInteractionSpec((InteractionSpec)spec);
        this.getSession().executeNonSelectingCall((Call)deleteCall);
    }

    public void test() throws Exception {
        Session session = this.getSession();
        session.getIdentityMapAccessor().initializeIdentityMaps();
        UnitOfWork uow = session.acquireUnitOfWork();
        Address address = new Address();
        address.addressee = "Bob Jones";
        address.street = "123 lane";
        address.city = "Ottawa";
        address.state = "Ont";
        address.country = "Canada";
        address.zipCode = "K2C4A4";
        ArrayList<LineItem> lineItems = new ArrayList<LineItem>();
        LineItem line = new LineItem();
        line.lineNumber = 1L;
        line.itemName = "Wheels";
        line.itemPrice = new BigDecimal("35.99");
        line.quantity = 50L;
        lineItems.add(line);
        line = new LineItem();
        line.lineNumber = 2L;
        line.itemName = "Axles";
        line.itemPrice = new BigDecimal("135.99");
        line.quantity = 25L;
        lineItems.add(line);
        Order order = new Order();
        order.id = 456L;
        order.orderedBy = "Tom Jones";
        order.address = address;
        order.lineItems = lineItems;
        session.logMessage(String.valueOf(order));
        order = (Order)uow.registerObject((Object)order);
        session.logMessage(String.valueOf(order));
        uow.commit();
        session.getIdentityMapAccessor().initializeIdentityMaps();
        uow = session.acquireUnitOfWork();
        order = (Order)uow.readObject((Object)order);
        session.logMessage(String.valueOf(order));
        uow.commit();
        session.getIdentityMapAccessor().initializeIdentityMaps();
        uow = session.acquireUnitOfWork();
        order = (Order)uow.readObject((Object)order);
        order.orderedBy = "John";
        line = new LineItem();
        line.lineNumber = 3L;
        line.itemName = "Wheels";
        line.itemPrice = new BigDecimal("35.99");
        line.quantity = 50L;
        order.lineItems.add(line);
        session.logMessage(String.valueOf(order));
        uow.commit();
        order = (Order)session.readObject((Object)order);
        session.logMessage(String.valueOf(order));
        if (order == null || order.lineItems.size() != 3 || !order.orderedBy.equals("John")) {
            throw new TestErrorException("merge did not occur correctly");
        }
        session.getIdentityMapAccessor().initializeIdentityMaps();
        uow = session.acquireUnitOfWork();
        order = (Order)uow.readObject((Object)order);
        if (order == null || order.lineItems.size() != 3 || !order.orderedBy.equals("John")) {
            throw new TestErrorException("update did not occur correctly");
        }
        uow.deleteObject((Object)order);
        uow.commit();
    }
}

