/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.emulateddb;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.tests.performance.emulateddb.EmulatedConnection;
import org.eclipse.persistence.testing.tests.performance.emulateddb.EmulatedResultSet;

public class EmulatedStatement
implements PreparedStatement {
    protected EmulatedConnection connection;
    protected String sql;
    protected List parameters;
    protected int batch;

    public EmulatedStatement(EmulatedConnection connection) {
        this.connection = connection;
        this.parameters = new ArrayList();
    }

    public EmulatedStatement(String sql, EmulatedConnection connection) {
        this(connection);
        this.sql = sql;
    }

    protected List fetchRows() throws SQLException {
        ArrayList<DatabaseRecord> rows = this.connection.getRows(this.sql);
        if (rows == null) {
            Connection realConnection = this.connection.getRealConnection();
            PreparedStatement statement = realConnection.prepareStatement(this.sql);
            for (int index = 0; index < this.parameters.size(); ++index) {
                statement.setObject(index + 1, this.parameters.get(index));
            }
            ResultSet result = statement.executeQuery();
            rows = new ArrayList<DatabaseRecord>();
            ResultSetMetaData metaData = result.getMetaData();
            while (result.next()) {
                DatabaseRecord row = new DatabaseRecord();
                for (int column = 0; column < metaData.getColumnCount(); ++column) {
                    row.add(new DatabaseField(metaData.getColumnName(column + 1)), result.getObject(column + 1));
                }
                rows.add(row);
            }
            result.close();
            statement.close();
        }
        this.connection.putRows(this.sql, rows);
        return rows;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return new EmulatedResultSet(this.fetchRows());
    }

    @Override
    public int executeUpdate() throws SQLException {
        return 1;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) {
        this.setObject(parameterIndex, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) {
    }

    @Override
    public void setByte(int parameterIndex, byte x) {
    }

    @Override
    public void setShort(int parameterIndex, short x) {
    }

    @Override
    public void setInt(int parameterIndex, int x) {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) {
        this.setObject(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) {
    }

    @Override
    public void setString(int parameterIndex, String x) {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) {
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) {
    }

    @Override
    public void clearParameters() {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) {
        while (this.parameters.size() < parameterIndex) {
            this.parameters.add(null);
        }
        this.parameters.set(parameterIndex - 1, x);
    }

    @Override
    public boolean execute() throws SQLException {
        return true;
    }

    @Override
    public void addBatch() {
        ++this.batch;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) {
    }

    @Override
    public void setRef(int i, Ref x) {
    }

    @Override
    public void setBlob(int i, Blob x) {
        this.setObject(i, x);
    }

    @Override
    public void setClob(int i, Clob x) {
        this.setObject(i, x);
    }

    @Override
    public void setArray(int i, Array x) {
        this.setObject(i, x);
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) {
        this.setObject(paramIndex, null);
    }

    @Override
    public void setURL(int parameterIndex, URL x) {
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return null;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return new EmulatedResultSet(this.connection.getRows(sql));
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return 1;
    }

    @Override
    public void close() {
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) {
    }

    @Override
    public int getMaxRows() {
        return 0;
    }

    @Override
    public void setMaxRows(int max) {
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    @Override
    public int getQueryTimeout() {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void setCursorName(String name) {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return true;
    }

    @Override
    public ResultSet getResultSet() {
        return null;
    }

    @Override
    public int getUpdateCount() {
        return 0;
    }

    @Override
    public boolean getMoreResults() {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public int getFetchDirection() {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() {
        return 0;
    }

    @Override
    public int getResultSetType() {
        return 0;
    }

    @Override
    public void addBatch(String sql) {
    }

    @Override
    public void clearBatch() {
    }

    @Override
    public int[] executeBatch() {
        int[] result = new int[this.batch];
        for (int index = 0; index < this.batch; ++index) {
            result[index] = 1;
        }
        this.batch = 0;
        return result;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 1;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 1;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 1;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return true;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return true;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return true;
    }

    @Override
    public int getResultSetHoldability() {
        return 0;
    }

    @Override
    public void setAsciiStream(int columnIndex, InputStream stream, long length) throws SQLException {
    }

    @Override
    public void setAsciiStream(int columnIndex, InputStream stream) throws SQLException {
    }

    public void setAsciiStream(String columnLabel, InputStream stream, long length) throws SQLException {
    }

    public void setAsciiStream(String columnLabel, InputStream stream) throws SQLException {
    }

    @Override
    public void setBlob(int columnIndex, InputStream stream, long length) throws SQLException {
    }

    @Override
    public void setBlob(int columnIndex, InputStream stream) throws SQLException {
    }

    public void setBlob(String columnLabel, InputStream stream, long length) throws SQLException {
    }

    public void setBlob(String columnLabel, InputStream stream) throws SQLException {
    }

    @Override
    public void setBinaryStream(int columnIndex, InputStream stream, long length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int columnIndex, InputStream stream) throws SQLException {
    }

    public void setBinaryStream(String columnLabel, InputStream stream, long length) throws SQLException {
    }

    public void setBinaryStream(String columnLabel, InputStream stream) throws SQLException {
    }

    @Override
    public void setCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setCharacterStream(int columnIndex, Reader reader) throws SQLException {
    }

    public void setCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    public void setCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void setClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setClob(int columnIndex, Reader reader) throws SQLException {
    }

    public void setClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    public void setClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int columnIndex, Reader reader) throws SQLException {
    }

    public void setNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    public void setNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void setNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNClob(int columnIndex, Reader reader) throws SQLException {
    }

    public void setNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    public void setNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void setNClob(int columnIndex, NClob nclob) throws SQLException {
    }

    public void setNClob(String columnLabel, NClob nclob) throws SQLException {
    }

    @Override
    public void setNString(int columnIndex, String nString) throws SQLException {
    }

    public void setNString(String columnLabel, String nString) throws SQLException {
    }

    public void setSQLXML(String columnLabel, SQLXML sqlxml) throws SQLException {
    }

    @Override
    public void setSQLXML(int columnIndex, SQLXML sqlxml) throws SQLException {
    }

    @Override
    public void setRowId(int columnIndex, RowId rowid) throws SQLException {
    }

    public void setRowId(String columnLabel, RowId rowid) throws SQLException {
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iFace) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iFace) throws SQLException {
        return iFace.cast(this);
    }
}

