/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import java.sql.Timestamp;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DB2Platform;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;

public class SessionBrokerPlatformTest
extends TransactionalTestCase {
    public DatabasePlatform platform;

    public void setup() {
        super.setup();
        this.platform = (DatabasePlatform)((AbstractSession)this.getSession()).getPlatform(LargeProject.class);
        DB2Platform newPlatform = new DB2Platform();
        newPlatform.setUsesNativeSQL(true);
        this.getSession().getLogin().setPlatform((Platform)newPlatform);
    }

    public void test() {
        try {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            LargeProject project = (LargeProject)uow.readObject(LargeProject.class);
            project.setDescription("Anything but what it was");
            project.setMilestoneVersion(new Timestamp(System.currentTimeMillis()));
            uow.commit();
        }
        catch (DatabaseException exception) {
            throw new TestErrorException("Failed to use the Session Platform to generate SQL.  Instead used Broker platform");
        }
    }

    public void reset() {
        super.reset();
        this.getSession().getLogin().setPlatform((Platform)this.platform);
    }
}

