/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.tableswithspacesmodel;

import junit.framework.Test;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllCallTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.tests.tableswithspacesmodel.EmployeeWithSpacesDeleteTest;
import org.eclipse.persistence.testing.tests.tableswithspacesmodel.EmployeeWithSpacesSystem;
import org.eclipse.persistence.testing.tests.tableswithspacesmodel.ProjectWithSpacesDeleteTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class EmployeeWithSpacesTestModel
extends TestModel {
    public EmployeeWithSpacesTestModel() {
        this.setDescription("This model tests reading/writing/deleting using the employee demo. Includes table names with spaces");
    }

    public EmployeeWithSpacesTestModel(boolean isSRG) {
        this();
        this.isSRG = isSRG;
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new EmployeeWithSpacesSystem());
    }

    public void addTests() {
        this.addTest((Test)EmployeeWithSpacesTestModel.getReadObjectTestSuite());
        this.addTest((Test)EmployeeWithSpacesTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)EmployeeWithSpacesTestModel.getInsertObjectTestSuite());
        this.addTest((Test)EmployeeWithSpacesTestModel.getDeleteObjectTestSuite());
    }

    public void addSRGTests() {
        this.addTest((Test)EmployeeWithSpacesTestModel.getSRGReadObjectTestSuite());
        this.addTest((Test)EmployeeWithSpacesTestModel.getSRGUpdateObjectTestSuite());
        this.addTest((Test)EmployeeWithSpacesTestModel.getSRGInsertObjectTestSuite());
        this.addTest((Test)EmployeeWithSpacesTestModel.getSRGDeleteObjectTestSuite());
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = EmployeeWithSpacesTestModel.getSRGDeleteObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new EmployeeWithSpacesDeleteTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new EmployeeWithSpacesDeleteTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new EmployeeWithSpacesDeleteTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new EmployeeWithSpacesDeleteTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new EmployeeWithSpacesDeleteTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new ProjectWithSpacesDeleteTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new ProjectWithSpacesDeleteTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new ProjectWithSpacesDeleteTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new ProjectWithSpacesDeleteTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new ProjectWithSpacesDeleteTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new ProjectWithSpacesDeleteTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = EmployeeWithSpacesTestModel.getSRGInsertObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the employee demo.");
        EmployeePopulator system = new EmployeePopulator();
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample3()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample4()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample5()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample3()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample3()));
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = EmployeeWithSpacesTestModel.getSRGReadAllTestSuite();
        return suite;
    }

    public static TestSuite getSRGReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the employee demo.");
        suite.addTest((Test)new ReadAllTest(Employee.class, 12));
        suite.addTest((Test)new ReadAllTest(Project.class, 15));
        suite.addTest((Test)new ReadAllTest(LargeProject.class, 5));
        suite.addTest((Test)new ReadAllTest(SmallProject.class, 10));
        suite.addTest((Test)new ReadAllCallTest(Employee.class, 12, (Call)new SQLCall("SELECT  t0.VERSION, t1.EMP_ID, t0.L_NAME, t0.F_NAME, t1.SALARY, t0.EMP_ID, t0.GENDER, t0.END_DATE, t0.START_DATE, t0.MANAGER_ID, t0.END_TIME, t0.START_TIME, t0.ADDR_ID FROM EMPLOYEE t0, SALARY t1 WHERE t1.EMP_ID = t0.EMP_ID")));
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = EmployeeWithSpacesTestModel.getSRGReadObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0005")));
        Project project = (Project)manager.getObject(largeProjectClass, "0001");
        ReadObjectTest test = new ReadObjectTest((Object)project);
        test.setQuery(new ReadObjectQuery(Project.class, new ExpressionBuilder().get("id").equal((Object)project.getId())));
        suite.addTest((Test)test);
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = EmployeeWithSpacesTestModel.getSRGUpdateObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }
}

