/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;

public class NoIdentityMergeCloneTest
extends TransactionalTestCase {
    protected PolicyHolder objectToBeWritten;
    protected Hashtable checkCacheState;
    protected Hashtable identityMapTypes;

    public NoIdentityMergeCloneTest() {
        this.setDescription("Test that the unit of work mergeClone still works when object identity is lost.");
    }

    public void reset() {
        ClassDescriptor key;
        if (this.getSession() instanceof RemoteSession) {
            return;
        }
        super.reset();
        Enumeration enumtr = this.checkCacheState.keys();
        while (enumtr.hasMoreElements()) {
            key = (ClassDescriptor)enumtr.nextElement();
            key.getQueryManager().getDoesExistQuery().setExistencePolicy(((Integer)this.checkCacheState.get(key)).intValue());
        }
        enumtr = this.identityMapTypes.keys();
        while (enumtr.hasMoreElements()) {
            key = (ClassDescriptor)enumtr.nextElement();
            key.setIdentityMapClass((Class)this.identityMapTypes.get(key));
        }
    }

    public void setup() {
        if (this.getSession() instanceof RemoteSession) {
            throw new TestWarningException("Not support in remote");
        }
        super.setup();
        this.checkCacheState = new Hashtable(10);
        this.identityMapTypes = new Hashtable(10);
        for (ClassDescriptor descriptor : this.getSession().getProject().getDescriptors().values()) {
            this.checkCacheState.put(descriptor, new Integer(descriptor.getQueryManager().getDoesExistQuery().getExistencePolicy()));
            if (!descriptor.requiresInitialization()) continue;
            this.identityMapTypes.put(descriptor, descriptor.getIdentityMapClass());
        }
        this.getSession().getProject().checkDatabaseForDoesExist();
        this.getSession().getProject().useCacheIdentityMap(1);
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        this.objectToBeWritten = (PolicyHolder)this.getSession().readAllObjects(PolicyHolder.class).firstElement();
        this.objectToBeWritten = (PolicyHolder)this.getSession().acquireUnitOfWork().registerObject((Object)this.objectToBeWritten);
        this.objectToBeWritten.setAddress(null);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.mergeClone((Object)this.objectToBeWritten);
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Object objectFromDatabase = this.getSession().readObject((Object)this.objectToBeWritten);
        if (!this.compareObjects(this.objectToBeWritten, objectFromDatabase)) {
            throw new TestErrorException("The object inserted into the database, '" + objectFromDatabase + "' does not match the original, '" + this.objectToBeWritten + ".");
        }
    }
}

